/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.accessories.components;

import io.mpos.accessories.components.ErrorListener;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.logger.LoggerKt;
import io.mpos.shared.errors.DefaultMposError;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u001a!\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"reportException", "", "Lio/mpos/accessories/components/ErrorListener;", "tag", "", "t", "", "(Lio/mpos/accessories/components/ErrorListener;Ljava/lang/String;Ljava/lang/Throwable;)Lkotlin/Unit;", "mpos.core"})
public final class ErrorListenerKt {
    @Nullable
    public static final Unit reportException(@NotNull ErrorListener $this$reportException, @NotNull String tag, @NotNull Throwable t2) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)$this$reportException, (String)"");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter((Object)t2, (String)"");
        Throwable throwable = t2;
        if (throwable instanceof CancellationException) {
            unit = LoggerKt.logDebug(tag, "component step was cancelled");
        } else if (throwable instanceof MposRuntimeException) {
            LoggerKt.logError(tag, "MposError", t2);
            MposError mposError = ((MposRuntimeException)t2).getError();
            Intrinsics.checkNotNullExpressionValue((Object)mposError, (String)"");
            $this$reportException.failure(mposError);
            unit = Unit.INSTANCE;
        } else if (throwable instanceof Exception) {
            LoggerKt.logError(tag, "Exception", t2);
            $this$reportException.failure(new DefaultMposError((Exception)t2));
            unit = Unit.INSTANCE;
        } else {
            LoggerKt.logError(tag, "Throwable", t2);
            $this$reportException.failure(new DefaultMposError(ErrorType.INTERNAL_INCONSISTENCY, t2.getMessage()));
            unit = Unit.INSTANCE;
        }
        return unit;
    }
}

