/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.accessories.components.interaction.parameters;

import io.mpos.accessories.components.interaction.CardDataPrompt;
import io.mpos.accessories.components.interaction.moto.DefaultMotoStrategy;
import io.mpos.accessories.components.interaction.moto.MotoStrategy;
import io.mpos.accessories.components.interaction.moto.MotoType;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.TransactionWorkflowType;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class AskForCardDataParameters {
    private CardDataPrompt[] cardDataPrompts;
    private boolean showIdleScreen;
    private MotoStrategy motoStrategy;
    private MotoType motoType;
    private TransactionType transactionType;
    private TransactionWorkflowType transactionWorkflowType;

    private AskForCardDataParameters(Builder builder) {
        this.cardDataPrompts = builder.cardDataPrompts;
        this.showIdleScreen = builder.showIdleScreen;
        this.motoStrategy = builder.motoStrategy;
        this.motoType = builder.motoType;
        this.transactionWorkflowType = builder.transactionWorkflowType;
        this.transactionType = builder.transactionType;
    }

    @Nullable
    public MotoType getMotoType() {
        return this.motoType;
    }

    public String toString() {
        return "AskForCardDataParameters{cardDataPrompts=" + Arrays.toString((Object[])this.cardDataPrompts) + ", showIdleScreen=" + this.showIdleScreen + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof AskForCardDataParameters)) {
            return false;
        }
        AskForCardDataParameters askForCardDataParameters = (AskForCardDataParameters)o2;
        if (this.showIdleScreen != askForCardDataParameters.showIdleScreen) {
            return false;
        }
        return Arrays.equals((Object[])this.cardDataPrompts, (Object[])askForCardDataParameters.cardDataPrompts);
    }

    public int hashCode() {
        int n2 = Arrays.hashCode((Object[])this.cardDataPrompts);
        n2 = 31 * n2 + (this.showIdleScreen ? 1 : 0);
        return n2;
    }

    public CardDataPrompt[] getCardDataPrompts() {
        return this.cardDataPrompts;
    }

    public boolean isShowIdleScreen() {
        return this.showIdleScreen;
    }

    public MotoStrategy getMotoStrategy() {
        return this.motoStrategy;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public TransactionWorkflowType getTransactionWorkflowType() {
        return this.transactionWorkflowType;
    }

    public void setTransactionWorkflowType(TransactionWorkflowType workflowType) {
        this.transactionWorkflowType = workflowType;
    }

    public static class Builder {
        private CardDataPrompt[] cardDataPrompts;
        private boolean showIdleScreen;
        private MotoStrategy motoStrategy = DefaultMotoStrategy.INSTANCE;
        private MotoType motoType;
        private TransactionType transactionType;
        private TransactionWorkflowType transactionWorkflowType;

        public Builder(CardDataPrompt[] prompts) {
            this.cardDataPrompts = prompts;
        }

        public Builder showIdleScreen() {
            this.showIdleScreen = true;
            return this;
        }

        public Builder motoStrategy(MotoStrategy motoStrategy) {
            this.motoStrategy = motoStrategy;
            return this;
        }

        public Builder motoType(@Nullable MotoType motoType) {
            this.motoType = motoType;
            return this;
        }

        public Builder withTransactionWorkflowType(@Nullable TransactionWorkflowType transactionWorkflowType) {
            this.transactionWorkflowType = transactionWorkflowType;
            return this;
        }

        public Builder withTransactionType(@Nullable TransactionType transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public AskForCardDataParameters build() {
            return new AskForCardDataParameters(this);
        }
    }
}

