/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.accessories.components.interaction.parameters;

import io.mpos.accessories.components.interaction.ConfirmationKey;
import java.util.EnumSet;

public class AskForConfirmationInteractionParameters {
    private String[] mPrompt;
    private boolean mCenterText;
    private boolean mShowIdleScreen;
    private EnumSet<ConfirmationKey> mConfirmationKeys;

    private AskForConfirmationInteractionParameters() {
    }

    private AskForConfirmationInteractionParameters(Builder builder) {
        this.mPrompt = builder.prompt;
        this.mCenterText = builder.centerText;
        this.mShowIdleScreen = builder.showIdleScreen;
        this.mConfirmationKeys = builder.confirmationKeys;
    }

    public String[] getPrompt() {
        return this.mPrompt;
    }

    public boolean isCenterText() {
        return this.mCenterText;
    }

    public boolean isShowIdleScreen() {
        return this.mShowIdleScreen;
    }

    public EnumSet<ConfirmationKey> getConfirmationKeys() {
        return this.mConfirmationKeys;
    }

    public static class Builder {
        String[] prompt;
        boolean centerText;
        boolean showIdleScreen;
        EnumSet<ConfirmationKey> confirmationKeys;

        public Builder(String[] prompt) {
            this.prompt = prompt;
            this.showIdleScreen = true;
            this.confirmationKeys = EnumSet.of(ConfirmationKey.OK, ConfirmationKey.CANCEL);
        }

        public Builder centerText(boolean centerText) {
            this.centerText = centerText;
            return this;
        }

        public Builder showIdleScreen(boolean showIdleScreen) {
            this.showIdleScreen = showIdleScreen;
            return this;
        }

        public Builder confirmationKeys(EnumSet<ConfirmationKey> confirmationKeys) {
            this.confirmationKeys = confirmationKeys;
            return this;
        }

        public AskForConfirmationInteractionParameters build() {
            return new AskForConfirmationInteractionParameters(this);
        }
    }
}

