/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.accessories.components.interaction.parameters;

import io.mpos.accessories.components.interaction.InteractionPrompt;
import io.mpos.transactions.Currency;
import java.math.BigDecimal;

public class AskForNumberInteractionParameters {
    private InteractionPrompt interactionPrompt;
    private InteractionPrompt auxiliaryInteractionPrompt;
    private Integer integerDigits;
    private Integer fractionDigits;
    private BigDecimal defaultNumber;
    private Currency currency;
    private BigDecimal amount;
    private Byte maximumNumberOfDigits;
    private Byte minimumNumberOfDigits;
    private boolean autoConfirm;
    private boolean showIdleScreen;
    private int[] promptIndexes;
    private boolean isSkippable;

    private AskForNumberInteractionParameters() {
    }

    private AskForNumberInteractionParameters(Builder builder) {
        this.interactionPrompt = builder.interactionPrompt;
        this.auxiliaryInteractionPrompt = builder.auxiliaryInteractionPrompt;
        this.integerDigits = builder.integerDigits;
        this.fractionDigits = builder.fractionDigits;
        this.defaultNumber = builder.defaultNumber;
        this.autoConfirm = builder.autoConfirm;
        this.amount = builder.amount;
        this.currency = builder.currency;
        this.showIdleScreen = builder.showIdleScreen;
        this.promptIndexes = builder.promptIndexes;
        this.maximumNumberOfDigits = builder.maximumNumberOfDigits;
        this.minimumNumberOfDigits = builder.minimumNumberOfDigits;
        this.isSkippable = builder.isSkippable;
    }

    public InteractionPrompt getInteractionPrompt() {
        return this.interactionPrompt;
    }

    public InteractionPrompt getAuxiliaryInteractionPrompt() {
        return this.auxiliaryInteractionPrompt;
    }

    public boolean isAutoConfirm() {
        return this.autoConfirm;
    }

    public Integer getIntegerDigits() {
        return this.integerDigits;
    }

    public Integer getFractionDigits() {
        return this.fractionDigits;
    }

    public BigDecimal getDefaultNumber() {
        return this.defaultNumber;
    }

    public boolean isDisplayAmount() {
        return this.amount != null && this.currency != null;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public boolean isShowIdleScreen() {
        return this.showIdleScreen;
    }

    public int[] getPromptIndexes() {
        return this.promptIndexes;
    }

    public Byte getMaximumNumberOfDigits() {
        return this.maximumNumberOfDigits;
    }

    public Byte getMinimumNumberOfDigits() {
        return this.minimumNumberOfDigits;
    }

    public boolean isSkippable() {
        return this.isSkippable;
    }

    public static class Builder {
        InteractionPrompt interactionPrompt;
        InteractionPrompt auxiliaryInteractionPrompt;
        Integer integerDigits;
        Integer fractionDigits;
        boolean autoConfirm;
        BigDecimal defaultNumber;
        Currency currency = Currency.UNKNOWN;
        BigDecimal amount;
        boolean showIdleScreen;
        int[] promptIndexes;
        Byte maximumNumberOfDigits;
        Byte minimumNumberOfDigits;
        boolean isSkippable;

        public Builder(InteractionPrompt interactionPrompt) {
            this.interactionPrompt = interactionPrompt;
            this.auxiliaryInteractionPrompt = InteractionPrompt.EMPTY;
            this.showIdleScreen = true;
        }

        public Builder(InteractionPrompt interactionPrompt, InteractionPrompt auxiliaryInteractionPrompt) {
            this.interactionPrompt = interactionPrompt;
            this.auxiliaryInteractionPrompt = auxiliaryInteractionPrompt;
            this.showIdleScreen = true;
        }

        public Builder(int[] promptIndexes) {
            this.promptIndexes = promptIndexes;
            this.showIdleScreen = true;
        }

        public Builder numberFormat(int integerDigits, int fractionDigits) {
            this.integerDigits = integerDigits;
            this.fractionDigits = fractionDigits;
            return this;
        }

        public Builder autoConfirm(boolean autoConfirm) {
            this.autoConfirm = autoConfirm;
            return this;
        }

        public Builder defaultNumber(BigDecimal defaultNumber) {
            this.defaultNumber = defaultNumber;
            return this;
        }

        public Builder displayAmountOnTop(BigDecimal amount, Currency currency) {
            this.amount = amount;
            this.currency = currency;
            return this;
        }

        public Builder showIdleScreen(boolean showIdleScreen) {
            this.showIdleScreen = showIdleScreen;
            return this;
        }

        public Builder maximumNumberOfDigits(Byte maximumNumberOfDigits) {
            this.maximumNumberOfDigits = maximumNumberOfDigits;
            return this;
        }

        public Builder minimumNumberOfDigits(Byte minimumNumberOfDigits) {
            this.minimumNumberOfDigits = minimumNumberOfDigits;
            return this;
        }

        public Builder skippable(boolean skippable) {
            this.isSkippable = skippable;
            return this;
        }

        public AskForNumberInteractionParameters build() {
            return new AskForNumberInteractionParameters(this);
        }
    }
}

