/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.accessories.displayupdate;

import bolts.Task;
import io.mpos.accessories.Accessory;
import io.mpos.accessories.displayupdate.infoscreen.AdditionalInfo;
import io.mpos.accessories.displayupdate.infoscreen.InformationToDisplay;
import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.core.common.obfuscated.gV;
import io.mpos.core.common.obfuscated.gW;
import io.mpos.core.common.obfuscated.gv;
import io.mpos.core.common.obfuscated.gw;
import io.mpos.errors.MposError;
import io.mpos.paymentdetails.ContactlessIndicatorState;
import io.mpos.shared.accessories.modules.listener.EmptySuccessListener;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListener;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListenerFactory;
import io.mpos.shared.localization.LocalizationPrompt;
import io.mpos.shared.paymentdetails.DefaultPinInformation;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.CurrencyWrapper;

public class TransactionProgressReporter {
    private static final String TAG = "TransactionProgressReporter";
    private gV paymentTextDisplayer = new gW();
    private gv paymentTextDisplayerHelper = new gw();
    private static final GenericOperationSuccessFailureListener<Accessory, LocalizationPrompt> ignoreResults = GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((operator, data) -> {}, (operator, error) -> {});

    public void reportPinInformation(PaymentAccessory accessory, DefaultPinInformation pinInformation) {
        this.paymentTextDisplayer.a(accessory, pinInformation);
    }

    public void reportContactlessIndicatorState(PaymentAccessory accessory, ContactlessIndicatorState state) {
        this.paymentTextDisplayerHelper.a(accessory, state);
    }

    public void report(PaymentAccessory accessory, BaseTransaction transaction, LocalizationPrompt prompt) {
        this.report(accessory, transaction, prompt, ignoreResults);
    }

    public void report(PaymentAccessory accessory, BaseTransaction transaction, LocalizationPrompt prompt, GenericOperationSuccessFailureListener<Accessory, LocalizationPrompt> listener) {
        String[] stringArray = new String[]{transaction == null ? "" : new CurrencyWrapper(transaction.getCurrency()).formatAmountAndCurrency(transaction.getAmount())};
        this.paymentTextDisplayerHelper.a(accessory, listener, prompt, transaction.getAmount(), transaction.getCurrency(), stringArray);
    }

    public void reportAdditionalInfo(final PaymentAccessory accessory, final BaseTransaction transaction, final AdditionalInfo additionalInfo, final EmptySuccessListener listener) {
        if (additionalInfo == null || !additionalInfo.hasNext()) {
            listener.onOperationSuccess();
            return;
        }
        final InformationToDisplay informationToDisplay = additionalInfo.popNextInfo();
        this.report(accessory, transaction, informationToDisplay.getLocalizationPrompt(), new GenericOperationSuccessFailureListener<Accessory, LocalizationPrompt>(){
            private GenericOperationSuccessFailureListener<Accessory, LocalizationPrompt> innerListener = this;

            @Override
            public void onOperationFailure(Accessory operator, MposError error) {
                this.continueAfterShowingInfo(additionalInfo, accessory);
            }

            @Override
            public void onOperationSuccess(Accessory operator, LocalizationPrompt data) {
                Task.delay((long)informationToDisplay.getDisplayTime()).continueWith(task -> {
                    this.continueAfterShowingInfo(additionalInfo, accessory);
                    return null;
                });
            }

            private void continueAfterShowingInfo(AdditionalInfo additionalInfo2, PaymentAccessory accessory2) {
                if (additionalInfo2.hasNext()) {
                    InformationToDisplay informationToDisplay2 = additionalInfo2.popNextInfo();
                    TransactionProgressReporter.this.report(accessory2, transaction, informationToDisplay2.getLocalizationPrompt(), this.innerListener);
                } else {
                    listener.onOperationSuccess();
                }
            }
        });
    }
}

