/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.accessories.displayupdate.infoscreen;

import io.mpos.accessories.displayupdate.infoscreen.InformationToDisplay;
import io.mpos.accessories.displayupdate.infoscreen.PinInformationScreen;
import io.mpos.accessories.displayupdate.infoscreen.TestCardScreen;
import io.mpos.paymentdetails.PinInformation;
import io.mpos.shared.config.DelayConfig;
import java.util.EnumMap;
import java.util.EnumSet;

public class AdditionalInfo {
    private EnumMap<DisplayInfoType, InformationToDisplay> infosToDisplay = new EnumMap(DisplayInfoType.class);
    private EnumSet<DisplayInfoType> infosDisplayed = EnumSet.noneOf(DisplayInfoType.class);
    private final DelayConfig delayConfig;

    public AdditionalInfo(DelayConfig delayConfig) {
        this.delayConfig = delayConfig;
    }

    public void addPinInformation(PinInformation pinInformation) {
        this.addInfo(DisplayInfoType.PIN_STATUS, new PinInformationScreen(pinInformation, this.delayConfig));
    }

    public void addTestCardInfo() {
        this.addInfo(DisplayInfoType.TEST_CARD, new TestCardScreen(this.delayConfig));
    }

    public InformationToDisplay popNextInfo() {
        if (this.infosToDisplay.containsKey((Object)DisplayInfoType.PIN_STATUS)) {
            this.infosDisplayed.add(DisplayInfoType.PIN_STATUS);
            return this.infosToDisplay.remove((Object)DisplayInfoType.PIN_STATUS);
        }
        if (this.infosToDisplay.containsKey((Object)DisplayInfoType.TEST_CARD)) {
            this.infosDisplayed.add(DisplayInfoType.TEST_CARD);
            return this.infosToDisplay.remove((Object)DisplayInfoType.TEST_CARD);
        }
        return null;
    }

    public boolean hasNext() {
        return this.infosToDisplay.size() > 0;
    }

    private void addInfo(DisplayInfoType type, InformationToDisplay info) {
        if (!this.infosDisplayed.contains((Object)type)) {
            this.infosToDisplay.put(type, info);
        }
    }

    private static enum DisplayInfoType {
        PIN_STATUS,
        TEST_CARD;

    }
}

