/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import bolts.Task;
import io.mpos.accessories.displayupdate.DisplayUpdateType;
import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.errors.ErrorType;
import io.mpos.mock.Breakpoint;
import io.mpos.mock.MockConfiguration;
import io.mpos.mock.MockDelay;
import io.mpos.paymentdetails.ApplicationInformation;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.paymentdetails.PinInformation;
import io.mpos.paymentdetails.PinInformationStatus;
import io.mpos.shared.accessories.displayupdate.DefaultPINDisplayUpdateSupport;
import io.mpos.shared.accessories.modules.AbstractCardProcessingModule;
import io.mpos.shared.accessories.modules.listener.CardProcessingAbortTransactionListener;
import io.mpos.shared.accessories.modules.listener.CardProcessingContinueTransactionListener;
import io.mpos.shared.accessories.modules.listener.CardProcessingDetectCardListener;
import io.mpos.shared.accessories.modules.listener.CardProcessingRemoveCardListener;
import io.mpos.shared.accessories.modules.listener.CardProcessingRequestPINListener;
import io.mpos.shared.accessories.modules.listener.CardProcessingStartTransactionListener;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListener;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.events.BusProvider;
import io.mpos.shared.events.providercomponent.AccessoryDisplayedTextUpdateBusEvent;
import io.mpos.shared.paymentdetails.DefaultApplicationInformation;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.DefaultPinInformation;
import io.mpos.shared.paymentdetails.IccInformation;
import io.mpos.shared.paymentdetails.MagstripeInformation;
import io.mpos.shared.paymentdetails.PaymentDetailsCustomerVerificationDetailed;
import io.mpos.shared.paymentdetails.PaymentDetailsIccWrapper;
import io.mpos.shared.provider.ProcessingOptions;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.DefaultDccDetails;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.shared.transactions.DefaultTransactionStatusDetails;
import io.mpos.shared.workflows.evaluator.AidEvaluator;
import io.mpos.specs.bertlv.TLVHelper;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;
import io.mpos.transactions.DccStatusDetails;
import io.mpos.transactions.TransactionMode;
import io.mpos.transactions.TransactionStatus;
import io.mpos.transactions.TransactionStatusDetailsCodes;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class H
extends AbstractCardProcessingModule {
    CardProcessingStartTransactionListener a;
    private final MockConfiguration b;
    private final MockDelay c;

    public H(MockConfiguration mockConfiguration, PaymentAccessory paymentAccessory, MockDelay mockDelay) {
        super(paymentAccessory);
        this.b = mockConfiguration;
        this.c = mockDelay;
    }

    @Override
    public void detectCardOnInterface(EnumSet<AbstractCardProcessingModule.ActiveInterface> interfaces, EnumSet<AbstractCardProcessingModule.CardProcessingTrait> traits, CardProcessingDetectCardListener listener) {
        this.setCardDetectionListener(listener);
        if (this.b.getPaymentAccessorySource() == MockConfiguration.PaymentAccessorySource.MAGSTRIPE) {
            if (!interfaces.contains((Object)AbstractCardProcessingModule.ActiveInterface.MAGSTRIPE)) {
                return;
            }
            if (this.b.getPaymentAccessoryBehavior() == MockConfiguration.PaymentAccessoryBehavior.ABORT) {
                listener.cancel(this.mAccessory, AbstractCardProcessingModule.CancelReason.USER_CANCELED);
                return;
            }
            Task.callInBackground(() -> {
                this.c.waitDelayLong();
                listener.success(this.mAccessory, AbstractCardProcessingModule.CardType.MAGSTRIPE, this.a(this.b.getPaymentDetailsScheme()));
                return null;
            });
        } else {
            if (!interfaces.contains((Object)AbstractCardProcessingModule.ActiveInterface.ICC)) {
                return;
            }
            Task.callInBackground(() -> {
                this.c.waitDelayLong(Breakpoint.DETECT_CARD_ON_INTERFACE);
                listener.success(this.mAccessory, AbstractCardProcessingModule.CardType.EMV, null);
                return null;
            });
        }
    }

    @Override
    public void startTransaction(@NotNull DefaultTransaction transaction, boolean allowPinBypass, @NotNull AidEvaluator evaluator, @NotNull EnumSet<ProcessingOptions.Behavior> behaviors, @NotNull EnumSet<AbstractCardProcessingModule.ActiveInterface> interfaces, @NotNull Function1<? super AbstractCardProcessingModule.ActiveInterface, ? extends CardProcessingStartTransactionListener> listenerProvider) {
        if (interfaces.contains((Object)AbstractCardProcessingModule.ActiveInterface.NFC)) {
            Object object = interfaces.clone();
            ((AbstractCollection)object).remove((Object)AbstractCardProcessingModule.ActiveInterface.NFC);
            this.a(transaction, (EnumSet<AbstractCardProcessingModule.ActiveInterface>)object, (CardProcessingStartTransactionListener)listenerProvider.invoke((Object)AbstractCardProcessingModule.ActiveInterface.NFC));
        } else {
            this.a(transaction, (CardProcessingStartTransactionListener)listenerProvider.invoke((Object)AbstractCardProcessingModule.ActiveInterface.ICC));
        }
    }

    private void a(DefaultTransaction defaultTransaction, CardProcessingStartTransactionListener cardProcessingStartTransactionListener) {
        this.a = cardProcessingStartTransactionListener;
        if (this.b.getPaymentAccessorySource() == MockConfiguration.PaymentAccessorySource.ICC_WITH_MULTIPLE_APPS) {
            ArrayList<ApplicationInformation> arrayList = new ArrayList<ApplicationInformation>();
            if (this.b.getPaymentDetailsScheme() == PaymentDetailsScheme.MASTERCARD) {
                arrayList.add(new DefaultApplicationInformation(0, "Mocked MasterCard", "a000000004101001"));
                arrayList.add(new DefaultApplicationInformation(1, "Mocked MasterCard Checkings", "a000000004101002"));
            } else {
                arrayList.add(new DefaultApplicationInformation(0, "Mocked VISA", "A000000003101001"));
                arrayList.add(new DefaultApplicationInformation(1, "Mocked VISA DEBIT", "A000000003101002"));
            }
            this.a.appSelection(this.mAccessory, defaultTransaction, arrayList);
        } else {
            this.a(defaultTransaction, PaymentDetailsSource.ICC, true);
        }
    }

    private void a(DefaultTransaction defaultTransaction, EnumSet<AbstractCardProcessingModule.ActiveInterface> enumSet, CardProcessingStartTransactionListener cardProcessingStartTransactionListener) {
        this.a = cardProcessingStartTransactionListener;
        if (this.b.getPaymentAccessorySource() == MockConfiguration.PaymentAccessorySource.MAGSTRIPE) {
            if (!enumSet.contains((Object)AbstractCardProcessingModule.ActiveInterface.MAGSTRIPE)) {
                return;
            }
            Task.callInBackground(() -> {
                this.c.waitDelayLong();
                cardProcessingStartTransactionListener.alternativeCard(this.mAccessory, defaultTransaction, AbstractCardProcessingModule.CardType.MAGSTRIPE, this.a(this.b.getPaymentDetailsScheme()), false);
                return null;
            });
            return;
        }
        if (this.b.getPaymentAccessorySource() == MockConfiguration.PaymentAccessorySource.ICC || this.b.getPaymentAccessorySource() == MockConfiguration.PaymentAccessorySource.ICC_WITH_MULTIPLE_APPS) {
            if (!enumSet.contains((Object)AbstractCardProcessingModule.ActiveInterface.ICC)) {
                return;
            }
            Task.callInBackground(() -> {
                this.c.waitDelayLong();
                cardProcessingStartTransactionListener.alternativeCard(this.mAccessory, defaultTransaction, AbstractCardProcessingModule.CardType.ICC, null, false);
                return null;
            });
            return;
        }
        if (this.b.getGatewayProcessingOptionsAllowedSources().size() == 1) {
            this.a(defaultTransaction, (PaymentDetailsSource)this.b.getGatewayProcessingOptionsAllowedSources().iterator().next(), this.b.getPaymentAccessoryOptions().contains((Object)MockConfiguration.PaymentAccessoryOptions.ONLINE_PIN));
            return;
        }
        this.a(defaultTransaction, PaymentDetailsSource.NFC_MAGSTRIPE, this.b.getPaymentAccessoryOptions().contains((Object)MockConfiguration.PaymentAccessoryOptions.ONLINE_PIN));
    }

    @Override
    public void continueTransactionWithAppSelection(DefaultTransaction transaction, ApplicationInformation selectedApplication, GenericOperationSuccessFailureListener<PaymentAccessory, DefaultTransaction> listener) {
        Task.callInBackground(() -> {
            if (listener != null) {
                listener.onOperationSuccess(this.mAccessory, null);
            }
            return null;
        });
        this.a(transaction, PaymentDetailsSource.ICC, true);
    }

    private void a(DefaultTransaction defaultTransaction, PaymentDetailsSource paymentDetailsSource, boolean bl2) {
        defaultTransaction.setPaymentDetails(this.a(paymentDetailsSource));
        if (bl2 && this.b(defaultTransaction, this.a)) {
            return;
        }
        Task.callInBackground(() -> {
            if (this.a == null) {
                return null;
            }
            this.c.waitDelayLong(Breakpoint.CONTINUE_TRANSACTION_AFTER_APPLICATION_SELECTION);
            if (this.b.getPaymentAccessoryBehavior().equals((Object)MockConfiguration.PaymentAccessoryBehavior.DECLINE_OFFLINE)) {
                this.a(defaultTransaction, TransactionStatusDetailsCodes.DECLINED_CARD_OR_TERMINAL_DECLINED);
                this.a.declined(this.mAccessory, defaultTransaction);
            } else if (this.b.getPaymentAccessoryBehavior().equals((Object)MockConfiguration.PaymentAccessoryBehavior.ABORT)) {
                this.a.cancel(this.mAccessory, defaultTransaction, AbstractCardProcessingModule.CancelReason.USER_CANCELED);
            } else if (this.b.getPaymentAccessoryBehavior().equals((Object)MockConfiguration.PaymentAccessoryBehavior.ERROR)) {
                this.a.failure(this.mAccessory, defaultTransaction, new DefaultMposError(ErrorType.ACCESSORY_ERROR));
            } else {
                if (this.b.getPaymentAccessoryOptions().contains((Object)MockConfiguration.PaymentAccessoryOptions.ASK_SIGNATURE)) {
                    ((DefaultPaymentDetails)defaultTransaction.getPaymentDetails()).setCustomerVerificationDetailed(PaymentDetailsCustomerVerificationDetailed.SIGNATURE);
                }
                if (this.a.continueAfterIdentification(this.mAccessory, defaultTransaction)) {
                    if (this.b.getGatewayOptions().contains((Object)MockConfiguration.GatewayOptions.DCC_SUPPORTED)) {
                        DefaultDccDetails defaultDccDetails = (DefaultDccDetails)defaultTransaction.getDccDetails();
                        defaultDccDetails.setStatusDetails(DccStatusDetails.APPLIED);
                        defaultDccDetails.setSupportedSchemes(EnumSet.of(PaymentDetailsScheme.VISA, PaymentDetailsScheme.MASTERCARD));
                        if (!this.a.dccSelection(this.mAccessory, defaultTransaction)) {
                            this.a.onlineAuthorization(this.mAccessory, defaultTransaction);
                        }
                    } else {
                        this.a.onlineAuthorization(this.mAccessory, defaultTransaction);
                    }
                } else {
                    this.a.identified(this.mAccessory, defaultTransaction);
                }
            }
            return null;
        }).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                this.a.failure(this.mAccessory, defaultTransaction, new DefaultMposError(task.getError()));
            }
            return null;
        });
    }

    @Override
    public void continueTransactionWithOnlineAuthorization(DefaultTransaction transaction, boolean onlineDialogSuccessful, CardProcessingContinueTransactionListener listener) {
        Task.callInBackground(() -> {
            boolean bl2;
            if (listener != null) {
                listener.success(this.mAccessory, transaction);
            }
            if (this.a == null) {
                return null;
            }
            this.c.waitDelayLong(Breakpoint.CONTINUE_TRANSACTION_WITH_ONLINE_AUTHORIZATION);
            boolean bl3 = bl2 = transaction.getMode() == TransactionMode.OFFLINE && transaction.getPaymentDetails().getSource() == PaymentDetailsSource.ICC;
            if (this.b.getPaymentAccessoryBehavior().equals((Object)MockConfiguration.PaymentAccessoryBehavior.DECLINE_ONLINE) || this.b.getProcessingWorkflowBehaviors().contains((Object)ProcessingOptions.Behavior.QUICK_CHIP) || bl2) {
                this.a(transaction, TransactionStatusDetailsCodes.DECLINED_CARD_OR_TERMINAL_DECLINED);
                this.a.declined(this.mAccessory, transaction);
            } else {
                this.a.approved(this.mAccessory, transaction);
            }
            return null;
        }).continueWith(task -> {
            if (task.isCancelled() || task.isFaulted()) {
                this.a.failure(this.mAccessory, transaction, new DefaultMposError(task.getError()));
            }
            return null;
        });
    }

    @Override
    public void abortTransaction(DefaultTransaction transaction, CardProcessingAbortTransactionListener listener) {
        if (listener != null) {
            listener.failure(this.mAccessory, transaction, new DefaultMposError(ErrorType.TRANSACTION_ERROR, "DefaultTransaction aborted"));
        }
    }

    @Override
    public void setNewTransaction(DefaultTransaction transaction) {
    }

    @Override
    public void detectCardRemoval(CardProcessingRemoveCardListener listener, boolean ignoreCancels) {
        Task.callInBackground(() -> {
            this.c.waitDelayShort(Breakpoint.DETECT_CARD_REMOVAL);
            if (listener != null) {
                listener.success(this.mAccessory);
            }
            return null;
        });
    }

    @Override
    public void requestPIN(DefaultTransaction transaction, boolean allowPinBypass, CardProcessingRequestPINListener listener) {
        EnumSet<MockConfiguration.PaymentAccessoryOptions> enumSet = this.b.getPaymentAccessoryOptions();
        if (MockConfiguration.PaymentAccessoryBehavior.ABORT == this.b.getPaymentAccessoryBehavior()) {
            listener.cancel(this.mAccessory, transaction);
            return;
        }
        if (enumSet.contains((Object)MockConfiguration.PaymentAccessoryOptions.PIN_BYPASS)) {
            DefaultPinInformation defaultPinInformation = new DefaultPinInformation(PinInformationStatus.UPDATED, PinInformation.PinType.ANY, 0);
            String[] stringArray = DefaultPinInformation.constructPINEntryText(defaultPinInformation, this.mAccessory.getDisplayModule().getLineWidth(), this.mAccessory.getLocale());
            this.a(transaction, defaultPinInformation, stringArray, null);
            this.c.waitDelayShort();
            listener.bypass(this.mAccessory, transaction);
            return;
        }
        this.a((BaseTransaction)transaction, null, 4);
        byte[] byArray = ByteHelper.fromHexString("BD52CFFC08402010");
        byte[] byArray2 = ByteHelper.fromHexString("000101026BDE5C000006");
        listener.success(this.mAccessory, transaction, byArray, byArray2, null, null);
    }

    private boolean b(DefaultTransaction defaultTransaction, CardProcessingStartTransactionListener cardProcessingStartTransactionListener) {
        EnumSet<MockConfiguration.PaymentAccessoryOptions> enumSet = this.b.getPaymentAccessoryOptions();
        if (enumSet.contains((Object)MockConfiguration.PaymentAccessoryOptions.PIN_ASK_OK) || enumSet.contains((Object)MockConfiguration.PaymentAccessoryOptions.PIN_WRONG) || enumSet.contains((Object)MockConfiguration.PaymentAccessoryOptions.ONLINE_PIN)) {
            PaymentDetailsCustomerVerificationDetailed paymentDetailsCustomerVerificationDetailed = enumSet.contains((Object)MockConfiguration.PaymentAccessoryOptions.ONLINE_PIN) ? PaymentDetailsCustomerVerificationDetailed.PIN_ONLINE : PaymentDetailsCustomerVerificationDetailed.PIN_OFFLINE_ENCIPHERED;
            ((DefaultPaymentDetails)defaultTransaction.getPaymentDetails()).setCustomerVerificationDetailed(paymentDetailsCustomerVerificationDetailed);
            DefaultPinInformation defaultPinInformation = new DefaultPinInformation(PinInformationStatus.STARTED, PinInformation.PinType.ONLINE, 0);
            String[] stringArray = DefaultPinInformation.constructPINEntryText(defaultPinInformation, this.mAccessory.getDisplayModule().getLineWidth(), this.mAccessory.getLocale());
            cardProcessingStartTransactionListener.pinUpdate(this.mAccessory, defaultTransaction, defaultPinInformation, stringArray);
            if (enumSet.contains((Object)MockConfiguration.PaymentAccessoryOptions.PIN_LAST_TRY) || enumSet.contains((Object)MockConfiguration.PaymentAccessoryOptions.PIN_RETRY)) {
                this.a((BaseTransaction)defaultTransaction, cardProcessingStartTransactionListener, 4);
                PinInformationStatus pinInformationStatus = PinInformationStatus.LAST_TRY;
                if (enumSet.contains((Object)MockConfiguration.PaymentAccessoryOptions.PIN_RETRY)) {
                    pinInformationStatus = PinInformationStatus.INCORRECT;
                }
                defaultPinInformation = new DefaultPinInformation(pinInformationStatus, PinInformation.PinType.ONLINE, 0);
                stringArray = DefaultPinInformation.constructPINEntryText(defaultPinInformation, this.mAccessory.getDisplayModule().getLineWidth(), this.mAccessory.getLocale());
                cardProcessingStartTransactionListener.pinUpdate(this.mAccessory, defaultTransaction, defaultPinInformation, stringArray);
            }
            if (MockConfiguration.PaymentAccessoryBehavior.ABORT == this.b.getPaymentAccessoryBehavior()) {
                this.a((BaseTransaction)defaultTransaction, cardProcessingStartTransactionListener, 2);
                cardProcessingStartTransactionListener.cancel(this.mAccessory, defaultTransaction, AbstractCardProcessingModule.CancelReason.USER_CANCELED);
                return true;
            }
            this.a((BaseTransaction)defaultTransaction, cardProcessingStartTransactionListener, 4);
            if (enumSet.contains((Object)MockConfiguration.PaymentAccessoryOptions.ONLINE_PIN)) {
                return false;
            }
            if (enumSet.contains((Object)MockConfiguration.PaymentAccessoryOptions.PIN_ASK_OK)) {
                defaultPinInformation = new DefaultPinInformation(PinInformationStatus.COMPLETED, PinInformation.PinType.ONLINE, 4);
                stringArray = DefaultPinInformation.constructPINEntryText(defaultPinInformation, this.mAccessory.getDisplayModule().getLineWidth(), this.mAccessory.getLocale());
                cardProcessingStartTransactionListener.pinUpdate(this.mAccessory, defaultTransaction, defaultPinInformation, stringArray);
                return false;
            }
            if (enumSet.contains((Object)MockConfiguration.PaymentAccessoryOptions.PIN_WRONG)) {
                defaultPinInformation = new DefaultPinInformation(PinInformationStatus.INCORRECT, PinInformation.PinType.ONLINE, 4);
                stringArray = DefaultPinInformation.constructPINEntryText(defaultPinInformation, this.mAccessory.getDisplayModule().getLineWidth(), this.mAccessory.getLocale());
                cardProcessingStartTransactionListener.pinUpdate(this.mAccessory, defaultTransaction, defaultPinInformation, stringArray);
            }
            this.a(defaultTransaction, TransactionStatusDetailsCodes.DECLINED_PIN_WRONG);
            Task.callInBackground(() -> {
                this.c.waitDelayLong();
                cardProcessingStartTransactionListener.declined(this.mAccessory, defaultTransaction);
                return null;
            });
            return true;
        }
        return false;
    }

    private MagstripeInformation a(PaymentDetailsScheme paymentDetailsScheme) {
        MagstripeInformation magstripeInformation;
        if (paymentDetailsScheme == PaymentDetailsScheme.MASTERCARD) {
            magstripeInformation = new MagstripeInformation(";510000*********0069=1412101085130111?<");
            magstripeInformation.setSredData("bb1380f00f839e062bfa1c47c0e9bb790ba11520bb29b0cd04acff8a6078dc1dbee66ddcefb2308caa8ff0812d864d9d");
            magstripeInformation.setSredKSN("ffff0203d1daa400000d");
        } else if (paymentDetailsScheme == PaymentDetailsScheme.VALUE_LINK) {
            magstripeInformation = new MagstripeInformation("601056XXXXXX4481D0001000XXXXXXXXXXXXX");
            magstripeInformation.setSredData("91F21042A18C4FF914477ED4329BDBDF30AC7235FE0ACD66DDEA3093138CCE28617C156D8AD356AA35DBE1BFF9247CC69FBEEFD74E63D6BB09C186B09ABCCDDF4671DAAFC1E1338423B25A2B1B2BE3B1E43015915C8CC100CAE138029496147A545B88FEB85E60EEBE98E62B4DF0C52ABE2556015049BE410080972A3A926B07");
            magstripeInformation.setSredKSN("FFFF99000200068004A8");
        } else {
            magstripeInformation = new MagstripeInformation(";476173XXXXXX0671=15121011350607689?6");
            magstripeInformation.setSredData("9ad308d38b76c96276e5630d4031c4fe51bebe68621100aa7cb7e684aa0d559c5b4c3e3edbe66635");
            magstripeInformation.setSredKSN("ffff0203d1daa4000009");
        }
        return magstripeInformation;
    }

    private void a(BaseTransaction baseTransaction, CardProcessingStartTransactionListener cardProcessingStartTransactionListener, int n2) {
        for (int i2 = 0; i2 <= n2; ++i2) {
            DefaultPinInformation defaultPinInformation = new DefaultPinInformation(PinInformationStatus.UPDATED, PinInformation.PinType.ANY, i2);
            String[] stringArray = DefaultPinInformation.constructPINEntryText(defaultPinInformation, this.mAccessory.getDisplayModule().getLineWidth(), this.mAccessory.getLocale());
            this.a(baseTransaction, defaultPinInformation, stringArray, cardProcessingStartTransactionListener);
            try {
                Thread.sleep(30L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                Thread.currentThread().interrupt();
                throw new RuntimeException("Unhandled thread interrupt");
            }
        }
    }

    private void a(BaseTransaction baseTransaction, PinInformation pinInformation, String[] stringArray, CardProcessingStartTransactionListener cardProcessingStartTransactionListener) {
        if (cardProcessingStartTransactionListener != null) {
            cardProcessingStartTransactionListener.pinUpdate(this.mAccessory, (DefaultTransaction)baseTransaction, pinInformation, stringArray);
        } else {
            AccessoryDisplayedTextUpdateBusEvent accessoryDisplayedTextUpdateBusEvent = new AccessoryDisplayedTextUpdateBusEvent(null, DisplayUpdateType.PIN, new DefaultPINDisplayUpdateSupport(this.mAccessory, pinInformation));
            BusProvider.getInstance().post((Object)accessoryDisplayedTextUpdateBusEvent);
        }
    }

    private void a(DefaultTransaction defaultTransaction, TransactionStatusDetailsCodes transactionStatusDetailsCodes) {
        defaultTransaction.setStatus(TransactionStatus.DECLINED);
        defaultTransaction.setStatusDetails(new DefaultTransactionStatusDetails(transactionStatusDetailsCodes, "", ""));
        PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper(defaultTransaction.getPaymentDetails());
        byte[] byArray = ByteHelper.fromHexString("8a0101");
        paymentDetailsIccWrapper.setDataAac(TLVHelper.deserializeFlatTlvObjects(byArray));
    }

    private DefaultPaymentDetails a(PaymentDetailsSource paymentDetailsSource) {
        DefaultPaymentDetails defaultPaymentDetails = new DefaultPaymentDetails();
        defaultPaymentDetails.setSource(paymentDetailsSource);
        IccInformation iccInformation = new IccInformation();
        iccInformation.setCardSequenceNumber("2");
        iccInformation.setExpirationDate("200606");
        PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper(defaultPaymentDetails);
        paymentDetailsIccWrapper.setIccInformation(iccInformation);
        if (this.b.getPaymentDetailsScheme() == PaymentDetailsScheme.MASTERCARD) {
            defaultPaymentDetails.setScheme(PaymentDetailsScheme.MASTERCARD);
            paymentDetailsIccWrapper.setApplicationName("Mocked MasterCard");
            paymentDetailsIccWrapper.setApplicationIdentifier(EnDecodeHelper.toHex("a0000000041010"));
            iccInformation.setMaskedAccountNumber("541333******0045");
            iccInformation.setSredData("0de70cc437d4a3b263af9b3b51203bf7dcf31a37279ee329");
            iccInformation.setSredKSN("ffff9900022222e00265");
            byte[] byArray = ByteHelper.fromHexString("9F2701809F360200199F2608C9963104653807E69F3901059F4104000000515F3401039F10120210A0000F240000420300000000000000FF9F37042B4B2523950500000480009A031405149F21031034319C01005F2A020978820258009F1A0202769F34034203009F3303E040C89F3501229F1E0831323334353637388408A0000000041010029F090200029B02E8009F0607A00000000410109F02060000000010009F03060000000000009F120A4D6173746572436172645F25030401015F280200569F4502DAC09F0E0500000000009F0F05F870A498009F0D05FC50A000009F4005F000F0A0019F160F2020202020202020202020202020205F20104D54495030382D32204D4344203930415F2D06656E646566729F080200025F3601025F300202018E1C0000000000000000410342031E031F00000000000000000000000000");
            paymentDetailsIccWrapper.setDataArqc(TLVHelper.deserializeFlatTlvObjects(byArray));
        } else {
            defaultPaymentDetails.setScheme(PaymentDetailsScheme.VISA);
            paymentDetailsIccWrapper.setApplicationName("Mocked VISA");
            paymentDetailsIccWrapper.setApplicationIdentifier(EnDecodeHelper.toHex("A0000000031010"));
            iccInformation.setMaskedAccountNumber("476173******0119");
            iccInformation.setSredData("8738ccd2aa71b0766d77a23f833bd9ede284304c68ff91f0");
            iccInformation.setSredKSN("ffff9900022222e0025f");
            byte[] byArray = ByteHelper.fromHexString("9F2701809F360200729F2608A396CC549D69B3DB9F3901059F41040000004F5F3401019F100706010A03A000009F3704B713B895950500000480009A031405149F21031015039C01005F2A02097882025C009F1A0202769F34030203009F3303E040C89F3501229F1E0831323334353637388407A00000000310109F0902008C9B02E8009F0607A00000000310109F02060000000010009F03060000000000009F120F4352454449544F20444520564953415F25030907015F280208409F4502DAC59F0E0500100000009F0F05F0400098009F0D05F0400088009F4005F000F0A0019F160F2020202020202020202020202020205F201A56495341204143515549524552205445535420434152442030319F0802008C5F3601025F300202018E1C00000000000000001E0302031F000000000000000000000000000000");
            paymentDetailsIccWrapper.setDataArqc(TLVHelper.deserializeFlatTlvObjects(byArray));
        }
        return defaultPaymentDetails;
    }

    @Override
    public void continueTransactionWithDccSelection(DefaultTransaction transaction, CardProcessingContinueTransactionListener listener) {
        super.continueTransactionWithDccSelection(transaction, listener);
        this.a.onlineAuthorization(this.mAccessory, transaction);
    }
}

