/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import bolts.Continuation;
import bolts.Task;
import com.visa.utils.BackendDeserializeOnlyDateFormat;
import io.mpos.accessories.AccessoryDetails;
import io.mpos.core.common.obfuscated.R;
import io.mpos.core.common.obfuscated.S;
import io.mpos.core.common.obfuscated.T;
import io.mpos.core.common.obfuscated.U;
import io.mpos.core.common.obfuscated.V;
import io.mpos.core.common.obfuscated.X;
import io.mpos.core.common.obfuscated.Y;
import io.mpos.core.common.obfuscated.aC;
import io.mpos.core.common.obfuscated.aD;
import io.mpos.core.common.obfuscated.aE;
import io.mpos.core.common.obfuscated.aF;
import io.mpos.core.common.obfuscated.aG;
import io.mpos.core.common.obfuscated.aH;
import io.mpos.core.common.obfuscated.aI;
import io.mpos.core.common.obfuscated.aJ;
import io.mpos.core.common.obfuscated.aK;
import io.mpos.core.common.obfuscated.aL;
import io.mpos.core.common.obfuscated.aM;
import io.mpos.core.common.obfuscated.aN;
import io.mpos.core.common.obfuscated.bZ;
import io.mpos.core.common.obfuscated.dx;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.mock.Breakpoint;
import io.mpos.mock.DefaultMockConfiguration;
import io.mpos.mock.MockCallType;
import io.mpos.mock.MockConfiguration;
import io.mpos.mock.MockDelay;
import io.mpos.mock.MockState;
import io.mpos.mock.MockTransactionState;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.provider.Provider;
import io.mpos.shared.accessories.AdditionalAccessoryCapabilities;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListener;
import io.mpos.shared.config.DelayConfig;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.helper.Helper;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.DefaultPaymentDetailsFactory;
import io.mpos.shared.paymentdetails.PaymentDetailsAlternativePaymentMethodWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsCustomerVerificationDetailed;
import io.mpos.shared.paymentdetails.PaymentDetailsIccWrapper;
import io.mpos.shared.processors.OfflineTransactionProcessor;
import io.mpos.shared.processors.OnlineTransactionProcessor;
import io.mpos.shared.processors.TransactionProcessor;
import io.mpos.shared.processors.payworks.services.response.DTOConversionHelper;
import io.mpos.shared.processors.payworks.services.response.dto.BackendMetricsDTO;
import io.mpos.shared.provider.ProcessingOptions;
import io.mpos.shared.provider.ProcessingOptionsContainer;
import io.mpos.shared.provider.configuration.AbstractConfiguration;
import io.mpos.shared.provider.configuration.Configuration;
import io.mpos.shared.provider.configuration.MerchantDetails;
import io.mpos.shared.storage.LegacyOfflineStorageManager;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.CurrencyWrapper;
import io.mpos.shared.transactions.DefaultDccDetails;
import io.mpos.shared.transactions.DefaultGiftCardDetails;
import io.mpos.shared.transactions.DefaultProcessingDetails;
import io.mpos.shared.transactions.DefaultRefundDetails;
import io.mpos.shared.transactions.DefaultRefundTransaction;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.shared.transactions.DefaultTransactionStatusDetails;
import io.mpos.shared.transactions.DefaultTransactionVerificationResults;
import io.mpos.shared.util.SuccessFailureListener;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.emv.TagAuthorisationResponseCode;
import io.mpos.specs.helper.EnDecodeHelper;
import io.mpos.transactions.AbortReason;
import io.mpos.transactions.Currency;
import io.mpos.transactions.DccLookupStatus;
import io.mpos.transactions.DccStatusDetails;
import io.mpos.transactions.ProcessingDetails;
import io.mpos.transactions.RefundDetailsProcess;
import io.mpos.transactions.RefundDetailsStatus;
import io.mpos.transactions.TransactionMode;
import io.mpos.transactions.TransactionStatus;
import io.mpos.transactions.TransactionStatusDetailsCodes;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.TransactionTypeDetailsCode;
import io.mpos.transactions.TransactionVerificationResult;
import io.mpos.transactions.TransactionWorkflowType;
import io.mpos.transactions.account.AccountParameters;
import io.mpos.transactions.offline.SubmittedTransaction;
import io.mpos.transactions.parameters.DefaultTransactionParameters;
import io.mpos.transactions.parameters.TransactionParameters;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class P
implements OfflineTransactionProcessor,
OnlineTransactionProcessor {
    private static final String a = P.class.getSimpleName();
    private static final MathContext b = new MathContext(4, RoundingMode.FLOOR);
    private U c;
    private T d;
    private V e;
    private S f;
    private final MockConfiguration g;
    private final MockDelay h;
    private final DelayConfig i;
    private AbstractConfiguration j;
    private TransactionMode k;
    private LegacyOfflineStorageManager l;
    private final Profiler m;
    private final MockState n;

    public P(MockConfiguration mockConfiguration, MockDelay mockDelay, MockState mockState, DelayConfig delayConfig, Provider provider, TransactionMode transactionMode, Configuration configuration, LegacyOfflineStorageManager legacyOfflineStorageManager, Profiler profiler) {
        this.m = profiler;
        this.i = delayConfig;
        this.h = mockDelay;
        this.n = mockState;
        this.k = transactionMode;
        this.l = legacyOfflineStorageManager;
        this.c = new U(provider.getPaymentDetailsFactory());
        this.d = new T();
        this.e = new V(provider);
        this.f = new S();
        this.g = mockConfiguration;
        this.j = (AbstractConfiguration)configuration;
    }

    @Override
    public void registerTransaction(TransactionParameters transactionParameters, AccessoryDetails accessoryDetails, aJ listener) {
        Task.callInBackground(() -> {
            ((DefaultMockConfiguration)this.g).setupWithAmount(transactionParameters.getAmount());
            ((DefaultMockConfiguration)this.g).setupWithSubjectIfAmountNotConflicting(transactionParameters.getSubject(), transactionParameters.getAmount());
            this.h.waitDelayLong(Breakpoint.REGISTER_TRANSACTION);
            if (this.g.getGatewayBehavior().equals((Object)MockConfiguration.GatewayBehavior.ERROR_DURING_REGISTER)) {
                listener.failure(new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Mocked ProcessingBehaviour.ERROR_DURING_REGISTER"));
                return null;
            }
            if (this.g.getGatewayBehavior().equals((Object)MockConfiguration.GatewayBehavior.ACCESSORY_NOT_WHITELISTED)) {
                listener.failure(new DefaultMposError(ErrorType.ACCESSORY_NOT_WHITELISTED, "Mocked ProcessingBehaviour.ACCESSORY_NOT_WHITELISTED"));
                return null;
            }
            DefaultTransaction defaultTransaction = this.c.a(transactionParameters, null, null, this.k);
            defaultTransaction.setIdentifier(UUID.randomUUID().toString());
            this.n.setLastTransactionState(new MockTransactionState(defaultTransaction));
            this.j.setWhitelistAccessories(this.e.a(this.g.getWhitelistBehavior()));
            this.d((BaseTransaction)defaultTransaction);
            if (this.a(this.g)) {
                ((DefaultDccDetails)defaultTransaction.getDccDetails()).setStatusDetails(DccStatusDetails.NOT_APPLIED);
            }
            ProcessingOptionsContainer processingOptionsContainer = this.f.a(this.g);
            this.j.setProcessingOptionsContainer(processingOptionsContainer);
            listener.success(defaultTransaction, new AdditionalAccessoryCapabilities(false));
            return null;
        });
    }

    @Override
    public void lookupTransactionWithSessionIdentifier(String sessionIdentifier, String accessorySerialNumber, aH listener) {
        Task.callInBackground(() -> {
            this.a(sessionIdentifier, listener);
            return null;
        });
    }

    private boolean a(String string, aH aH2) {
        Object object;
        ((DefaultMockConfiguration)this.g).setupWithAmount(DefaultMockConfiguration.AMOUNT_UNUSED);
        TransactionParameters transactionParameters = this.a();
        PaymentDetailsScheme paymentDetailsScheme = PaymentDetailsScheme.UNKNOWN;
        PaymentDetailsSource paymentDetailsSource = PaymentDetailsSource.UNKNOWN;
        switch (string) {
            case "alipaySessionIdentifier": {
                this.g.setWorkflowTypeForSessionLookups(TransactionWorkflowType.ALTERNATIVE_PAYMENT_METHOD);
                paymentDetailsScheme = PaymentDetailsScheme.ALIPAY;
                paymentDetailsSource = PaymentDetailsSource.BARCODE;
                break;
            }
            case "activationGiftCardSessionIdentifier": {
                this.g.setWorkflowTypeForSessionLookups(TransactionWorkflowType.GIFT_CARD);
                ((DefaultTransactionParameters)transactionParameters).setType(TransactionType.ACTIVATION);
                break;
            }
            case "balanceInquiryGiftCardSessionIdentifier": {
                this.g.setWorkflowTypeForSessionLookups(TransactionWorkflowType.GIFT_CARD);
                ((DefaultTransactionParameters)transactionParameters).setType(TransactionType.BALANCE_INQUIRY);
                break;
            }
            case "cashoutGiftCardSessionIdentifier": {
                this.g.setWorkflowTypeForSessionLookups(TransactionWorkflowType.GIFT_CARD);
                ((DefaultTransactionParameters)transactionParameters).setType(TransactionType.CASHOUT);
                break;
            }
            case "chargeGiftCardSessionIdentifier": {
                this.g.setWorkflowTypeForSessionLookups(TransactionWorkflowType.GIFT_CARD);
                ((DefaultTransactionParameters)transactionParameters).setType(TransactionType.CHARGE);
                break;
            }
            default: {
                Log.w(a, "no behavior found for session identifier: " + string);
            }
        }
        this.h.waitDelayLong();
        if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.ERROR_DURING_LOOKUP) {
            return this.a(string, aH2, new DefaultMposError(ErrorType.SERVER_ERROR, "Mocked GatewayBehavior.ERROR_DURING_LOOKUP"));
        }
        if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.INCONCLUSIVE_DURING_EXECUTE) {
            return this.a(string, aH2, new DefaultMposError(ErrorType.SERVER_TIMEOUT, "Mocked GatewayBehavior.INCONCLUSIVE_DURING_EXECUTE"));
        }
        if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_INCONCLUSIVE_EXECUTE || this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_INCONCLUSIVE_FINALIZE || this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_DURING_VOID) {
            object = this.n.getLastTransactionState();
            if (object != null) {
                if (((MockTransactionState)object).getCalls().contains((Object)(switch (this.g.getGatewayBehavior()) {
                    case MockConfiguration.GatewayBehavior.APPROVE_INCONCLUSIVE_EXECUTE, MockConfiguration.GatewayBehavior.APPROVE_DURING_VOID -> MockCallType.EXECUTE;
                    default -> MockCallType.FINALIZE;
                })) && ((MockTransactionState)object).getCalls().contains((Object)MockCallType.VOID)) {
                    BaseTransaction baseTransaction = ((MockTransactionState)object).getTransaction();
                    DefaultTransaction defaultTransaction = new DefaultTransaction(baseTransaction.getAmount(), baseTransaction.getCurrency(), baseTransaction.getType());
                    defaultTransaction.mergeWithTransaction(baseTransaction);
                    defaultTransaction.setStatus(TransactionStatus.APPROVED);
                    defaultTransaction.setStatusDetails(new DefaultTransactionStatusDetails(TransactionStatusDetailsCodes.APPROVED, "", ""));
                    defaultTransaction.setError(null);
                    aH2.success(string, defaultTransaction, new AdditionalAccessoryCapabilities(false));
                } else if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_DURING_VOID) {
                    BaseTransaction baseTransaction = ((MockTransactionState)object).getTransaction();
                    DefaultTransaction defaultTransaction = new DefaultTransaction(baseTransaction.getAmount(), baseTransaction.getCurrency(), baseTransaction.getType());
                    defaultTransaction.mergeWithTransaction(baseTransaction);
                    defaultTransaction.setStatus(TransactionStatus.PENDING);
                    defaultTransaction.setStatusDetails(new DefaultTransactionStatusDetails(TransactionStatusDetailsCodes.PENDING_WAITING_FOR_PROCESSOR, "", ""));
                    defaultTransaction.setError(null);
                    aH2.success(string, defaultTransaction, new AdditionalAccessoryCapabilities(false));
                } else {
                    aH2.failure(string, new DefaultMposError(ErrorType.SERVER_UNAVAILABLE, "Mocked GatewayBehavior." + this.g.getGatewayBehavior()));
                }
            } else {
                aH2.failure(string, new DefaultMposError(ErrorType.TRANSACTION_REFERENCE_NOT_FOUND, "Mocked GatewayBehavior." + this.g.getGatewayBehavior()));
            }
            return false;
        }
        object = this.c.a(transactionParameters, string, null, this.k);
        ProcessingOptionsContainer processingOptionsContainer = this.f.a(this.g);
        this.j.setProcessingOptionsContainer(processingOptionsContainer);
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)((DefaultTransaction)object).getPaymentDetails();
        defaultPaymentDetails.setWorkflowType(this.g.getWorkflowTypeForSessionLookups());
        defaultPaymentDetails.setScheme(paymentDetailsScheme);
        defaultPaymentDetails.setSource(paymentDetailsSource);
        ((DefaultTransaction)object).setWorkflow(this.g.getWorkflowTypeForSessionLookups());
        this.d((BaseTransaction)object);
        aH2.success(string, (BaseTransaction)object, new AdditionalAccessoryCapabilities(false));
        return false;
    }

    private TransactionParameters a() {
        return new TransactionParameters.Builder().charge(DefaultMockConfiguration.AMOUNT_UNUSED, Currency.EUR).subject("mock subject").customIdentifier("mockcustomIdentifier").build();
    }

    private boolean a(String string, aH aH2, DefaultMposError defaultMposError) {
        aH2.failure(string, defaultMposError);
        return true;
    }

    @Override
    public void lookupTransactionByIdentifierWithReducedTimeout(String transactionIdentifier, Locale locale, aH listener) {
        Task.callInBackground(() -> {
            if ("timeoutTransactionId".equals(transactionIdentifier)) {
                Thread.sleep(this.i.getMockTransactionLookupTimeout());
                listener.failure(transactionIdentifier, new DefaultMposError(ErrorType.SERVER_TIMEOUT, "Server timeout, error=could not read from socket"));
            } else if (transactionIdentifier == null) {
                this.a("defaultSessionId", listener);
            } else {
                this.a(transactionIdentifier, listener);
            }
            return null;
        });
    }

    @Override
    public void executeTransaction(BaseTransaction transaction, AccountParameters accountParameters, Locale locale, aE listener) {
        Task.callInBackground(() -> {
            DefaultTransaction defaultTransaction = (DefaultTransaction)transaction;
            this.h.waitDelayLong(Breakpoint.EXECUTE_TRANSACTION);
            MockTransactionState mockTransactionState = this.n.getLastTransactionState();
            if (mockTransactionState != null) {
                mockTransactionState.getCalls().add(MockCallType.EXECUTE);
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.ERROR_DURING_EXECUTE) {
                defaultTransaction.setStatus(TransactionStatus.ERROR);
                listener.a(defaultTransaction, new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Mocked ProcessingBehaviour.ERROR_DURING_EXECUTE"));
                return null;
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.INCONCLUSIVE_DURING_EXECUTE) {
                defaultTransaction.setStatus(TransactionStatus.INCONCLUSIVE);
                listener.a(defaultTransaction, new DefaultMposError(ErrorType.SERVER_TIMEOUT, "Mocked ProcessingBehaviour.INCONCLUSIVE_DURING_EXECUTE"));
                return null;
            }
            if (this.g.getGatewayBehavior().equals((Object)MockConfiguration.GatewayBehavior.ACCESSORY_NOT_WHITELISTED)) {
                listener.a(defaultTransaction, new DefaultMposError(ErrorType.ACCESSORY_NOT_WHITELISTED, "Mocked ProcessingBehaviour.ACCESSORY_NOT_WHITELISTED"));
                return null;
            }
            switch (accountParameters.getScheme()) {
                case ALIPAY: 
                case WECHAT_PAY: {
                    DefaultPaymentDetails defaultPaymentDetails = new DefaultPaymentDetails();
                    defaultPaymentDetails.setScheme(accountParameters.getScheme());
                    defaultPaymentDetails.setSource(accountParameters.getSource());
                    defaultPaymentDetails.setWorkflowType(TransactionWorkflowType.ALTERNATIVE_PAYMENT_METHOD);
                    new PaymentDetailsAlternativePaymentMethodWrapper(defaultPaymentDetails).setAccountNumber(accountParameters.getShopperAccountIdentifier());
                    if (this.g.getAlternativePaymentApprovalBehavior() == MockConfiguration.AlternativePaymentApprovalBehavior.ONLINE) {
                        defaultPaymentDetails.setCustomerVerificationDetailed(PaymentDetailsCustomerVerificationDetailed.CUSTOMER_DEVICE);
                    } else {
                        defaultPaymentDetails.setCustomerVerificationDetailed(PaymentDetailsCustomerVerificationDetailed.NONE);
                    }
                    defaultTransaction.setWorkflow(TransactionWorkflowType.ALTERNATIVE_PAYMENT_METHOD);
                    defaultTransaction.setPaymentDetails(defaultPaymentDetails);
                    defaultTransaction.setCaptured(true);
                    if (this.g.getAlternativePaymentApprovalBehavior() == MockConfiguration.AlternativePaymentApprovalBehavior.ONLINE) {
                        this.a(defaultTransaction, TransactionStatus.PENDING, TransactionStatusDetailsCodes.PENDING_WAITING_FOR_PROCESSOR, "waiting for approval");
                        break;
                    }
                    if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.DECLINE) {
                        this.a(defaultTransaction, TransactionStatus.DECLINED, TransactionStatusDetailsCodes.DECLINED_PROCESSOR, "Mocked GatewayBehavior.DECLINE");
                        break;
                    }
                    this.a(defaultTransaction, TransactionStatus.APPROVED, TransactionStatusDetailsCodes.APPROVED, "");
                    break;
                }
                case CYBERSOURCE_TOKEN: {
                    DefaultPaymentDetails defaultPaymentDetails = new DefaultPaymentDetails();
                    defaultPaymentDetails.setScheme(accountParameters.getScheme());
                    defaultPaymentDetails.setSource(accountParameters.getSource());
                    defaultPaymentDetails.setWorkflowType(TransactionWorkflowType.ALTERNATIVE_PAYMENT_METHOD);
                    defaultTransaction.setWorkflow(TransactionWorkflowType.ALTERNATIVE_PAYMENT_METHOD);
                    new PaymentDetailsAlternativePaymentMethodWrapper(defaultPaymentDetails).setAccountNumber(accountParameters.getShopperAccountIdentifier());
                    defaultTransaction.setPaymentDetails(defaultPaymentDetails);
                    if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.DECLINE) {
                        this.a(defaultTransaction, TransactionStatus.DECLINED, TransactionStatusDetailsCodes.DECLINED_PROCESSOR, "Mocked GatewayBehavior.DECLINE");
                        break;
                    }
                    this.a(defaultTransaction, TransactionStatus.APPROVED, TransactionStatusDetailsCodes.APPROVED, "");
                }
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_INCONCLUSIVE_EXECUTE && mockTransactionState != null) {
                listener.a(defaultTransaction, new DefaultMposError(ErrorType.SERVER_TIMEOUT, "Mocked GatewayBehavior.APPROVE_INCONCLUSIVE_EXECUTE"));
                return null;
            }
            listener.a(defaultTransaction);
            return null;
        });
    }

    @Override
    public void registerAndExecuteTransaction(BaseTransaction transaction, AccountParameters accountParameters, Locale locale, aE listener) {
        if (transaction.getIdentifier() == null) {
            ((DefaultTransaction)transaction).setIdentifier(UUID.randomUUID().toString());
        }
        this.n.setLastTransactionState(new MockTransactionState(transaction));
        this.executeTransaction(transaction, accountParameters, locale, listener);
    }

    @Override
    public void executeTransaction(BaseTransaction transaction, Locale locale, aE listener) {
        Task.callInBackground(() -> {
            Object object;
            DefaultTransaction defaultTransaction = (DefaultTransaction)transaction;
            this.h.waitDelayLong(Breakpoint.EXECUTE_TRANSACTION);
            MockTransactionState mockTransactionState = this.n.getLastTransactionState();
            if (mockTransactionState != null) {
                mockTransactionState.getCalls().add(MockCallType.EXECUTE);
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.ERROR_DURING_EXECUTE) {
                listener.a(transaction, new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Mocked GatewayBehavior.ERROR_DURING_EXECUTE"));
                return null;
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.INCONCLUSIVE_DURING_EXECUTE) {
                listener.a(transaction, new DefaultMposError(ErrorType.SERVER_TIMEOUT, "Mocked GatewayBehavior.INCONCLUSIVE_DURING_EXECUTE"));
                return null;
            }
            String string = "00";
            if (this.g.getGatewayOptions().contains((Object)MockConfiguration.GatewayOptions.REQUIRE_IDENTIFICATION)) {
                string = "08";
            }
            if (this.a(transaction)) {
                this.a(transaction, defaultTransaction, string);
            } else if (this.b(transaction)) {
                this.b(transaction, defaultTransaction, string);
            } else if (this.b()) {
                this.a(transaction, defaultTransaction);
            } else {
                if (this.a(defaultTransaction)) {
                    this.a(listener, defaultTransaction, TransactionStatusDetailsCodes.INITIALIZED_TRANSACTION_REQUEST_PIN);
                    return null;
                }
                if (this.b(defaultTransaction)) {
                    this.a(listener, defaultTransaction, TransactionStatusDetailsCodes.INITIALIZED_TRANSACTION_REQUEST_CUSTOMER_DEVICE_AUTHORIZATION_WITH_CVM_LIMIT_ZERO);
                    return null;
                }
                if (this.c(defaultTransaction)) {
                    this.a(listener, defaultTransaction, TransactionStatusDetailsCodes.INITIALIZED_WITH_REPLACEMENT);
                    return null;
                }
                if (this.d(defaultTransaction)) {
                    this.a(listener, defaultTransaction);
                    return null;
                }
                this.a(defaultTransaction, TransactionStatus.PENDING);
                object = new PaymentDetailsIccWrapper((DefaultPaymentDetails)transaction.getPaymentDetails());
                ((PaymentDetailsIccWrapper)object).setDataArpc(new TlvObject[]{TagAuthorisationResponseCode.create(EnDecodeHelper.toAscii(string))});
            }
            if (!transaction.getType().isRefund()) {
                this.d(transaction);
            }
            if (dx.a(transaction) && transaction.getType() != TransactionType.REFUND) {
                object = TransactionVerificationResult.UNKNOWN;
                TransactionVerificationResult transactionVerificationResult = TransactionVerificationResult.UNKNOWN;
                TransactionVerificationResult transactionVerificationResult2 = TransactionVerificationResult.UNKNOWN;
                switch (this.g.getVerificationResultsBehavior()) {
                    case ALL_MATCH: {
                        object = TransactionVerificationResult.PASSED;
                        transactionVerificationResult = TransactionVerificationResult.PASSED;
                        transactionVerificationResult2 = TransactionVerificationResult.PASSED;
                        break;
                    }
                    case CVV_MATCH_ONLY: {
                        object = TransactionVerificationResult.NOT_CHECKED;
                        transactionVerificationResult = TransactionVerificationResult.NOT_CHECKED;
                        transactionVerificationResult2 = TransactionVerificationResult.PASSED;
                        break;
                    }
                    case ADDRESS_MATCH_ONLY: {
                        object = TransactionVerificationResult.PASSED;
                        transactionVerificationResult = TransactionVerificationResult.PASSED;
                        transactionVerificationResult2 = TransactionVerificationResult.NOT_CHECKED;
                        break;
                    }
                    case NO_DATA_MATCHES: {
                        object = TransactionVerificationResult.NOT_PASSED;
                        transactionVerificationResult = TransactionVerificationResult.NOT_PASSED;
                        transactionVerificationResult2 = TransactionVerificationResult.NOT_PASSED;
                        break;
                    }
                    case DATA_NOT_CHECKED: {
                        object = TransactionVerificationResult.NOT_CHECKED;
                        transactionVerificationResult = TransactionVerificationResult.NOT_CHECKED;
                        transactionVerificationResult2 = TransactionVerificationResult.NOT_CHECKED;
                    }
                }
                defaultTransaction.setVerificationResults(new DefaultTransactionVerificationResults((TransactionVerificationResult)object, transactionVerificationResult, transactionVerificationResult2));
            }
            object = new DefaultProcessingDetails("2013-05-23 13:13:43", "96e433b0-cf74-11e2-8b8b-0800200c9a66");
            ((DefaultTransaction)transaction).setProcessingDetails((ProcessingDetails)object);
            this.a(locale, defaultTransaction);
            if (transaction.getStatus() == TransactionStatus.ACCEPTED) {
                this.a(transaction, listener);
            } else if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_INCONCLUSIVE_EXECUTE) {
                if (mockTransactionState != null) {
                    listener.a(defaultTransaction, new DefaultMposError(ErrorType.SERVER_TIMEOUT, "Mocked GatewayBehavior.APPROVE_INCONCLUSIVE_EXECUTE"));
                }
            } else {
                listener.a(transaction);
            }
            transaction.toString();
            return null;
        }).continueWith((Continuation)bZ.a("Execute transaction", transaction, listener));
    }

    private boolean a(BaseTransaction baseTransaction) {
        return this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_EARLY && (baseTransaction.getPaymentDetails().getSource() != PaymentDetailsSource.ICC || baseTransaction.getType().isRefund() || this.g.getProcessingWorkflowBehaviors().contains((Object)ProcessingOptions.Behavior.QUICK_CHIP) || ((DefaultTransaction)baseTransaction).getWorkflow() == TransactionWorkflowType.GIFT_CARD);
    }

    private void a(BaseTransaction baseTransaction, DefaultTransaction defaultTransaction, String string) throws ParseException {
        TransactionStatus transactionStatus = this.k == TransactionMode.OFFLINE ? TransactionStatus.ACCEPTED : TransactionStatus.APPROVED;
        this.a(defaultTransaction, transactionStatus);
        PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper((DefaultPaymentDetails)baseTransaction.getPaymentDetails());
        paymentDetailsIccWrapper.setDataArpc(new TlvObject[]{TagAuthorisationResponseCode.create(EnDecodeHelper.toAscii(string))});
        if (defaultTransaction.getWorkflow() == TransactionWorkflowType.GIFT_CARD) {
            switch (baseTransaction.getType()) {
                case ACTIVATION: {
                    defaultTransaction.setGiftCardDetails(this.a(BigDecimal.ZERO, baseTransaction.getAmount()));
                    break;
                }
                case BALANCE_INQUIRY: {
                    defaultTransaction.setGiftCardDetails(this.a(new BigDecimal(100), new BigDecimal(100)));
                    break;
                }
                case CASHOUT: {
                    defaultTransaction.setGiftCardDetails(this.a(new BigDecimal(100), BigDecimal.ZERO));
                    defaultTransaction.setAmount(new BigDecimal(100));
                    defaultTransaction.setCurrency(defaultTransaction.getGiftCardDetails().getCurrency());
                    break;
                }
                case CHARGE: {
                    BigDecimal bigDecimal = this.c().getCurrentBalance();
                    BigDecimal bigDecimal2 = bigDecimal.subtract(defaultTransaction.getAmount());
                    if (bigDecimal2.compareTo(BigDecimal.ZERO) >= 0) {
                        this.a(defaultTransaction, TransactionStatus.APPROVED, TransactionStatusDetailsCodes.APPROVED);
                    } else {
                        bigDecimal2 = BigDecimal.ZERO;
                        this.a(defaultTransaction, TransactionStatus.APPROVED, TransactionStatusDetailsCodes.APPROVED_PARTIALLY);
                        defaultTransaction.setAmount(bigDecimal);
                    }
                    defaultTransaction.setGiftCardDetails(this.a(bigDecimal, bigDecimal2));
                }
            }
        }
    }

    private boolean b(BaseTransaction baseTransaction) {
        return this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_PARTIALLY && this.k == TransactionMode.ONLINE && baseTransaction.getType() == TransactionType.CHARGE;
    }

    private void b(BaseTransaction baseTransaction, DefaultTransaction defaultTransaction, String string) {
        if (baseTransaction.getPaymentDetails().getSource() == PaymentDetailsSource.ICC) {
            this.a(defaultTransaction, TransactionStatus.PENDING);
            PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper((DefaultPaymentDetails)baseTransaction.getPaymentDetails());
            paymentDetailsIccWrapper.setDataArpc(new TlvObject[]{TagAuthorisationResponseCode.create(EnDecodeHelper.toAscii(string))});
        } else {
            this.a(defaultTransaction, TransactionStatus.APPROVED, TransactionStatusDetailsCodes.APPROVED_PARTIALLY);
            defaultTransaction.setAmount(baseTransaction.getAmount().multiply(BigDecimal.valueOf(0.8)).round(b));
        }
    }

    private boolean b() {
        return Helper.isInEnum(this.g.getGatewayBehavior(), MockConfiguration.GatewayBehavior.DECLINE, MockConfiguration.GatewayBehavior.DECLINE_VERIFICATION_FAILED, MockConfiguration.GatewayBehavior.DECLINE_FORBIDDEN_APPLICATION);
    }

    private void a(BaseTransaction baseTransaction, DefaultTransaction defaultTransaction) throws ParseException {
        this.a(defaultTransaction, TransactionStatus.DECLINED);
        PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper((DefaultPaymentDetails)baseTransaction.getPaymentDetails());
        paymentDetailsIccWrapper.setDataArpc(new TlvObject[]{TagAuthorisationResponseCode.create(EnDecodeHelper.toAscii("05"))});
        if (defaultTransaction.getWorkflow().equals((Object)TransactionWorkflowType.GIFT_CARD) && Helper.isInEnum(defaultTransaction.getType(), TransactionType.BALANCE_INQUIRY, TransactionType.CHARGE, TransactionType.CASHOUT)) {
            defaultTransaction.setGiftCardDetails(this.a(new BigDecimal(100), new BigDecimal(100)));
        }
        if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.DECLINE_VERIFICATION_FAILED) {
            defaultTransaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.DECLINED_VERIFICATION_FAILED);
        }
        if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.DECLINE_FORBIDDEN_APPLICATION) {
            defaultTransaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.DECLINED_FORBIDDEN_APPLICATION);
        }
    }

    private boolean a(DefaultTransaction defaultTransaction) {
        return this.g.getGatewayBehavior().equals((Object)MockConfiguration.GatewayBehavior.SCA_REQUEST_ONLINE_PIN) && defaultTransaction.getPaymentDetails().getSource().isNfc() && !defaultTransaction.getStatusDetails().getCode().equals((Object)TransactionStatusDetailsCodes.INITIALIZED_TRANSACTION_REQUEST_PIN);
    }

    private boolean b(DefaultTransaction defaultTransaction) {
        return this.g.getGatewayBehavior().equals((Object)MockConfiguration.GatewayBehavior.SCA_REQUEST_SECOND_TAP) && defaultTransaction.getPaymentDetails().getSource().isNfc() && !defaultTransaction.getStatusDetails().getCode().equals((Object)TransactionStatusDetailsCodes.INITIALIZED_TRANSACTION_REQUEST_CUSTOMER_DEVICE_AUTHORIZATION_WITH_CVM_LIMIT_ZERO);
    }

    private boolean c(DefaultTransaction defaultTransaction) {
        return this.g.getGatewayBehavior().equals((Object)MockConfiguration.GatewayBehavior.SCA_FALLBACK_TO_ICC) && defaultTransaction.getPaymentDetails().getSource().isNfc() && !defaultTransaction.getStatusDetails().getCode().equals((Object)TransactionStatusDetailsCodes.INITIALIZED_WITH_REPLACEMENT);
    }

    private void a(aE aE2, DefaultTransaction defaultTransaction, TransactionStatusDetailsCodes transactionStatusDetailsCodes) {
        this.a(defaultTransaction, TransactionStatus.INITIALIZED, transactionStatusDetailsCodes, "waiting for PIN entry");
        DefaultTransaction defaultTransaction2 = new DefaultTransaction(defaultTransaction.getAmount(), defaultTransaction.getCurrency(), defaultTransaction.getType());
        defaultTransaction.setPreviousTransaction(defaultTransaction2);
        aE2.a(defaultTransaction);
    }

    private boolean d(DefaultTransaction defaultTransaction) {
        return defaultTransaction.getType() == TransactionType.VERIFICATION;
    }

    private void a(aE aE2, DefaultTransaction defaultTransaction) {
        if (defaultTransaction.getCustomIdentifier() == null) {
            this.a(defaultTransaction, TransactionStatus.APPROVED, TransactionStatusDetailsCodes.APPROVED, "");
        } else {
            switch (defaultTransaction.getCustomIdentifier()) {
                case "pending": {
                    this.a(defaultTransaction, TransactionStatus.PENDING, TransactionStatusDetailsCodes.PENDING_AWAITING_FINALIZATION, "");
                    break;
                }
                case "decline": {
                    this.a(defaultTransaction, TransactionStatus.DECLINED, TransactionStatusDetailsCodes.DECLINED_PROCESSOR, "");
                    break;
                }
                case "error": {
                    this.a(defaultTransaction, TransactionStatus.ERROR, TransactionStatusDetailsCodes.ERROR_PROCESSOR_CONNECTION_NO_RESPONSE, "");
                    break;
                }
                default: {
                    this.a(defaultTransaction, TransactionStatus.APPROVED, TransactionStatusDetailsCodes.APPROVED, "");
                }
            }
        }
        aE2.a(defaultTransaction);
    }

    private void a(DefaultTransaction defaultTransaction, TransactionStatus transactionStatus, TransactionStatusDetailsCodes transactionStatusDetailsCodes, String string) {
        defaultTransaction.setStatus(transactionStatus);
        DefaultTransactionStatusDetails defaultTransactionStatusDetails = new DefaultTransactionStatusDetails(transactionStatusDetailsCodes, string, string);
        defaultTransaction.setStatusDetails(defaultTransactionStatusDetails);
    }

    private DefaultGiftCardDetails c() throws ParseException {
        return this.a(BigDecimal.ZERO, new BigDecimal(100));
    }

    @NotNull
    private DefaultGiftCardDetails a(BigDecimal bigDecimal, BigDecimal bigDecimal2) throws ParseException {
        DefaultGiftCardDetails defaultGiftCardDetails = new DefaultGiftCardDetails();
        defaultGiftCardDetails.setPreviousBalance(bigDecimal);
        defaultGiftCardDetails.setCurrentBalance(bigDecimal2);
        defaultGiftCardDetails.setExpiryDate(new BackendDeserializeOnlyDateFormat().parse("2030-05-01"));
        defaultGiftCardDetails.setCurrency(Currency.EUR);
        return defaultGiftCardDetails;
    }

    @Override
    public void finalizeTransaction(BaseTransaction transaction, Locale locale, aF listener) {
        Task.callInBackground(() -> {
            this.h.waitDelayLong(Breakpoint.FINALIZE_TRANSACTION);
            MockTransactionState mockTransactionState = this.n.getLastTransactionState();
            if (mockTransactionState != null) {
                mockTransactionState.getCalls().add(MockCallType.FINALIZE);
            }
            DefaultTransaction defaultTransaction = (DefaultTransaction)transaction;
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.ERROR_DURING_FINALIZE_OR_VOID) {
                this.a(defaultTransaction, TransactionStatus.ERROR);
                listener.a(transaction, new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Mocked GatewayBehavior.ERROR_DURING_FINALIZE_OR_VOID"));
            } else if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.INCONCLUSIVE_DURING_FINALIZE_OR_VOID || this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.INCONCLUSIVE_DURING_EXECUTE) {
                this.a(defaultTransaction, TransactionStatus.ERROR);
                listener.a(transaction, new DefaultMposError(ErrorType.SERVER_TIMEOUT, "Mocked GatewayBehavior.INCONCLUSIVE_DURING_FINALIZE_OR_VOID"));
            } else if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_PARTIALLY) {
                this.a(defaultTransaction, TransactionStatus.APPROVED, TransactionStatusDetailsCodes.APPROVED_PARTIALLY);
                ((DefaultTransaction)transaction).setAmount(transaction.getAmount().multiply(BigDecimal.valueOf(0.8)).round(b));
                defaultTransaction.setCaptured(defaultTransaction.isAutoCapture());
                listener.a(transaction);
            } else {
                TransactionStatus transactionStatus = this.k == TransactionMode.OFFLINE ? TransactionStatus.ACCEPTED : TransactionStatus.APPROVED;
                this.a(defaultTransaction, transactionStatus);
                defaultTransaction.setCaptured(defaultTransaction.isAutoCapture());
                DefaultRefundDetails defaultRefundDetails = new DefaultRefundDetails();
                defaultRefundDetails.setRefundDetailsProcesses(EnumSet.of(RefundDetailsProcess.ANY_CARD));
                defaultRefundDetails.setRefundDetailsStatus(RefundDetailsStatus.REFUNDABLE_PARTIAL_AND_FULL);
                defaultTransaction.setRefundDetails(defaultRefundDetails);
                this.a(locale, defaultTransaction);
                if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_INCONCLUSIVE_FINALIZE && mockTransactionState != null) {
                    listener.a(defaultTransaction, new DefaultMposError(ErrorType.SERVER_TIMEOUT, "Mocked GatewayBehavior.APPROVE_INCONCLUSIVE_FINALIZE"));
                    return null;
                }
                listener.a(transaction);
            }
            return null;
        });
    }

    @Override
    public void voidTransaction(BaseTransaction transaction, Locale locale, aN listener) {
        Task.callInBackground(() -> {
            DefaultTransaction defaultTransaction = (DefaultTransaction)transaction;
            this.h.waitDelayLong(Breakpoint.VOID_TRANSACTION);
            MockTransactionState mockTransactionState = this.n.getLastTransactionState();
            if (mockTransactionState != null) {
                mockTransactionState.getCalls().add(MockCallType.VOID);
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.ERROR_DURING_FINALIZE_OR_VOID) {
                this.a(defaultTransaction, TransactionStatus.ERROR);
                listener.failure(transaction, new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Mocked ProcessingBehaviour.ERROR_DURING_EXECUTE"));
                return null;
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.INCONCLUSIVE_DURING_FINALIZE_OR_VOID || this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.INCONCLUSIVE_DURING_EXECUTE) {
                this.a(defaultTransaction, TransactionStatus.ERROR);
                listener.failure(defaultTransaction, new DefaultMposError(ErrorType.SERVER_TIMEOUT, "Mocked GatewayBehavior.INCONCLUSIVE_DURING_FINALIZE_OR_VOID"));
                return null;
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.DECLINE_FORBIDDEN_APPLICATION) {
                defaultTransaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.DECLINED_FORBIDDEN_APPLICATION);
            } else if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_INCONCLUSIVE_EXECUTE || this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_DURING_VOID) {
                if (mockTransactionState != null && mockTransactionState.getCalls().contains((Object)MockCallType.EXECUTE)) {
                    listener.failure(defaultTransaction, new DefaultMposError(ErrorType.TRANSACTION_SESSION_EXPIRED, "Mocked GatewayBehavior." + this.g.getGatewayBehavior()));
                    return null;
                }
            } else if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_INCONCLUSIVE_FINALIZE && mockTransactionState != null && mockTransactionState.getCalls().contains((Object)MockCallType.FINALIZE)) {
                listener.failure(defaultTransaction, new DefaultMposError(ErrorType.TRANSACTION_SESSION_EXPIRED, "Mocked GatewayBehavior.APPROVE_INCONCLUSIVE_EXECUTE"));
                return null;
            }
            defaultTransaction.setCaptured(defaultTransaction.isAutoCapture());
            this.a(locale, defaultTransaction);
            listener.success(defaultTransaction);
            return null;
        });
    }

    @Override
    public void voidTransaction(String sessionIdentifier, Locale locale, AbortReason reason, aN listener) {
        Task.callInBackground(() -> {
            DefaultTransaction defaultTransaction = this.c.a(new TransactionParameters.Builder().charge(new BigDecimal("12.34"), Currency.EUR).build(), null, null, null);
            this.h.waitDelayLong(Breakpoint.VOID_TRANSACTION);
            MockTransactionState mockTransactionState = this.n.getLastTransactionState();
            if (mockTransactionState != null) {
                mockTransactionState.getCalls().add(MockCallType.VOID);
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.ERROR_DURING_FINALIZE_OR_VOID) {
                listener.failure(null, new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Mocked GatewayBehavior.ERROR_DURING_FINALIZE_OR_VOID"));
                return null;
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_INCONCLUSIVE_EXECUTE || this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_DURING_VOID) {
                if (mockTransactionState != null && mockTransactionState.getCalls().contains((Object)MockCallType.EXECUTE)) {
                    listener.failure(null, new DefaultMposError(ErrorType.TRANSACTION_SESSION_EXPIRED, "Mocked GatewayBehavior." + this.g.getGatewayBehavior()));
                    return null;
                }
            } else if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.APPROVE_INCONCLUSIVE_FINALIZE && mockTransactionState != null && mockTransactionState.getCalls().contains((Object)MockCallType.FINALIZE)) {
                listener.failure(null, new DefaultMposError(ErrorType.TRANSACTION_SESSION_EXPIRED, "Mocked GatewayBehavior.APPROVE_INCONCLUSIVE_FINALIZE"));
                return null;
            }
            this.a(defaultTransaction, TransactionStatus.ABORTED);
            listener.success(defaultTransaction);
            return null;
        });
    }

    @Override
    public void refundTransactionV2(TransactionParameters transactionParameters, Locale locale, aI listener) {
        Task.callInBackground(() -> {
            this.h.waitDelayLong();
            if (this.k == TransactionMode.OFFLINE && transactionParameters.getAmount() != null) {
                listener.failure(new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Cannot partially refund an offline transaction"));
                return null;
            }
            DefaultTransaction defaultTransaction = this.c.a(transactionParameters, null, null, this.k);
            defaultTransaction.setReferencedTransactionIdentifier(transactionParameters.getReferencedTransactionIdentifier());
            this.j.setWhitelistAccessories(this.e.a(this.g.getWhitelistBehavior()));
            ProcessingOptionsContainer processingOptionsContainer = this.f.a(this.g);
            this.j.setProcessingOptionsContainer(processingOptionsContainer);
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.DECLINE) {
                this.a(defaultTransaction, TransactionStatus.DECLINED);
            } else {
                this.a(defaultTransaction, TransactionStatus.APPROVED);
            }
            this.a(locale, defaultTransaction);
            listener.success(defaultTransaction);
            return null;
        });
    }

    @Override
    public void refundTransactionV21(TransactionParameters transactionParameters, Locale locale, aI listener) {
        Task.callInBackground(() -> {
            this.h.waitDelayLong();
            if (this.k == TransactionMode.OFFLINE && transactionParameters.getAmount() != null) {
                listener.failure(new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Cannot partially refund an offline transaction"));
                return null;
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.DECLINE) {
                listener.failure(new DefaultMposError(ErrorType.TRANSACTION_DECLINED, "Refund was declined"));
                return null;
            }
            DefaultTransaction defaultTransaction = this.c.a(transactionParameters, null, null, this.k);
            defaultTransaction.setIdentifier(transactionParameters.getReferencedTransactionIdentifier());
            this.j.setWhitelistAccessories(this.e.a(this.g.getWhitelistBehavior()));
            ProcessingOptionsContainer processingOptionsContainer = this.f.a(this.g);
            this.j.setProcessingOptionsContainer(processingOptionsContainer);
            TransactionStatus transactionStatus = this.k == TransactionMode.OFFLINE ? TransactionStatus.ACCEPTED : TransactionStatus.APPROVED;
            this.a(defaultTransaction, transactionStatus);
            DefaultRefundTransaction defaultRefundTransaction = new DefaultRefundTransaction();
            defaultRefundTransaction.setStatus(transactionStatus);
            defaultRefundTransaction.setAmount(defaultTransaction.getAmount());
            defaultRefundTransaction.setCurrency(defaultTransaction.getCurrency());
            defaultRefundTransaction.setCode(TransactionTypeDetailsCode.REFUND_AFTER_CLEARING);
            defaultRefundTransaction.setType(TransactionType.CHARGE);
            defaultRefundTransaction.setIdentifier(UUID.randomUUID().toString());
            DefaultRefundDetails defaultRefundDetails = new DefaultRefundDetails();
            defaultRefundDetails.setRefundDetailsStatus(RefundDetailsStatus.REFUNDED);
            defaultRefundDetails.setRefundDetailsProcesses(EnumSet.noneOf(RefundDetailsProcess.class));
            defaultRefundDetails.setRefundTransactions(Collections.singletonList(defaultRefundTransaction));
            defaultTransaction.setRefundDetails(defaultRefundDetails);
            this.a(locale, defaultTransaction);
            listener.success(defaultTransaction);
            return null;
        });
    }

    @Override
    public void captureTransaction(TransactionParameters transactionParameters, Locale locale, aC listener) {
        Task.callInBackground(() -> {
            this.h.waitDelayLong();
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.ERROR_DURING_EXECUTE) {
                listener.failure(new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Mocked ProcessingBehaviour.ERROR_DURING_EXECUTE"));
                return null;
            }
            DefaultTransaction defaultTransaction = this.c.a(transactionParameters, null, transactionParameters.getReferencedTransactionIdentifier(), this.k);
            defaultTransaction.setCaptured(true);
            this.a(defaultTransaction, TransactionStatus.APPROVED);
            this.a(locale, defaultTransaction);
            listener.success(defaultTransaction);
            return null;
        });
    }

    @Override
    public void tipAdjustTransaction(TransactionParameters transactionParameters, Locale locale, aM listener) {
        Task.callInBackground(() -> {
            this.h.waitDelayLong();
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.ERROR_DURING_EXECUTE) {
                listener.failure(new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Mocked ProcessingBehaviour.ERROR_DURING_EXECUTE"));
                return null;
            }
            DefaultTransaction defaultTransaction = this.c.a(transactionParameters);
            this.a(defaultTransaction, TransactionStatus.APPROVED);
            this.a(locale, defaultTransaction);
            listener.success(defaultTransaction);
            return null;
        });
    }

    @Override
    public void sendTransactionMetrics(GenericOperationSuccessFailureListener<TransactionProcessor, Void> listener) {
        Task.callInBackground(() -> {
            this.h.waitDelayShort(Breakpoint.SEND_TRANSACTION_METRICS);
            BackendMetricsDTO backendMetricsDTO = new DTOConversionHelper().createBackendMetricsDTO(this.m);
            this.a(Collections.singletonList(backendMetricsDTO), listener);
            return null;
        });
    }

    @Override
    public void submitTransactionMetrics(List<BackendMetricsDTO> metrics, GenericOperationSuccessFailureListener<TransactionProcessor, Void> listener) {
        Task.callInBackground(() -> {
            this.h.waitDelayShort();
            this.a((List<? extends BackendMetricsDTO>)metrics, listener);
            return null;
        });
    }

    @Override
    public void requestOfflineConfiguration(Locale locale, aK listener) {
        Task.callInBackground(() -> {
            this.h.waitDelayShort(Breakpoint.REQUEST_OFFLINE_CONFIGURATION_TOKENS);
            if (this.g.getSynchronizeConfigurationBehavior() == MockConfiguration.SynchronizeConfigurationBehavior.ERROR) {
                listener.a(new DefaultMposError(ErrorType.SERVER_UNAVAILABLE, "Mocked SynchronizeConfigurationBehavior.ERROR"));
                return null;
            }
            MerchantDetails merchantDetails = new R().a();
            listener.a(merchantDetails);
            return null;
        });
    }

    @Override
    public void submitTransactionsBatch(String batchIdentifier, List<? extends BaseTransaction> transactions, final aL listener) {
        Task.callInBackground(() -> {
            this.h.waitDelayShort();
            final ArrayList<SubmittedTransaction> arrayList = new ArrayList<SubmittedTransaction>();
            MockConfiguration.SubmitTransactionsBatchBehavior submitTransactionsBatchBehavior = this.g.getSubmitTransactionBehavior();
            switch (submitTransactionsBatchBehavior) {
                case SUCCESS: {
                    int n2;
                    for (n2 = 0; n2 < transactions.size(); ++n2) {
                        arrayList.add(this.c.a(TransactionStatusDetailsCodes.APPROVED));
                    }
                    break;
                }
                case ERROR: {
                    listener.a(new DefaultMposError(ErrorType.SERVER_UNAVAILABLE, "Mocked SubmitTransactionsBatchBehavior.ERROR"));
                    return null;
                }
                case PENDING_MANUAL_REVIEW: {
                    int n2;
                    for (n2 = 0; n2 < transactions.size(); ++n2) {
                        arrayList.add(this.c.a(TransactionStatusDetailsCodes.ERROR_TRANSACTION_PENDING_MANUAL_REVIEW));
                    }
                    break;
                }
            }
            Y y2 = (Y)this.l.getTransactionStorage();
            y2.a(transactions, new SuccessFailureListener<Void>(){

                public void a() {
                    listener.a(arrayList);
                }

                @Override
                public void onFailure(MposError error) {
                    listener.a(error);
                }

                @Override
                public /* synthetic */ void onSuccess(Object object) {
                    Void cfr_ignored_0 = (Void)object;
                    this.a();
                }
            });
            return null;
        });
    }

    @Override
    public void dccLookup(BaseTransaction transaction, aD listener) {
        DefaultTransaction defaultTransaction = this.c(transaction);
        DefaultDccDetails defaultDccDetails = (DefaultDccDetails)defaultTransaction.getDccDetails();
        this.a(defaultDccDetails, this.g, defaultTransaction);
        if (this.g.getDccLookupBehavior() == MockConfiguration.DccLookupBehavior.ERROR) {
            new DefaultMposError(ErrorType.SERVER_ERROR);
            listener.a();
        } else {
            listener.a(defaultTransaction, defaultTransaction.getDccDetails());
        }
    }

    @Override
    public void incrementalAuthorizationTransaction(TransactionParameters transactionParameters, Locale locale, aG listener) {
        Task.callInBackground(() -> {
            this.h.waitDelayLong();
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.ERROR_DURING_EXECUTE) {
                listener.failure(new DefaultMposError(ErrorType.TRANSACTION_ERROR, "Mocked ProcessingBehaviour.ERROR_DURING_EXECUTE"));
                return null;
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.INCREMENTAL_AUTH_NOT_POSSIBLE) {
                listener.failure(new DefaultMposError(ErrorType.INCREMENTAL_AUTH_NOT_POSSIBLE, "Mocked ProcessingBehaviour.INCREMENTAL_AUTH_NOT_POSSIBLE"));
                return null;
            }
            if (this.g.getGatewayBehavior() == MockConfiguration.GatewayBehavior.INCREMENTAL_AUTH_NOT_SUPPORTED_BY_CARD) {
                listener.failure(new DefaultMposError(ErrorType.INCREMENTAL_AUTH_NOT_SUPPORTED_BY_CARD, "Mocked ProcessingBehaviour.INCREMENTAL_AUTH_NOT_SUPPORTED_BY_CARD"));
                return null;
            }
            DefaultTransaction defaultTransaction = this.c.a(transactionParameters, null, transactionParameters.getReferencedTransactionIdentifier(), this.k);
            this.a(defaultTransaction, TransactionStatus.APPROVED);
            this.a(locale, defaultTransaction);
            listener.success(defaultTransaction);
            return null;
        });
    }

    private void a(final BaseTransaction baseTransaction, final aE aE2) {
        this.l.getTransactionStorage().a(baseTransaction, new SuccessFailureListener<Void>(){

            public void a() {
                aE2.a(baseTransaction);
            }

            @Override
            public void onFailure(MposError error) {
                aE2.a(baseTransaction, error);
            }

            @Override
            public /* synthetic */ void onSuccess(Object object) {
                Void cfr_ignored_0 = (Void)object;
                this.a();
            }
        });
    }

    private void a(List<? extends BackendMetricsDTO> list, final GenericOperationSuccessFailureListener<TransactionProcessor, Void> genericOperationSuccessFailureListener2) {
        X x2 = (X)this.l.getMetricsStorage();
        x2.a(list, new SuccessFailureListener<Void>(){

            public void a() {
                genericOperationSuccessFailureListener2.onOperationSuccess(P.this, null);
            }

            @Override
            public void onFailure(MposError error) {
                genericOperationSuccessFailureListener2.onOperationFailure(P.this, error);
            }

            @Override
            public /* synthetic */ void onSuccess(Object object) {
                Void cfr_ignored_0 = (Void)object;
                this.a();
            }
        });
    }

    private DefaultTransaction c(BaseTransaction baseTransaction) {
        U u2 = new U(new DefaultPaymentDetailsFactory());
        return u2.a(new TransactionParameters.Builder().charge(baseTransaction.getAmount(), baseTransaction.getCurrency()).build(), null, null, baseTransaction.getMode());
    }

    private boolean a(MockConfiguration mockConfiguration) {
        return mockConfiguration.getGatewayOptions().contains((Object)MockConfiguration.GatewayOptions.DCC_SUPPORTED);
    }

    private void a(Locale locale, DefaultTransaction defaultTransaction) {
        defaultTransaction.setCustomerReceipt(this.d.a(locale, defaultTransaction));
        defaultTransaction.setMerchantReceipt(this.d.b(locale, defaultTransaction));
    }

    private void a(DefaultTransaction defaultTransaction, TransactionStatus transactionStatus, TransactionStatusDetailsCodes transactionStatusDetailsCodes) {
        defaultTransaction.setStatus(transactionStatus);
        defaultTransaction.getStatusDetails().setCode(transactionStatusDetailsCodes);
    }

    private void a(DefaultTransaction defaultTransaction, TransactionStatus transactionStatus) {
        switch (transactionStatus) {
            case UNKNOWN: 
            case INITIALIZED: {
                defaultTransaction.setStatus(TransactionStatus.INITIALIZED);
                defaultTransaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.INITIALIZED_AT_PROCESSOR);
                break;
            }
            case PENDING: {
                defaultTransaction.setStatus(TransactionStatus.PENDING);
                defaultTransaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.PENDING_AWAITING_FINALIZATION);
                break;
            }
            case APPROVED: {
                defaultTransaction.setStatus(TransactionStatus.APPROVED);
                defaultTransaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.APPROVED);
                break;
            }
            case ACCEPTED: {
                defaultTransaction.setStatus(TransactionStatus.ACCEPTED);
                defaultTransaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.ACCEPTED_WAITING_FOR_SUBMISSION);
                break;
            }
            case DECLINED: {
                defaultTransaction.setStatus(TransactionStatus.DECLINED);
                defaultTransaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.DECLINED_PROCESSOR);
                break;
            }
            case ERROR: {
                defaultTransaction.setStatus(TransactionStatus.ERROR);
                defaultTransaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.ERROR_INVALID_PROCESSOR_STATUS);
                break;
            }
            case INCONCLUSIVE: {
                defaultTransaction.setStatus(TransactionStatus.INCONCLUSIVE);
                defaultTransaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.ERROR_SERVER_TIMEOUT);
                break;
            }
            case ABORTED: {
                defaultTransaction.setStatus(TransactionStatus.ABORTED);
                defaultTransaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.ABORTED_MERCHANT_ABORTED);
            }
        }
    }

    private void a(DefaultDccDetails defaultDccDetails, MockConfiguration mockConfiguration, BaseTransaction baseTransaction) {
        if (this.a(mockConfiguration)) {
            switch (mockConfiguration.getDccLookupBehavior()) {
                case SUCCESSFUL: {
                    defaultDccDetails.setConvertedAmount(new BigDecimal("2.13"));
                    defaultDccDetails.setConvertedCurrency(Currency.USD);
                    defaultDccDetails.setMarkup(new BigDecimal("1.41"));
                    defaultDccDetails.setRate(new BigDecimal("2.13"));
                    defaultDccDetails.setConversionHint(this.a(baseTransaction.getAmount(), defaultDccDetails.getConvertedAmount(), baseTransaction.getCurrency(), defaultDccDetails.getConvertedCurrency(), defaultDccDetails.getMarkup()));
                    defaultDccDetails.setStatusDetails(DccStatusDetails.NOT_APPLIED);
                    defaultDccDetails.setDccLookupStatus(DccLookupStatus.SUCCESSFUL);
                    break;
                }
                case SAME_CURRENCY: {
                    defaultDccDetails.setStatusDetails(DccStatusDetails.NOT_APPLIED_SAME_CURRENCY);
                    defaultDccDetails.setDccLookupStatus(DccLookupStatus.SAME_CURRENCY);
                    break;
                }
                case NOT_SUCCESSFUL: {
                    defaultDccDetails.setStatusDetails(DccStatusDetails.NOT_APPLIED);
                    defaultDccDetails.setDccLookupStatus(DccLookupStatus.NOT_SUCCESSFUL);
                }
            }
            defaultDccDetails.setSupportedSchemes(EnumSet.of(PaymentDetailsScheme.VISA, PaymentDetailsScheme.MASTERCARD));
        } else {
            defaultDccDetails.setDccLookupStatus(DccLookupStatus.NOT_SUCCESSFUL);
        }
    }

    private void d(BaseTransaction baseTransaction) {
        DefaultDccDetails defaultDccDetails = (DefaultDccDetails)baseTransaction.getDccDetails();
        if (this.a(this.g)) {
            defaultDccDetails.setSupportedSchemes(EnumSet.of(PaymentDetailsScheme.VISA, PaymentDetailsScheme.MASTERCARD));
        }
    }

    public static String a(BigDecimal bigDecimal, Currency currency) {
        return new CurrencyWrapper(currency).formatAmount(bigDecimal);
    }

    public static String a(BigDecimal bigDecimal) {
        return bigDecimal != null ? new DecimalFormat().format(bigDecimal) : "";
    }

    private String a(BigDecimal bigDecimal, BigDecimal bigDecimal2, Currency currency, Currency currency2, BigDecimal bigDecimal3) {
        BigDecimal bigDecimal4 = bigDecimal.divide(bigDecimal, 4, RoundingMode.HALF_UP);
        BigDecimal bigDecimal5 = bigDecimal2.divide(bigDecimal, 4, RoundingMode.HALF_UP);
        String string = String.format("%s %s = %s %s, Int'l Margin %s%%", P.a(bigDecimal4, currency), currency, P.a(bigDecimal5, currency2), currency2, P.a(bigDecimal3));
        return string;
    }
}

