/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import com.visa.utils.BackendDeserializeOnlyDateFormat;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.paymentdetails.PaymentDetailsFactory;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.helper.Helper;
import io.mpos.shared.helper.TimeHelper;
import io.mpos.shared.paymentdetails.PaymentDetailsCustomerVerificationDetailed;
import io.mpos.shared.transactions.DefaultGiftCardDetails;
import io.mpos.shared.transactions.DefaultRefundDetails;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.shared.transactions.DefaultTransactionStatusDetails;
import io.mpos.shared.transactions.offline.DefaultSubmittedRefundDetails;
import io.mpos.shared.transactions.offline.DefaultSubmittedTransaction;
import io.mpos.transactions.Currency;
import io.mpos.transactions.DefaultTransactionDetails;
import io.mpos.transactions.RefundDetailsProcess;
import io.mpos.transactions.RefundDetailsStatus;
import io.mpos.transactions.RefundTransaction;
import io.mpos.transactions.TipAdjustStatus;
import io.mpos.transactions.TransactionMode;
import io.mpos.transactions.TransactionState;
import io.mpos.transactions.TransactionStatus;
import io.mpos.transactions.TransactionStatusDetailsCodes;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.TransactionWorkflowType;
import io.mpos.transactions.offline.SubmittedTransaction;
import io.mpos.transactions.parameters.TransactionParameters;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.UUID;

public class U {
    private final PaymentDetailsFactory a;

    public U(PaymentDetailsFactory paymentDetailsFactory) {
        this.a = paymentDetailsFactory;
    }

    public DefaultTransaction a(TransactionParameters transactionParameters, String string, String string2, TransactionMode transactionMode) {
        if (string == null) {
            string = "d8ccd88b-bd40-4fce-bc1e-981496dfb018";
        }
        if (string2 == null) {
            string2 = Helper.createRandomUUID().replace("-", "");
        }
        BigDecimal bigDecimal = transactionParameters.getAmount() != null ? transactionParameters.getAmount() : new BigDecimal("1.23");
        Currency currency = transactionParameters.getCurrency() != null && !transactionParameters.getCurrency().equals((Object)Currency.UNKNOWN) ? transactionParameters.getCurrency() : Currency.EUR;
        DefaultTransaction defaultTransaction = new DefaultTransaction(bigDecimal, currency, transactionParameters.getType());
        defaultTransaction.setAutoCapture(transactionParameters.isAutoCapture());
        defaultTransaction.setSessionIdentifier(string);
        defaultTransaction.setIdentifier(string2);
        defaultTransaction.setCustomIdentifier(transactionParameters.getCustomIdentifier());
        defaultTransaction.setSubject(transactionParameters.getSubject());
        defaultTransaction.setCreatedTimestamp(System.currentTimeMillis());
        defaultTransaction.setCreatedTimeZone(TimeHelper.getCurrentTimeZone());
        defaultTransaction.setStatus(TransactionStatus.INITIALIZED);
        defaultTransaction.setState(TransactionState.IDLE);
        defaultTransaction.setReferencedTransactionIdentifier(transactionParameters.getReferencedTransactionIdentifier());
        defaultTransaction.setMode(transactionMode);
        defaultTransaction.setWorkflow(transactionParameters.getWorkflow());
        defaultTransaction.setWorkflowConfiguration(transactionParameters.getWorkflowConfiguration());
        defaultTransaction.setPaymentDetails(this.a.createPaymentDetails(PaymentDetailsScheme.UNKNOWN, PaymentDetailsSource.UNKNOWN, PaymentDetailsCustomerVerificationDetailed.UNKNOWN, transactionParameters.getWorkflow(), null));
        DefaultRefundDetails defaultRefundDetails = new DefaultRefundDetails();
        defaultRefundDetails.setRefundDetailsProcesses(EnumSet.of(RefundDetailsProcess.WITHOUT_CARD));
        defaultRefundDetails.setRefundDetailsStatus(RefundDetailsStatus.REFUNDABLE_PARTIAL_AND_FULL);
        defaultRefundDetails.setRefundTransactions(new ArrayList<RefundTransaction>());
        defaultTransaction.setRefundDetails(defaultRefundDetails);
        DefaultTransactionDetails defaultTransactionDetails = new DefaultTransactionDetails();
        defaultTransactionDetails.setTipAdjustStatus(transactionParameters.isTipAdjustable() ? TipAdjustStatus.ADJUSTABLE : TipAdjustStatus.NOT_ADJUSTABLE);
        defaultTransactionDetails.setIncludedTipAmount(transactionParameters.getIncludedTipAmount());
        defaultTransactionDetails.setCashbackAmount(transactionParameters.getCashbackAmount());
        defaultTransactionDetails.setMetadata(transactionParameters.getMetadata());
        defaultTransaction.setDetails(defaultTransactionDetails);
        if (defaultTransaction.getType() != null) {
            defaultTransaction = this.a(defaultTransaction);
        }
        return defaultTransaction;
    }

    public DefaultTransaction a(TransactionParameters transactionParameters) {
        TransactionParameters transactionParameters2 = new TransactionParameters.Builder().charge(BigDecimal.TEN, transactionParameters.getCurrency()).subject("mockSubject").customIdentifier("mockCustomIdentifier").tipAdjustable(true).autoCapture(false).build();
        DefaultTransaction defaultTransaction = this.a(transactionParameters2, null, transactionParameters.getReferencedTransactionIdentifier(), TransactionMode.ONLINE);
        DefaultTransactionDetails defaultTransactionDetails = (DefaultTransactionDetails)defaultTransaction.getDetails();
        defaultTransaction.setAmount(defaultTransaction.getAmount().add(transactionParameters.getAmount()));
        defaultTransactionDetails.setTipAdjustStatus(TipAdjustStatus.ADJUSTED);
        defaultTransactionDetails.setIncludedTipAmount(transactionParameters.getAmount());
        return defaultTransaction;
    }

    public SubmittedTransaction a(TransactionStatusDetailsCodes transactionStatusDetailsCodes) {
        DefaultTransactionStatusDetails defaultTransactionStatusDetails = new DefaultTransactionStatusDetails(transactionStatusDetailsCodes, transactionStatusDetailsCodes.name(), transactionStatusDetailsCodes.name());
        DefaultSubmittedRefundDetails defaultSubmittedRefundDetails = new DefaultSubmittedRefundDetails(RefundDetailsStatus.REFUNDABLE_FULL_ONLY, null);
        return new DefaultSubmittedTransaction(UUID.randomUUID().toString(), defaultTransactionStatusDetails, defaultSubmittedRefundDetails);
    }

    private DefaultTransaction a(DefaultTransaction defaultTransaction) {
        Date date;
        DefaultGiftCardDetails defaultGiftCardDetails = new DefaultGiftCardDetails();
        try {
            date = new BackendDeserializeOnlyDateFormat().parse("2030-05-01");
        }
        catch (ParseException parseException) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.INTERNAL_INCONSISTENCY, "Error when parsing expiration date"));
        }
        BigDecimal bigDecimal = new BigDecimal("100");
        if (TransactionType.ACTIVATION.equals((Object)defaultTransaction.getType())) {
            defaultGiftCardDetails.setCurrentBalance(defaultTransaction.getAmount());
            defaultGiftCardDetails.setCurrency(Currency.EUR);
            defaultGiftCardDetails.setExpiryDate(date);
        } else if (TransactionType.BALANCE_INQUIRY.equals((Object)defaultTransaction.getType())) {
            defaultGiftCardDetails.setCurrentBalance(bigDecimal);
            defaultGiftCardDetails.setPreviousBalance(bigDecimal);
            defaultGiftCardDetails.setCurrency(Currency.EUR);
            defaultGiftCardDetails.setExpiryDate(date);
            defaultTransaction = this.b(defaultTransaction);
        } else if (TransactionType.CASHOUT.equals((Object)defaultTransaction.getType())) {
            defaultGiftCardDetails.setCurrentBalance(new BigDecimal(0));
            defaultGiftCardDetails.setPreviousBalance(bigDecimal);
            defaultGiftCardDetails.setCurrency(Currency.EUR);
            defaultGiftCardDetails.setExpiryDate(date);
            defaultTransaction = this.b(defaultTransaction);
        } else if (TransactionType.CHARGE.equals((Object)defaultTransaction.getType()) && TransactionWorkflowType.GIFT_CARD.equals((Object)defaultTransaction.getWorkflow())) {
            BigDecimal bigDecimal2 = defaultTransaction.getAmount().subtract(bigDecimal);
            if (bigDecimal2.compareTo(BigDecimal.ZERO) < 0) {
                bigDecimal2 = BigDecimal.ZERO;
            }
            defaultGiftCardDetails.setCurrentBalance(bigDecimal2);
            defaultGiftCardDetails.setPreviousBalance(bigDecimal);
            defaultGiftCardDetails.setCurrency(Currency.EUR);
            defaultGiftCardDetails.setExpiryDate(date);
        }
        defaultTransaction.setGiftCardDetails(defaultGiftCardDetails);
        return defaultTransaction;
    }

    private DefaultTransaction b(DefaultTransaction defaultTransaction) {
        defaultTransaction.setAmount(null);
        defaultTransaction.setCurrency(Currency.UNKNOWN);
        return defaultTransaction;
    }
}

