/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.helper.AssetsHandler;
import io.mpos.shared.localization.LocalizationServer;
import io.mpos.shared.processors.payworks.services.response.BackendObjectMapperKt;
import io.mpos.shared.receipt.ReceiptLocalization;
import io.mpos.utils.InputStreamAsStringKt;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0012\u0010\f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/mpos/internal/receipt/ReceiptAssetsLoader;", "", "assetsHandler", "Lio/mpos/shared/helper/AssetsHandler;", "<init>", "(Lio/mpos/shared/helper/AssetsHandler;)V", "tag", "", "loadReceiptLocalization", "Lio/mpos/shared/receipt/ReceiptLocalization;", "locale", "Ljava/util/Locale;", "loadReceiptAsset", "getReceiptAssetPath", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nReceiptAssetsLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReceiptAssetsLoader.kt\nio/mpos/internal/receipt/ReceiptAssetsLoader\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,43:1\n222#2:44\n*S KotlinDebug\n*F\n+ 1 ReceiptAssetsLoader.kt\nio/mpos/internal/receipt/ReceiptAssetsLoader\n*L\n37#1:44\n*E\n"})
public final class cA {
    @NotNull
    private final AssetsHandler a;
    @NotNull
    private final String b;

    public cA(@NotNull AssetsHandler assetsHandler) {
        Intrinsics.checkNotNullParameter((Object)assetsHandler, (String)"");
        this.a = assetsHandler;
        this.b = "ReceiptAssetsLoader";
    }

    @NotNull
    public final ReceiptLocalization a(@Nullable Locale locale) {
        ReceiptLocalization receiptLocalization;
        try {
            receiptLocalization = this.b(locale);
        }
        catch (MposRuntimeException mposRuntimeException) {
            Locale locale2 = LocalizationServer.FALLBACK_DEFAULT;
            String cfr_ignored_0 = "Localization for '" + locale + "' not available, falling back to: " + locale2;
            receiptLocalization = this.b(locale2);
        }
        catch (IOException iOException) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.SDK_RESOURCES_NOT_FOUND, "Receipt localization for '" + locale + "' could not be resolved"));
        }
        return receiptLocalization;
    }

    private final ReceiptLocalization b(Locale locale) {
        Locale locale2 = LocalizationServer.checkAndAssignLocaleWithFallbackToLanguage(locale);
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"");
        Locale locale3 = locale2;
        String string = this.c(locale3);
        Json json = BackendObjectMapperKt.getBackendObjectMapper();
        BufferedInputStream bufferedInputStream = this.a.resolveAndCheckAsset(string);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedInputStream, (String)"");
        String string2 = InputStreamAsStringKt.readEntireStreamAsString$default(bufferedInputStream, null, 1, null);
        json.getSerializersModule();
        return (ReceiptLocalization)json.decodeFromString((DeserializationStrategy)ReceiptLocalization.Companion.serializer(), string2);
    }

    private final String c(Locale locale) {
        return "io.payworks.mpos.l10n/receipts/receipt-" + locale.getLanguage() + "_" + locale.getCountry() + ".json";
    }
}

