/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import bolts.Task;
import io.mpos.accessories.Accessory;
import io.mpos.accessories.AccessoryConnectionType;
import io.mpos.accessories.parameters.AccessoryParameters;
import io.mpos.core.common.obfuscated.db;
import io.mpos.core.common.obfuscated.dy;
import io.mpos.core.common.obfuscated.et;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.platform.EventDispatcher;
import io.mpos.provider.Provider;
import io.mpos.provider.listener.AccessoryConnectionStateListener;
import io.mpos.shared.localization.LocalizationPrompt;
import io.mpos.shared.transactionprovider.DefaultAccessoryModule;
import io.mpos.shared.transactionprovider.StartableAccessoryProcess;
import io.mpos.transactionprovider.AccessoryConnectListener;
import io.mpos.transactionprovider.AccessoryDisconnectListener2;
import io.mpos.transactionprovider.AccessoryProcess;
import io.mpos.transactionprovider.AccessoryProcessDetails;
import io.mpos.transactionprovider.AccessoryProcessDetailsState;
import io.mpos.transactionprovider.AccessoryProcessDetailsStateDetails;

public class da
implements StartableAccessoryProcess {
    private final DefaultAccessoryModule a;
    private final Provider b;
    private final EventDispatcher c;
    private final AccessoryParameters d;
    private AccessoryConnectListener e;
    private Accessory f;
    private final Object g = new Object();
    private AccessoryProcessDetails h;
    private boolean i;
    private boolean j;
    private boolean k;
    private boolean l;
    private AccessoryConnectionStateListener m = new a();

    public da(Provider provider, EventDispatcher eventDispatcher, DefaultAccessoryModule defaultAccessoryModule, AccessoryParameters accessoryParameters, AccessoryConnectListener accessoryConnectListener) {
        if (provider == null) {
            throw new IllegalStateException("no provider to work with. You have to create a TransactionProvider first.");
        }
        this.b = provider;
        this.c = eventDispatcher;
        this.a = defaultAccessoryModule;
        this.d = accessoryParameters;
        this.e = accessoryConnectListener;
    }

    public da(Provider provider, EventDispatcher eventDispatcher, DefaultAccessoryModule defaultAccessoryModule, AccessoryParameters accessoryParameters, AccessoryConnectListener accessoryConnectListener, boolean bl2) {
        this(provider, eventDispatcher, defaultAccessoryModule, accessoryParameters, accessoryConnectListener);
        this.l = bl2;
    }

    @Override
    public void start() {
        Log.i("ConnectToAccessoryProcess", "Requesting connect to accessory: " + this.d);
        this.j = false;
        if (this.a.isConnected(this.d)) {
            Object object = this.g;
            synchronized (object) {
                this.f = this.a.getConnectedAccessory(this.d);
            }
            this.g();
        } else if (this.a.isConnected()) {
            this.a(AccessoryProcessDetailsStateDetails.CONNECTING_TO_ACCESSORY);
            this.a(this.a.getConnectedAccessory());
        } else {
            this.a(AccessoryProcessDetailsStateDetails.CONNECTING_TO_ACCESSORY);
            this.c();
        }
    }

    public boolean requestAbort() {
        if (!this.canBeAborted()) {
            return false;
        }
        this.i = true;
        this.d();
        return true;
    }

    public boolean canBeAborted() {
        return !this.i && !this.b();
    }

    public AccessoryProcessDetails getDetails() {
        return this.h;
    }

    private boolean b() {
        if (this.h != null) {
            switch ((AccessoryProcessDetailsState)this.h.getState()) {
                case CREATED: 
                case CONNECTING_TO_ACCESSORY: 
                case UPDATING_ACCESSORY: {
                    return false;
                }
                case COMPLETED: 
                case ABORTED: 
                case FAILED: {
                    return true;
                }
            }
        }
        return false;
    }

    private void c() {
        if (this.i) {
            this.f();
            return;
        }
        Log.i("ConnectToAccessoryProcess", "Connecting to accessory");
        this.b.addAccessoryConnectionStateListener(this.m);
        Object object = this.g;
        synchronized (object) {
            this.f = this.b.connectToAccessory(this.d);
        }
    }

    private void d() {
        Log.i("ConnectToAccessoryProcess", "Requesting cancellation for accessory connect");
        Object object = this.g;
        synchronized (object) {
            this.b.cancelConnectToAccessory(this.f);
        }
    }

    private void a(Accessory accessory) {
        if (this.i) {
            this.f();
            return;
        }
        Log.i("ConnectToAccessoryProcess", "Disconnecting existing accessory and connecting to a new one");
        this.a.internalDisconnectFromAccessory(accessory, new AccessoryDisconnectListener2(){

            public void a(AccessoryProcessDetails accessoryProcessDetails) {
                if (accessoryProcessDetails.getState() == AccessoryProcessDetailsState.FAILED) {
                    da.this.a(accessoryProcessDetails.getError());
                } else {
                    da.this.c();
                }
            }

            public /* synthetic */ void onCompleted(Object object, Object object2, Object object3) {
                AccessoryProcess cfr_ignored_0 = (AccessoryProcess)object;
                Accessory cfr_ignored_1 = (Accessory)object2;
                this.a((AccessoryProcessDetails)object3);
            }
        });
    }

    private void e() {
        if (this.k) {
            Log.i("ConnectToAccessoryProcess", "retry accessory connection skipped, reconnectCancelled flag turned on");
            return;
        }
        if (this.i) {
            this.f();
            return;
        }
        this.a(AccessoryProcessDetailsStateDetails.CONNECTING_TO_ACCESSORY_RETRYING);
        this.b.removeAccessoryConnectionStateListener(this.m);
        long l2 = da.a(this.d.getAccessoryConnectionType());
        Task.callInBackground(() -> {
            Thread.sleep(l2);
            return null;
        }).continueWith(task -> {
            if (this.k) {
                Log.i("ConnectToAccessoryProcess", "retry accessory connection skipped, reconnectCancelled flag turned on");
                return null;
            }
            if (this.i) {
                this.f();
            } else {
                this.c.fire(() -> this.c());
            }
            return null;
        });
    }

    private void f() {
        AccessoryProcessDetails accessoryProcessDetails;
        if (this.j) {
            return;
        }
        this.j = true;
        this.h = accessoryProcessDetails = this.a(AccessoryProcessDetailsStateDetails.ABORTED, null);
        this.a(null, accessoryProcessDetails);
    }

    private void g() {
        AccessoryProcessDetails accessoryProcessDetails;
        if (this.j) {
            return;
        }
        this.j = true;
        this.h = accessoryProcessDetails = this.a(AccessoryProcessDetailsStateDetails.COMPLETED, null);
        Object object = this.g;
        synchronized (object) {
            this.a(this.f, accessoryProcessDetails);
        }
    }

    private void a(MposError mposError) {
        AccessoryProcessDetails accessoryProcessDetails;
        if (this.j) {
            return;
        }
        this.j = true;
        this.h = accessoryProcessDetails = this.a(AccessoryProcessDetailsStateDetails.FAILED, mposError);
        this.a(null, accessoryProcessDetails);
    }

    private void a(AccessoryProcessDetailsStateDetails accessoryProcessDetailsStateDetails) {
        AccessoryProcessDetails accessoryProcessDetails;
        this.h = accessoryProcessDetails = this.a(accessoryProcessDetailsStateDetails, null);
        this.a(accessoryProcessDetails);
    }

    private AccessoryProcessDetails a(AccessoryProcessDetailsStateDetails accessoryProcessDetailsStateDetails, MposError mposError) {
        AccessoryProcessDetailsState accessoryProcessDetailsState = dy.a(accessoryProcessDetailsStateDetails);
        LocalizationPrompt localizationPrompt = dy.b(accessoryProcessDetailsStateDetails);
        String[] stringArray = et.a(localizationPrompt);
        stringArray = et.a(stringArray);
        return new db(accessoryProcessDetailsState, accessoryProcessDetailsStateDetails, stringArray, mposError);
    }

    private void a(Accessory accessory, AccessoryProcessDetails accessoryProcessDetails) {
        String cfr_ignored_0 = "accessory connection complete: " + accessoryProcessDetails;
        this.b.removeAccessoryConnectionStateListener(this.m);
        if (this.e != null) {
            this.c.fire(() -> {
                this.e.onStatusChanged((Object)this, (Object)accessory, (Object)accessoryProcessDetails);
                this.e.onCompleted((Object)this, (Object)accessory, (Object)accessoryProcessDetails);
                this.e = null;
            });
        }
    }

    private void a(AccessoryProcessDetails accessoryProcessDetails) {
        String cfr_ignored_0 = "accessory connection status changed: " + accessoryProcessDetails;
        if (this.e != null) {
            this.c.fire(() -> {
                Accessory accessory;
                Object object = this.g;
                synchronized (object) {
                    accessory = this.f;
                }
                this.e.onStatusChanged((Object)this, (Object)accessory, (Object)accessoryProcessDetails);
            });
        }
    }

    private void b(MposError mposError) {
        if (mposError.getErrorType() == ErrorType.ACCESSORY_NOT_FOUND && !this.l) {
            this.e();
        } else {
            this.a(mposError);
        }
    }

    private boolean b(Accessory accessory) {
        Object object = this.g;
        synchronized (object) {
            return this.f != null && this.f.equals(accessory);
        }
    }

    public void a() {
        this.k = true;
    }

    public static long a(AccessoryConnectionType accessoryConnectionType) {
        switch (accessoryConnectionType) {
            case UNKNOWN: 
            case BONJOUR: 
            case EXTERNAL_ACCESSORY: {
                return 1000L;
            }
            case TCP: 
            case SERIAL_PORT: {
                return 5000L;
            }
        }
        return 0L;
    }

    private class a
    implements AccessoryConnectionStateListener {
        private a() {
        }

        @Override
        public void onAccessoryConnectSuccess(Accessory accessory) {
            Object object = da.this.g;
            synchronized (object) {
                if (!da.this.b(accessory)) {
                    Log.w("ConnectToAccessoryProcess", "Received connected for non-current accessory, current accessory is: " + da.this.f + " but given: " + accessory);
                    return;
                }
                Log.i("ConnectToAccessoryProcess", "connected to accessory: " + accessory.getFamily() + ":" + accessory.getAccessoryDetails().getSerialNumber());
                da.this.f = accessory;
            }
            da.this.g();
        }

        @Override
        public void onAccessoryConnectFailure(MposError error) {
            Log.i("ConnectToAccessoryProcess", "error connecting to accessory: " + error);
            da.this.b(error);
        }

        @Override
        public void onAccessoryDisconnectSuccess(Accessory accessory) {
        }

        @Override
        public void onAccessoryDisconnectFailure(Accessory accessory, MposError error) {
        }

        @Override
        public void onAccessoryCancelConnectSuccess(Accessory accessory) {
            if (!da.this.b(accessory)) {
                Log.w("ConnectToAccessoryProcess", "Received cancelled connect for non-current accessory");
                return;
            }
            Log.i("ConnectToAccessoryProcess", "cancelled connecting to accessory");
            da.this.f();
        }

        @Override
        public void onAccessoryCancelConnectFailure(Accessory accessory, MposError error) {
            Log.i("ConnectToAccessoryProcess", "cancelling connect to accessory failed: " + error);
        }
    }
}

