/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.paymentdetails.PaymentDetails;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.shared.accessories.EncryptionDetailsState;
import io.mpos.shared.accessories.payment.AbstractPaymentAccessory;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.PaymentDetailsIccWrapper;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.shared.transactions.receipts.ReceiptDetails;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.TLVHelper;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.emv.TagAuthorisationResponseCode;
import io.mpos.specs.emv.TagTerminalVerificationResults;
import io.mpos.specs.emv.TagTransactionStatusInformation;
import io.mpos.specs.helper.ByteHelper;

public class gG {
    public static int a = 50;

    static boolean a(DefaultTransaction defaultTransaction) {
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)defaultTransaction.getPaymentDetails();
        switch (defaultPaymentDetails.getCustomerVerificationDetailed()) {
            case PIN_ONLINE: {
                return true;
            }
            case CUSTOMER_DEVICE: 
            case NONE: 
            case SIGNATURE: 
            case UNKNOWN: 
            case PIN_OFFLINE_ENCIPHERED: 
            case PIN_OFFLINE_ENCIPHERED_AND_SIGNATURE: 
            case PIN_OFFLINE_PLAINTEXT: 
            case PIN_OFFLINE_PLAINTEXT_AND_SIGNATURE: {
                return false;
            }
        }
        return false;
    }

    static boolean b(DefaultTransaction defaultTransaction) {
        return defaultTransaction.isCustomerIdentificationRequired();
    }

    public static void a(Object[] objectArray, DefaultTransaction defaultTransaction) {
        ReceiptDetails receiptDetails = defaultTransaction.getReceiptDetails();
        if (receiptDetails == null) {
            return;
        }
        PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper(defaultTransaction.getPaymentDetails());
        receiptDetails.setApplicationLabel(paymentDetailsIccWrapper.getApplicationName());
        receiptDetails.setApplicationId(ByteHelper.toHexShortString(paymentDetailsIccWrapper.getApplicationIdentifier()));
        if (objectArray == null) {
            return;
        }
        for (Object object : objectArray) {
            if (!(object instanceof PrimitiveTlv)) continue;
            PrimitiveTlv primitiveTlv = (PrimitiveTlv)object;
            if (primitiveTlv.hasThisTag(TagTransactionStatusInformation.TAG_BYTES)) {
                receiptDetails.setTransactionStatusInformation(TagTransactionStatusInformation.wrap(primitiveTlv).getValueAsString());
                continue;
            }
            if (primitiveTlv.hasThisTag(TagTerminalVerificationResults.TAG_BYTES)) {
                receiptDetails.setTerminalVerificationResult(TagTerminalVerificationResults.wrap(primitiveTlv).getValueAsString());
                continue;
            }
            if (!primitiveTlv.hasThisTag(TagAuthorisationResponseCode.TAG_BYTES)) continue;
            receiptDetails.setAuthorizationCode(TagAuthorisationResponseCode.wrap(primitiveTlv).getValueAsString());
        }
    }

    public static boolean a(PaymentAccessory paymentAccessory) {
        AbstractPaymentAccessory abstractPaymentAccessory = (AbstractPaymentAccessory)paymentAccessory;
        return abstractPaymentAccessory.getEncryptionDetails().getPinState() == EncryptionDetailsState.READY;
    }

    public static void a(PaymentDetails paymentDetails) {
        if (paymentDetails.getSource() != PaymentDetailsSource.NFC_ICC && paymentDetails.getSource() != PaymentDetailsSource.NFC_MAGSTRIPE) {
            return;
        }
        if (paymentDetails.getScheme() == null || !paymentDetails.getScheme().isVisaFamily()) {
            return;
        }
        PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper(paymentDetails);
        if (paymentDetailsIccWrapper.getDataArqc() == null) {
            return;
        }
        TlvObject tlvObject = TLVHelper.findFirstItemInArray(TagTerminalVerificationResults.TAG_BYTES, paymentDetailsIccWrapper.getDataArqc());
        if (tlvObject != null) {
            return;
        }
        byte[] byArray = ByteHelper.fromHexString("0000000000");
        PrimitiveTlv primitiveTlv = new PrimitiveTlv(TagTerminalVerificationResults.TAG_BYTES, byArray);
        TlvObject[] tlvObjectArray = TLVHelper.getExtendedWithTlvObject(paymentDetailsIccWrapper.getDataArqc(), primitiveTlv);
        paymentDetailsIccWrapper.setDataArqc(tlvObjectArray);
    }
}

