/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.helper.AssetsHandler;
import io.mpos.shared.localization.LocalizationServer;
import io.mpos.shared.processors.payworks.services.response.BackendObjectMapperKt;
import io.mpos.transactionprovider.accessibility.AccessibilityLocalizationData;
import io.mpos.transactionprovider.accessibility.AccessibilityLocalizationLoader;
import io.mpos.utils.InputStreamAsStringKt;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/mpos/internal/accessibility/DefaultAccessibilityLocalizationLoader;", "Lio/mpos/transactionprovider/accessibility/AccessibilityLocalizationLoader;", "assetsHandler", "Lio/mpos/shared/helper/AssetsHandler;", "<init>", "(Lio/mpos/shared/helper/AssetsHandler;)V", "load", "Lio/mpos/transactionprovider/accessibility/AccessibilityLocalizationData;", "locale", "Ljava/util/Locale;", "loadInternal", "getAssetPathForLocale", "", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nDefaultAccessibilityLocalizationLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAccessibilityLocalizationLoader.kt\nio/mpos/internal/accessibility/DefaultAccessibilityLocalizationLoader\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,48:1\n222#2:49\n*S KotlinDebug\n*F\n+ 1 DefaultAccessibilityLocalizationLoader.kt\nio/mpos/internal/accessibility/DefaultAccessibilityLocalizationLoader\n*L\n43#1:49\n*E\n"})
public final class p
implements AccessibilityLocalizationLoader {
    @NotNull
    private final AssetsHandler a;

    public p(@NotNull AssetsHandler assetsHandler) {
        Intrinsics.checkNotNullParameter((Object)assetsHandler, (String)"");
        this.a = assetsHandler;
    }

    @Override
    @NotNull
    public AccessibilityLocalizationData load(@NotNull Locale locale) {
        AccessibilityLocalizationData accessibilityLocalizationData;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"");
        try {
            try {
                accessibilityLocalizationData = this.a(locale);
            }
            catch (MposRuntimeException mposRuntimeException) {
                Locale locale2 = LocalizationServer.FALLBACK_DEFAULT;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"");
                accessibilityLocalizationData = this.a(locale2);
            }
        }
        catch (IOException iOException) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.SDK_RESOURCES_NOT_FOUND, "Accessibility localizations for language " + locale + " could not be resolved. Exception: " + iOException.getMessage()));
        }
        return accessibilityLocalizationData;
    }

    private final AccessibilityLocalizationData a(Locale locale) {
        Locale locale2 = LocalizationServer.checkAndAssignLocaleWithFallbackToLanguage(locale);
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"");
        Locale locale3 = locale2;
        String string = this.b(locale3);
        Json json = BackendObjectMapperKt.getBackendObjectMapper();
        BufferedInputStream bufferedInputStream = this.a.resolveAndCheckAsset(string);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedInputStream, (String)"");
        String string2 = InputStreamAsStringKt.readEntireStreamAsString$default(bufferedInputStream, null, 1, null);
        json.getSerializersModule();
        return (AccessibilityLocalizationData)json.decodeFromString((DeserializationStrategy)AccessibilityLocalizationData.Companion.serializer(), string2);
    }

    private final String b(Locale locale) {
        return "io.payworks.mpos.l10n/accessibility/accessibility-" + locale + ".json";
    }
}

