/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.logger;

import com.visa.logger.EventConsumer;
import com.visa.logger.LogEvent;
import com.visa.logger.LogLevel;
import io.mpos.logger.DefaultLogger;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\"\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\"\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001c\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016J\u001c\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016J\u001c\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016J\u001c\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016J&\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0016J0\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J*\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lio/mpos/logger/Logger;", "Lcom/visa/logger/EventConsumer;", "verbosity", "Lcom/visa/logger/LogLevel;", "<init>", "(Lcom/visa/logger/LogLevel;)V", "getVerbosity", "()Lcom/visa/logger/LogLevel;", "log", "", "tag", "", "message", "throwable", "", "level", "trace", "debug", "info", "warn", "error", "messageBlock", "Lkotlin/Function0;", "logLazy", "logNow", "Companion", "mpos.core"})
public abstract class Logger
implements EventConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LogLevel verbosity;
    @Nullable
    private static Logger logger = new DefaultLogger(LogLevel.INFO);

    public Logger(@NotNull LogLevel verbosity) {
        Intrinsics.checkNotNullParameter((Object)verbosity, (String)"");
        this.verbosity = verbosity;
    }

    @NotNull
    public LogLevel getVerbosity() {
        return this.verbosity;
    }

    public final void log(@NotNull String tag, @NotNull String message, @Nullable Throwable throwable, @NotNull LogLevel level) {
        Map map;
        LogEvent logEvent;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter((Object)message, (String)"");
        Intrinsics.checkNotNullParameter((Object)level, (String)"");
        if (level.compareTo((Enum)this.getVerbosity()) < 0) {
            return;
        }
        if (throwable != null) {
            logEvent = new LogEvent[]{TuplesKt.to((Object)"stacktrace", (Object)ExceptionsKt.stackTraceToString((Throwable)throwable)), TuplesKt.to((Object)"exceptionMessage", (Object)throwable.getClass().toString())};
            map = MapsKt.mapOf((Pair[])logEvent);
        } else {
            map = MapsKt.emptyMap();
        }
        Map map2 = map;
        logEvent = new LogEvent(0L, message, tag, level, map2, 1, null);
        this.consume(logEvent);
    }

    public final void trace(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter((Object)message, (String)"");
        this.logNow(tag, message, null, LogLevel.TRACE);
    }

    public final void debug(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter((Object)message, (String)"");
        this.logNow(tag, message, null, LogLevel.DEBUG);
    }

    public final void info(@NotNull String tag, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter((Object)message, (String)"");
        this.logNow(tag, message, null, LogLevel.INFO);
    }

    public final void warn(@NotNull String tag, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter((Object)message, (String)"");
        this.logNow(tag, message, throwable, LogLevel.WARN);
    }

    public static /* synthetic */ void warn$default(Logger logger, String string, String string2, Throwable throwable, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: warn");
        }
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        logger.warn(string, string2, throwable);
    }

    public final void error(@NotNull String tag, @NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter((Object)message, (String)"");
        this.logNow(tag, message, throwable, LogLevel.ERROR);
    }

    public static /* synthetic */ void error$default(Logger logger, String string, String string2, Throwable throwable, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: error");
        }
        if ((n2 & 4) != 0) {
            throwable = null;
        }
        logger.error(string, string2, throwable);
    }

    public final void trace(@NotNull String tag, @NotNull Function0<String> messageBlock) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter(messageBlock, (String)"");
        this.logLazy(tag, messageBlock, null, LogLevel.TRACE);
    }

    public final void debug(@NotNull String tag, @NotNull Function0<String> messageBlock) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter(messageBlock, (String)"");
        this.logLazy(tag, messageBlock, null, LogLevel.DEBUG);
    }

    public final void info(@NotNull String tag, @NotNull Function0<String> messageBlock) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter(messageBlock, (String)"");
        this.logLazy(tag, messageBlock, null, LogLevel.INFO);
    }

    public final void warn(@NotNull String tag, @NotNull Function0<String> messageBlock) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter(messageBlock, (String)"");
        this.logLazy(tag, messageBlock, null, LogLevel.WARN);
    }

    public final void error(@NotNull String tag, @Nullable Throwable throwable, @NotNull Function0<String> messageBlock) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter(messageBlock, (String)"");
        this.logLazy(tag, messageBlock, throwable, LogLevel.ERROR);
    }

    private final void logLazy(String tag, Function0<String> messageBlock, Throwable throwable, LogLevel level) {
        this.logNow(tag, (String)messageBlock.invoke(), throwable, level);
    }

    private final void logNow(String tag, String message, Throwable throwable, LogLevel level) {
        this.log(tag, message, throwable, level);
    }

    @Nullable
    public static final Logger getLogger() {
        return Companion.getLogger();
    }

    public static final void setLogger(@Nullable Logger logger) {
        Companion.setLogger(logger);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/mpos/logger/Logger$Companion;", "", "<init>", "()V", "logger", "Lio/mpos/logger/Logger;", "getLogger$annotations", "getLogger", "()Lio/mpos/logger/Logger;", "setLogger", "(Lio/mpos/logger/Logger;)V", "mpos.core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Logger getLogger() {
            return logger;
        }

        public final void setLogger(@Nullable Logger logger) {
            Logger.logger = logger;
        }

        @JvmStatic
        public static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

