/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.mock;

import io.mpos.accessories.AccessoryType;
import io.mpos.accessories.AccessoryUpdateRequirementComponent;
import io.mpos.accessories.components.AccessoryComponentType;
import io.mpos.mock.MockConfiguration;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.shared.provider.ProcessingOptions;
import io.mpos.shared.provider.WhitelistAccessory;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.TransactionWorkflowType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultMockConfiguration
implements MockConfiguration {
    public static final BigDecimal AMOUNT_UNUSED = new BigDecimal("12.34");
    public static final BigDecimal AMOUNT_DEFAULT = new BigDecimal("106");
    public static final BigDecimal AMOUNT_APPROVE_WITH_PIN = new BigDecimal("107.1");
    public static final BigDecimal AMOUNT_APPROVE_WITH_SIGNATURE = new BigDecimal("108.2");
    public static final BigDecimal AMOUNT_DECLINE_OFFLINE = new BigDecimal("109.3");
    public static final BigDecimal AMOUNT_DECLINE_ONLINE = new BigDecimal("110.4");
    public static final BigDecimal AMOUNT_DECLINE_GIFT_CARD = new BigDecimal("73.55");
    public static final BigDecimal AMOUNT_DECLINE_FORBIDDEN_APPLICATION = new BigDecimal("73.77");
    public static final BigDecimal AMOUNT_DECLINE_FULL_EMV_REFUND = new BigDecimal("73.66");
    public static final BigDecimal AMOUNT_ABORT = new BigDecimal("111.5");
    public static final BigDecimal AMOUNT_ABORT_GIFT_CARD = new BigDecimal("9.99");
    public static final BigDecimal AMOUNT_ABORT_DURING_PIN_ENTRY = new BigDecimal("112.6");
    public static final BigDecimal AMOUNT_APPROVE_WITH_APP_SELECTION = new BigDecimal("113.73");
    public static final BigDecimal AMOUNT_GATEWAY_DECLINE = new BigDecimal("114.99");
    public static final BigDecimal AMOUNT_GATEWAY_DECLINED_VERIFICATION_FAILED = new BigDecimal("114.98");
    public static final BigDecimal AMOUNT_ERROR_DURING_EXECUTE = new BigDecimal("119.1");
    public static final BigDecimal AMOUNT_ERROR_DURING_FINALIZE = new BigDecimal("115.0");
    public static final BigDecimal AMOUNT_APPROVE_AND_REQUIRE_IDENTIFICATION = new BigDecimal("116.55");
    public static final BigDecimal AMOUNT_INCONCLUSIVE = new BigDecimal("117.7");
    public static final BigDecimal AMOUNT_GATEWAY_APPROVE_EARLY = new BigDecimal("102.79");
    public static final BigDecimal AMOUNT_APPLY_DCC = new BigDecimal("80.23");
    public static final BigDecimal AMOUNT_ACTIVATION_GIFT_CARD = new BigDecimal("114.62");
    public static final BigDecimal AMOUNT_PARTIAL_AUTHORIZATION = new BigDecimal("20.45");
    public static final String GIFT_CARD_CASHOUT_SUBJECT = "mock.giftcard.cashout";
    public static final String GIFT_CARD_BALANCE_INQUIRY_SUBJECT = "mock.giftcard.balance_inquiry";
    public static final String GIFT_CARD_REDEMPTION_SUBJECT = "mock.giftcard.charge";
    private MockConfiguration.PaymentAccessoryBehavior paymentAccessoryBehavior = MockConfiguration.PaymentAccessoryBehavior.APPROVE;
    private EnumSet<MockConfiguration.PaymentAccessoryOptions> paymentAccessoryOptions = EnumSet.of(MockConfiguration.PaymentAccessoryOptions.NONE);
    private EnumSet<MockConfiguration.PaymentAccessoryExtraFeature> paymentAccessoryExtraFeatures = EnumSet.noneOf(MockConfiguration.PaymentAccessoryExtraFeature.class);
    private MockConfiguration.PaymentAccessorySource paymentAccessorySource = MockConfiguration.PaymentAccessorySource.ICC;
    private MockConfiguration.GatewayBehavior gatewayBehavior = MockConfiguration.GatewayBehavior.APPROVE;
    private MockConfiguration.GatewayProvisioningBehavior gatewayProvisioningBehavior = MockConfiguration.GatewayProvisioningBehavior.SUCCESS;
    private EnumSet<MockConfiguration.GatewayOptions> gatewayOptions = EnumSet.of(MockConfiguration.GatewayOptions.NONE);
    private EnumSet<PaymentDetailsSource> gatewayProcessingOptionsAllowedSources = EnumSet.allOf(PaymentDetailsSource.class);
    private Map<TransactionType, Set<PaymentDetailsScheme>> gatewayProcessingOptionsBlockedTransactionTypes = new HashMap<TransactionType, Set<PaymentDetailsScheme>>();
    private MockConfiguration.AccessoryUpdateBehavior accessoryUpdateBehavior = MockConfiguration.AccessoryUpdateBehavior.NO_UPDATE;
    private MockConfiguration.AccessoryConnectionBehavior accessoryConnectionBehavior = MockConfiguration.AccessoryConnectionBehavior.SUCCESS;
    private MockConfiguration.WhitelistBehavior whitelistBehavior = MockConfiguration.WhitelistBehavior.INCLUDE_CONNECTED;
    private MockConfiguration.PrinterAccessoryComponentBehavior printerAccessoryComponentBehavior = MockConfiguration.PrinterAccessoryComponentBehavior.NORMAL;
    private MockConfiguration.TippingAccessoryComponentBehavior tippingAccessoryComponentBehavior = MockConfiguration.TippingAccessoryComponentBehavior.ENTERED;
    private MockConfiguration.AskForConfirmationInteractionComponentBehavior askForConfirmationBehavior = MockConfiguration.AskForConfirmationInteractionComponentBehavior.OK_PRESSED;
    private MockConfiguration.AskForNumberInteractionComponentBehavior askForNumberBehavior = MockConfiguration.AskForNumberInteractionComponentBehavior.SUCCESS;
    private MockConfiguration.ReadCardBehavior readCardBehavior = MockConfiguration.ReadCardBehavior.CARD_SWIPED;
    private MockConfiguration.SubmitTransactionsBatchBehavior submitTransactionsBatchBehavior = MockConfiguration.SubmitTransactionsBatchBehavior.SUCCESS;
    private MockConfiguration.SynchronizeConfigurationBehavior synchronizeConfigurationBehavior = MockConfiguration.SynchronizeConfigurationBehavior.SUCCESS;
    private MockConfiguration.OfflineConfigurationBehavior offlineConfigurationBehavior = MockConfiguration.OfflineConfigurationBehavior.PRESENT;
    private EnumSet<AccessoryComponentType> supportedAccessoryComponentTypes = EnumSet.allOf(AccessoryComponentType.class);
    private EnumSet<MockConfiguration.GatewayFeature> supportedGatewayFeatures = EnumSet.allOf(MockConfiguration.GatewayFeature.class);
    private EnumSet<ProcessingOptions.Behavior> processingWorkflowBehaviors = EnumSet.noneOf(ProcessingOptions.Behavior.class);
    private MockConfiguration.AlternativePaymentApprovalBehavior alternativePaymentApprovalBehavior = MockConfiguration.AlternativePaymentApprovalBehavior.OFFLINE;
    private TransactionWorkflowType workflowTypeForSessionLookups = TransactionWorkflowType.POS;
    private PaymentDetailsScheme paymentDetailsScheme = PaymentDetailsScheme.VISA;
    private BigDecimal noCvmLimit = BigDecimal.ZERO;
    private MockConfiguration.DccSelectionBehavior dccSelectionBehavior = MockConfiguration.DccSelectionBehavior.ORIGINAL_SELECTED;
    private MockConfiguration.DccLookupBehavior dccLookupBehavior = MockConfiguration.DccLookupBehavior.NOT_SUCCESSFUL;
    private MockConfiguration.VerificationResultsBehavior verificationResultsBehavior = MockConfiguration.VerificationResultsBehavior.ALL_MATCH;
    private EnumSet<AccessoryUpdateRequirementComponent> updateRequirementComponents;
    private boolean accessoryGetsStuckDuringDisplay;
    private MockConfiguration.BarcodeScannerBehavior barcodeScannerBehavior = MockConfiguration.BarcodeScannerBehavior.SUCCESSFUL_SINGLE_SCAN;
    private MockConfiguration.AskForCardDataWithParametersBehavior askForCardDataWithParametersBehavior = MockConfiguration.AskForCardDataWithParametersBehavior.SUCCESS;

    public void setupWithAmount(BigDecimal amount) {
        if (amount == null) {
            return;
        }
        if (amount.compareTo(AMOUNT_DEFAULT) == 0) {
            this.initDefault();
        } else if (amount.equals(AMOUNT_APPROVE_WITH_PIN)) {
            this.initApproveWithPIN();
        } else if (amount.equals(AMOUNT_APPROVE_WITH_SIGNATURE)) {
            this.initApproveWithSignature();
        } else if (amount.equals(AMOUNT_DECLINE_OFFLINE)) {
            this.initDeclineOffline();
        } else if (amount.equals(AMOUNT_DECLINE_ONLINE)) {
            this.initDeclineOnline();
        } else if (amount.equals(AMOUNT_DECLINE_GIFT_CARD)) {
            this.initGiftCardForDecline();
        } else if (amount.equals(AMOUNT_DECLINE_FORBIDDEN_APPLICATION)) {
            this.initDeclineForbiddenApplication();
        } else if (amount.equals(AMOUNT_DECLINE_FULL_EMV_REFUND)) {
            this.initDeclineFullEmvRefund();
        } else if (amount.equals(AMOUNT_ABORT)) {
            this.initAbort();
        } else if (amount.equals(AMOUNT_ABORT_GIFT_CARD)) {
            this.initGiftCardForAbort();
        } else if (amount.equals(AMOUNT_ABORT_DURING_PIN_ENTRY)) {
            this.initAbortDuringPINEntry();
        } else if (amount.equals(AMOUNT_APPROVE_WITH_APP_SELECTION)) {
            this.initApproveWithAppSelection();
        } else if (amount.equals(AMOUNT_GATEWAY_DECLINE)) {
            this.initGatewayDecline();
        } else if (amount.equals(AMOUNT_GATEWAY_DECLINED_VERIFICATION_FAILED)) {
            this.initGatewayDeclineVerificationFailed();
        } else if (amount.equals(AMOUNT_ERROR_DURING_EXECUTE)) {
            this.initErrorDuringExecute();
        } else if (amount.equals(AMOUNT_ERROR_DURING_FINALIZE)) {
            this.initErrorDuringFinalize();
        } else if (amount.equals(AMOUNT_APPROVE_AND_REQUIRE_IDENTIFICATION)) {
            this.initApproveAndRequireIdentification();
        } else if (amount.equals(AMOUNT_ACTIVATION_GIFT_CARD)) {
            this.initActivationGiftCard();
        } else if (amount.equals(AMOUNT_INCONCLUSIVE)) {
            this.initInconclusive();
        } else if (amount.equals(AMOUNT_GATEWAY_APPROVE_EARLY)) {
            this.initGatewayApproveEarly();
        } else if (amount.equals(AMOUNT_APPLY_DCC)) {
            this.initDcc();
        } else if (amount.equals(AMOUNT_PARTIAL_AUTHORIZATION)) {
            this.initPartialApprovals();
        }
    }

    private void initDeclineFullEmvRefund() {
        this.initDefault();
        this.processingWorkflowBehaviors.add(ProcessingOptions.Behavior.FULL_EMV_REFUND_WORKFLOW);
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.DECLINE;
    }

    public void setupWithSubjectIfAmountNotConflicting(String subject, BigDecimal amount) {
        if (Arrays.asList(GIFT_CARD_BALANCE_INQUIRY_SUBJECT, GIFT_CARD_REDEMPTION_SUBJECT, GIFT_CARD_CASHOUT_SUBJECT).contains(subject) && !Arrays.asList(AMOUNT_DECLINE_GIFT_CARD, AMOUNT_ABORT_GIFT_CARD).contains(amount)) {
            this.initGiftCardForPossibleApproval();
        }
    }

    private void initActivationGiftCard() {
        this.initDefault();
        this.initValueLink();
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.APPROVE_EARLY;
    }

    private void initGiftCardForPossibleApproval() {
        this.initDefault();
        this.initValueLink();
        if (!MockConfiguration.GatewayBehavior.DECLINE.equals((Object)this.gatewayBehavior)) {
            this.gatewayBehavior = MockConfiguration.GatewayBehavior.APPROVE_EARLY;
        }
    }

    private void initGiftCardForDecline() {
        this.initDefault();
        this.initValueLink();
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.DECLINE;
    }

    private void initDeclineForbiddenApplication() {
        this.initDefault();
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.DECLINE_FORBIDDEN_APPLICATION;
    }

    private void initGiftCardForAbort() {
        this.initDefault();
        this.initValueLink();
        this.paymentAccessoryBehavior = MockConfiguration.PaymentAccessoryBehavior.ABORT;
    }

    private void initValueLink() {
        this.paymentDetailsScheme = PaymentDetailsScheme.VALUE_LINK;
        this.paymentAccessorySource = MockConfiguration.PaymentAccessorySource.MAGSTRIPE;
        this.gatewayOptions = EnumSet.of(MockConfiguration.GatewayOptions.NONE);
        this.processingWorkflowBehaviors = EnumSet.of(ProcessingOptions.Behavior.US_MAGSTRIPE_REQUIRES_CREDIT_DEBIT_SELECTION_BY_MERCHANT, ProcessingOptions.Behavior.US_MAGSTRIPE_REQUIRES_CREDIT_DEBIT_SELECTION_BY_SHOPPER);
    }

    private void initDefault() {
        this.paymentAccessoryBehavior = MockConfiguration.PaymentAccessoryBehavior.APPROVE;
        this.paymentAccessoryOptions = EnumSet.of(MockConfiguration.PaymentAccessoryOptions.NONE);
        this.paymentAccessorySource = MockConfiguration.PaymentAccessorySource.ICC;
        this.paymentDetailsScheme = PaymentDetailsScheme.VISA;
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.APPROVE;
        this.gatewayOptions = EnumSet.of(MockConfiguration.GatewayOptions.NONE);
        this.accessoryUpdateBehavior = MockConfiguration.AccessoryUpdateBehavior.NO_UPDATE;
        this.accessoryConnectionBehavior = MockConfiguration.AccessoryConnectionBehavior.SUCCESS;
        this.updateRequirementComponents = EnumSet.noneOf(AccessoryUpdateRequirementComponent.class);
        this.tippingAccessoryComponentBehavior = MockConfiguration.TippingAccessoryComponentBehavior.ENTERED;
        this.printerAccessoryComponentBehavior = MockConfiguration.PrinterAccessoryComponentBehavior.NORMAL;
        this.askForConfirmationBehavior = MockConfiguration.AskForConfirmationInteractionComponentBehavior.OK_PRESSED;
        this.askForNumberBehavior = MockConfiguration.AskForNumberInteractionComponentBehavior.SUCCESS;
        this.readCardBehavior = MockConfiguration.ReadCardBehavior.CARD_SWIPED;
        this.submitTransactionsBatchBehavior = MockConfiguration.SubmitTransactionsBatchBehavior.SUCCESS;
        this.synchronizeConfigurationBehavior = MockConfiguration.SynchronizeConfigurationBehavior.SUCCESS;
        this.offlineConfigurationBehavior = MockConfiguration.OfflineConfigurationBehavior.PRESENT;
        this.supportedAccessoryComponentTypes = EnumSet.allOf(AccessoryComponentType.class);
        this.whitelistBehavior = MockConfiguration.WhitelistBehavior.INCLUDE_CONNECTED;
        this.supportedGatewayFeatures = EnumSet.allOf(MockConfiguration.GatewayFeature.class);
        this.processingWorkflowBehaviors = EnumSet.noneOf(ProcessingOptions.Behavior.class);
        this.noCvmLimit = BigDecimal.ZERO;
        this.dccSelectionBehavior = MockConfiguration.DccSelectionBehavior.ORIGINAL_SELECTED;
        this.dccLookupBehavior = MockConfiguration.DccLookupBehavior.NOT_SUCCESSFUL;
        this.barcodeScannerBehavior = MockConfiguration.BarcodeScannerBehavior.SUCCESSFUL_SINGLE_SCAN;
        this.workflowTypeForSessionLookups = TransactionWorkflowType.POS;
    }

    private void initApproveWithPIN() {
        this.initDefault();
        this.paymentAccessoryOptions = EnumSet.of(MockConfiguration.PaymentAccessoryOptions.PIN_ASK_OK);
    }

    private void initApproveWithSignature() {
        this.initDefault();
        this.paymentAccessoryOptions = EnumSet.of(MockConfiguration.PaymentAccessoryOptions.ASK_SIGNATURE);
    }

    private void initDeclineOffline() {
        this.initDefault();
        this.paymentAccessoryBehavior = MockConfiguration.PaymentAccessoryBehavior.DECLINE_OFFLINE;
    }

    private void initDeclineOnline() {
        this.initDefault();
        this.paymentAccessoryBehavior = MockConfiguration.PaymentAccessoryBehavior.DECLINE_ONLINE;
    }

    private void initAbort() {
        this.initDefault();
        this.paymentAccessoryBehavior = MockConfiguration.PaymentAccessoryBehavior.ABORT;
    }

    private void initAbortDuringPINEntry() {
        this.initDefault();
        this.paymentAccessoryOptions = EnumSet.of(MockConfiguration.PaymentAccessoryOptions.PIN_ASK_OK);
        this.paymentAccessoryBehavior = MockConfiguration.PaymentAccessoryBehavior.ABORT;
    }

    private void initApproveWithAppSelection() {
        this.initDefault();
        this.paymentAccessorySource = MockConfiguration.PaymentAccessorySource.ICC_WITH_MULTIPLE_APPS;
    }

    private void initGatewayDecline() {
        this.initDefault();
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.DECLINE;
    }

    private void initGatewayDeclineVerificationFailed() {
        this.initDefault();
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.DECLINE_VERIFICATION_FAILED;
        this.verificationResultsBehavior = MockConfiguration.VerificationResultsBehavior.NO_DATA_MATCHES;
    }

    private void initErrorDuringExecute() {
        this.initDefault();
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.ERROR_DURING_EXECUTE;
    }

    private void initErrorDuringFinalize() {
        this.initDefault();
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.ERROR_DURING_FINALIZE_OR_VOID;
    }

    private void initApproveAndRequireIdentification() {
        this.initDefault();
        this.paymentDetailsScheme = PaymentDetailsScheme.MASTERCARD;
        this.gatewayOptions = EnumSet.of(MockConfiguration.GatewayOptions.REQUIRE_IDENTIFICATION);
    }

    private void initInconclusive() {
        this.initDefault();
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.INCONCLUSIVE_DURING_FINALIZE_OR_VOID;
    }

    private void initGatewayApproveEarly() {
        this.initDefault();
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.APPROVE_EARLY;
    }

    private void initDcc() {
        this.initDefault();
        this.gatewayOptions = EnumSet.of(MockConfiguration.GatewayOptions.DCC_SUPPORTED);
        this.dccLookupBehavior = MockConfiguration.DccLookupBehavior.SUCCESSFUL;
    }

    private void initPartialApprovals() {
        this.initDefault();
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.APPROVE_PARTIALLY;
    }

    public static Set<WhitelistAccessory> getWhitelist() {
        HashSet<WhitelistAccessory> hashSet = new HashSet<WhitelistAccessory>();
        WhitelistAccessory whitelistAccessory = new WhitelistAccessory("999999999", "ACTIVE", "05987746-d78f-4e42-9876-618e57157ca7", AccessoryType.MOCK, "06045370", null);
        whitelistAccessory.setUpdateStatus(WhitelistAccessory.UpdateStatus.DEVICE_PERFORMS_CHECK);
        hashSet.add(whitelistAccessory);
        hashSet.add(new WhitelistAccessory("06045370", "ACTIVE", "05987746-d78f-4e42-9876-618e57157ca7", AccessoryType.MOCK, "06045370", null));
        hashSet.add(new WhitelistAccessory("06045371", "ACTIVE", "05987746-d78f-4e42-9876-618e57157ca7", AccessoryType.MIURA_SHUTTLE, "06045371", null));
        return hashSet;
    }

    @Override
    public MockConfiguration.PaymentAccessoryBehavior getPaymentAccessoryBehavior() {
        return this.paymentAccessoryBehavior;
    }

    @Override
    public void setPaymentAccessoryBehavior(MockConfiguration.PaymentAccessoryBehavior behavior) {
        this.paymentAccessoryBehavior = behavior;
    }

    @Override
    public EnumSet<MockConfiguration.PaymentAccessoryOptions> getPaymentAccessoryOptions() {
        return this.paymentAccessoryOptions;
    }

    @Override
    public void setPaymentAccessoryOptions(EnumSet<MockConfiguration.PaymentAccessoryOptions> options) {
        this.paymentAccessoryOptions = options == null ? EnumSet.of(MockConfiguration.PaymentAccessoryOptions.NONE) : options;
    }

    @Override
    public EnumSet<MockConfiguration.PaymentAccessoryExtraFeature> getPaymentAccessoryExtraFeatures() {
        return this.paymentAccessoryExtraFeatures;
    }

    @Override
    public void setPaymentAccessoryExtraFeatures(EnumSet<MockConfiguration.PaymentAccessoryExtraFeature> extraFeatures) {
        this.paymentAccessoryExtraFeatures = extraFeatures;
    }

    @Override
    public MockConfiguration.PaymentAccessorySource getPaymentAccessorySource() {
        return this.paymentAccessorySource;
    }

    @Override
    public void setPaymentAccessorySource(MockConfiguration.PaymentAccessorySource source) {
        this.paymentAccessorySource = source;
    }

    @Override
    public MockConfiguration.GatewayBehavior getGatewayBehavior() {
        return this.gatewayBehavior;
    }

    @Override
    public void setGatewayBehavior(MockConfiguration.GatewayBehavior behavior) {
        this.gatewayBehavior = behavior;
    }

    @Override
    public MockConfiguration.GatewayProvisioningBehavior getGatewayProvisioningBehavior() {
        return this.gatewayProvisioningBehavior;
    }

    @Override
    public void setGatewayProvisioningBehavior(MockConfiguration.GatewayProvisioningBehavior provisioningBehavior) {
        this.gatewayProvisioningBehavior = provisioningBehavior;
    }

    @Override
    public EnumSet<MockConfiguration.GatewayOptions> getGatewayOptions() {
        return this.gatewayOptions;
    }

    @Override
    public void setGatewayOptions(EnumSet<MockConfiguration.GatewayOptions> options) {
        this.gatewayOptions = options == null ? EnumSet.of(MockConfiguration.GatewayOptions.NONE) : options;
    }

    @Override
    public EnumSet<PaymentDetailsSource> getGatewayProcessingOptionsAllowedSources() {
        return this.gatewayProcessingOptionsAllowedSources;
    }

    @Override
    public void setGatewayProcessingOptionsAllowedSources(EnumSet<PaymentDetailsSource> sources) {
        this.gatewayProcessingOptionsAllowedSources = sources;
    }

    @Override
    public void setGatewayProcessingOptionsBlockedTransactionTypes(Map<TransactionType, Set<PaymentDetailsScheme>> blockedTransactionTypes) {
        this.gatewayProcessingOptionsBlockedTransactionTypes = blockedTransactionTypes;
    }

    @Override
    public Map<TransactionType, Set<PaymentDetailsScheme>> getGatewayProcessingOptionsBlockedTransactionTypes() {
        return this.gatewayProcessingOptionsBlockedTransactionTypes;
    }

    @Override
    public MockConfiguration.AccessoryUpdateBehavior getUpdateBehavior() {
        return this.accessoryUpdateBehavior;
    }

    @Override
    public void setUpdateBehavior(MockConfiguration.AccessoryUpdateBehavior behavior) {
        this.accessoryUpdateBehavior = behavior;
    }

    @Override
    public MockConfiguration.AccessoryConnectionBehavior getAccessoryConnectionBehavior() {
        return this.accessoryConnectionBehavior;
    }

    @Override
    public void setAccessoryConnectionBehavior(MockConfiguration.AccessoryConnectionBehavior behavior) {
        this.accessoryConnectionBehavior = behavior;
    }

    @Override
    public MockConfiguration.WhitelistBehavior getWhitelistBehavior() {
        return this.whitelistBehavior;
    }

    @Override
    public void setWhitelistBehavior(MockConfiguration.WhitelistBehavior whitelistBehavior) {
        this.whitelistBehavior = whitelistBehavior;
    }

    @Override
    public PaymentDetailsScheme getPaymentDetailsScheme() {
        return this.paymentDetailsScheme;
    }

    @Override
    public void setPaymentDetailsScheme(PaymentDetailsScheme scheme) {
        this.paymentDetailsScheme = scheme;
    }

    @Override
    public MockConfiguration.PrinterAccessoryComponentBehavior getPrinterAccessoryComponentBehavior() {
        return this.printerAccessoryComponentBehavior;
    }

    @Override
    public void setPrinterAccessoryComponentBehavior(MockConfiguration.PrinterAccessoryComponentBehavior behavior) {
        this.printerAccessoryComponentBehavior = behavior;
    }

    @Override
    public EnumSet<AccessoryUpdateRequirementComponent> getUpdateRequirementComponents() {
        return this.updateRequirementComponents;
    }

    @Override
    public void setUpdateRequirementComponents(EnumSet<AccessoryUpdateRequirementComponent> components) {
        this.updateRequirementComponents = components;
    }

    @Override
    public EnumSet<AccessoryComponentType> getSupportedAccessoryComponentTypes() {
        return this.supportedAccessoryComponentTypes;
    }

    @Override
    public void setSupportedAccessoryComponentTypes(EnumSet<AccessoryComponentType> componentTypes) {
        this.supportedAccessoryComponentTypes = componentTypes;
    }

    @Override
    public void resetToDefaults() {
        this.paymentAccessoryBehavior = MockConfiguration.PaymentAccessoryBehavior.APPROVE;
        this.paymentAccessoryOptions = EnumSet.of(MockConfiguration.PaymentAccessoryOptions.NONE);
        this.paymentAccessoryExtraFeatures = EnumSet.noneOf(MockConfiguration.PaymentAccessoryExtraFeature.class);
        this.paymentAccessorySource = MockConfiguration.PaymentAccessorySource.ICC;
        this.gatewayBehavior = MockConfiguration.GatewayBehavior.APPROVE;
        this.gatewayProvisioningBehavior = MockConfiguration.GatewayProvisioningBehavior.SUCCESS;
        this.gatewayOptions = EnumSet.of(MockConfiguration.GatewayOptions.NONE);
        this.gatewayProcessingOptionsAllowedSources = EnumSet.allOf(PaymentDetailsSource.class);
        this.accessoryUpdateBehavior = MockConfiguration.AccessoryUpdateBehavior.NO_UPDATE;
        this.accessoryConnectionBehavior = MockConfiguration.AccessoryConnectionBehavior.SUCCESS;
        this.whitelistBehavior = MockConfiguration.WhitelistBehavior.INCLUDE_CONNECTED;
        this.printerAccessoryComponentBehavior = MockConfiguration.PrinterAccessoryComponentBehavior.NORMAL;
        this.tippingAccessoryComponentBehavior = MockConfiguration.TippingAccessoryComponentBehavior.ENTERED;
        this.askForConfirmationBehavior = MockConfiguration.AskForConfirmationInteractionComponentBehavior.OK_PRESSED;
        this.askForNumberBehavior = MockConfiguration.AskForNumberInteractionComponentBehavior.SUCCESS;
        this.readCardBehavior = MockConfiguration.ReadCardBehavior.CARD_SWIPED;
        this.submitTransactionsBatchBehavior = MockConfiguration.SubmitTransactionsBatchBehavior.SUCCESS;
        this.synchronizeConfigurationBehavior = MockConfiguration.SynchronizeConfigurationBehavior.SUCCESS;
        this.offlineConfigurationBehavior = MockConfiguration.OfflineConfigurationBehavior.PRESENT;
        this.supportedAccessoryComponentTypes = EnumSet.allOf(AccessoryComponentType.class);
        this.supportedGatewayFeatures = EnumSet.allOf(MockConfiguration.GatewayFeature.class);
        this.processingWorkflowBehaviors = EnumSet.noneOf(ProcessingOptions.Behavior.class);
        this.alternativePaymentApprovalBehavior = MockConfiguration.AlternativePaymentApprovalBehavior.OFFLINE;
        this.workflowTypeForSessionLookups = TransactionWorkflowType.POS;
        this.paymentDetailsScheme = PaymentDetailsScheme.VISA;
        this.noCvmLimit = BigDecimal.ZERO;
        this.dccSelectionBehavior = MockConfiguration.DccSelectionBehavior.ORIGINAL_SELECTED;
        this.dccLookupBehavior = MockConfiguration.DccLookupBehavior.NOT_SUCCESSFUL;
        this.verificationResultsBehavior = MockConfiguration.VerificationResultsBehavior.ALL_MATCH;
        this.updateRequirementComponents = null;
        this.accessoryGetsStuckDuringDisplay = false;
        this.barcodeScannerBehavior = MockConfiguration.BarcodeScannerBehavior.SUCCESSFUL_SINGLE_SCAN;
        this.askForCardDataWithParametersBehavior = MockConfiguration.AskForCardDataWithParametersBehavior.SUCCESS;
    }

    @Override
    public MockConfiguration.TippingAccessoryComponentBehavior getTippingAccessoryComponentBehavior() {
        return this.tippingAccessoryComponentBehavior;
    }

    @Override
    public void setTippingAccessoryComponentBehavior(MockConfiguration.TippingAccessoryComponentBehavior tippingAccessoryComponentBehavior) {
        this.tippingAccessoryComponentBehavior = tippingAccessoryComponentBehavior;
    }

    @Override
    public MockConfiguration.AskForConfirmationInteractionComponentBehavior getAskForConfirmationInteractionComponentBehavior() {
        return this.askForConfirmationBehavior;
    }

    @Override
    public void setAskForConfirmationInteractionComponentBehavior(MockConfiguration.AskForConfirmationInteractionComponentBehavior behavior) {
        this.askForConfirmationBehavior = behavior;
    }

    @Override
    public MockConfiguration.AskForNumberInteractionComponentBehavior getAskForNumberInteractionComponentBehavior() {
        return this.askForNumberBehavior;
    }

    @Override
    public void setAskForNumberInteractionComponentBehavior(MockConfiguration.AskForNumberInteractionComponentBehavior behavior) {
        this.askForNumberBehavior = behavior;
    }

    @Override
    public MockConfiguration.ReadCardBehavior getReadCardBehaviour() {
        return this.readCardBehavior;
    }

    @Override
    public void setReadCardBehavior(MockConfiguration.ReadCardBehavior behavior) {
        this.readCardBehavior = behavior;
    }

    @Override
    public MockConfiguration.SubmitTransactionsBatchBehavior getSubmitTransactionBehavior() {
        return this.submitTransactionsBatchBehavior;
    }

    @Override
    public void setSubmitTransactionsBatchBehavior(MockConfiguration.SubmitTransactionsBatchBehavior behavior) {
        this.submitTransactionsBatchBehavior = behavior;
    }

    @Override
    public MockConfiguration.SynchronizeConfigurationBehavior getSynchronizeConfigurationBehavior() {
        return this.synchronizeConfigurationBehavior;
    }

    @Override
    public void setSynchronizeConfigurationBehavior(MockConfiguration.SynchronizeConfigurationBehavior behavior) {
        this.synchronizeConfigurationBehavior = behavior;
    }

    @Override
    public EnumSet<MockConfiguration.GatewayFeature> getSupportedGatewayFeatures() {
        return this.supportedGatewayFeatures;
    }

    @Override
    public void setSupportedGatewayFeatures(EnumSet<MockConfiguration.GatewayFeature> gatewayFeatures) {
        this.supportedGatewayFeatures = gatewayFeatures;
    }

    @Override
    public EnumSet<ProcessingOptions.Behavior> getProcessingWorkflowBehaviors() {
        return this.processingWorkflowBehaviors;
    }

    @Override
    public void setProcessingWorkflowBehaviors(EnumSet<ProcessingOptions.Behavior> behaviors) {
        this.processingWorkflowBehaviors = behaviors;
    }

    @Override
    public void setAlternativePaymentApprovalBehavior(MockConfiguration.AlternativePaymentApprovalBehavior behavior) {
        this.alternativePaymentApprovalBehavior = behavior;
    }

    @Override
    public MockConfiguration.AlternativePaymentApprovalBehavior getAlternativePaymentApprovalBehavior() {
        return this.alternativePaymentApprovalBehavior;
    }

    @Override
    public void setNoCvmLimit(BigDecimal noCvmLimit) {
        this.noCvmLimit = noCvmLimit;
    }

    @Override
    public BigDecimal getNoCvmLimit() {
        return this.noCvmLimit;
    }

    @Override
    public void setOfflineConfigurationBehavior(MockConfiguration.OfflineConfigurationBehavior behavior) {
        this.offlineConfigurationBehavior = behavior;
    }

    @Override
    public MockConfiguration.OfflineConfigurationBehavior getOfflineConfigurationBehavior() {
        return this.offlineConfigurationBehavior;
    }

    @Override
    public MockConfiguration.DccSelectionBehavior getDccSelectionBehavior() {
        return this.dccSelectionBehavior;
    }

    @Override
    public void setDccSelectionBehavior(MockConfiguration.DccSelectionBehavior dccSelectionBehavior) {
        this.dccSelectionBehavior = dccSelectionBehavior;
    }

    @Override
    public MockConfiguration.DccLookupBehavior getDccLookupBehavior() {
        return this.dccLookupBehavior;
    }

    @Override
    public void setDccLookupBehavior(MockConfiguration.DccLookupBehavior dccLookupBehavior) {
        this.dccLookupBehavior = dccLookupBehavior;
    }

    @Override
    public MockConfiguration.BarcodeScannerBehavior getBarcodeScannerBehavior() {
        return this.barcodeScannerBehavior;
    }

    @Override
    public void setBarcodeScannerBehavior(MockConfiguration.BarcodeScannerBehavior barcodeScannerBehavior) {
        this.barcodeScannerBehavior = barcodeScannerBehavior;
    }

    public void setAccessoryGetsStuckDuringDisplay(boolean accessoryGetsStuckDuringDisplay) {
        this.accessoryGetsStuckDuringDisplay = accessoryGetsStuckDuringDisplay;
    }

    public boolean isAccessoryGetsStuckDuringDisplay() {
        return this.accessoryGetsStuckDuringDisplay;
    }

    @Override
    public MockConfiguration.AskForCardDataWithParametersBehavior getAskForCardDataWithParametersBehavior() {
        return this.askForCardDataWithParametersBehavior;
    }

    @Override
    public void setAskForCardDataWithParametersBehavior(MockConfiguration.AskForCardDataWithParametersBehavior askForCardDataWithParametersBehavior) {
        this.askForCardDataWithParametersBehavior = askForCardDataWithParametersBehavior;
    }

    @Override
    public MockConfiguration.VerificationResultsBehavior getVerificationResultsBehavior() {
        return this.verificationResultsBehavior;
    }

    @Override
    public void setVerificationResultsBehavior(MockConfiguration.VerificationResultsBehavior verificationResultsBehavior) {
        this.verificationResultsBehavior = verificationResultsBehavior;
    }

    @Override
    public TransactionWorkflowType getWorkflowTypeForSessionLookups() {
        return this.workflowTypeForSessionLookups;
    }

    @Override
    public void setWorkflowTypeForSessionLookups(TransactionWorkflowType workflowTypeForSessionLookups) {
        this.workflowTypeForSessionLookups = workflowTypeForSessionLookups;
    }

    public String toString() {
        return "DefaultMockConfiguration{paymentAccessoryBehavior=" + this.paymentAccessoryBehavior + ", paymentAccessoryOptions=" + this.paymentAccessoryOptions + ", paymentAccessoryExtraFeatures=" + this.paymentAccessoryExtraFeatures + ", paymentAccessorySource=" + this.paymentAccessorySource + ", gatewayBehavior=" + this.gatewayBehavior + ", gatewayProvisioningBehavior=" + this.gatewayProvisioningBehavior + ", gatewayOptions=" + this.gatewayOptions + ", gatewayProcessingOptionsAllowedSources=" + this.gatewayProcessingOptionsAllowedSources + ", accessoryUpdateBehavior=" + this.accessoryUpdateBehavior + ", accessoryConnectionBehavior=" + this.accessoryConnectionBehavior + ", whitelistBehavior=" + this.whitelistBehavior + ", printerAccessoryComponentBehavior=" + this.printerAccessoryComponentBehavior + ", tippingAccessoryComponentBehavior=" + this.tippingAccessoryComponentBehavior + ", askForConfirmationBehavior=" + this.askForConfirmationBehavior + ", askForNumberBehavior=" + this.askForNumberBehavior + ", readCardBehavior=" + this.readCardBehavior + ", submitTransactionsBatchBehavior=" + this.submitTransactionsBatchBehavior + ", synchronizeConfigurationBehavior=" + this.synchronizeConfigurationBehavior + ", offlineConfigurationBehavior=" + this.offlineConfigurationBehavior + ", supportedAccessoryComponentTypes=" + this.supportedAccessoryComponentTypes + ", supportedGatewayFeatures=" + this.supportedGatewayFeatures + ", processingWorkflowBehaviors=" + this.processingWorkflowBehaviors + ", alternativePaymentApprovalBehavior=" + this.alternativePaymentApprovalBehavior + ", paymentDetailsScheme=" + this.paymentDetailsScheme + ", noCvmLimit=" + this.noCvmLimit + ", dccSelectionBehavior=" + this.dccSelectionBehavior + ", dccLookupBehavior=" + this.dccLookupBehavior + ", updateRequirementComponents=" + this.updateRequirementComponents + ", accessoryGetsStuckDuringDisplay=" + this.accessoryGetsStuckDuringDisplay + ", barcodeScannerBehavior=" + this.barcodeScannerBehavior + ", askForCardDataWithParametersBehavior=" + this.askForCardDataWithParametersBehavior + ", verificationResultsBehavior" + this.verificationResultsBehavior + ", workflowTypeForSessionLookups" + this.workflowTypeForSessionLookups + "}";
    }
}

