/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.mock;

import io.mpos.logger.LoggerKt;
import io.mpos.mock.Breakpoint;
import io.mpos.mock.Breakpoints;
import io.mpos.mock.MockDelay;
import io.mpos.mock.UnhandledThreadInterruptException;
import io.mpos.shared.config.DelayConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lio/mpos/mock/DefaultMockDelay;", "Lio/mpos/mock/MockDelay;", "delayConfig", "Lio/mpos/shared/config/DelayConfig;", "breakpoints", "Lio/mpos/mock/Breakpoints;", "<init>", "(Lio/mpos/shared/config/DelayConfig;Lio/mpos/mock/Breakpoints;)V", "breakpointsMode", "", "getBreakpointsMode", "()Z", "setBreakpointsMode", "(Z)V", "waitDelayShort", "", "breakpoint", "Lio/mpos/mock/Breakpoint;", "waitDelayLong", "sleepThread", "waitMs", "", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nDefaultMockDelay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultMockDelay.kt\nio/mpos/mock/DefaultMockDelay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class DefaultMockDelay
implements MockDelay {
    @NotNull
    private final DelayConfig delayConfig;
    @NotNull
    private final Breakpoints breakpoints;
    private boolean breakpointsMode;

    public DefaultMockDelay(@NotNull DelayConfig delayConfig, @NotNull Breakpoints breakpoints) {
        Intrinsics.checkNotNullParameter((Object)delayConfig, (String)"");
        Intrinsics.checkNotNullParameter((Object)breakpoints, (String)"");
        this.delayConfig = delayConfig;
        this.breakpoints = breakpoints;
    }

    @Override
    public boolean getBreakpointsMode() {
        return this.breakpointsMode;
    }

    @Override
    public void setBreakpointsMode(boolean bl2) {
        this.breakpointsMode = bl2;
    }

    @Override
    public void waitDelayShort(@Nullable Breakpoint breakpoint) {
        if (this.getBreakpointsMode()) {
            if (breakpoint == null) {
                String string = "This method should never be called without a breakpoint when in breakpoints mode. ";
                throw new IllegalStateException(string.toString());
            }
            this.breakpoints.pauseAt(breakpoint);
        } else {
            this.sleepThread(this.delayConfig.getMockDelayShort());
        }
    }

    @Override
    public void waitDelayLong(@Nullable Breakpoint breakpoint) {
        if (this.getBreakpointsMode()) {
            if (breakpoint == null) {
                String string = "This method should never be called without a breakpoint when in breakpoints mode. ";
                throw new IllegalStateException(string.toString());
            }
            this.breakpoints.pauseAt(breakpoint);
        } else {
            this.sleepThread(this.delayConfig.getMockDelayLong());
        }
    }

    @Override
    public void waitDelayShort() {
        this.waitDelayShort(null);
    }

    @Override
    public void waitDelayLong() {
        this.waitDelayLong(null);
    }

    private final void sleepThread(long waitMs) {
        if (waitMs <= 0L) {
            return;
        }
        try {
            Thread.sleep(waitMs);
        }
        catch (InterruptedException interruptedException) {
            LoggerKt.logError("DefaultMockDelay", "Received interrupted exception", interruptedException);
            interruptedException.printStackTrace();
            Thread.currentThread().interrupt();
            throw new UnhandledThreadInterruptException();
        }
    }
}

