/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.network.jwt;

import io.mpos.core.common.obfuscated.aw;
import io.mpos.errors.ErrorType;
import io.mpos.network.UserAgent;
import io.mpos.network.jwt.JwtAuthenticationInterceptorException;
import io.mpos.network.jwt.JwtToken;
import io.mpos.network.jwt.JwtTokenRepository;
import io.mpos.network.jwt.JwtTokenResponse;
import io.mpos.network.jwt.TokenParserKt;
import io.mpos.platform.DeviceInformation;
import io.mpos.provider.ProviderMode;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\fH\u0016JK\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u00072!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020#0\u001eH\u0016JC\u0010$\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\f2!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020#0\u001eH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/mpos/network/jwt/DefaultJwtTokenRepository;", "Lio/mpos/network/jwt/JwtTokenRepository;", "deviceInformation", "Lio/mpos/platform/DeviceInformation;", "<init>", "(Lio/mpos/platform/DeviceInformation;)V", "maxLoginRetryAttempts", "", "retryCodes", "", "Lkotlin/ranges/IntRange;", "tag", "", "store", "", "Lio/mpos/network/jwt/JwtToken;", "mapper", "Lkotlinx/serialization/json/Json$Default;", "addToken", "", "merchantId", "token", "hasToken", "", "getToken", "obtainJwtToken", "secret", "baseUrl", "minimumExpirationTimeInSeconds", "executeRequest", "Lkotlin/Function1;", "Lokhttp3/Request;", "Lkotlin/ParameterName;", "name", "loginRequest", "Lokhttp3/Response;", "createJwtToken", "extractProviderMode", "Lio/mpos/provider/ProviderMode;", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nDefaultJwtTokenRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultJwtTokenRepository.kt\nio/mpos/network/jwt/DefaultJwtTokenRepository\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n205#2:142\n222#2:146\n1761#3,3:143\n*S KotlinDebug\n*F\n+ 1 DefaultJwtTokenRepository.kt\nio/mpos/network/jwt/DefaultJwtTokenRepository\n*L\n83#1:142\n100#1:146\n96#1:143,3\n*E\n"})
public final class DefaultJwtTokenRepository
implements JwtTokenRepository {
    @NotNull
    private final DeviceInformation deviceInformation;
    private final int maxLoginRetryAttempts;
    @NotNull
    private final Set<IntRange> retryCodes;
    @NotNull
    private final String tag;
    @NotNull
    private final Map<String, JwtToken> store;
    @NotNull
    private final Json.Default mapper;

    @Inject
    public DefaultJwtTokenRepository(@NotNull DeviceInformation deviceInformation) {
        Intrinsics.checkNotNullParameter((Object)deviceInformation, (String)"");
        this.deviceInformation = deviceInformation;
        this.maxLoginRetryAttempts = 3;
        Object[] objectArray = new IntRange[]{new IntRange(404, 404), new IntRange(500, 599)};
        this.retryCodes = SetsKt.setOf((Object[])objectArray);
        this.tag = "JwtAuthenticationInterceptor";
        this.store = new LinkedHashMap();
        this.mapper = Json.Default;
    }

    private final void addToken(String merchantId, JwtToken token) {
        this.store.put(merchantId, token);
    }

    @Override
    public boolean hasToken(@NotNull String merchantId) {
        Intrinsics.checkNotNullParameter((Object)merchantId, (String)"");
        return this.store.containsKey(merchantId);
    }

    @Override
    @Nullable
    public JwtToken getToken(@NotNull String merchantId) {
        Intrinsics.checkNotNullParameter((Object)merchantId, (String)"");
        return this.store.get(merchantId);
    }

    @Override
    @NotNull
    public JwtToken obtainJwtToken(@NotNull String merchantId, @NotNull String secret, @NotNull String baseUrl, int minimumExpirationTimeInSeconds, @NotNull Function1<? super Request, Response> executeRequest) {
        JwtToken jwtToken;
        Intrinsics.checkNotNullParameter((Object)merchantId, (String)"");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"");
        Intrinsics.checkNotNullParameter(executeRequest, (String)"");
        JwtToken jwtToken2 = this.store.get(merchantId);
        if (jwtToken2 != null && (jwtToken = jwtToken2).isValidMoreThan(minimumExpirationTimeInSeconds)) {
            return jwtToken;
        }
        return this.createJwtToken(merchantId, secret, baseUrl, executeRequest);
    }

    @Override
    @NotNull
    public JwtToken createJwtToken(@NotNull String merchantId, @NotNull String secret, @NotNull String baseUrl, @NotNull Function1<? super Request, Response> executeRequest) {
        Json json;
        Object object;
        Object object2;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)merchantId, (String)"");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"");
        Intrinsics.checkNotNullParameter(executeRequest, (String)"");
        ProviderMode providerMode = new ProviderMode[]{TuplesKt.to((Object)"id", (Object)merchantId), TuplesKt.to((Object)"secret", (Object)secret)};
        Map map = MapsKt.mapOf((Pair[])providerMode);
        providerMode = this.extractProviderMode(baseUrl);
        Request.Builder builder = new Request.Builder().addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").addHeader("User-Agent", UserAgent.createUserAgentString(this.deviceInformation.getSdkInformation().getVersion(), this.deviceInformation.getDeviceIdentifier(), providerMode.name(), this.deviceInformation.getOperatingSystem().name(), this.deviceInformation.getVersion()));
        Json json2 = (Json)this.mapper;
        json2.getSerializersModule();
        Request request = builder.post(RequestBody.Companion.create(json2.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), (Object)map), MediaType.Companion.parse("application/json"))).url(baseUrl + "/login").build();
        int n2 = 0;
        block0: do {
            Response response;
            ++n2;
            object2 = executeRequest.invoke((Object)request);
            Object object3 = object2;
            if (object3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"");
                response = null;
            } else {
                response = (Response)object3;
            }
            String cfr_ignored_0 = "Call login endpoint attempt:" + n2 + " from " + this.maxLoginRetryAttempts + " result is " + response.code();
            if (n2 >= this.maxLoginRetryAttempts) break;
            object = this.retryCodes;
            if (object instanceof Collection && ((Collection)object).isEmpty()) {
                bl2 = false;
                continue;
            }
            json = object.iterator();
            while (json.hasNext()) {
                Object e2 = json.next();
                IntRange intRange = (IntRange)e2;
                int n3 = intRange.getFirst();
                int n4 = intRange.getLast();
                int n5 = ((Response)object2).code();
                boolean bl3 = n3 <= n5 ? n5 <= n4 : false;
                if (!bl3) continue;
                bl2 = true;
                continue block0;
            }
            bl2 = false;
        } while (bl2);
        if (((Response)object2).isSuccessful()) {
            object = ((Response)object2).body().string();
            json = (Json)this.mapper;
            json.getSerializersModule();
            JwtToken jwtToken = TokenParserKt.parseToken(((JwtTokenResponse)json.decodeFromString((DeserializationStrategy)JwtTokenResponse.Companion.serializer(), (String)object)).getToken());
            this.addToken(merchantId, jwtToken);
            return jwtToken;
        }
        throw new JwtAuthenticationInterceptorException(ErrorType.SERVER_INVALID_RESPONSE, "response from " + baseUrl + "/login was unsuccessful. Response code is " + ((Response)object2).code(), (Response)object2);
    }

    private final ProviderMode extractProviderMode(String baseUrl) {
        ProviderMode providerMode;
        try {
            HttpUrl httpUrl = HttpUrl.Companion.parse(baseUrl);
            if (httpUrl == null || (httpUrl = aw.a(httpUrl)) == null) {
                httpUrl = ProviderMode.UNKNOWN;
            }
            providerMode = httpUrl;
        }
        catch (IllegalStateException illegalStateException) {
            providerMode = ProviderMode.UNKNOWN;
        }
        return providerMode;
    }
}

