/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.network.jwt;

import io.mpos.errors.ErrorType;
import io.mpos.network.jwt.JwtAuthenticationInterceptorException;
import io.mpos.network.jwt.JwtToken;
import io.mpos.network.jwt.JwtTokenRepository;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 &2\u00020\u0001:\u0001&B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J8\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J8\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\u0007H\u0002J$\u0010!\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u0007H\u0002J\f\u0010#\u001a\u00020\u0007*\u00020$H\u0002J\f\u0010%\u001a\u00020 *\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/mpos/network/jwt/JwtAuthenticationInterceptor;", "Lokhttp3/Interceptor;", "jwtTokenRepository", "Lio/mpos/network/jwt/JwtTokenRepository;", "baseUrlWithPortResolver", "Lkotlin/Function1;", "Lokhttp3/HttpUrl;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Lio/mpos/network/jwt/JwtTokenRepository;Lkotlin/jvm/functions/Function1;)V", "(Lio/mpos/network/jwt/JwtTokenRepository;)V", "tag", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "proceedWithReaderMerchantCredential", "merchantId", "secret", "originalRequest", "Lokhttp3/Request;", "baseUrlAndPort", "jwtToken", "Lio/mpos/network/jwt/JwtToken;", "proceedWithFallbackToJwtWhen401", "incomingResponse", "baseUrl", "getMerchantIdAndSecret", "Lkotlin/Pair;", "request", "isReaderMerchantCredential", "", "replaceAuthorizationWithJwtTokenHeader", "newUrl", "authorizationHeaderValue", "Lokhttp3/Headers;", "containsBasicAuthHeader", "Companion", "mpos.core"})
public final class JwtAuthenticationInterceptor
implements Interceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JwtTokenRepository jwtTokenRepository;
    @NotNull
    private final Function1<HttpUrl, String> baseUrlWithPortResolver;
    @NotNull
    private final String tag;
    @NotNull
    private static final String AUTHORIZATION_HEADER = "Authorization";
    @NotNull
    private static final Regex PAYWORKS_BASIC_AUTHORIZATION_HEADER_VALUE_REGEX = new Regex("merchantIdentifier=(.*?),merchantSecretKey=");
    @NotNull
    private static final Regex READER_MERCHANT_CREDENTIAL_REGEX = new Regex("(.+)@(.+):(.+)");

    public JwtAuthenticationInterceptor(@NotNull JwtTokenRepository jwtTokenRepository, @NotNull Function1<? super HttpUrl, String> baseUrlWithPortResolver) {
        Intrinsics.checkNotNullParameter((Object)jwtTokenRepository, (String)"");
        Intrinsics.checkNotNullParameter(baseUrlWithPortResolver, (String)"");
        this.jwtTokenRepository = jwtTokenRepository;
        this.baseUrlWithPortResolver = baseUrlWithPortResolver;
        this.tag = "JwtAuthenticationInterceptor";
    }

    @Inject
    public JwtAuthenticationInterceptor(@NotNull JwtTokenRepository jwtTokenRepository) {
        Intrinsics.checkNotNullParameter((Object)jwtTokenRepository, (String)"");
        this(jwtTokenRepository, (Function1<? super HttpUrl, String>)((Function1)1.INSTANCE));
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"");
        Request request = chain.request();
        if (!this.containsBasicAuthHeader(request)) {
            return chain.proceed(request);
        }
        try {
            Pair<String, String> pair = this.getMerchantIdAndSecret(request);
            String string = (String)pair.component1();
            String string2 = (String)pair.component2();
            String string3 = (String)this.baseUrlWithPortResolver.invoke((Object)request.url());
            JwtToken jwtToken = JwtTokenRepository.DefaultImpls.obtainJwtToken$default(this.jwtTokenRepository, string, string2, string3, 0, arg_0 -> JwtAuthenticationInterceptor.intercept$lambda$0(chain, arg_0), 8, null);
            if (this.isReaderMerchantCredential(string)) {
                return this.proceedWithReaderMerchantCredential(string, string2, request, chain, string3, jwtToken);
            }
            Request request2 = JwtAuthenticationInterceptor.replaceAuthorizationWithJwtTokenHeader$default(this, request, jwtToken, null, 4, null);
            return this.proceedWithFallbackToJwtWhen401(chain.proceed(request2), chain, string, string2, string3, request);
        }
        catch (JwtAuthenticationInterceptorException jwtAuthenticationInterceptorException) {
            String cfr_ignored_0 = "Exception thrown: " + jwtAuthenticationInterceptorException.getMessage() + " Interceptor will fallback to BadRequest.";
            Response response = jwtAuthenticationInterceptorException.getResponse();
            if (response == null) {
                response = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(400).body(ResponseBody.Companion.create$default((ResponseBody.Companion)ResponseBody.Companion, (String)jwtAuthenticationInterceptorException.getError().name(), null, (int)1, null)).message(jwtAuthenticationInterceptorException.getError().name() + " " + jwtAuthenticationInterceptorException.getMessage()).build();
            }
            return response;
        }
    }

    private final Response proceedWithReaderMerchantCredential(String merchantId, String secret, Request originalRequest, Interceptor.Chain chain, String baseUrlAndPort, JwtToken jwtToken) {
        String string = jwtToken.getSubject();
        String string2 = StringsKt.replace$default((String)originalRequest.url().toString(), (String)merchantId, (String)string, (boolean)false, (int)4, null);
        Request request = this.replaceAuthorizationWithJwtTokenHeader(originalRequest, jwtToken, string2);
        return this.proceedWithFallbackToJwtWhen401(chain.proceed(request), chain, merchantId, secret, baseUrlAndPort, request);
    }

    private final Response proceedWithFallbackToJwtWhen401(Response incomingResponse, Interceptor.Chain chain, String merchantId, String secret, String baseUrl, Request originalRequest) {
        Response response = incomingResponse;
        if (401 == response.code()) {
            response.close();
            JwtToken jwtToken = this.jwtTokenRepository.createJwtToken(merchantId, secret, baseUrl, (Function1<? super Request, Response>)((Function1)arg_0 -> JwtAuthenticationInterceptor.proceedWithFallbackToJwtWhen401$lambda$1(chain, arg_0)));
            Request request = JwtAuthenticationInterceptor.replaceAuthorizationWithJwtTokenHeader$default(this, originalRequest, jwtToken, null, 4, null);
            response = chain.proceed(request);
        }
        return response;
    }

    private final Pair<String, String> getMerchantIdAndSecret(Request request) {
        if (!this.containsBasicAuthHeader(request)) {
            throw new JwtAuthenticationInterceptorException(ErrorType.SERVER_AUTHENTICATION_FAILED, "AUTHORIZATION header value doesn't match the expected format 'merchantIdentifier=[merchantIdentifierValue],merchantSecretKey=[merchantSecretValue]", null, 4, null);
        }
        String string = this.authorizationHeaderValue(request.headers());
        return new Pair((Object)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)string, (String)"merchantIdentifier=", null, (int)2, null), (String)",", null, (int)2, null), (Object)StringsKt.substringAfter$default((String)string, (String)"merchantSecretKey=", null, (int)2, null));
    }

    private final boolean isReaderMerchantCredential(String $this$isReaderMerchantCredential) {
        CharSequence charSequence = $this$isReaderMerchantCredential;
        return READER_MERCHANT_CREDENTIAL_REGEX.containsMatchIn(charSequence);
    }

    private final Request replaceAuthorizationWithJwtTokenHeader(Request request, JwtToken jwtToken, String newUrl) {
        Request.Builder builder = new Request.Builder();
        String string = newUrl;
        if (string == null) {
            string = request.url().toString();
        }
        return builder.url(string).method(request.method(), request.body()).headers(request.headers()).removeHeader(AUTHORIZATION_HEADER).addHeader(AUTHORIZATION_HEADER, "Bearer " + jwtToken.getToken()).build();
    }

    static /* synthetic */ Request replaceAuthorizationWithJwtTokenHeader$default(JwtAuthenticationInterceptor jwtAuthenticationInterceptor, Request request, JwtToken jwtToken, String string, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string = null;
        }
        return jwtAuthenticationInterceptor.replaceAuthorizationWithJwtTokenHeader(request, jwtToken, string);
    }

    private final String authorizationHeaderValue(Headers $this$authorizationHeaderValue) {
        return String.valueOf($this$authorizationHeaderValue.get(AUTHORIZATION_HEADER));
    }

    private final boolean containsBasicAuthHeader(Request $this$containsBasicAuthHeader) {
        String string = $this$containsBasicAuthHeader.headers().get(AUTHORIZATION_HEADER);
        if (string == null) {
            string = "";
        }
        CharSequence charSequence = string;
        return PAYWORKS_BASIC_AUTHORIZATION_HEADER_VALUE_REGEX.containsMatchIn(charSequence);
    }

    private static final Response intercept$lambda$0(Interceptor.Chain $chain, Request loginRequest) {
        Intrinsics.checkNotNullParameter((Object)loginRequest, (String)"");
        return $chain.proceed(loginRequest);
    }

    private static final Response proceedWithFallbackToJwtWhen401$lambda$1(Interceptor.Chain $chain, Request loginRequest) {
        Intrinsics.checkNotNullParameter((Object)loginRequest, (String)"");
        return $chain.proceed(loginRequest);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/mpos/network/jwt/JwtAuthenticationInterceptor$Companion;", "", "<init>", "()V", "AUTHORIZATION_HEADER", "", "PAYWORKS_BASIC_AUTHORIZATION_HEADER_VALUE_REGEX", "Lkotlin/text/Regex;", "READER_MERCHANT_CREDENTIAL_REGEX", "mpos.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

