/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.network.jwt;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0006J\b\u0010\u0011\u001a\u00020\u0006H\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c2\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/mpos/network/jwt/JwtToken;", "", "token", "", "subject", "validForInSeconds", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;I)V", "getToken", "()Ljava/lang/String;", "getSubject", "creationLocalTimeInSeconds", "valid4ever", "", "isValidMoreThan", "minimumExpTimeInSeconds", "nowSeconds", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "mpos.core"})
public final class JwtToken {
    @NotNull
    private final String token;
    @NotNull
    private final String subject;
    private final int validForInSeconds;
    private final int creationLocalTimeInSeconds;

    public JwtToken(@NotNull String token, @NotNull String subject, int validForInSeconds) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"");
        this.token = token;
        this.subject = subject;
        this.validForInSeconds = validForInSeconds;
        this.creationLocalTimeInSeconds = this.nowSeconds();
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @NotNull
    public final String getSubject() {
        return this.subject;
    }

    private final boolean valid4ever() {
        return this.validForInSeconds == 0;
    }

    public final boolean isValidMoreThan(int minimumExpTimeInSeconds) {
        boolean bl2 = this.nowSeconds() + minimumExpTimeInSeconds < this.creationLocalTimeInSeconds + this.validForInSeconds;
        String cfr_ignored_0 = "isStillValid:" + bl2 + ", isValid4ever:" + this.valid4ever() + " requested valid for:" + minimumExpTimeInSeconds + ", validUntil:" + (this.creationLocalTimeInSeconds + this.validForInSeconds);
        return this.valid4ever() || bl2;
    }

    private final int nowSeconds() {
        return (int)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime());
    }

    @NotNull
    public final String component1() {
        return this.token;
    }

    @NotNull
    public final String component2() {
        return this.subject;
    }

    private final int component3() {
        return this.validForInSeconds;
    }

    @NotNull
    public final JwtToken copy(@NotNull String token, @NotNull String subject, int validForInSeconds) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"");
        Intrinsics.checkNotNullParameter((Object)subject, (String)"");
        return new JwtToken(token, subject, validForInSeconds);
    }

    public static /* synthetic */ JwtToken copy$default(JwtToken jwtToken, String string, String string2, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = jwtToken.token;
        }
        if ((n3 & 2) != 0) {
            string2 = jwtToken.subject;
        }
        if ((n3 & 4) != 0) {
            n2 = jwtToken.validForInSeconds;
        }
        return jwtToken.copy(string, string2, n2);
    }

    @NotNull
    public String toString() {
        return "JwtToken(token=" + this.token + ", subject=" + this.subject + ", validForInSeconds=" + this.validForInSeconds + ")";
    }

    public int hashCode() {
        int n2 = this.token.hashCode();
        n2 = n2 * 31 + this.subject.hashCode();
        n2 = n2 * 31 + Integer.hashCode(this.validForInSeconds);
        return n2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JwtToken)) {
            return false;
        }
        JwtToken jwtToken = (JwtToken)other;
        if (!Intrinsics.areEqual((Object)this.token, (Object)jwtToken.token)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subject, (Object)jwtToken.subject)) {
            return false;
        }
        return this.validForInSeconds == jwtToken.validForInSeconds;
    }
}

