/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.network.jwt;

import com.visa.utils.Base64;
import io.mpos.errors.ErrorType;
import io.mpos.network.jwt.JwtAuthenticationInterceptorException;
import io.mpos.network.jwt.JwtToken;
import io.mpos.network.jwt.JwtTokenPayload;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"jwtTokenRegex", "Lkotlin/text/Regex;", "mapper", "Lkotlinx/serialization/json/Json;", "parseToken", "Lio/mpos/network/jwt/JwtToken;", "tokenInBase64", "", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nTokenParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TokenParser.kt\nio/mpos/network/jwt/TokenParserKt\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,27:1\n222#2:28\n1#3:29\n*S KotlinDebug\n*F\n+ 1 TokenParser.kt\nio/mpos/network/jwt/TokenParserKt\n*L\n21#1:28\n*E\n"})
public final class TokenParserKt {
    @NotNull
    private static final Regex jwtTokenRegex = new Regex("^[a-zA-Z0-9\\-_]+\\.[a-zA-Z0-9\\-_]+\\.[a-zA-Z0-9\\-_]+$");
    @NotNull
    private static final Json mapper = JsonKt.Json$default(null, TokenParserKt::mapper$lambda$0, (int)1, null);

    @NotNull
    public static final JwtToken parseToken(@NotNull String tokenInBase64) {
        Intrinsics.checkNotNullParameter((Object)tokenInBase64, (String)"");
        Object object = tokenInBase64;
        if (jwtTokenRegex.containsMatchIn((CharSequence)object)) {
            int n2;
            Object object2 = new String[]{"."};
            object = Base64.decode((String)((String)StringsKt.split$default((CharSequence)tokenInBase64, (String[])object2, (boolean)false, (int)0, (int)6, null).get(1)), (int)8);
            Json json = mapper;
            Intrinsics.checkNotNull((Object)object);
            Object object3 = object;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"");
            Charset charset2 = charset;
            object3 = new String((byte[])object3, charset2);
            json.getSerializersModule();
            object2 = (JwtTokenPayload)json.decodeFromString((DeserializationStrategy)JwtTokenPayload.Companion.serializer(), (String)object3);
            Integer n3 = ((JwtTokenPayload)object2).getExp();
            if (n3 != null) {
                int n4 = ((Number)n3).intValue();
                n2 = n4 - ((JwtTokenPayload)object2).getIat();
            } else {
                n2 = 0;
            }
            int n5 = n2;
            return new JwtToken(tokenInBase64, ((JwtTokenPayload)object2).getSub(), n5);
        }
        throw new JwtAuthenticationInterceptorException(ErrorType.SERVER_INVALID_RESPONSE, "Invalid JWT token string => " + tokenInBase64, null, 4, null);
    }

    private static final Unit mapper$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }
}

