/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.accessories;

import io.mpos.accessories.Accessory;
import io.mpos.accessories.AccessoryBatteryState;
import io.mpos.accessories.AccessoryConnectionState;
import io.mpos.accessories.AccessoryConnectionType;
import io.mpos.accessories.AccessoryDetails;
import io.mpos.accessories.AccessoryFamily;
import io.mpos.accessories.AccessoryType;
import io.mpos.logger.Log;
import io.mpos.shared.accessories.AccessoryCommunicationPlugins;
import io.mpos.shared.accessories.debug.AccessoryDataLogger;
import io.mpos.shared.communicationmodules.CommunicationDelegate;
import io.mpos.shared.communicationmodules.CommunicationModule;
import io.mpos.shared.communicationmodules.SuccessFailureListener;
import io.mpos.shared.events.AccessoryConnectionStateChangedEvent;
import io.mpos.shared.events.BusProvider;
import io.mpos.shared.helper.Helper;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.localization.LocalizationServer;
import io.mpos.shared.provider.AbstractProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAccessory
implements Accessory,
CommunicationDelegate {
    private static final String TAG = "AbstractAccessory";
    protected AccessoryType mAccessoryType = AccessoryType.UNKNOWN;
    protected AccessoryFamily mAccessoryFamily = AccessoryFamily.UNKNOWN;
    protected AccessoryDetails mAccessoryDetails;
    protected Locale mLocale = LocalizationServer.FALLBACK_DEFAULT;
    protected int mBatteryLevel = -1;
    protected AccessoryBatteryState mAccessoryBatteryState = AccessoryBatteryState.UNKNOWN;
    private final String mInternalUniqueId = Helper.createRandomUUID();
    private AbstractProvider mProvider;
    protected Profiler mProfiler;
    private final ByteArrayOutputStream mReceiveBuffer;
    protected CommunicationModule mCommunicationModule;

    public AbstractAccessory(CommunicationModule communicationModule) {
        this.mCommunicationModule = communicationModule;
        this.mReceiveBuffer = new ByteArrayOutputStream();
    }

    public AbstractAccessory(CommunicationModule communicationModule, Locale locale) {
        this(communicationModule);
        this.setLocale(locale);
    }

    public AccessoryType getType() {
        return this.mAccessoryType;
    }

    public AccessoryFamily getFamily() {
        return this.mAccessoryFamily;
    }

    @Override
    public void onIncomingData(byte[] data) {
        Object object;
        AccessoryDataLogger.onIncomingData(data);
        if (data == null || data.length == 0) {
            return;
        }
        try {
            object = this.mReceiveBuffer;
            synchronized (object) {
                this.mReceiveBuffer.write(data);
            }
        }
        catch (IOException iOException) {
            Log.e(TAG, "exception queueing incoming data");
        }
        object = AccessoryCommunicationPlugins.getListeners();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            AccessoryCommunicationPlugins.CommunicationListener communicationListener = (AccessoryCommunicationPlugins.CommunicationListener)iterator.next();
            communicationListener.onResponseReceived(this, data);
        }
        this.handleQueuedData();
    }

    protected byte[] getCurrentQueuedData() {
        ByteArrayOutputStream byteArrayOutputStream = this.mReceiveBuffer;
        synchronized (byteArrayOutputStream) {
            byte[] byArray = this.mReceiveBuffer.toByteArray();
            this.mReceiveBuffer.reset();
            return byArray;
        }
    }

    @Override
    public void connectionStateChanged(AccessoryConnectionState newState) {
        if (newState != AccessoryConnectionState.CONNECTED && this.mProvider != null) {
            this.mProvider.internalReactToAccessoryDisconnect(this);
        }
        Log.i(TAG, "Accessory changed state to: " + newState);
        AccessoryConnectionStateChangedEvent accessoryConnectionStateChangedEvent = new AccessoryConnectionStateChangedEvent(this, newState);
        BusProvider.getInstance().post((Object)accessoryConnectionStateChangedEvent);
        if (newState == AccessoryConnectionState.DISCONNECTED || newState == AccessoryConnectionState.CONNECTED_BUT_UNAVAILABLE) {
            this.internal_notifyFullyDisconnected();
        }
    }

    protected void internal_notifyFullyDisconnected() {
        List<AccessoryCommunicationPlugins.CommunicationListener> list = AccessoryCommunicationPlugins.getListeners();
        for (AccessoryCommunicationPlugins.CommunicationListener communicationListener : list) {
            communicationListener.onDisconnected(this);
        }
    }

    public AccessoryConnectionType getConnectionType() {
        return this.mCommunicationModule.getConnectionType();
    }

    public AccessoryConnectionState getConnectionState() {
        return this.mCommunicationModule.getConnectionState();
    }

    public AccessoryBatteryState getBatteryState() {
        return this.mAccessoryBatteryState;
    }

    public void setAccessoryBatteryState(AccessoryBatteryState accessoryBatteryState) {
        this.mAccessoryBatteryState = accessoryBatteryState;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    public void setLocale(@NotNull Locale locale) {
        this.mLocale = LocalizationServer.checkAndAssignLocaleWithFallbackToLanguage(locale);
    }

    public int getBatteryLevel() {
        return this.mBatteryLevel;
    }

    public void setBatteryLevel(int batteryLevel) {
        this.mBatteryLevel = batteryLevel;
    }

    public AccessoryDetails getAccessoryDetails() {
        return this.mAccessoryDetails;
    }

    public String toString() {
        return "AbstractAccessory{, mAccessoryType=" + this.mAccessoryType + ", mAccessoryFamily=" + this.mAccessoryFamily + ", mAccessoryDetails=" + this.getAccessoryDetails() + ", mLocale=" + this.mLocale + ", mBatteryLevel=" + this.mBatteryLevel + ", mAccessoryBatteryState=" + this.mAccessoryBatteryState + ", mInternalUniqueId='" + this.mInternalUniqueId + "'}";
    }

    public void setProvider(AbstractProvider provider) {
        this.mProvider = provider;
    }

    public void setProfiler(Profiler profiler) {
        this.mProfiler = profiler;
    }

    public AbstractProvider getProvider() {
        return this.mProvider;
    }

    public final void connect(SuccessFailureListener listener) {
        List<AccessoryCommunicationPlugins.CommunicationListener> list = AccessoryCommunicationPlugins.getListeners();
        for (AccessoryCommunicationPlugins.CommunicationListener communicationListener : list) {
            communicationListener.onConnect(this);
        }
        this.startConnection(listener);
    }

    protected abstract void startConnection(SuccessFailureListener var1);

    public final void disconnect(SuccessFailureListener listener) {
        this.endConnection(listener);
    }

    protected abstract void endConnection(SuccessFailureListener var1);

    protected abstract void handleQueuedData();

    public void sendData(byte[] data, boolean applyTimeout) {
        AccessoryDataLogger.logOutgoingData(data, this.mAccessoryFamily);
        this.mCommunicationModule.sendData(data, applyTimeout);
        List<AccessoryCommunicationPlugins.CommunicationListener> list = AccessoryCommunicationPlugins.getListeners();
        for (AccessoryCommunicationPlugins.CommunicationListener communicationListener : list) {
            communicationListener.onCommandSent(this, data);
        }
    }

    public void sendData(byte[] data) {
        AccessoryDataLogger.logOutgoingData(data, this.mAccessoryFamily);
        this.mCommunicationModule.sendData(data);
        List<AccessoryCommunicationPlugins.CommunicationListener> list = AccessoryCommunicationPlugins.getListeners();
        for (AccessoryCommunicationPlugins.CommunicationListener communicationListener : list) {
            communicationListener.onCommandSent(this, data);
        }
    }

    public void sendDataStream(byte[] data) {
        AccessoryDataLogger.logOutgoingStreamData(data);
        this.mCommunicationModule.sendData(data, false);
        List<AccessoryCommunicationPlugins.CommunicationListener> list = AccessoryCommunicationPlugins.getListeners();
        for (AccessoryCommunicationPlugins.CommunicationListener communicationListener : list) {
            communicationListener.onCommandSent(this, data);
        }
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof AbstractAccessory)) {
            return false;
        }
        AbstractAccessory abstractAccessory = (AbstractAccessory)o2;
        return !(this.mInternalUniqueId != null ? !this.mInternalUniqueId.equals(abstractAccessory.mInternalUniqueId) : abstractAccessory.mInternalUniqueId != null);
    }

    public int hashCode() {
        return this.mInternalUniqueId != null ? this.mInternalUniqueId.hashCode() : 0;
    }
}

