/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.accessories.debug;

import com.visa.logger.LogLevel;
import io.mpos.accessories.AccessoryFamily;
import io.mpos.logger.Logger;
import io.mpos.logger.LoggerKt;
import io.mpos.shared.accessories.debug.HexHelpersKt;
import io.mpos.specs.helper.ByteHelper;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0014\u0010\f\u001a\u00020\r*\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lio/mpos/shared/accessories/debug/AccessoryDataLogger;", "", "<init>", "()V", "logOutgoingData", "", "data", "", "accessoryFamily", "Lio/mpos/accessories/AccessoryFamily;", "onIncomingData", "logOutgoingStreamData", "asCommandName", "", "prettyPrintOutgoing", "prettyPrintIncoming", "shouldLimit", "", "mpos.core"})
public final class AccessoryDataLogger {
    @NotNull
    public static final AccessoryDataLogger INSTANCE = new AccessoryDataLogger();

    private AccessoryDataLogger() {
    }

    @JvmStatic
    public static final void logOutgoingData(@NotNull byte[] data, @NotNull AccessoryFamily accessoryFamily) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"");
        Intrinsics.checkNotNullParameter((Object)accessoryFamily, (String)"");
        Logger logger = Logger.Companion.getLogger();
        Object object = logger != null ? logger.getVerbosity() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: 
            case 2: {
                INSTANCE.prettyPrintOutgoing(data, accessoryFamily);
                break;
            }
            default: {
                LoggerKt.logInfo("AbstractAccessory", INSTANCE.prettyPrintOutgoing(data, accessoryFamily));
            }
        }
    }

    @JvmStatic
    public static final void onIncomingData(@Nullable byte[] data) {
        if (data == null || data.length == 0) {
            LoggerKt.logInfo("AbstractAccessory", "got 0 data");
            return;
        }
        Logger logger = Logger.Companion.getLogger();
        Object object = logger != null ? logger.getVerbosity() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: 
            case 2: {
                INSTANCE.prettyPrintIncoming(data);
                break;
            }
            default: {
                LoggerKt.logInfo("AbstractAccessory", INSTANCE.prettyPrintIncoming(data));
            }
        }
    }

    @JvmStatic
    public static final void logOutgoingStreamData(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"");
        String string = ">>>>> [STREAM] " + data.length + " bytes";
        Logger logger = Logger.Companion.getLogger();
        Object object = logger != null ? logger.getVerbosity() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                LoggerKt.logInfo("AbstractAccessory", string);
            }
        }
    }

    private final String asCommandName(String $this$asCommandName, AccessoryFamily accessoryFamily) {
        return switch (WhenMappings.$EnumSwitchMapping$1[accessoryFamily.ordinal()]) {
            case 1 -> {
                String v0 = $this$asCommandName.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"");
                yield HexHelpersKt.asMiuraCommandName(v0);
            }
            case 2 -> {
                String v2 = $this$asCommandName.substring(6);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"");
                yield HexHelpersKt.asVipaCommandName(v2);
            }
            default -> "???";
        };
    }

    private final String prettyPrintOutgoing(byte[] data, AccessoryFamily accessoryFamily) {
        String string;
        if (data.length > 24 && this.shouldLimit()) {
            String string2 = ByteHelper.toHexShortString(ArraysKt.copyOfRange((byte[])data, (int)0, (int)24));
            Intrinsics.checkNotNull((Object)string2);
            string = "[" + this.asCommandName(string2, accessoryFamily) + "] " + string2 + " ... (" + data.length + " bytes)";
        } else {
            String string3 = ByteHelper.toHexShortString(data);
            Intrinsics.checkNotNull((Object)string3);
            string = "[" + this.asCommandName(string3, accessoryFamily) + "] " + string3;
        }
        return ">>>>> " + string;
    }

    private final String prettyPrintIncoming(byte[] data) {
        Object object;
        if (data.length > 24 && this.shouldLimit()) {
            String string = ByteHelper.toHexShortString(ArraysKt.copyOfRange((byte[])data, (int)0, (int)24));
            object = string + " ... (" + data.length + " bytes)";
        } else {
            object = ByteHelper.toHexShortString(data);
        }
        return "<<<<< " + (String)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldLimit() {
        Logger logger = Logger.Companion.getLogger();
        if ((logger != null ? logger.getVerbosity() : null) == LogLevel.TRACE) return false;
        Logger logger2 = Logger.Companion.getLogger();
        if ((logger2 != null ? logger2.getVerbosity() : null) == LogLevel.DEBUG) return false;
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.TRACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[LogLevel.DEBUG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AccessoryFamily.values().length];
            try {
                nArray[AccessoryFamily.MIURA_MPI.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[AccessoryFamily.VERIFONE_VIPA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

