/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.accessories.modules;

import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.paymentdetails.ApplicationInformation;
import io.mpos.shared.accessories.modules.AbstractInteractionModule;
import io.mpos.shared.accessories.modules.InteractionResult;
import io.mpos.shared.accessories.modules.listener.DccSelectionRequestListener;
import io.mpos.shared.accessories.modules.listener.InteractionApplicationSelectionListener;
import io.mpos.shared.accessories.modules.listener.InteractionCheckingSavingsSelectionListener;
import io.mpos.shared.accessories.modules.listener.InteractionConfirmationListener;
import io.mpos.shared.accessories.modules.listener.InteractionCreditDebitSelectionListener;
import io.mpos.shared.accessories.modules.listener.LanguageSelectionListener;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.actionresponse.TransactionActionApplicationSelectionResponse;
import io.mpos.shared.transactions.actionresponse.TransactionActionCreditDebitSelectionResponse;
import io.mpos.shared.transactions.actionresponse.TransactionActionDccSelectionResponse;
import io.mpos.shared.transactions.actionresponse.TransactionActionInteracAccountSelectionResponse;
import io.mpos.shared.transactions.actionresponse.TransactionActionLanguageSelectionResponse;
import io.mpos.shared.transactions.actionsupport.DefaultApplicationSelectionTransactionActionSupport;
import io.mpos.shared.transactions.actionsupport.DefaultDccSelectionTransactionActionSupport;
import io.mpos.shared.transactions.actionsupport.DefaultLanguageSelectionTransactionActionSupport;
import io.mpos.transactions.TransactionAction;
import io.mpos.transactions.actionresponse.TransactionActionResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class GenericInteractionModule
extends AbstractInteractionModule {
    private static final String TAG = "GenericInteractionModule";
    private InteractionApplicationSelectionListener mInteractionApplicationSelectionListener;
    private InteractionCheckingSavingsSelectionListener mInteractionCheckingSavingsSelectionListener;
    private InteractionCreditDebitSelectionListener mInteractionCreditDebitSelectionListener;
    private LanguageSelectionListener languageSelectionListener;
    private DccSelectionRequestListener mDccSelectionListener;
    private List<ApplicationInformation> mAvailableApplications;
    private BaseTransaction transaction;

    public GenericInteractionModule(PaymentAccessory accessory) {
        super(accessory);
    }

    @Override
    public void requestConfirmation(InteractionConfirmationListener interactionConfirmationListener) {
        interactionConfirmationListener.success(this.mAccessory, InteractionResult.YES);
    }

    @Override
    public void requestApplicationSelection(List<ApplicationInformation> applications, String[] text, InteractionApplicationSelectionListener listener) {
        String cfr_ignored_0 = "requesting application selection: applications=" + applications + " text=" + Arrays.toString(text);
        this.mInteractionApplicationSelectionListener = listener;
        this.mAvailableApplications = applications;
        DefaultApplicationSelectionTransactionActionSupport defaultApplicationSelectionTransactionActionSupport = new DefaultApplicationSelectionTransactionActionSupport(applications, text);
        this.mAccessory.getWorkflowInteraction().requestAction(TransactionAction.APPLICATION_SELECTION, defaultApplicationSelectionTransactionActionSupport);
    }

    @Override
    public void requestAccountSelection(InteractionCheckingSavingsSelectionListener listener) {
        this.mInteractionCheckingSavingsSelectionListener = listener;
        this.mAccessory.getWorkflowInteraction().requestAction(TransactionAction.ACCOUNT_SELECTION, null);
    }

    @Override
    public void requestLanguageSelection(List<Locale> supportedLanguages, LanguageSelectionListener listener) {
        this.languageSelectionListener = listener;
        DefaultLanguageSelectionTransactionActionSupport defaultLanguageSelectionTransactionActionSupport = new DefaultLanguageSelectionTransactionActionSupport(supportedLanguages);
        this.mAccessory.getWorkflowInteraction().requestAction(TransactionAction.LANGUAGE_SELECTION, defaultLanguageSelectionTransactionActionSupport);
    }

    @Override
    public void requestCreditDebitSelection(InteractionCreditDebitSelectionListener listener) {
        this.mInteractionCreditDebitSelectionListener = listener;
        this.mAccessory.getWorkflowInteraction().requestAction(TransactionAction.CREDIT_DEBIT_SELECTION, null);
    }

    @Override
    public void requestDccSelection(BaseTransaction transaction, DccSelectionRequestListener listener) {
        this.mDccSelectionListener = listener;
        this.transaction = transaction;
        DefaultDccSelectionTransactionActionSupport defaultDccSelectionTransactionActionSupport = new DefaultDccSelectionTransactionActionSupport(transaction);
        this.mAccessory.getWorkflowInteraction().requestAction(TransactionAction.DCC_SELECTION, defaultDccSelectionTransactionActionSupport);
    }

    @Override
    public void continueWithAction(TransactionAction action, TransactionActionResponse response) {
        switch (action) {
            case APPLICATION_SELECTION: {
                TransactionActionApplicationSelectionResponse transactionActionApplicationSelectionResponse = (TransactionActionApplicationSelectionResponse)response;
                String cfr_ignored_0 = "Having a selected application=" + transactionActionApplicationSelectionResponse.getApplicationInformation();
                this.returnApplicationSelectionResponseSuccess(transactionActionApplicationSelectionResponse);
                break;
            }
            case CREDIT_DEBIT_SELECTION: {
                TransactionActionCreditDebitSelectionResponse transactionActionCreditDebitSelectionResponse = (TransactionActionCreditDebitSelectionResponse)response;
                String cfr_ignored_1 = "Having a selected account=" + transactionActionCreditDebitSelectionResponse.getType();
                this.returnCreditDebitSelectionResponseSuccess(transactionActionCreditDebitSelectionResponse);
                break;
            }
            case DCC_SELECTION: {
                TransactionActionDccSelectionResponse transactionActionDccSelectionResponse = (TransactionActionDccSelectionResponse)response;
                String cfr_ignored_2 = "Having a selected dcc=" + transactionActionDccSelectionResponse.getSelected();
                this.returnDccSelectionResponseSuccess(transactionActionDccSelectionResponse);
                break;
            }
            case ACCOUNT_SELECTION: {
                TransactionActionInteracAccountSelectionResponse transactionActionInteracAccountSelectionResponse = (TransactionActionInteracAccountSelectionResponse)response;
                String cfr_ignored_3 = "Having a selected interac account=" + transactionActionInteracAccountSelectionResponse.getSelectedInteracAccountType();
                this.returnInteracAccountSelectionResponseSuccess(transactionActionInteracAccountSelectionResponse);
                break;
            }
            case LANGUAGE_SELECTION: {
                TransactionActionLanguageSelectionResponse transactionActionLanguageSelectionResponse = (TransactionActionLanguageSelectionResponse)response;
                String cfr_ignored_4 = "Having a selected language=" + transactionActionLanguageSelectionResponse.getSelectedLocale();
                this.returnLanguageSelectionSuccess(transactionActionLanguageSelectionResponse);
                break;
            }
            default: {
                super.continueWithAction(action, response);
            }
        }
    }

    private void returnApplicationSelectionResponseSuccess(TransactionActionApplicationSelectionResponse applicationSelectionResponse) {
        if (this.mInteractionApplicationSelectionListener != null) {
            this.mInteractionApplicationSelectionListener.success(this.mAccessory, this.mAvailableApplications, applicationSelectionResponse.getApplicationInformation());
        }
    }

    private void returnCreditDebitSelectionResponseSuccess(TransactionActionCreditDebitSelectionResponse creditDebitSelectionResponse) {
        if (this.mInteractionCreditDebitSelectionListener != null) {
            this.mInteractionCreditDebitSelectionListener.success(this.mAccessory, creditDebitSelectionResponse.getType());
        }
    }

    private void returnDccSelectionResponseSuccess(TransactionActionDccSelectionResponse dccSelectionResponse) {
        if (this.mDccSelectionListener != null) {
            switch (dccSelectionResponse.getSelected()) {
                case ORIGINAL: {
                    this.mDccSelectionListener.originalSelected(this.transaction);
                    break;
                }
                case CONVERTED: {
                    this.mDccSelectionListener.convertedSelected(this.transaction);
                }
            }
        }
    }

    private void returnInteracAccountSelectionResponseSuccess(TransactionActionInteracAccountSelectionResponse accountSelectionResponse) {
        if (this.mInteractionCheckingSavingsSelectionListener != null) {
            this.mInteractionCheckingSavingsSelectionListener.success(accountSelectionResponse.getSelectedInteracAccountType());
        }
    }

    private void returnLanguageSelectionSuccess(TransactionActionLanguageSelectionResponse languageSwitchResponse) {
        if (this.languageSelectionListener != null) {
            this.languageSelectionListener.onOperationSuccess(this.mAccessory, languageSwitchResponse.getSelectedLocale());
        }
    }
}

