/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.cache;

import io.mpos.shared.cache.Cache;
import java.util.HashMap;
import java.util.Map;

public class MemoryCache<K, V>
implements Cache<K, V> {
    private static final String TAG = "Cache";
    long mExpiry;
    Map<K, CacheEntry> mData = new HashMap<K, CacheEntry>();

    public MemoryCache(long expiry) {
        this.mExpiry = expiry;
    }

    @Override
    public V get(K k2) {
        if (!this.mData.containsKey(k2)) {
            return null;
        }
        CacheEntry cacheEntry = this.mData.get(k2);
        if (System.currentTimeMillis() > cacheEntry.timestamp) {
            this.mData.remove(k2);
            return null;
        }
        return cacheEntry.v;
    }

    @Override
    public void put(K k2, V v2) {
        if (this.mData.containsKey(k2)) {
            this.mData.remove(k2);
        }
        String cfr_ignored_0 = "put=" + k2 + " expires=" + (System.currentTimeMillis() + this.mExpiry);
        CacheEntry cacheEntry = new CacheEntry(System.currentTimeMillis() + this.mExpiry, v2);
        this.mData.put(k2, cacheEntry);
    }

    @Override
    public void clear(K k2) {
        this.mData.remove(k2);
    }

    @Override
    public void invalidate() {
        this.mData.clear();
    }

    @Override
    public int size() {
        return this.mData.size();
    }

    class CacheEntry {
        long timestamp;
        V v;

        CacheEntry(long timestamp, V v2) {
            this.timestamp = timestamp;
            this.v = v2;
        }
    }
}

