/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.helper;

import io.mpos.core.common.obfuscated.gJ;
import io.mpos.shared.localization.LocalizationPromptParameters;
import io.mpos.shared.localization.LocalizationServer;
import io.mpos.transactions.TransactionStatusDetailsCodes;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.TransactionVerificationResults;
import io.mpos.transactions.TransactionWorkflowType;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class IntegratorInformationHelper {
    public String getInformation(TransactionStatusDetailsCodes detailsCode, Locale locale, TransactionType transactionType, TransactionWorkflowType workflow, TransactionVerificationResults verificationResults) {
        if (detailsCode == null) {
            return null;
        }
        if (detailsCode == TransactionStatusDetailsCodes.DECLINED_VERIFICATION_FAILED) {
            return this.getInformationFromVerificationResults(detailsCode, locale, transactionType, workflow, verificationResults);
        }
        return this.getInformationFromStatusDetailsCodes(detailsCode, locale);
    }

    private String getInformationFromStatusDetailsCodes(TransactionStatusDetailsCodes detailsCode, Locale locale) {
        String[] stringArray = LocalizationServer.getInstance().getCenteredLocalizationArray(LocalizationPromptParameters.create(detailsCode.name()).locale(locale).build());
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0].trim();
        }
        return null;
    }

    private String getInformationFromVerificationResults(TransactionStatusDetailsCodes detailsCode, Locale locale, TransactionType transactionType, TransactionWorkflowType workflow, TransactionVerificationResults verificationResults) {
        gJ gJ2 = new gJ(null, -1, locale, transactionType, workflow, detailsCode);
        List<String> list = Arrays.asList(gJ2.b(verificationResults));
        return String.join((CharSequence)",", list.subList(1, list.size()));
    }
}

