/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.helper;

import io.mpos.shared.helper.EmvHelper;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.PaymentDetailsCustomerVerificationDetailed;
import io.mpos.shared.paymentdetails.PaymentDetailsIccWrapper;
import io.mpos.shared.transactions.BaseTransaction;
import java.util.Arrays;

public class PaymentDetailsCustomerVerificationHelper {
    public static PaymentDetailsCustomerVerificationDetailed getCustomerVerificationDetailed(BaseTransaction transaction) {
        if (transaction == null || transaction.getPaymentDetails() == null) {
            throw new IllegalArgumentException("transaction/paymentDetails cannot be null");
        }
        switch (transaction.getPaymentDetails().getCustomerVerification()) {
            case NONE: {
                return PaymentDetailsCustomerVerificationDetailed.NONE;
            }
            case SIGNATURE: {
                return PaymentDetailsCustomerVerificationDetailed.SIGNATURE;
            }
            case CUSTOMER_DEVICE: {
                return PaymentDetailsCustomerVerificationDetailed.CUSTOMER_DEVICE;
            }
            case PIN: 
            case PIN_AND_SIGNATURE: {
                PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper(transaction.getPaymentDetails());
                if (paymentDetailsIccWrapper.getDataArqc() != null) {
                    return EmvHelper.getCustomerVerificationDetailedFromArqc(Arrays.asList(paymentDetailsIccWrapper.getDataArqc()));
                }
                return ((DefaultPaymentDetails)transaction.getPaymentDetails()).getCustomerVerificationDetailed();
            }
        }
        return PaymentDetailsCustomerVerificationDetailed.UNKNOWN;
    }
}

