/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.hexstring;

import io.mpos.logger.LoggerKt;
import io.mpos.shared.hexstring.ByteArrayTransformExtensionsKt;
import io.mpos.shared.hexstring.HexStringKt;
import io.mpos.shared.hexstring.PaddingStyle;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010(\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u000b\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000223B\u001b\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0096\u0002J\u000e\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000bJ\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u00162\u0006\u0010\u0017\u001a\u00020\u000bJ\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u00162\u0006\u0010\u0019\u001a\u00020\u000bJ\u001c\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u0000J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\u0006\u0010\u001d\u001a\u00020\u0004J\"\u0010\u001e\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u001f\u001a\u00020\u00022\b\b\u0002\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000bJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u000bJ\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020\u000bH\u0016J\u0006\u0010+\u001a\u00020'J\u0011\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0000J\u000e\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u00064"}, d2={"Lio/mpos/shared/hexstring/HexString;", "", "", "str", "", "orig", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "iterator", "", "length", "", "getLength", "()I", "get", "index", "substring", "range", "Lkotlin/ranges/IntRange;", "substringFrom", "substringUpTo", "splitFromStart", "Lkotlin/Pair;", "leftSideLength", "splitFromEnd", "rightSideLength", "splitOnFirst", "delimiter", "toString", "toPrettyString", "stringAdjustedToLength", "padByte", "paddingStyle", "Lio/mpos/shared/hexstring/PaddingStyle;", "validate", "minLength", "maxLength", "exactLength", "equals", "", "other", "", "hashCode", "isEmpty", "plus", "right", "trimEnd", "suffix", "startsWith", "prefix", "Companion", "ByteIterator", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nHexString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HexString.kt\nio/mpos/shared/hexstring/HexString\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,205:1\n1118#2,3:206\n*S KotlinDebug\n*F\n+ 1 HexString.kt\nio/mpos/shared/hexstring/HexString\n*L\n139#1:206,3\n*E\n"})
public final class HexString
implements Iterable<Byte>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String str;
    @NotNull
    private final String orig;
    private final int length;
    @NotNull
    private static final Regex regexNormalize = new Regex("^0X| ");
    @NotNull
    private static final HexString empty = HexStringKt.hex("");

    private HexString(String str, String orig) {
        this.str = str;
        this.orig = orig;
        this.length = this.str.length() / 2;
    }

    /* synthetic */ HexString(String string, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = string;
        }
        this(string, string2);
    }

    @Override
    @NotNull
    public Iterator<Byte> iterator() {
        return new ByteIterator();
    }

    public final int getLength() {
        return this.length;
    }

    public final byte get(int index) {
        int n2 = index * 2;
        int n3 = StringsKt.indexOf$default((CharSequence)"0123456789ABCDEF", (char)this.str.charAt(n2), (int)0, (boolean)false, (int)6, null);
        int n4 = StringsKt.indexOf$default((CharSequence)"0123456789ABCDEF", (char)this.str.charAt(n2 + 1), (int)0, (boolean)false, (int)6, null);
        int n5 = n3 << 4 | n4;
        return (byte)n5;
    }

    @NotNull
    public final HexString substring(@NotNull IntRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"");
        int n2 = range.getFirst() * 2;
        int n3 = (range.getLast() + 1) * 2;
        String string = this.str.substring(n2, n3);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return new HexString(string, null, 2, null);
    }

    @NotNull
    public final HexString substringFrom(int index) {
        return this.substring(RangesKt.until((int)index, (int)this.length));
    }

    @NotNull
    public final HexString substringUpTo(int index) {
        return this.substring(RangesKt.until((int)0, (int)index));
    }

    @NotNull
    public final Pair<HexString, HexString> splitFromStart(int leftSideLength) {
        return new Pair((Object)this.substringUpTo(leftSideLength), (Object)this.substringFrom(leftSideLength));
    }

    @NotNull
    public final Pair<HexString, HexString> splitFromEnd(int rightSideLength) {
        return this.splitFromStart(this.length - rightSideLength);
    }

    @Nullable
    public final Pair<HexString, HexString> splitOnFirst(@NotNull HexString delimiter) {
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"");
        int n2 = ((CharSequence)this.str).length() + -1;
        int n3 = 0;
        int n4 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n2, (int)2);
        if (n3 <= n4) {
            while (true) {
                if (StringsKt.startsWith$default((String)this.str, (String)delimiter.str, (int)n3, (boolean)false, (int)4, null)) {
                    String string = this.str.substring(0, n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                    HexString hexString = new HexString(string, null, 2, null);
                    String string2 = this.str.substring(n3 + delimiter.str.length());
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
                    HexString hexString2 = new HexString(string2, null, 2, null);
                    return new Pair((Object)hexString, (Object)hexString2);
                }
                if (n3 == n4) break;
                n3 += 2;
            }
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.str;
    }

    @NotNull
    public final String toPrettyString() {
        return this.orig;
    }

    @NotNull
    public final HexString stringAdjustedToLength(int length, byte padByte, @NotNull PaddingStyle paddingStyle) {
        Intrinsics.checkNotNullParameter((Object)((Object)paddingStyle), (String)"");
        return this.length > length ? HexStringKt.cutPadding(this, length, paddingStyle) : (this.length < length ? HexStringKt.pad(this, length, padByte, paddingStyle) : this);
    }

    public static /* synthetic */ HexString stringAdjustedToLength$default(HexString hexString, int n2, byte by2, PaddingStyle paddingStyle, int n3, Object object) {
        if ((n3 & 2) != 0) {
            by2 = 0;
        }
        if ((n3 & 4) != 0) {
            paddingStyle = PaddingStyle.Front;
        }
        return hexString.stringAdjustedToLength(n2, by2, paddingStyle);
    }

    @NotNull
    public final HexString validate(int minLength, int maxLength) {
        HexString hexString;
        int n2 = this.length;
        if (minLength > maxLength) {
            LoggerKt.logWarn$default("HexString", "minLength is larger than maxLength: " + minLength + " > " + maxLength, null, 4, null);
        }
        if (n2 < minLength) {
            LoggerKt.logWarn$default("HexString", "Length is below minLength and will be padded: " + n2 + " < " + minLength + ", original: " + this.str, null, 4, null);
            hexString = HexString.stringAdjustedToLength$default(this, minLength, (byte)0, null, 6, null);
        } else if (n2 > maxLength) {
            LoggerKt.logWarn$default("HexString", "Length exceeds maxLength and will be cut: " + n2 + " > " + maxLength + ", original: " + this.str, null, 4, null);
            hexString = HexString.stringAdjustedToLength$default(this, maxLength, (byte)0, null, 6, null);
        } else {
            hexString = this;
        }
        return hexString;
    }

    @NotNull
    public final HexString validate(int exactLength) {
        if (this.length != exactLength) {
            LoggerKt.logWarn$default("HexString", "Length does not match the required length: " + this.length + " != " + exactLength + ", original: " + this.str, null, 4, null);
        }
        return HexString.stringAdjustedToLength$default(this, exactLength, (byte)0, null, 6, null);
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (other instanceof HexString ? Intrinsics.areEqual((Object)this.str, (Object)((HexString)other).str) : false);
    }

    public int hashCode() {
        int n2;
        CharSequence charSequence = this.str;
        int n3 = n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2;
            char c3 = c2 = charSequence.charAt(i2);
            int n4 = n3;
            n3 = n4 * 31 + c3;
        }
        return n3;
    }

    public final boolean isEmpty() {
        return ((CharSequence)this.str).length() == 0;
    }

    @NotNull
    public final HexString plus(@NotNull HexString right) {
        Intrinsics.checkNotNullParameter((Object)right, (String)"");
        return new HexString(this.str + right.str, null, 2, null);
    }

    @NotNull
    public final HexString trimEnd(@NotNull HexString suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"");
        if (suffix.isEmpty()) {
            return this;
        }
        String string = this.str;
        String string2 = suffix.str;
        while (StringsKt.endsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) {
            string = StringsKt.removeSuffix((String)string, (CharSequence)string2);
        }
        return HexStringKt.hex(string);
    }

    public final boolean startsWith(@NotNull HexString prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"");
        return StringsKt.startsWith$default((String)this.str, (String)prefix.str, (boolean)false, (int)2, null);
    }

    public /* synthetic */ HexString(String str, String orig, DefaultConstructorMarker $constructor_marker) {
        this(str, orig);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\u000e\u0010\r\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lio/mpos/shared/hexstring/HexString$ByteIterator;", "", "", "<init>", "(Lio/mpos/shared/hexstring/HexString;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "hasNext", "", "next", "()Ljava/lang/Byte;", "mpos.core"})
    private final class ByteIterator
    implements Iterator<Byte>,
    KMappedMarker {
        private int index;

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n2) {
            this.index = n2;
        }

        @Override
        public boolean hasNext() {
            return this.index < HexString.this.getLength();
        }

        @Override
        @NotNull
        public Byte next() {
            int n2 = this.index;
            this.index = n2 + 1;
            return HexString.this.get(n2);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lio/mpos/shared/hexstring/HexString$Companion;", "", "<init>", "()V", "regexNormalize", "Lkotlin/text/Regex;", "empty", "Lio/mpos/shared/hexstring/HexString;", "getEmpty", "()Lio/mpos/shared/hexstring/HexString;", "create", "string", "", "fromAscii", "normalizedString", "mpos.core"})
    @SourceDebugExtension(value={"SMAP\nHexString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HexString.kt\nio/mpos/shared/hexstring/HexString$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,205:1\n1088#2,2:206\n*S KotlinDebug\n*F\n+ 1 HexString.kt\nio/mpos/shared/hexstring/HexString$Companion\n*L\n45#1:206,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HexString getEmpty() {
            return empty;
        }

        @Nullable
        public final HexString create(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            String string2 = this.normalizedString(string);
            return string2 != null ? new HexString(string2, string, null) : null;
        }

        @NotNull
        public final HexString fromAscii(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"");
            return ByteArrayTransformExtensionsKt.toHexString(StringsKt.encodeToByteArray((String)string));
        }

        private final String normalizedString(String string) {
            boolean bl2;
            String string2;
            block3: {
                String string3 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"");
                CharSequence charSequence = string3;
                Regex regex = regexNormalize;
                String string4 = "";
                string2 = regex.replace(charSequence, string4);
                charSequence = string2;
                for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                    char c2;
                    char c3 = c2 = charSequence.charAt(i2);
                    if (!(!HexStringKt.getHEX_CHARS_SET().contains(Character.valueOf(c3)))) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
            if (bl2) {
                LoggerKt.logError$default("HexString", "Can't create HexString (Contains invalid characters) '" + string + "'", null, 4, null);
                return null;
            }
            if (string2.length() % 2 != 0) {
                LoggerKt.logError$default("HexString", "Can't create HexString (Length is odd) '" + string + "'", null, 4, null);
                return null;
            }
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

