/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.hexstring;

import io.mpos.shared.hexstring.ByteArrayTransformExtensionsKt;
import io.mpos.shared.hexstring.HexString;
import java.nio.charset.CharacterCodingException;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0001\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\b*\u00020\u0001\u00a8\u0006\f"}, d2={"toHexString", "Lio/mpos/shared/hexstring/HexString;", "", "toBytes", "", "", "toAsciiString", "toBCDInt", "", "toBCDLong", "", "toInt", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nHexStringTransformExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HexStringTransformExtensions.kt\nio/mpos/shared/hexstring/HexStringTransformExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,29:1\n1803#2,3:30\n*S KotlinDebug\n*F\n+ 1 HexStringTransformExtensions.kt\nio/mpos/shared/hexstring/HexStringTransformExtensionsKt\n*L\n17#1:30,3\n*E\n"})
public final class HexStringTransformExtensionsKt {
    @Nullable
    public static final HexString toHexString(@NotNull String $this$toHexString) {
        Intrinsics.checkNotNullParameter((Object)$this$toHexString, (String)"");
        return HexString.Companion.create($this$toHexString);
    }

    @NotNull
    public static final byte[] toBytes(@NotNull HexString $this$toBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$toBytes, (String)"");
        byte[] byArray = new byte[$this$toBytes.getLength()];
        int n2 = $this$toBytes.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = $this$toBytes.get(i2);
        }
        return byArray;
    }

    @NotNull
    public static final byte[] toBytes(@NotNull Iterable<HexString> $this$toBytes) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter($this$toBytes, (String)"");
        Iterable<HexString> iterable = $this$toBytes;
        byte[] byArray2 = byArray = new byte[0];
        Iterator<HexString> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            HexString hexString;
            HexString hexString2 = hexString = iterator.next();
            byte[] byArray3 = byArray2;
            byArray2 = ArraysKt.plus((byte[])byArray3, (byte[])HexStringTransformExtensionsKt.toBytes(hexString2));
        }
        return byArray2;
    }

    @NotNull
    public static final String toAsciiString(@NotNull HexString $this$toAsciiString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toAsciiString, (String)"");
        try {
            string = StringsKt.decodeToString$default((byte[])HexStringTransformExtensionsKt.toBytes($this$toAsciiString), (int)0, (int)0, (boolean)true, (int)3, null);
        }
        catch (CharacterCodingException characterCodingException) {
            String cfr_ignored_0 = "Failed to format input '" + $this$toAsciiString.toPrettyString() + "' to ASCII: " + characterCodingException;
            string = "<failed to format HexString as ASCII>";
        }
        return string;
    }

    public static final int toBCDInt(@NotNull HexString $this$toBCDInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toBCDInt, (String)"");
        return ByteArrayTransformExtensionsKt.toBCDInt(HexStringTransformExtensionsKt.toBytes($this$toBCDInt));
    }

    public static final long toBCDLong(@NotNull HexString $this$toBCDLong) {
        Intrinsics.checkNotNullParameter((Object)$this$toBCDLong, (String)"");
        return ByteArrayTransformExtensionsKt.toBCDLong(HexStringTransformExtensionsKt.toBytes($this$toBCDLong));
    }

    public static final int toInt(@NotNull HexString $this$toInt) {
        Intrinsics.checkNotNullParameter((Object)$this$toInt, (String)"");
        return ByteArrayTransformExtensionsKt.toInt(HexStringTransformExtensionsKt.toBytes($this$toInt));
    }
}

