/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.localization;

import io.mpos.logger.Log;
import io.mpos.shared.helper.AssetsHandler;
import io.mpos.shared.localization.LocalizationPromptParameters;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalizationServer {
    private static final String TAG = "I18n";
    private static final String KEY_SEPARATOR = ";";
    private static final String[] LOCALIZATION_FILES_PREFIXES = new String[]{"prompts", "reasons"};
    private static final LocalizationServer INSTANCE = new LocalizationServer();
    public static final Locale FALLBACK_DEFAULT = Locale.US;
    public static List<Locale> supportedLocales = Arrays.asList(Locale.US, Locale.UK, Locale.GERMANY, Locale.FRANCE, Locale.CANADA_FRENCH, Locale.ITALY, new Locale("nl", "BE"), new Locale("pt", "PT"), new Locale("es", "ES"), new Locale("fi", "FI"), new Locale("pl", "PL"), new Locale("sv", "SE"), new Locale("cs", "CZ"), new Locale("da", "DK"), new Locale("hu", "HU"), new Locale("lt", "LT"), new Locale("lv", "LV"), new Locale("nb", "NO"), Locale.CHINA, new Locale("zh", "HK"), new Locale("ar", "AR"));
    public static List<Locale> localesForInteracLanguageSelectionScreen = Arrays.asList(Locale.US, Locale.CANADA_FRENCH);
    public static final int DEFAULT_SYSTEM_DISPLAY_SIZE = 40;
    private static final int[][] DISPLAY_SIZES = new int[][]{{40, 2}, {20, 4}};
    private static final String DEFAULT_DISPLAY_SIZE = "20x4";
    private final Map<String, Map<String, String[]>> cache = new HashMap<String, Map<String, String[]>>();

    private LocalizationServer() {
    }

    public static LocalizationServer getInstance() {
        return INSTANCE;
    }

    private String[] getLocalization(LocalizationPromptParameters complexPrompt) {
        String[] stringArray;
        if (complexPrompt == null || complexPrompt.getMainPrompt() == null || complexPrompt.getMainPrompt().equals("")) {
            return null;
        }
        int n2 = complexPrompt.getLineWidth();
        Locale locale = complexPrompt.getLocale();
        String string = this.buildKey(locale, n2);
        if (!this.dictionaryLoaded(string)) {
            this.internalLoadIntoCache(string);
        }
        if ((stringArray = this.internalLoadFromCache(string, complexPrompt)) != null) {
            return stringArray;
        }
        Log.w(TAG, "Could not load localization for prompt=" + complexPrompt + ", key=" + string + ", locale=" + locale + ", lineWidth=" + n2);
        return null;
    }

    private String[] internalLoadFromCache(String key, LocalizationPromptParameters promptParameters) {
        List<String> list = LocalizationPromptParameters.getPrioritizedFullPrompts(promptParameters.getMainPrompt(), promptParameters.getTransactionType(), promptParameters.getWorkflowType());
        for (String string : list) {
            String[] stringArray = this.internalLoadFromCache(key, string);
            if (stringArray == null) continue;
            return stringArray;
        }
        return null;
    }

    private boolean dictionaryLoaded(String key) {
        return this.cache.containsKey(key);
    }

    public String[] getCenteredLocalizationArray(LocalizationPromptParameters prompt) {
        return this.getLocalizationArrayWithReplacedVariables(prompt, true);
    }

    @Nullable
    public String[] getLocalizationArray(LocalizationPromptParameters prompt) {
        return this.getLocalizationArrayWithReplacedVariables(prompt, false);
    }

    private String[] getLocalizationArrayWithReplacedVariables(LocalizationPromptParameters prompt, boolean center) {
        String[] stringArray = this.getLocalization(prompt);
        if (stringArray == null) {
            return null;
        }
        this.replaceVariable(prompt.getArguments(), stringArray);
        if (center) {
            return LocalizationServer.centerArrayLines(stringArray, prompt.getLineWidth());
        }
        return stringArray;
    }

    private void replaceVariable(String[] arguments, String[] lines) {
        if (arguments != null) {
            block0: for (String string : arguments) {
                for (int i2 = 0; i2 < lines.length; ++i2) {
                    String string2 = lines[i2];
                    if (!string2.contains("$")) continue;
                    lines[i2] = this.replaceVariableFromLineWith(string2, string == null ? "" : Matcher.quoteReplacement(string));
                    continue block0;
                }
            }
        }
    }

    private String replaceVariableFromLineWith(String line, String replacement) {
        return line.replaceAll("\\$.*\\$", replacement);
    }

    public String[] getLocalizationError(LocalizationPromptParameters complexPrompt) {
        Locale locale = LocalizationServer.checkAndAssignLocaleWithFallbackToLanguage(complexPrompt.getLocale());
        String string = complexPrompt.getLineWidth() + "x1;" + locale.toString();
        if (!this.cache.containsKey(string)) {
            this.cache.put(string, new HashMap());
            String string2 = this.generateFilePath("errors", complexPrompt.getLineWidth() + "x1", locale.toString(), "errors");
            this.readAssetIntoCache(string, string2);
        }
        return this.internalLoadFromCache(string, complexPrompt);
    }

    public String[] getCenteredLocalizationError(LocalizationPromptParameters complexPrompt) {
        String[] stringArray = this.getLocalizationError(complexPrompt);
        if (stringArray != null) {
            return LocalizationServer.centerArrayLines(stringArray, complexPrompt.getLineWidth());
        }
        return null;
    }

    public static String[] centerArrayLines(String[] lines, int lineWidth) {
        if (lineWidth <= 0) {
            return lines;
        }
        String[] stringArray = new String[lines.length];
        for (int i2 = 0; i2 < lines.length; ++i2) {
            stringArray[i2] = LocalizationServer.center(lines[i2], lineWidth);
        }
        return stringArray;
    }

    public static String center(String text, int len) {
        String string = String.format("%" + len + "s%s%" + len + "s", "", text, "");
        float f2 = (float)string.length() / 2.0f;
        float f3 = f2 - (float)len / 2.0f;
        float f4 = f3 + (float)len;
        return string.substring((int)f3, (int)f4);
    }

    private String[] internalLoadFromCache(String key, String prompt) {
        Map<String, String[]> map = this.cache.get(key);
        if (map == null) {
            return null;
        }
        String[] stringArray = map.get(prompt);
        return stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length);
    }

    private String buildKey(Locale locale, int lineWidth) {
        Locale locale2 = LocalizationServer.checkAndAssignLocaleWithFallbackToLanguage(locale);
        return this.displaySizeForAccessory(lineWidth) + KEY_SEPARATOR + locale2.toString();
    }

    public void clearCache() {
        this.cache.clear();
    }

    private void internalLoadIntoCache(String key) {
        this.cache.put(key, new HashMap());
        String string = key.split(KEY_SEPARATOR)[0];
        String string2 = key.split(KEY_SEPARATOR)[1];
        for (String string3 : LOCALIZATION_FILES_PREFIXES) {
            String string4 = this.generateFilePath("displays", string, string2, string3);
            this.readAssetIntoCache(key, string4);
        }
    }

    private String generateFilePath(String root, String displaySize, String locale, String prefix) {
        return "io.payworks.mpos.l10n/" + root + "/" + displaySize + "/" + prefix + "-" + displaySize + "-" + locale + ".json";
    }

    private void readAssetIntoCache(String key, String asset) {
        String string = AssetsHandler.getInstance().readAssetIntoString(asset);
        try {
            JsonObject jsonObject = (JsonObject)Json.Default.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), string);
            JsonObject jsonObject2 = (JsonObject)jsonObject.get("localization");
            Set set = jsonObject2.getKeys();
            for (String string2 : set) {
                JsonArray jsonArray = (JsonArray)jsonObject2.get(string2);
                String[] stringArray = new String[jsonArray.getSize()];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringArray[i2] = ((JsonPrimitive)jsonArray.get(i2)).getContent();
                }
                this.cache.get(key).put(string2, stringArray);
            }
        }
        catch (Exception exception) {
            Log.e(TAG, "Can't read asset=" + asset, exception);
        }
    }

    private String displaySizeForAccessory(int lineWidth) {
        if (lineWidth == -1) {
            return "vipa";
        }
        for (int[] nArray : DISPLAY_SIZES) {
            if (lineWidth < nArray[0]) continue;
            return nArray[0] + "x" + nArray[1];
        }
        return DEFAULT_DISPLAY_SIZE;
    }

    @NotNull
    public static Locale checkAndAssignLocaleWithFallbackToLanguage(@Nullable Locale locale) {
        Locale locale2 = LocalizationServer.getSupportedLocale(locale, supportedLocales);
        return locale2 != null ? locale2 : FALLBACK_DEFAULT;
    }

    @Nullable
    public static Locale getSupportedLocale(@Nullable Locale locale, List<Locale> locales) {
        if (locale == null) {
            return null;
        }
        for (Locale locale2 : locales) {
            if (!locale2.equals(locale)) continue;
            return locale2;
        }
        for (Locale locale2 : locales) {
            if (!locale2.getLanguage().equals(locale.getLanguage()) || !locale2.getCountry().equals(locale.getCountry())) continue;
            return locale2;
        }
        for (Locale locale2 : locales) {
            if (!locale2.getLanguage().equals(locale.getLanguage())) continue;
            return locale2;
        }
        return null;
    }

    public static String getInApiFormat(Locale locale) {
        String string = locale.getCountry();
        if (string.length() > 0) {
            return locale.getLanguage() + "-" + string;
        }
        return locale.getLanguage();
    }
}

