/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.mock;

import bolts.Task;
import io.mpos.accessories.AccessoryConnectionState;
import io.mpos.accessories.parameters.AccessoryParameters;
import io.mpos.errors.ErrorType;
import io.mpos.mock.Breakpoint;
import io.mpos.mock.MockConfiguration;
import io.mpos.mock.MockDelay;
import io.mpos.shared.communicationmodules.CommunicationDelegate;
import io.mpos.shared.communicationmodules.CommunicationModule;
import io.mpos.shared.communicationmodules.SuccessFailureListener;
import io.mpos.shared.errors.DefaultMposError;

public class MockCommunicationModule
extends CommunicationModule {
    private final MockConfiguration mockConfiguration;
    private final MockDelay mockDelay;

    public MockCommunicationModule(MockConfiguration mockConfiguration, AccessoryParameters accessoryParameters, MockDelay mockDelay) {
        super(accessoryParameters);
        this.mockConfiguration = mockConfiguration;
        this.mockDelay = mockDelay;
    }

    @Override
    public void sendData(byte[] data) {
    }

    @Override
    public void connect(CommunicationDelegate miuraPaymentAccessory, SuccessFailureListener listener) {
        Task.callInBackground(() -> {
            this.mockDelay.waitDelayShort(Breakpoint.CONNECT);
            MockConfiguration.AccessoryConnectionBehavior accessoryConnectionBehavior = this.mockConfiguration.getAccessoryConnectionBehavior();
            switch (accessoryConnectionBehavior) {
                case SUCCESS: {
                    this.setConnectionState(AccessoryConnectionState.CONNECTED);
                    listener.onSuccess(null);
                    break;
                }
                case BUSY: {
                    this.setConnectionState(AccessoryConnectionState.DISCONNECTED);
                    listener.onFailure(new DefaultMposError(ErrorType.ACCESSORY_BUSY, "Mock AccessortConnectionBehaviour.BUSY"));
                    break;
                }
                case NOT_FOUND: {
                    this.setConnectionState(AccessoryConnectionState.DISCONNECTED);
                    listener.onFailure(new DefaultMposError(ErrorType.ACCESSORY_NOT_FOUND, "Mock AccessortConnectionBehaviour.NOT_FOUND"));
                }
            }
            return null;
        });
    }

    @Override
    public void disconnect(SuccessFailureListener listener) {
        Task.callInBackground(() -> {
            this.mockDelay.waitDelayShort(Breakpoint.DISCONNECT);
            this.setConnectionState(AccessoryConnectionState.DISCONNECTED);
            listener.onSuccess(null);
            return null;
        });
    }
}

