/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.mock;

import io.mpos.accessories.Accessory;
import io.mpos.accessories.AccessoryBatteryState;
import io.mpos.accessories.AccessoryConnectionState;
import io.mpos.accessories.AccessoryFamily;
import io.mpos.accessories.AccessoryType;
import io.mpos.accessories.AccessoryUpdateRequirementComponent;
import io.mpos.accessories.components.AccessoryComponent;
import io.mpos.accessories.components.AccessoryComponentType;
import io.mpos.accessories.payment.PaymentAccessoryFeatures;
import io.mpos.accessories.payment.listener.PaymentAccessoryDisplayActionListener;
import io.mpos.core.common.obfuscated.B;
import io.mpos.core.common.obfuscated.C;
import io.mpos.core.common.obfuscated.D;
import io.mpos.core.common.obfuscated.E;
import io.mpos.core.common.obfuscated.F;
import io.mpos.core.common.obfuscated.G;
import io.mpos.core.common.obfuscated.H;
import io.mpos.core.common.obfuscated.I;
import io.mpos.core.common.obfuscated.J;
import io.mpos.core.common.obfuscated.K;
import io.mpos.core.common.obfuscated.L;
import io.mpos.core.common.obfuscated.M;
import io.mpos.core.common.obfuscated.N;
import io.mpos.mock.DefaultMockConfiguration;
import io.mpos.mock.MockConfiguration;
import io.mpos.mock.MockDelay;
import io.mpos.shared.accessories.DefaultAccessoryDetails;
import io.mpos.shared.accessories.EncryptionDetails;
import io.mpos.shared.accessories.EncryptionDetailsState;
import io.mpos.shared.accessories.EncryptionKeyInjectionStrategy;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListener;
import io.mpos.shared.accessories.payment.AbstractPaymentAccessory;
import io.mpos.shared.communicationmodules.CommunicationDelegate;
import io.mpos.shared.communicationmodules.CommunicationModule;
import io.mpos.shared.communicationmodules.SuccessFailureListener;
import io.mpos.shared.config.DelayConfig;
import io.mpos.shared.provider.WhitelistAccessory;
import io.mpos.specs.helper.ByteHelper;
import java.util.EnumSet;

public class MockPaymentAccessory
extends AbstractPaymentAccessory
implements CommunicationDelegate {
    private static final String TAG = "MockPaymentAccessory";
    private final B barcodeAccessoryComponent;
    private MockPaymentAccessoryListener mockPaymentAccessoryListener;
    private final MockConfiguration mockConfiguration;
    private final F mockPrinterAccessoryComponent;
    private final G mockTippingAccessoryComponent;
    private final D mockInteractionComponent;
    private final E mockMotoComponent;
    private final C mockCardComponent;

    public MockPaymentAccessory(MockConfiguration mockConfiguration, CommunicationModule communicationModule, MockDelay mockDelay, DelayConfig delayConfig) {
        super(communicationModule);
        this.mockConfiguration = mockConfiguration;
        this.mockPrinterAccessoryComponent = new F(mockConfiguration, mockDelay);
        this.mockTippingAccessoryComponent = new G(mockConfiguration, delayConfig.getMockDelayLong());
        this.mockInteractionComponent = new D(mockConfiguration, mockDelay);
        this.mockMotoComponent = new E(this.mockInteractionComponent);
        this.mockCardComponent = new C(mockConfiguration, mockDelay);
        this.mAccessoryBatteryState = AccessoryBatteryState.CHARGING;
        this.mBatteryLevel = 75;
        this.cardProcessingModule = new H(mockConfiguration, this, mockDelay);
        this.displayModule = new I(this);
        this.interactionModule = new J(mockConfiguration, this);
        this.logModule = new K(this);
        this.securityModule = new L(mockConfiguration, this);
        this.statusModule = new M(this);
        this.systemModule = new N(mockConfiguration, this, mockDelay);
        this.mAccessoryType = AccessoryType.MOCK;
        this.mAccessoryFamily = AccessoryFamily.MOCK;
        this.barcodeAccessoryComponent = new B(mockConfiguration, mockDelay, delayConfig);
        this.mAccessoryDetails = new DefaultAccessoryDetails("999999999", "mock-os", "mock-sw", AccessoryType.MIURA_SHUTTLE.name());
        ((DefaultAccessoryDetails)this.mAccessoryDetails).setAccessoryType(AccessoryType.MOCK);
        this.mPaymentAccessoryFeatures = EnumSet.of(PaymentAccessoryFeatures.MAGNETIC_STRIPE, new PaymentAccessoryFeatures[]{PaymentAccessoryFeatures.ICC, PaymentAccessoryFeatures.EMV_KERNEL, PaymentAccessoryFeatures.SRED_ENCRYPTION, PaymentAccessoryFeatures.PIN_ENCRYPTION, PaymentAccessoryFeatures.KEYPAD, PaymentAccessoryFeatures.DISPLAY, PaymentAccessoryFeatures.ONLINE_TRANSACTIONS, PaymentAccessoryFeatures.OFFLINE_PIN, PaymentAccessoryFeatures.REFUND});
        this.mEncryptionKeyInjectionStrategy = EncryptionKeyInjectionStrategy.KEY_GENERATION;
        this.mCardPresent = mockConfiguration.getPaymentAccessorySource() != MockConfiguration.PaymentAccessorySource.MAGSTRIPE;
        this.mEncryptionDetails = new EncryptionDetails(EncryptionDetailsState.READY, EncryptionDetailsState.READY, EncryptionDetailsState.READY);
    }

    @Override
    public EnumSet<PaymentAccessoryFeatures> getPaymentAccessoryFeatures() {
        EnumSet<PaymentAccessoryFeatures> enumSet = EnumSet.noneOf(PaymentAccessoryFeatures.class);
        if (this.mockConfiguration.getPaymentAccessoryExtraFeatures().contains((Object)MockConfiguration.PaymentAccessoryExtraFeature.NFC)) {
            enumSet.add(PaymentAccessoryFeatures.NFC);
        }
        if (this.mockConfiguration.getPaymentAccessoryExtraFeatures().contains((Object)MockConfiguration.PaymentAccessoryExtraFeature.SCA)) {
            enumSet.add(PaymentAccessoryFeatures.SCA_SECOND_TAP_WITH_FORCE_CVM_LIMIT_TO_ZERO);
        }
        enumSet.addAll(super.getPaymentAccessoryFeatures());
        return enumSet;
    }

    @Override
    public void displayText(String[] text, GenericOperationSuccessFailureListener<Accessory, String[]> listener) {
        if (((DefaultMockConfiguration)this.mockConfiguration).isAccessoryGetsStuckDuringDisplay()) {
            return;
        }
        super.displayText(text, listener);
        if (this.mockPaymentAccessoryListener != null) {
            this.mockPaymentAccessoryListener.onTextDisplayed(text);
        }
    }

    @Override
    public void displayIdleScreen(PaymentAccessoryDisplayActionListener listener) {
        if (((DefaultMockConfiguration)this.mockConfiguration).isAccessoryGetsStuckDuringDisplay()) {
            return;
        }
        super.displayIdleScreen(listener);
        if (this.mockPaymentAccessoryListener != null) {
            this.mockPaymentAccessoryListener.onIdleDisplayed();
        }
    }

    @Override
    public boolean configurationUpdateRequired(WhitelistAccessory whitelistAccessory) {
        if (this.mockConfiguration.getUpdateBehavior() == MockConfiguration.AccessoryUpdateBehavior.UPDATE_AVAILABLE_AND_REQUIRED) {
            return this.mockConfiguration.getUpdateRequirementComponents().contains(AccessoryUpdateRequirementComponent.CONFIGURATION);
        }
        return false;
    }

    @Override
    public boolean softwareUpdateRequired(WhitelistAccessory whitelistAccessory) {
        if (this.mockConfiguration.getUpdateBehavior() == MockConfiguration.AccessoryUpdateBehavior.UPDATE_AVAILABLE_AND_REQUIRED) {
            return this.mockConfiguration.getUpdateRequirementComponents().contains(AccessoryUpdateRequirementComponent.SOFTWARE);
        }
        return false;
    }

    @Override
    public boolean firmwareUpdateRequired(WhitelistAccessory whitelistAccessory) {
        if (this.mockConfiguration.getUpdateBehavior() == MockConfiguration.AccessoryUpdateBehavior.UPDATE_AVAILABLE_AND_REQUIRED) {
            return this.mockConfiguration.getUpdateRequirementComponents().contains(AccessoryUpdateRequirementComponent.FIRMWARE);
        }
        return false;
    }

    @Override
    public void resetModules() {
    }

    @Override
    protected void startConnection(SuccessFailureListener listener) {
        this.mCommunicationModule.connect(this, listener);
    }

    @Override
    protected void endConnection(SuccessFailureListener listener) {
        this.mCommunicationModule.disconnect(listener);
    }

    @Override
    public void onIncomingData(byte[] data) {
        String cfr_ignored_0 = "Got incoming data: " + ByteHelper.toHexString(data);
    }

    @Override
    public void connectionStateChanged(AccessoryConnectionState newState) {
        String cfr_ignored_0 = "Connection state changed: " + newState;
    }

    @Override
    protected void handleQueuedData() {
    }

    @Override
    public EncryptionDetails getEncryptionDetails() {
        if (this.mockConfiguration.getUpdateBehavior() == MockConfiguration.AccessoryUpdateBehavior.UPDATE_AVAILABLE_AND_REQUIRED && this.mockConfiguration.getUpdateRequirementComponents().contains(AccessoryUpdateRequirementComponent.SECURITY)) {
            return new EncryptionDetails(EncryptionDetailsState.NOT_INITIALIZED, EncryptionDetailsState.NOT_INITIALIZED, EncryptionDetailsState.NOT_INITIALIZED);
        }
        return new EncryptionDetails(EncryptionDetailsState.READY, EncryptionDetailsState.READY, EncryptionDetailsState.READY);
    }

    public AccessoryComponent getAccessoryComponent(AccessoryComponentType componentType) {
        EnumSet<AccessoryComponentType> enumSet = this.mockConfiguration.getSupportedAccessoryComponentTypes();
        if (!enumSet.contains(componentType)) {
            return null;
        }
        switch (componentType) {
            case PRINTER: {
                return this.mockPrinterAccessoryComponent;
            }
            case TIPPING: {
                return this.mockTippingAccessoryComponent;
            }
            case INTERACTION: {
                return this.mockInteractionComponent;
            }
            case MOTO: {
                return this.mockMotoComponent;
            }
            case CARD: {
                return this.mockCardComponent;
            }
            case BARCODE_SCANNER: {
                return this.barcodeAccessoryComponent;
            }
        }
        return null;
    }

    public MockPaymentAccessoryListener getMockPaymentAccessoryListener() {
        return this.mockPaymentAccessoryListener;
    }

    public void setMockPaymentAccessoryListener(MockPaymentAccessoryListener mockPaymentAccessoryListener) {
        this.mockPaymentAccessoryListener = mockPaymentAccessoryListener;
    }

    public void addAccessoryFeature(PaymentAccessoryFeatures feature) {
        this.mPaymentAccessoryFeatures.add(feature);
    }

    public static interface MockPaymentAccessoryListener {
        public void onTextDisplayed(String[] var1);

        public void onIdleDisplayed();
    }
}

