/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.offline;

import io.mpos.shared.processors.payworks.services.offline.dto.BackendBatchSubmissionResponseDTO;
import io.mpos.shared.processors.payworks.services.offline.dto.BackendSubmittedTransactionDTO;
import io.mpos.shared.processors.payworks.services.response.DTOConversionHelper;
import io.mpos.shared.processors.payworks.services.response.dto.BackendRefundDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendRefundTransactionDTO;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.RefundDetailsStatusSerializer;
import io.mpos.shared.transactions.DefaultTransactionStatusDetails;
import io.mpos.shared.transactions.offline.DefaultSubmittedRefundDetails;
import io.mpos.shared.transactions.offline.DefaultSubmittedRefundTransaction;
import io.mpos.shared.transactions.offline.DefaultSubmittedTransaction;
import io.mpos.transactions.RefundDetailsStatus;
import io.mpos.transactions.offline.SubmittedRefundDetails;
import io.mpos.transactions.offline.SubmittedRefundTransaction;
import io.mpos.transactions.offline.SubmittedTransaction;
import java.util.ArrayList;
import java.util.List;

public class SubmittedTransactionConverter {
    private final DTOConversionHelper dtoConversionHelper;

    public SubmittedTransactionConverter(DTOConversionHelper dtoConversionHelper) {
        this.dtoConversionHelper = dtoConversionHelper;
    }

    public List<SubmittedTransaction> createSubmittedTransactionsFromDTO(BackendBatchSubmissionResponseDTO dto) {
        ArrayList<SubmittedTransaction> arrayList = new ArrayList<SubmittedTransaction>();
        for (BackendSubmittedTransactionDTO backendSubmittedTransactionDTO : dto.getData().getTransactions()) {
            SubmittedTransaction submittedTransaction = this.createSubmittedTransactionFromDTO(backendSubmittedTransactionDTO);
            arrayList.add(submittedTransaction);
        }
        return arrayList;
    }

    private SubmittedTransaction createSubmittedTransactionFromDTO(BackendSubmittedTransactionDTO dto) {
        DefaultTransactionStatusDetails defaultTransactionStatusDetails = this.dtoConversionHelper.createTransactionStatusDetailsFromDTO(dto.getStatusDetails());
        SubmittedRefundDetails submittedRefundDetails = this.createSubmittedRefundDetailsFromDTO(dto.getRefundDetails());
        return new DefaultSubmittedTransaction(dto.getIdentifier(), defaultTransactionStatusDetails, submittedRefundDetails);
    }

    private SubmittedRefundDetails createSubmittedRefundDetailsFromDTO(BackendRefundDetailsDTO dto) {
        if (dto == null) {
            return null;
        }
        RefundDetailsStatus refundDetailsStatus = (RefundDetailsStatus)RefundDetailsStatusSerializer.getInstance().deserialize(dto.getStatus());
        List<SubmittedRefundTransaction> list = this.createSubmittedRefundTransactionsFromDTO(dto.getRefundTransactions());
        return new DefaultSubmittedRefundDetails(refundDetailsStatus, list);
    }

    private List<SubmittedRefundTransaction> createSubmittedRefundTransactionsFromDTO(List<BackendRefundTransactionDTO> dtos) {
        if (dtos == null || dtos.isEmpty()) {
            return new ArrayList<SubmittedRefundTransaction>();
        }
        ArrayList<SubmittedRefundTransaction> arrayList = new ArrayList<SubmittedRefundTransaction>();
        for (BackendRefundTransactionDTO backendRefundTransactionDTO : dtos) {
            SubmittedRefundTransaction submittedRefundTransaction = this.createSubmittedRefundTransactionFromDTO(backendRefundTransactionDTO);
            arrayList.add(submittedRefundTransaction);
        }
        return arrayList;
    }

    private SubmittedRefundTransaction createSubmittedRefundTransactionFromDTO(BackendRefundTransactionDTO dto) {
        DefaultTransactionStatusDetails defaultTransactionStatusDetails = this.dtoConversionHelper.createTransactionStatusDetailsFromDTO(dto.getStatusDetails());
        return new DefaultSubmittedRefundTransaction(dto.getIdentifier(), defaultTransactionStatusDetails);
    }
}

