/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.paymentdetails;

import io.mpos.accessories.components.interaction.moto.MotoType;
import io.mpos.paymentdetails.PaymentDetails;
import io.mpos.paymentdetails.PaymentDetailsCustomerVerification;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.shared.paymentdetails.BypassedVerificationMethod;
import io.mpos.shared.paymentdetails.PaymentDetailsAlternativePaymentMethodWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsCustomerVerificationDetailed;
import io.mpos.shared.paymentdetails.PaymentDetailsFallbackReason;
import io.mpos.shared.paymentdetails.PaymentDetailsIccWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsMagstripeWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsManualInputWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsSignatureWrapper;
import io.mpos.shared.processors.payworks.services.response.dto.AdditionalCustomerVerification;
import io.mpos.transactions.TransactionWorkflowType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultPaymentDetails
implements PaymentDetails {
    private static Set<String> blacklistedKeys = Collections.singleton("security_code_card_data_payment_details_wrapper");
    private PaymentDetailsScheme scheme;
    private PaymentDetailsSource source;
    private PaymentDetailsCustomerVerificationDetailed customerVerificationDetailed;
    private TransactionWorkflowType workflowType;
    private boolean fallback;
    private PaymentDetailsFallbackReason fallbackReason;
    private Set<BypassedVerificationMethod> bypassedVerificationMethods;
    private boolean manualApplicationSelection;
    private AdditionalCustomerVerification additionalCustomerVerification;
    private MotoType motoType = null;
    private final Map<String, Object> mData = Collections.synchronizedMap(new HashMap());
    private boolean forceZeroCvmLimit;

    public DefaultPaymentDetails() {
        this.scheme = PaymentDetailsScheme.UNKNOWN;
        this.source = PaymentDetailsSource.UNKNOWN;
        this.customerVerificationDetailed = PaymentDetailsCustomerVerificationDetailed.UNKNOWN;
        this.fallbackReason = PaymentDetailsFallbackReason.UNKNOWN;
        this.workflowType = TransactionWorkflowType.UNKNOWN;
        this.bypassedVerificationMethods = new HashSet<BypassedVerificationMethod>();
        this.manualApplicationSelection = false;
        this.additionalCustomerVerification = null;
    }

    DefaultPaymentDetails(PaymentDetailsScheme scheme, PaymentDetailsSource source, PaymentDetailsCustomerVerificationDetailed verification, TransactionWorkflowType workflowType, AdditionalCustomerVerification additionalCustomerVerification) {
        this.scheme = scheme;
        this.source = source;
        this.customerVerificationDetailed = verification;
        this.workflowType = workflowType;
        this.bypassedVerificationMethods = new HashSet<BypassedVerificationMethod>();
        this.manualApplicationSelection = false;
        this.additionalCustomerVerification = additionalCustomerVerification;
    }

    public void mergeWithPaymentDetails(PaymentDetails details) {
        Object object;
        Object object2;
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)details;
        if (defaultPaymentDetails.getSource() != null && this.source == PaymentDetailsSource.UNKNOWN) {
            this.source = defaultPaymentDetails.getSource();
        }
        if (defaultPaymentDetails.getScheme() != null && this.scheme == PaymentDetailsScheme.UNKNOWN) {
            this.scheme = defaultPaymentDetails.getScheme();
        }
        if (defaultPaymentDetails.getWorkflowType() != null) {
            this.workflowType = defaultPaymentDetails.getWorkflowType();
        }
        if (defaultPaymentDetails.getCustomerVerificationDetailed() != null) {
            this.customerVerificationDetailed = defaultPaymentDetails.getCustomerVerificationDetailed();
        }
        if (defaultPaymentDetails.requiresSignature()) {
            object2 = new PaymentDetailsSignatureWrapper(this);
            object = new PaymentDetailsSignatureWrapper(defaultPaymentDetails);
            ((PaymentDetailsSignatureWrapper)object2).mergeWithPaymentDetailsSignatureWrapper((PaymentDetailsSignatureWrapper)object);
        }
        if (defaultPaymentDetails.getAdditionalCustomerVerification() != null) {
            this.setAdditionalCustomerVerification(defaultPaymentDetails.getAdditionalCustomerVerification());
        }
        if (defaultPaymentDetails.getBypassedVerificationMethods() != null) {
            this.bypassedVerificationMethods.addAll(defaultPaymentDetails.getBypassedVerificationMethods());
        }
        if (this.isAlternativePaymentMethod()) {
            object2 = new PaymentDetailsAlternativePaymentMethodWrapper(this);
            object = new PaymentDetailsAlternativePaymentMethodWrapper(defaultPaymentDetails);
            ((PaymentDetailsAlternativePaymentMethodWrapper)object2).mergeWithPaymentDetailsAlternativePaymentMethodWrapper((PaymentDetailsAlternativePaymentMethodWrapper)object);
        } else if (this.isMoto() || this.sourceHasManualData()) {
            object2 = new PaymentDetailsManualInputWrapper(this);
            object = new PaymentDetailsManualInputWrapper(this);
            ((PaymentDetailsManualInputWrapper)object2).mergeWithPaymentsManualWrapper((PaymentDetailsManualInputWrapper)object);
        } else if (this.sourceHasMagstripeData()) {
            object2 = new PaymentDetailsMagstripeWrapper(this);
            object = new PaymentDetailsMagstripeWrapper(defaultPaymentDetails);
            ((PaymentDetailsMagstripeWrapper)object2).mergeWithPaymentDetailsMagstripeWrapper((PaymentDetailsMagstripeWrapper)object);
        } else if (this.sourceHasIccData()) {
            object2 = new PaymentDetailsIccWrapper(this);
            object = new PaymentDetailsIccWrapper(defaultPaymentDetails);
            ((PaymentDetailsIccWrapper)object2).mergeWithPaymentDetailsICCWrapper((PaymentDetailsIccWrapper)object);
        }
    }

    public PaymentDetailsScheme getScheme() {
        return this.scheme;
    }

    public PaymentDetailsSource getSource() {
        return this.source;
    }

    public PaymentDetailsCustomerVerification getCustomerVerification() {
        if (this.customerVerificationDetailed != null) {
            return this.customerVerificationDetailed.getCustomerVerification();
        }
        return null;
    }

    public Set<BypassedVerificationMethod> getBypassedVerificationMethods() {
        return this.bypassedVerificationMethods;
    }

    public void addBypassedVerificationMethods(Collection<BypassedVerificationMethod> methods) {
        this.bypassedVerificationMethods.addAll(methods);
    }

    public String getMaskedAccountNumber() {
        if (this.source == null) {
            return null;
        }
        switch (this.source) {
            case ICC: 
            case NFC_ICC: 
            case NFC_MAGSTRIPE: {
                PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper(this);
                if (paymentDetailsIccWrapper.getIccInformation() == null) {
                    return null;
                }
                return paymentDetailsIccWrapper.getIccInformation().getMaskedAccountNumber();
            }
            case MAGNETIC_STRIPE: 
            case MAGNETIC_STRIPE_FALLBACK: {
                PaymentDetailsMagstripeWrapper paymentDetailsMagstripeWrapper = new PaymentDetailsMagstripeWrapper(this);
                if (paymentDetailsMagstripeWrapper.getMagstripeInformation() == null) {
                    return null;
                }
                return paymentDetailsMagstripeWrapper.getMagstripeInformation().getMaskedAccountNumber();
            }
            case BARCODE: 
            case QR_CODE: {
                PaymentDetailsAlternativePaymentMethodWrapper paymentDetailsAlternativePaymentMethodWrapper = new PaymentDetailsAlternativePaymentMethodWrapper(this);
                return paymentDetailsAlternativePaymentMethodWrapper.getMaskedAccountNumber();
            }
            case MANUAL: {
                switch (this.workflowType) {
                    case ALTERNATIVE_PAYMENT_METHOD: {
                        return new PaymentDetailsAlternativePaymentMethodWrapper(this).getMaskedAccountNumber();
                    }
                    case MOTO: 
                    case EBT: 
                    case GIFT_CARD: 
                    case POS: {
                        return new PaymentDetailsManualInputWrapper(this).getMaskedAccountNumber();
                    }
                }
                return null;
            }
        }
        return null;
    }

    public MotoType getMotoType() {
        return this.motoType;
    }

    public void setMotoType(MotoType motoType) {
        this.motoType = motoType;
    }

    public Map<String, Object> getData() {
        return this.mData;
    }

    public boolean isFallback() {
        return this.fallback;
    }

    public void setFallback(boolean fallback) {
        this.fallback = fallback;
    }

    public String toString() {
        Map<String, Object> map = this.excludeSensitiveData();
        return "DefaultPaymentDetails{scheme=" + this.scheme + ", source=" + this.source + ", customerVerificationDetailed=" + this.customerVerificationDetailed + ", mData=" + map + ", workflowType=" + this.workflowType + ", fallback=" + this.fallback + ", fallbackReason=" + this.fallbackReason + ", bypassedVerificationMethods=" + this.bypassedVerificationMethods + ", manualApplicationSelection=" + this.manualApplicationSelection + ", additionalCustomerVerification=" + this.additionalCustomerVerification + "}";
    }

    private Map<String, Object> excludeSensitiveData() {
        Map<String, Object> map = this.mData;
        synchronized (map) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>(this.mData);
            for (String string : blacklistedKeys) {
                hashMap.remove(string);
            }
            return hashMap;
        }
    }

    public void setSource(PaymentDetailsSource source) {
        this.source = source;
    }

    public void setScheme(PaymentDetailsScheme scheme) {
        this.scheme = scheme;
    }

    public PaymentDetailsCustomerVerificationDetailed getCustomerVerificationDetailed() {
        return this.customerVerificationDetailed;
    }

    public void setCustomerVerificationDetailed(PaymentDetailsCustomerVerificationDetailed customerVerificationDetailed) {
        this.customerVerificationDetailed = customerVerificationDetailed;
    }

    public void applyOtherPaymentDetails(DefaultPaymentDetails other) {
        this.source = other.getSource();
        this.scheme = other.getScheme();
        if (other.isFallback()) {
            this.fallback = true;
            this.fallbackReason = other.getFallbackReason();
        }
        this.customerVerificationDetailed = other.getCustomerVerificationDetailed();
        Map<String, Object> map = other.getData();
        if (map == null) {
            return;
        }
        Set<String> set = map.keySet();
        for (String string : set) {
            this.mData.put(string, map.get(string));
        }
        this.forceZeroCvmLimit = other.forceZeroCvmLimit;
    }

    public PaymentDetailsFallbackReason getFallbackReason() {
        return this.fallbackReason;
    }

    public void setFallbackReason(PaymentDetailsFallbackReason mFallbackReason) {
        this.fallbackReason = mFallbackReason;
    }

    public boolean sourceHasIccData() {
        return this.source == PaymentDetailsSource.ICC || this.source == PaymentDetailsSource.NFC_ICC || this.source == PaymentDetailsSource.NFC_MAGSTRIPE;
    }

    public boolean sourceHasMagstripeData() {
        return this.source == PaymentDetailsSource.MAGNETIC_STRIPE || this.source == PaymentDetailsSource.MAGNETIC_STRIPE_FALLBACK;
    }

    public boolean sourceHasManualData() {
        return this.source == PaymentDetailsSource.MANUAL;
    }

    public boolean isAlternativePaymentMethod() {
        return this.workflowType == TransactionWorkflowType.ALTERNATIVE_PAYMENT_METHOD;
    }

    public boolean isMoto() {
        return this.workflowType == TransactionWorkflowType.MOTO;
    }

    public boolean isEbt() {
        return this.workflowType == TransactionWorkflowType.EBT;
    }

    public boolean isGiftCard() {
        return this.workflowType == TransactionWorkflowType.GIFT_CARD;
    }

    public boolean sourceIsNfc() {
        return this.source == PaymentDetailsSource.NFC_ICC || this.source == PaymentDetailsSource.NFC_MAGSTRIPE;
    }

    public TransactionWorkflowType getWorkflowType() {
        return this.workflowType;
    }

    public void setWorkflowType(TransactionWorkflowType workflowType) {
        this.workflowType = workflowType;
    }

    public boolean getManualApplicationSelection() {
        return this.manualApplicationSelection;
    }

    public void setManualApplicationSelection(boolean manualApplicationSelection) {
        this.manualApplicationSelection = manualApplicationSelection;
    }

    public boolean requiresSignature() {
        return this.customerVerificationDetailed != null && this.customerVerificationDetailed.requiresSignature() || this.getAdditionalCustomerVerification() == AdditionalCustomerVerification.SIGNATURE;
    }

    public AdditionalCustomerVerification getAdditionalCustomerVerification() {
        return this.additionalCustomerVerification;
    }

    public void setAdditionalCustomerVerification(AdditionalCustomerVerification additionalCustomerVerification) {
        this.additionalCustomerVerification = additionalCustomerVerification;
    }

    public void setForceZeroCvmLimit(boolean forceZeroCvmLimit) {
        this.forceZeroCvmLimit = forceZeroCvmLimit;
    }

    public boolean getForceZeroCvmLimit() {
        return this.forceZeroCvmLimit;
    }
}

