/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.paymentdetails;

import io.mpos.core.common.obfuscated.ac;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.shared.paymentdetails.MagstripeServiceCode;
import io.mpos.shared.paymentdetails.MagstripeServiceCodeFactory;
import io.mpos.shared.provider.CardHelper;
import io.mpos.shared.transactions.BaseTransaction;
import java.util.Arrays;

public class MagstripeInformation {
    private String maskedAccountNumber;
    private MagstripeServiceCode serviceCode;
    private Format format;
    private String sredData;
    private String sredKSN;
    private String pinData;
    private String pinKSN;
    private String macData;
    private String macKSN;
    private byte[] rawTrack2;
    private String maskedTrack2;
    private String unencryptedTrack1;
    private String unencryptedTrack2;
    private String unencryptedTrack3;
    private String cardholderName;
    private BaseTransaction transaction;
    private static final int AMEX_ISO_TRACK_LENGTH = 37;

    public MagstripeInformation() {
    }

    public MagstripeInformation(String maskedTrack2) {
        this.maskedTrack2 = CardHelper.maskTrack2Data(maskedTrack2);
        this.maskedAccountNumber = CardHelper.parseAccountNumberFromTrack2(this.maskedTrack2);
        PaymentDetailsScheme paymentDetailsScheme = CardHelper.schemeForAccountNumber(this.maskedAccountNumber, true);
        this.format = this.parseFormat(paymentDetailsScheme, this.maskedTrack2);
        if (this.format == Format.ISO) {
            String string = CardHelper.parseServiceCodeFromTrack2(this.maskedTrack2);
            this.serviceCode = MagstripeServiceCodeFactory.build(paymentDetailsScheme, string, this);
        } else {
            this.serviceCode = new ac();
        }
    }

    public MagstripeInformation(String maskedAccountNumber, String serviceCode) {
        this.maskedAccountNumber = CardHelper.maskAccountNumber(maskedAccountNumber);
        PaymentDetailsScheme paymentDetailsScheme = CardHelper.schemeForAccountNumber(this.maskedAccountNumber, true);
        this.format = Format.ISO;
        this.serviceCode = serviceCode != null ? MagstripeServiceCodeFactory.build(paymentDetailsScheme, serviceCode, this) : new ac();
    }

    public void mergeWithMagstripeInformation(MagstripeInformation other) {
        if (other == null) {
            return;
        }
        if (other.maskedAccountNumber != null) {
            this.maskedAccountNumber = other.maskedAccountNumber;
        }
        if (other.serviceCode != null) {
            this.serviceCode = other.serviceCode;
        }
        if (other.sredData != null) {
            this.sredData = other.sredData;
        }
        if (other.sredKSN != null) {
            this.sredKSN = other.sredKSN;
        }
        if (other.pinData != null) {
            this.pinData = other.pinData;
        }
        if (other.pinKSN != null) {
            this.pinKSN = other.pinKSN;
        }
        if (other.macData != null) {
            this.macData = other.macData;
        }
        if (other.macKSN != null) {
            this.macKSN = other.macKSN;
        }
        if (other.maskedTrack2 != null) {
            this.maskedTrack2 = other.maskedTrack2;
        }
        if (other.unencryptedTrack3 != null) {
            this.unencryptedTrack3 = other.unencryptedTrack3;
        }
        if (other.cardholderName != null) {
            this.cardholderName = other.cardholderName;
        }
        if (other.transaction != null) {
            this.transaction = other.transaction;
        }
    }

    public String getMaskedAccountNumber() {
        return this.maskedAccountNumber;
    }

    public void setMaskedAccountNumber(String maskedAccountNumber) {
        this.maskedAccountNumber = maskedAccountNumber;
    }

    public String getMaskedTrack2() {
        return this.maskedTrack2;
    }

    public void setRawTrack2(byte[] rawTrack2) {
        this.rawTrack2 = rawTrack2;
    }

    public byte[] getRawTrack2() {
        return this.rawTrack2;
    }

    public void setMaskedTrack2(String maskedTrack2) {
        this.maskedTrack2 = maskedTrack2;
    }

    public String getUnencryptedTrack1() {
        return this.unencryptedTrack1;
    }

    public void setUnencryptedTrack1(String unencryptedTrack1) {
        this.unencryptedTrack1 = unencryptedTrack1;
    }

    public String getUnencryptedTrack2() {
        return this.unencryptedTrack2;
    }

    public void setUnencryptedTrack2(String unencryptedTrack2) {
        this.unencryptedTrack2 = unencryptedTrack2;
    }

    public String getUnencryptedTrack3() {
        return this.unencryptedTrack3;
    }

    public void setUnencryptedTrack3(String unencryptedTrack3) {
        this.unencryptedTrack3 = unencryptedTrack3;
    }

    public String getSredData() {
        return this.sredData;
    }

    public void setSredData(String sredData) {
        this.sredData = sredData;
    }

    public String getSredKSN() {
        return this.sredKSN;
    }

    public void setSredKSN(String sredKSN) {
        this.sredKSN = sredKSN;
    }

    public MagstripeServiceCode getServiceCode() {
        return this.serviceCode;
    }

    public void setServiceCode(MagstripeServiceCode serviceCode) {
        this.serviceCode = serviceCode;
    }

    public String getPinData() {
        return this.pinData;
    }

    public void setPinData(String pinData) {
        this.pinData = pinData;
    }

    public String getPinKSN() {
        return this.pinKSN;
    }

    public void setPinKSN(String pinKSN) {
        this.pinKSN = pinKSN;
    }

    public String getMacData() {
        return this.macData;
    }

    public void setMacData(String macData) {
        this.macData = macData;
    }

    public String getMacKSN() {
        return this.macKSN;
    }

    public void setMacKSN(String macKSN) {
        this.macKSN = macKSN;
    }

    public String getCardholderName() {
        return this.cardholderName;
    }

    public void setCardholderName(String cardholderName) {
        this.cardholderName = cardholderName;
    }

    public BaseTransaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(BaseTransaction transaction) {
        this.transaction = transaction;
    }

    public String toString() {
        return "MagstripeInformation{maskedAccountNumber='" + this.maskedAccountNumber + "', serviceCode=" + this.serviceCode + ", format=" + this.format + ", sredData='" + this.sredData + "', sredKSN='" + this.sredKSN + "', pinData='" + this.pinData + "', pinKSN='" + this.pinKSN + "', macData='" + this.macData + "', macKSN='" + this.macKSN + "', rawTrack2=" + Arrays.toString(this.rawTrack2) + ", maskedTrack2='" + this.maskedTrack2 + "', unencryptedTrack1='" + this.unencryptedTrack1 + "', unencryptedTrack2='" + this.unencryptedTrack2 + "', unencryptedTrack3='" + this.unencryptedTrack3 + "', cardholderName='" + this.cardholderName + "', transactionId=" + (this.transaction != null ? this.transaction.getIdentifier() : "null") + "}";
    }

    private Format parseFormat(PaymentDetailsScheme scheme, String track2) {
        Format format = Format.ISO;
        switch (scheme) {
            case AMERICAN_EXPRESS: 
            case AMEX_COMMON_DEBIT: {
                if (track2.length() < 37) {
                    format = Format.ANSI;
                    break;
                }
                format = Format.ISO;
                break;
            }
            case UNKNOWN: 
            case DINERS: 
            case DISCOVER: 
            case JCB: 
            case MAESTRO: 
            case MASTERCARD: 
            case VISA: 
            case VISA_ELECTRON: 
            case UNION_PAY: 
            case UNION_PAY_COMMON_DEBIT: 
            case VISA_INTERLINK: 
            case DISCOVER_COMMON_DEBIT: 
            case MASTERCARD_COMMON_DEBIT: 
            case VISA_COMMON_DEBIT: 
            case GH_LINK: 
            case VALUE_LINK: 
            case CARTES_BANCAIRES: 
            case INTERAC: 
            case EBT: {
                format = Format.ISO;
            }
        }
        return format;
    }

    public static enum Format {
        ISO,
        ANSI;

    }
}

