/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.paymentdetails;

import io.mpos.core.common.obfuscated.aa;
import io.mpos.core.common.obfuscated.ab;
import io.mpos.core.common.obfuscated.ad;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.shared.paymentdetails.MagstripeInformation;
import io.mpos.shared.paymentdetails.MagstripeServiceCode;
import org.jetbrains.annotations.Nullable;

public class MagstripeServiceCodeFactory {
    public static MagstripeServiceCode build(PaymentDetailsScheme scheme, @Nullable String serviceCode, MagstripeInformation magstripeInformation) {
        if (serviceCode == null) {
            return null;
        }
        MagstripeServiceCode magstripeServiceCode = null;
        switch (scheme) {
            case AMERICAN_EXPRESS: 
            case AMEX_COMMON_DEBIT: {
                magstripeServiceCode = new aa(serviceCode);
                break;
            }
            case MAESTRO: 
            case MASTERCARD: {
                magstripeServiceCode = new ad(serviceCode, magstripeInformation);
                break;
            }
            case UNKNOWN: 
            case DINERS: 
            case DISCOVER: 
            case JCB: 
            case VISA: 
            case VISA_ELECTRON: 
            case UNION_PAY: 
            case UNION_PAY_COMMON_DEBIT: 
            case VISA_INTERLINK: 
            case DISCOVER_COMMON_DEBIT: 
            case MASTERCARD_COMMON_DEBIT: 
            case VISA_COMMON_DEBIT: 
            case GH_LINK: 
            case VALUE_LINK: 
            case CARTES_BANCAIRES: 
            case INTERAC: 
            case EBT: {
                magstripeServiceCode = new ab(serviceCode);
            }
        }
        return magstripeServiceCode;
    }
}

