/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.processors.payworks.services.response;

import com.visa.utils.Base64;
import io.mpos.accessories.Accessory;
import io.mpos.accessories.AccessoryConnectionType;
import io.mpos.accessories.AccessoryDetails;
import io.mpos.accessories.AccessoryType;
import io.mpos.accessories.components.interaction.DefaultCardData;
import io.mpos.accessories.components.interaction.moto.MotoType;
import io.mpos.core.common.obfuscated.cy;
import io.mpos.core.common.obfuscated.eP;
import io.mpos.core.common.obfuscated.eQ;
import io.mpos.core.common.obfuscated.ei;
import io.mpos.core.common.obfuscated.ej;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.paymentdetails.PaymentDetails;
import io.mpos.paymentdetails.PaymentDetailsCustomerVerification;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.provider.ProviderMode;
import io.mpos.provider.ProviderOptions;
import io.mpos.shared.accessories.AdditionalAccessoryCapabilities;
import io.mpos.shared.accessories.DefaultAccessoryDetails;
import io.mpos.shared.accessories.modules.AccessoryFile;
import io.mpos.shared.accessories.modules.AccessoryKeys;
import io.mpos.shared.accessories.modules.AccessoryKeysWrapper;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.helper.Helper;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.helper.TimeHelper;
import io.mpos.shared.mapper.MapperExtensionsKt;
import io.mpos.shared.paymentdetails.BypassedVerificationMethod;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.DefaultPaymentDetailsFactory;
import io.mpos.shared.paymentdetails.IccInformation;
import io.mpos.shared.paymentdetails.MagstripeInformation;
import io.mpos.shared.paymentdetails.PaymentDetailsAlternativePaymentMethodWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsCustomerVerificationDetailed;
import io.mpos.shared.paymentdetails.PaymentDetailsFallbackReason;
import io.mpos.shared.paymentdetails.PaymentDetailsIccWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsMagstripeWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsManualInputWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsSchemesContainer;
import io.mpos.shared.paymentdetails.PaymentDetailsSignatureWrapper;
import io.mpos.shared.processors.payworks.services.response.CardHolderPresenceType;
import io.mpos.shared.processors.payworks.services.response.dto.AdditionalCustomerVerification;
import io.mpos.shared.processors.payworks.services.response.dto.BackendAccessoryFileDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendAvsDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendCaptureTransactionPayloadDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendCardDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendClearingDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendCreateAndExecuteTransactionPayloadDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendCurrencyDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendCustomerVerificationDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendCustomerVerificationSignatureDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendDccCardDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendDccDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendDccLookupStatusDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendDccOptionsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendDccRequestDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendDccStatusDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendDccStatusDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendEbtDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendEncryptedDataDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendErrorDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendExecuteTransactionCardPresentDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendExecuteTransactionEncryptedDataDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendExecuteTransactionIccDataDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendExecuteTransactionPayloadDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendExecuteTransactionReaderDataDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendGenerateKeysAccessoryServicePayloadDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendGenerateKeysAccessoryServiceResponseDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendGetKeysAccessoryServiceResponseDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendGiftCardDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendIncrementalAuthorizationDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendIncrementalAuthorizationTransactionDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendIncrementalAuthorizationTransactionPayloadDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendMetricsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendNotifyAccessoryWasUpdatedServicePayloadDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendPaymentDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendPaymentDetailsIccDataDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendProcessingDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendProcessingOptionsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendProvisionAccessoryPayloadDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendReaderDataDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendReceiptDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendReceiptDetailsEntityDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendReceiptLineItemDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendRefundDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendRefundTransactionDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendRegisterAndExecuteTransactionDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendShopperDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendStatusDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTipAdjustTransactionPayloadDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionAlternativePaymentMethodDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionReceiptDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionRegistrationDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionResponseDataDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionResponseEmbeddedDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionResponseEmbeddedListsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionVerificationResultDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionVerificationResultsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendTransactionWorkflowTypeDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendVoidFinalizeTransactionPayloadDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendWhitelistReaderDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendWhitelistReaderDetailsDTO;
import io.mpos.shared.processors.payworks.services.response.dto.Certificate;
import io.mpos.shared.processors.payworks.services.response.dto.KeyIksn;
import io.mpos.shared.processors.payworks.services.response.dto.TippingParametersDTO;
import io.mpos.shared.processors.payworks.services.response.dto.mappers.AidConstraintsMapper;
import io.mpos.shared.processors.payworks.services.response.dto.mappers.EbtMapper;
import io.mpos.shared.processors.payworks.services.response.dto.mappers.EncryptedDataMapper;
import io.mpos.shared.processors.payworks.services.response.dto.mappers.GiftCardMapper;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.AccessoryTypeSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.BypassedVerificationMethodSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.CurrencySerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.PaymentDetailsCustomerVerificationDetailedSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.PaymentDetailsCustomerVerificationSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.PaymentDetailsFallbackReasonSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.PaymentDetailsSchemeSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.PaymentDetailsSourceSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.ProcessingOptionsSerializers;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.ReceiptLineItemKeySerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.RefundDetailsProcessSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.RefundDetailsStatusSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.TipAdjustStatusSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.TransactionStatusDetailsCodesSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.TransactionStatusSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.TransactionTypeDetailsCodeSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.TransactionTypeSerializer;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.WhitelistAccessorySerializers;
import io.mpos.shared.provider.CardHelper;
import io.mpos.shared.provider.ProcessingOptions;
import io.mpos.shared.provider.ProcessingOptionsContainer;
import io.mpos.shared.provider.WhitelistAccessory;
import io.mpos.shared.provider.WhitelistAccessoryRequirement;
import io.mpos.shared.transactionprovider.processparameters.steps.tipping.AmountOrPercentage;
import io.mpos.shared.transactions.AvsDetails;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.CurrencyWrapper;
import io.mpos.shared.transactions.DefaultAvsDetails;
import io.mpos.shared.transactions.DefaultCardDetails;
import io.mpos.shared.transactions.DefaultDccDetails;
import io.mpos.shared.transactions.DefaultIncrementalAuthorizationDetails;
import io.mpos.shared.transactions.DefaultIncrementalAuthorizationTransaction;
import io.mpos.shared.transactions.DefaultInstallmentDetails;
import io.mpos.shared.transactions.DefaultMerchantDetails;
import io.mpos.shared.transactions.DefaultProcessingDetails;
import io.mpos.shared.transactions.DefaultReceiptDetails;
import io.mpos.shared.transactions.DefaultRefundDetails;
import io.mpos.shared.transactions.DefaultRefundTransaction;
import io.mpos.shared.transactions.DefaultShopperDetails;
import io.mpos.shared.transactions.DefaultTaxDetails;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.shared.transactions.DefaultTransactionStatusDetails;
import io.mpos.shared.transactions.DefaultTransactionVerificationResults;
import io.mpos.shared.transactions.receipts.ReceiptDetails;
import io.mpos.shared.util.MultiBuffer;
import io.mpos.shared.workflows.accessory.ConfigurationItem;
import io.mpos.specs.bertlv.TLVHelper;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.transactionprovider.processparameters.steps.tipping.TippingParameters;
import io.mpos.transactions.CardDetails;
import io.mpos.transactions.Currency;
import io.mpos.transactions.DccStatus;
import io.mpos.transactions.DccStatusDetails;
import io.mpos.transactions.DefaultTransactionDetails;
import io.mpos.transactions.IncrementalAuthorizationDetails;
import io.mpos.transactions.IncrementalAuthorizationTransaction;
import io.mpos.transactions.InstallmentDetails;
import io.mpos.transactions.MerchantDetails;
import io.mpos.transactions.ProcessingDetails;
import io.mpos.transactions.RefundDetails;
import io.mpos.transactions.RefundDetailsProcess;
import io.mpos.transactions.RefundDetailsStatus;
import io.mpos.transactions.RefundTransaction;
import io.mpos.transactions.ShopperDetails;
import io.mpos.transactions.TaxDetails;
import io.mpos.transactions.TipAdjustStatus;
import io.mpos.transactions.TransactionDetails;
import io.mpos.transactions.TransactionState;
import io.mpos.transactions.TransactionStatus;
import io.mpos.transactions.TransactionStatusDetailsCodes;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.TransactionTypeDetailsCode;
import io.mpos.transactions.TransactionWorkflowType;
import io.mpos.transactions.account.AccountParameters;
import io.mpos.transactions.parameters.TransactionParameters;
import io.mpos.transactions.receipts.ClearingDetails;
import io.mpos.transactions.receipts.Receipt;
import io.mpos.transactions.receipts.ReceiptLineItem;
import io.mpos.transactions.receipts.ReceiptLineItemKey;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class DTOConversionHelper {
    public static final DTOConversionHelper INSTANCE = new DTOConversionHelper();
    public static final String TAG = "ConversionHelper";
    private final GiftCardMapper giftCardMapper = new GiftCardMapper();
    private final EncryptedDataMapper encryptedDataMapper = new EncryptedDataMapper();
    private final AidConstraintsMapper aidConstraintsMapper = new AidConstraintsMapper();
    private final EbtMapper ebtMapper = new EbtMapper();

    public synchronized BaseTransaction createTransactionFromBackendTransactionResponseDataDTO(BackendTransactionResponseDataDTO transactionResponseDTO) {
        return this.createTransactionFromBackendTransactionResponseDataDTO(transactionResponseDTO, null);
    }

    public synchronized BaseTransaction createTransactionFromBackendTransactionResponseDataDTO(BackendTransactionResponseDataDTO transactionResponseDTO, BackendTransactionResponseEmbeddedDTO transactionEmbeddedDTO) {
        DefaultDccDetails defaultDccDetails;
        BackendTransactionDTO backendTransactionDTO = transactionResponseDTO.getTransaction();
        DefaultTransaction defaultTransaction = (DefaultTransaction)this.createTransactionFromBackendTransactionDTO(backendTransactionDTO);
        defaultTransaction.setSessionIdentifier(transactionResponseDTO.getIdentifier());
        this.updateTransactionReceipts(defaultTransaction, transactionEmbeddedDTO);
        if (transactionResponseDTO.getDccOptions() != null && (defaultDccDetails = (DefaultDccDetails)defaultTransaction.getDccDetails()) != null) {
            BackendDccOptionsDTO backendDccOptionsDTO = transactionResponseDTO.getDccOptions();
            defaultDccDetails.resetWithCandidates(MapperExtensionsKt.toPaymentDetailsScheme((EnumSet)backendDccOptionsDTO.getSupportedSchemes()));
        }
        return defaultTransaction;
    }

    public synchronized BaseTransaction createTransactionFromBackendTransactionDTO(BackendTransactionDTO transactionDTO) {
        Object object;
        BackendEbtDetailsDTO backendEbtDetailsDTO;
        Object object2;
        BackendAvsDetailsDTO backendAvsDetailsDTO;
        BackendTransactionVerificationResultsDTO backendTransactionVerificationResultsDTO;
        DefaultTransaction defaultTransaction;
        BackendTransactionDTO backendTransactionDTO;
        BackendShopperDetailsDTO backendShopperDetailsDTO;
        BackendCardDetailsDTO backendCardDetailsDTO;
        BackendStatusDetailsDTO backendStatusDetailsDTO;
        BackendClearingDetailsDTO backendClearingDetailsDTO;
        BackendIncrementalAuthorizationDetailsDTO backendIncrementalAuthorizationDetailsDTO;
        BackendRefundDetailsDTO backendRefundDetailsDTO;
        BackendReceiptDetailsDTO backendReceiptDetailsDTO;
        BackendProcessingDetailsDTO backendProcessingDetailsDTO;
        Object object3;
        TransactionWorkflowType transactionWorkflowType;
        BigDecimal bigDecimal = transactionDTO.getAmount();
        Currency currency = (Currency)CurrencySerializer.getInstance().deserialize(transactionDTO.getCurrency());
        TransactionType transactionType = (TransactionType)TransactionTypeSerializer.getInstance().deserialize(transactionDTO.getType());
        DefaultTransaction defaultTransaction2 = new DefaultTransaction(bigDecimal, currency, transactionType);
        defaultTransaction2.setIdentifier(transactionDTO.getIdentifier());
        defaultTransaction2.setCustomIdentifier(transactionDTO.getCustomIdentifier());
        defaultTransaction2.setSubject(transactionDTO.getSubject());
        defaultTransaction2.setStatus((TransactionStatus)TransactionStatusSerializer.getInstance().deserialize(transactionDTO.getStatus()));
        defaultTransaction2.setState(TransactionState.IDLE);
        defaultTransaction2.setReferencedTransactionIdentifier(transactionDTO.getReferencedTransactionIdentifier());
        defaultTransaction2.setGroupIdentifier(transactionDTO.getGroupIdentifier());
        defaultTransaction2.setCreatedTimestamp(transactionDTO.getCreated().getTime());
        TimeZone timeZone = TimeHelper.extractTimeZoneFromIso8601String((String)transactionDTO.getCreatedTimeZoned());
        if (timeZone != null) {
            defaultTransaction2.setCreatedTimeZone(timeZone);
        }
        if ((transactionWorkflowType = MapperExtensionsKt.toTransactionWorkflowType((BackendTransactionWorkflowTypeDTO)transactionDTO.getWorkflow())) != null) {
            defaultTransaction2.setWorkflow(transactionWorkflowType);
        } else {
            defaultTransaction2.setWorkflow(TransactionWorkflowType.UNKNOWN);
        }
        TransactionType transactionType2 = (TransactionType)TransactionTypeSerializer.getInstance().deserialize(transactionDTO.getInternalTypeOverride());
        if (transactionType2 != null) {
            defaultTransaction2.setInternalTypeOverride(transactionType2);
        } else {
            defaultTransaction2.setInternalTypeOverride(TransactionType.UNKNOWN);
        }
        defaultTransaction2.setAutoCapture(defaultTransaction2.getInternalTypeOverride() != TransactionType.PREAUTHORIZE);
        defaultTransaction2.setCaptured(transactionDTO.getCaptured());
        BackendTransactionDetailsDTO backendTransactionDetailsDTO = transactionDTO.getDetails();
        if (backendTransactionDetailsDTO != null) {
            defaultTransaction2.setDetails(this.createTransactionDetailsFromDTO(backendTransactionDetailsDTO));
            Map map = object3 = backendTransactionDetailsDTO.getMetadata() != null ? backendTransactionDetailsDTO.getMetadata() : new HashMap();
            if (object3 != null && !object3.isEmpty()) {
                defaultTransaction2.setMerchantDetails(this.extractMerchantDetails((Map<String, String>)object3));
                defaultTransaction2.setInstallmentDetails(this.extractInstallmentDetails((Map<String, String>)object3));
                defaultTransaction2.setTaxDetails(this.extractTaxDetails((Map<String, String>)object3));
            }
        }
        if ((object3 = transactionDTO.getPaymentDetails()) != null) {
            defaultTransaction2.setPaymentDetails(this.createPaymentDetailsFromDTO((BackendPaymentDetailsDTO)object3, defaultTransaction2.getWorkflow()));
        }
        if ((backendProcessingDetailsDTO = transactionDTO.getProcessingDetails()) != null) {
            defaultTransaction2.setProcessingDetails(this.createProcessingDetailsFromDTO(backendProcessingDetailsDTO));
        }
        if ((backendReceiptDetailsDTO = transactionDTO.getReceiptDetails()) != null && backendReceiptDetailsDTO.getEmv() != null && backendReceiptDetailsDTO.getEmv().getApplicationID() != null) {
            defaultTransaction2.setReceiptDetails(this.createReceiptDetailsFromDTO(backendReceiptDetailsDTO));
        }
        if ((backendRefundDetailsDTO = transactionDTO.getRefundDetails()) != null) {
            defaultTransaction2.setRefundDetails(this.createRefundDetailsFromDTO(backendRefundDetailsDTO));
        }
        if ((backendIncrementalAuthorizationDetailsDTO = transactionDTO.getIncrementalAuthorizationDetails()) != null) {
            defaultTransaction2.setIncrementalAuthorizationDetails(this.createIncrementalAuthorizationDetailsFromDTO(backendIncrementalAuthorizationDetailsDTO));
        }
        if ((backendClearingDetailsDTO = transactionDTO.getClearingDetails()) != null) {
            defaultTransaction2.setClearingDetails(this.createClearingDetailsFromDTO(backendClearingDetailsDTO));
        }
        if ((backendStatusDetailsDTO = transactionDTO.getStatusDetails()) != null && backendStatusDetailsDTO.getDescription() != null) {
            defaultTransaction2.setStatusDetails(this.createTransactionStatusDetailsFromDTO(backendStatusDetailsDTO));
        }
        if ((backendCardDetailsDTO = transactionDTO.getCardDetails()) != null) {
            defaultTransaction2.setCardDetails(this.createCardDetailsFromDTO(backendCardDetailsDTO));
        }
        if ((backendShopperDetailsDTO = transactionDTO.getShopperDetails()) != null) {
            defaultTransaction2.setShopperDetails(this.createShopperDetailsFromDTO(backendShopperDetailsDTO));
        }
        if ((backendTransactionDTO = transactionDTO.getPreviousTransaction()) != null) {
            defaultTransaction = (DefaultTransaction)this.createTransactionFromBackendTransactionDTO(backendTransactionDTO);
            defaultTransaction2.setPreviousTransaction(defaultTransaction);
        } else {
            defaultTransaction2.setPreviousTransaction(null);
        }
        defaultTransaction = transactionDTO.getDccDetails();
        if (defaultTransaction != null) {
            defaultTransaction2.setDccDetails(this.createDccDetails((BackendDccDTO)defaultTransaction));
        }
        if ((backendTransactionVerificationResultsDTO = transactionDTO.getVerificationResults()) != null) {
            defaultTransaction2.setVerificationResults(this.createVerificationResultDetails(backendTransactionVerificationResultsDTO));
        }
        if ((backendAvsDetailsDTO = transactionDTO.getAvsDetails()) != null) {
            object2 = new PaymentDetailsManualInputWrapper((DefaultPaymentDetails)defaultTransaction2.getPaymentDetails());
            ((PaymentDetailsManualInputWrapper)object2).setAvsDetails(this.createAvsDetailsFromDTO(backendAvsDetailsDTO));
        }
        if ((object2 = transactionDTO.getGiftCardDetails()) != null) {
            defaultTransaction2.setGiftCardDetails(this.giftCardMapper.createGiftCardDetails((BackendGiftCardDetailsDTO)object2));
        }
        if ((backendEbtDetailsDTO = transactionDTO.getEbtDetails()) != null) {
            defaultTransaction2.setEbtDetails(this.ebtMapper.createEbtDetails(backendEbtDetailsDTO));
        }
        if (transactionDTO.getTypeDetails() != null && transactionDTO.getTypeDetails().getCode() != null && (object = (TransactionTypeDetailsCode)TransactionTypeDetailsCodeSerializer.getInstance().deserialize(transactionDTO.getTypeDetails().getCode())) == TransactionTypeDetailsCode.INCREMENTAL_AUTHORIZATION) {
            defaultTransaction2.setType(TransactionType.INCREMENTAL_AUTHORIZATION);
        }
        if (transactionDTO.getReader() != null && transactionDTO.getReader().getDetails() != null) {
            object = new DefaultAccessoryDetails(transactionDTO.getReader().getDetails().getSerialNo(), null, null, null);
            defaultTransaction2.setAccessoryDetails((AccessoryDetails)object);
        }
        return defaultTransaction2;
    }

    private MerchantDetails extractMerchantDetails(Map<String, String> metadata) {
        String string;
        String string2;
        DefaultMerchantDetails defaultMerchantDetails = new DefaultMerchantDetails();
        String string3 = metadata.get("salesOrganizationId");
        if (string3 != null) {
            defaultMerchantDetails.setSalesOrganizationId(string3);
        }
        if ((string2 = metadata.get("subMerchantId")) != null) {
            defaultMerchantDetails.setSubMerchantId(string2);
        }
        if ((string = metadata.get("merchantDescriptor")) != null) {
            defaultMerchantDetails.setDescriptorName(string);
        }
        if (defaultMerchantDetails.isMerchantDetailsEmpty()) {
            return null;
        }
        return defaultMerchantDetails;
    }

    private InstallmentDetails extractInstallmentDetails(Map<String, String> metadata) {
        Boolean bl2;
        Boolean bl3;
        DefaultInstallmentDetails defaultInstallmentDetails = new DefaultInstallmentDetails();
        defaultInstallmentDetails.setPlanType(metadata.get("installmentPlanType"));
        Integer n2 = this.safeParseInt(metadata.get("installmentTotalCount"));
        if (n2 != null) {
            defaultInstallmentDetails.setNumberOfInstallments(n2);
        }
        if ((bl3 = this.safeParseBoolean(metadata.get("installmentInterestIndicator"))) != null) {
            defaultInstallmentDetails.setIncludesInterest(bl3);
        }
        if ((bl2 = this.safeParseBoolean(metadata.get("installmentGovernmentPlan"))) != null) {
            defaultInstallmentDetails.setGovernmentPlan(bl2);
        }
        if (defaultInstallmentDetails.isInstallmentDetailsEmpty()) {
            return null;
        }
        return defaultInstallmentDetails;
    }

    private TaxDetails extractTaxDetails(Map<String, String> metadata) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        DefaultTaxDetails defaultTaxDetails = new DefaultTaxDetails();
        defaultTaxDetails.setMerchantTaxId(metadata.get("merchantTaxId"));
        Integer n2 = this.safeParseInt(metadata.get("salesSlipNumber"));
        if (n2 != null) {
            defaultTaxDetails.setSalesSlipNumber(n2);
        }
        if ((bigDecimal3 = this.safeParseBigDecimal(metadata.get("taxAmount"))) != null) {
            defaultTaxDetails.setIncludedTaxAmount(bigDecimal3);
        }
        if ((bigDecimal2 = this.safeParseBigDecimal(metadata.get("localTaxAmount"))) != null) {
            defaultTaxDetails.setIncludedLocalTaxAmount(bigDecimal2);
        }
        if ((bigDecimal = this.safeParseBigDecimal(metadata.get("nationalTaxAmount"))) != null) {
            defaultTaxDetails.setIncludedNationalTaxAmount(bigDecimal);
        }
        if (defaultTaxDetails.isTaxDetailsEmpty()) {
            return null;
        }
        return defaultTaxDetails;
    }

    private Integer safeParseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Boolean safeParseBoolean(String value) {
        if (value != null && !value.isEmpty()) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    private BigDecimal safeParseBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return null;
        }
    }

    public BackendDccRequestDTO createDccLookupDTO(DefaultTransaction transaction) {
        BackendExecuteTransactionReaderDataDTO backendExecuteTransactionReaderDataDTO;
        BackendDccCardDTO backendDccCardDTO = new BackendDccCardDTO();
        String string = PaymentDetailsSourceSerializer.getInstance().serialize(transaction.getPaymentDetails().getSource());
        backendDccCardDTO.setMode(string);
        String string2 = this.createPaymentDetailsSchemeString(transaction.getPaymentDetails().getScheme());
        backendDccCardDTO.setPaymentScheme(string2);
        if (transaction.getAccessoryDetails() != null) {
            backendExecuteTransactionReaderDataDTO = this.createExecuteTransactionReaderDataDTO(transaction.getAccessoryDetails());
            backendDccCardDTO.setReader(backendExecuteTransactionReaderDataDTO);
        }
        if (transaction.getPaymentDetails() != null && transaction.getPaymentDetails() instanceof DefaultPaymentDetails) {
            backendExecuteTransactionReaderDataDTO = transaction.getPaymentDetails().getSource();
            if (backendExecuteTransactionReaderDataDTO == PaymentDetailsSource.MAGNETIC_STRIPE || backendExecuteTransactionReaderDataDTO == PaymentDetailsSource.MAGNETIC_STRIPE_FALLBACK) {
                PaymentDetailsMagstripeWrapper paymentDetailsMagstripeWrapper = new PaymentDetailsMagstripeWrapper((DefaultPaymentDetails)transaction.getPaymentDetails());
                MagstripeInformation magstripeInformation = paymentDetailsMagstripeWrapper.getMagstripeInformation();
                if (magstripeInformation != null) {
                    backendDccCardDTO.setSred(this.createExecuteTransactionEncryptedDataDTO(magstripeInformation.getSredData(), magstripeInformation.getSredKSN()));
                    backendDccCardDTO.setMaskedAccountNumber(magstripeInformation.getMaskedAccountNumber());
                }
            } else if (backendExecuteTransactionReaderDataDTO == PaymentDetailsSource.ICC || backendExecuteTransactionReaderDataDTO == PaymentDetailsSource.NFC_ICC || backendExecuteTransactionReaderDataDTO == PaymentDetailsSource.NFC_MAGSTRIPE) {
                PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper((DefaultPaymentDetails)transaction.getPaymentDetails());
                IccInformation iccInformation = paymentDetailsIccWrapper.getIccInformation();
                if (iccInformation != null) {
                    backendDccCardDTO.setSred(this.createExecuteTransactionEncryptedDataDTO(iccInformation.getSredData(), iccInformation.getSredKSN()));
                    backendDccCardDTO.setMaskedAccountNumber(paymentDetailsIccWrapper.getIccInformation().getMaskedAccountNumber());
                }
            } else if (backendExecuteTransactionReaderDataDTO == PaymentDetailsSource.MANUAL) {
                PaymentDetailsManualInputWrapper paymentDetailsManualInputWrapper;
                DefaultCardData defaultCardData;
                DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)transaction.getPaymentDetails();
                if (defaultPaymentDetails.isAlternativePaymentMethod()) {
                    PaymentDetailsAlternativePaymentMethodWrapper paymentDetailsAlternativePaymentMethodWrapper = new PaymentDetailsAlternativePaymentMethodWrapper(defaultPaymentDetails);
                    backendDccCardDTO.setMaskedAccountNumber(paymentDetailsAlternativePaymentMethodWrapper.getAccountNumber());
                } else if (defaultPaymentDetails.isMoto() && (defaultCardData = (paymentDetailsManualInputWrapper = new PaymentDetailsManualInputWrapper((DefaultPaymentDetails)transaction.getPaymentDetails())).getCardData()) != null) {
                    backendDccCardDTO.setSred(this.createExecuteTransactionEncryptedDataDTO(defaultCardData.getSred(), defaultCardData.getKsn()));
                    backendDccCardDTO.setMaskedAccountNumber(defaultCardData.getMaskedPan());
                }
            }
        }
        backendExecuteTransactionReaderDataDTO = new BackendDccRequestDTO();
        backendExecuteTransactionReaderDataDTO.setCardPresent(backendDccCardDTO);
        backendExecuteTransactionReaderDataDTO.setLocalTimeZone(TimeHelper.getTimeZoneFromCreatedTimeZone((TimeZone)transaction.getCreatedTimeZone()));
        return backendExecuteTransactionReaderDataDTO;
    }

    private DefaultDccDetails createDccDetails(BackendDccDTO backendDccDTO) {
        DefaultDccDetails defaultDccDetails = new DefaultDccDetails();
        defaultDccDetails.setMarkup(backendDccDTO.getMarkup());
        defaultDccDetails.setDccLookupStatus(MapperExtensionsKt.toDccLookupStatus((BackendDccLookupStatusDTO)backendDccDTO.getLookupStatus()));
        defaultDccDetails.setConvertedAmount(backendDccDTO.getConvertedAmount());
        defaultDccDetails.setConvertedCurrency(MapperExtensionsKt.toCurrency((BackendCurrencyDTO)backendDccDTO.getConvertedCurrency()));
        defaultDccDetails.setRate(backendDccDTO.getRate());
        defaultDccDetails.setConversionHint(backendDccDTO.getConversionHint());
        defaultDccDetails.setStatusDetails(MapperExtensionsKt.toDccStatusDetails((BackendDccStatusDetailsDTO)backendDccDTO.getStatusDetails()));
        defaultDccDetails.setOptions(MapperExtensionsKt.toDccOptions((EnumSet)backendDccDTO.getOptions()));
        return defaultDccDetails;
    }

    public synchronized BaseTransaction createTransactionFromBackendTransactionDTO(BackendTransactionDTO transactionDTO, BackendTransactionResponseEmbeddedDTO transactionEmbeddedDTO) {
        DefaultTransaction defaultTransaction = (DefaultTransaction)this.createTransactionFromBackendTransactionDTO(transactionDTO);
        this.updateTransactionReceipts(defaultTransaction, transactionEmbeddedDTO);
        return defaultTransaction;
    }

    private synchronized void updateTransactionReceipts(DefaultTransaction transaction, BackendTransactionResponseEmbeddedDTO transactionEmbeddedDTO) {
        if (transactionEmbeddedDTO != null) {
            Object object;
            BackendTransactionReceiptDTO backendTransactionReceiptDTO = transactionEmbeddedDTO.getMerchantReceipt();
            if (backendTransactionReceiptDTO != null) {
                object = this.createReceiptFromBackendTransactionReceiptDTO(backendTransactionReceiptDTO);
                transaction.setMerchantReceipt((Receipt)object);
            }
            if ((object = transactionEmbeddedDTO.getCustomerReceipt()) != null) {
                ej ej2 = this.createReceiptFromBackendTransactionReceiptDTO((BackendTransactionReceiptDTO)object);
                transaction.setCustomerReceipt(ej2);
            }
        }
    }

    private void addTipInformation(ej receipt, BackendTransactionReceiptDTO transactionEmbeddedDTO) {
        receipt.c(transactionEmbeddedDTO.isTipIncluded());
        if (transactionEmbeddedDTO.isTipIncluded()) {
            receipt.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.INCLUDED_TIP_AMOUNT_AND_CURRENCY, transactionEmbeddedDTO.getIncludedTipAmountAndCurrency()));
            receipt.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.TOTAL_AMOUNT_AND_CURRENCY, transactionEmbeddedDTO.getTotalAmountAndCurrency()));
            receipt.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.PURCHASE_AMOUNT_AND_CURRENCY, transactionEmbeddedDTO.getPurchaseAmountAndCurrency()));
        }
    }

    public synchronized List<BaseTransaction> createTransactionListFromBackendTransactionListDTO(List<BackendTransactionDTO> transactionListDTO, BackendTransactionResponseEmbeddedListsDTO embeddedListsDTO) {
        Object object2;
        HashMap<String, BackendTransactionDTO> hashMap = null;
        HashMap<String, BackendTransactionDTO> hashMap2 = null;
        if (embeddedListsDTO != null && embeddedListsDTO.getMerchantReceipt() != null) {
            hashMap = new HashMap<String, BackendTransactionDTO>(embeddedListsDTO.getMerchantReceipt().size());
            for (BackendTransactionReceiptDTO backendTransactionReceiptDTO : embeddedListsDTO.getMerchantReceipt()) {
                object2 = this.createReceiptFromBackendTransactionReceiptDTO(backendTransactionReceiptDTO);
                hashMap.put(object2.getIdentifier().getValue(), (BackendTransactionDTO)object2);
            }
        }
        if (embeddedListsDTO != null && embeddedListsDTO.getCustomerReceipt() != null) {
            hashMap2 = new HashMap<String, BackendTransactionDTO>(embeddedListsDTO.getCustomerReceipt().size());
            for (BackendTransactionReceiptDTO backendTransactionReceiptDTO : embeddedListsDTO.getCustomerReceipt()) {
                object2 = this.createReceiptFromBackendTransactionReceiptDTO(backendTransactionReceiptDTO);
                hashMap2.put(object2.getIdentifier().getValue(), (BackendTransactionDTO)object2);
            }
        }
        Iterator<DefaultTransaction> iterator = new ArrayList(transactionListDTO.size());
        for (Object object2 : transactionListDTO) {
            DefaultTransaction defaultTransaction = (DefaultTransaction)this.createTransactionFromBackendTransactionDTO((BackendTransactionDTO)object2);
            if (hashMap != null && hashMap.containsKey(defaultTransaction.getIdentifier())) {
                defaultTransaction.setMerchantReceipt((Receipt)hashMap.get(defaultTransaction.getIdentifier()));
            }
            if (hashMap2 != null && hashMap2.containsKey(defaultTransaction.getIdentifier())) {
                defaultTransaction.setCustomerReceipt((Receipt)hashMap2.get(defaultTransaction.getIdentifier()));
            }
            iterator.add(defaultTransaction);
        }
        return iterator;
    }

    public synchronized TransactionDetails createTransactionDetailsFromDTO(BackendTransactionDetailsDTO transactionDetailsDTO) {
        DefaultTransactionDetails defaultTransactionDetails = new DefaultTransactionDetails();
        defaultTransactionDetails.setIncludedTipAmount(transactionDetailsDTO.getIncludedTipAmount());
        defaultTransactionDetails.setCashbackAmount(transactionDetailsDTO.getCashbackAmount());
        Map map = transactionDetailsDTO.getMetadata() != null ? transactionDetailsDTO.getMetadata() : new HashMap();
        defaultTransactionDetails.setMetadata(map);
        defaultTransactionDetails.setTipAdjustStatus((TipAdjustStatus)TipAdjustStatusSerializer.getInstance().deserialize(transactionDetailsDTO.getTipAdjustStatus()));
        return defaultTransactionDetails;
    }

    public synchronized PaymentDetails createPaymentDetailsFromDTO(BackendPaymentDetailsDTO paymentDetailsDTO, TransactionWorkflowType transactionWorkflowType) {
        AdditionalCustomerVerification additionalCustomerVerification;
        PaymentDetailsScheme paymentDetailsScheme = null;
        if (paymentDetailsDTO.getScheme() != null) {
            paymentDetailsScheme = (PaymentDetailsScheme)PaymentDetailsSchemeSerializer.getInstance().deserialize(paymentDetailsDTO.getScheme());
        }
        PaymentDetailsSource paymentDetailsSource = null;
        if (paymentDetailsDTO.getSource() != null) {
            paymentDetailsSource = (PaymentDetailsSource)PaymentDetailsSourceSerializer.getInstance().deserialize(paymentDetailsDTO.getSource());
        }
        PaymentDetailsCustomerVerificationDetailed paymentDetailsCustomerVerificationDetailed = PaymentDetailsCustomerVerificationDetailed.UNKNOWN;
        if (paymentDetailsDTO.getCustomerVerification() != null && paymentDetailsDTO.getCustomerVerification().getType() != null) {
            paymentDetailsCustomerVerificationDetailed = this.createCustomerVerificationDetailedFromDTOString(paymentDetailsDTO.getCustomerVerification().getType());
        }
        String string = paymentDetailsDTO.getAdditionalCustomerVerification();
        try {
            additionalCustomerVerification = AdditionalCustomerVerification.valueOf((String)string);
        }
        catch (Exception exception) {
            additionalCustomerVerification = null;
        }
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)new DefaultPaymentDetailsFactory().createPaymentDetails(paymentDetailsScheme, paymentDetailsSource, paymentDetailsCustomerVerificationDetailed, transactionWorkflowType, additionalCustomerVerification);
        if (defaultPaymentDetails.sourceHasIccData()) {
            PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper(defaultPaymentDetails);
            IccInformation iccInformation = new IccInformation();
            paymentDetailsIccWrapper.setIccInformation(iccInformation);
            if (paymentDetailsDTO.getMaskedAccount() != null) {
                String string2 = CardHelper.maskAccountNumber(paymentDetailsDTO.getMaskedAccount());
                iccInformation.setMaskedAccountNumber(string2);
            }
            if (paymentDetailsDTO.getCardholderName() != null) {
                iccInformation.setCardholderName(paymentDetailsDTO.getCardholderName());
            }
            if (paymentDetailsDTO.getIccData() != null) {
                this.updatePaymentDetailsIccData(defaultPaymentDetails, paymentDetailsDTO);
            }
        } else if (defaultPaymentDetails.sourceHasMagstripeData()) {
            PaymentDetailsMagstripeWrapper paymentDetailsMagstripeWrapper = new PaymentDetailsMagstripeWrapper(defaultPaymentDetails);
            MagstripeInformation magstripeInformation = paymentDetailsMagstripeWrapper.getMagstripeInformation();
            if (magstripeInformation == null) {
                paymentDetailsMagstripeWrapper.setMagstripeInformation(new MagstripeInformation());
            }
            magstripeInformation = paymentDetailsMagstripeWrapper.getMagstripeInformation();
            if (paymentDetailsDTO.getMaskedAccount() != null) {
                String string3 = CardHelper.maskAccountNumber(paymentDetailsDTO.getMaskedAccount());
                magstripeInformation.setMaskedAccountNumber(string3);
            }
            if (paymentDetailsDTO.getCardholderName() != null) {
                magstripeInformation.setCardholderName(paymentDetailsDTO.getCardholderName());
            }
        } else if (defaultPaymentDetails.isAlternativePaymentMethod()) {
            PaymentDetailsAlternativePaymentMethodWrapper paymentDetailsAlternativePaymentMethodWrapper = new PaymentDetailsAlternativePaymentMethodWrapper(defaultPaymentDetails);
            if (paymentDetailsDTO.getMaskedAccount() != null) {
                paymentDetailsAlternativePaymentMethodWrapper.setAccountNumber(paymentDetailsDTO.getMaskedAccount());
            }
        } else if (defaultPaymentDetails.isMoto()) {
            PaymentDetailsManualInputWrapper paymentDetailsManualInputWrapper = new PaymentDetailsManualInputWrapper(defaultPaymentDetails);
            if (paymentDetailsDTO.getMaskedAccount() != null) {
                paymentDetailsManualInputWrapper.setCardData(new DefaultCardData(paymentDetailsDTO.getMaskedAccount()));
            }
        } else if (defaultPaymentDetails.sourceHasManualData()) {
            PaymentDetailsManualInputWrapper paymentDetailsManualInputWrapper = new PaymentDetailsManualInputWrapper(defaultPaymentDetails);
            if (paymentDetailsDTO.getMaskedAccount() != null) {
                paymentDetailsManualInputWrapper.setCardData(new DefaultCardData(paymentDetailsDTO.getMaskedAccount()));
            }
        }
        return defaultPaymentDetails;
    }

    public PaymentDetailsCustomerVerificationDetailed createCustomerVerificationDetailedFromDTOString(String verification) {
        PaymentDetailsCustomerVerificationDetailed paymentDetailsCustomerVerificationDetailed = (PaymentDetailsCustomerVerificationDetailed)((Object)PaymentDetailsCustomerVerificationDetailedSerializer.getInstance().deserialize(verification));
        if (paymentDetailsCustomerVerificationDetailed == null) {
            PaymentDetailsCustomerVerification paymentDetailsCustomerVerification = (PaymentDetailsCustomerVerification)PaymentDetailsCustomerVerificationSerializer.getInstance().deserialize(verification);
            if (paymentDetailsCustomerVerification != null) {
                switch (paymentDetailsCustomerVerification) {
                    case UNKNOWN: {
                        return PaymentDetailsCustomerVerificationDetailed.UNKNOWN;
                    }
                    case NONE: {
                        return PaymentDetailsCustomerVerificationDetailed.NONE;
                    }
                    case SIGNATURE: {
                        return PaymentDetailsCustomerVerificationDetailed.SIGNATURE;
                    }
                    case PIN: {
                        return PaymentDetailsCustomerVerificationDetailed.PIN_OFFLINE_PLAINTEXT;
                    }
                    case PIN_AND_SIGNATURE: {
                        return PaymentDetailsCustomerVerificationDetailed.PIN_OFFLINE_PLAINTEXT_AND_SIGNATURE;
                    }
                    case CUSTOMER_DEVICE: {
                        return PaymentDetailsCustomerVerificationDetailed.CUSTOMER_DEVICE;
                    }
                }
            }
            return PaymentDetailsCustomerVerificationDetailed.UNKNOWN;
        }
        return paymentDetailsCustomerVerificationDetailed;
    }

    public synchronized RefundDetails createRefundDetailsFromDTO(BackendRefundDetailsDTO refundDetailsDTO) {
        DefaultRefundDetails defaultRefundDetails = new DefaultRefundDetails();
        defaultRefundDetails.setRefundDetailsStatus((RefundDetailsStatus)RefundDetailsStatusSerializer.getInstance().deserialize(refundDetailsDTO.getStatus()));
        defaultRefundDetails.setRefundDetailsProcesses(this.createRefundDetailsProcesses(refundDetailsDTO.getProcess()));
        defaultRefundDetails.setRefundTransactions(this.createRefundTransactionList(refundDetailsDTO.getRefundTransactions()));
        return defaultRefundDetails;
    }

    public IncrementalAuthorizationDetails createIncrementalAuthorizationDetailsFromDTO(BackendIncrementalAuthorizationDetailsDTO incrementalAuthorizationDetailsDTO) {
        DefaultIncrementalAuthorizationDetails defaultIncrementalAuthorizationDetails = new DefaultIncrementalAuthorizationDetails();
        defaultIncrementalAuthorizationDetails.setIncrementTransactions(this.createIncrementalAuthorizationTransactionList(incrementalAuthorizationDetailsDTO.getIncrementalAuthorizationTransactions()));
        return defaultIncrementalAuthorizationDetails;
    }

    private DefaultAvsDetails createAvsDetailsFromDTO(BackendAvsDetailsDTO backendAvsDetailsDTO) {
        DefaultAvsDetails defaultAvsDetails = new DefaultAvsDetails();
        defaultAvsDetails.setStreet(backendAvsDetailsDTO.getStreet());
        defaultAvsDetails.setPostcode(backendAvsDetailsDTO.getZipCode());
        return defaultAvsDetails;
    }

    private BackendAvsDetailsDTO createAvsDetailsDTO(AvsDetails avsDetails) {
        BackendAvsDetailsDTO backendAvsDetailsDTO = new BackendAvsDetailsDTO();
        if (avsDetails != null) {
            backendAvsDetailsDTO.setStreet(avsDetails.getStreet());
            backendAvsDetailsDTO.setZipCode(avsDetails.getPostcode());
        }
        return backendAvsDetailsDTO;
    }

    private EnumSet<RefundDetailsProcess> createRefundDetailsProcesses(List<String> processes) {
        if (processes == null) {
            return null;
        }
        EnumSet<RefundDetailsProcess> enumSet = EnumSet.noneOf(RefundDetailsProcess.class);
        for (String string : processes) {
            enumSet.add((RefundDetailsProcess)RefundDetailsProcessSerializer.getInstance().deserialize(string));
        }
        return enumSet;
    }

    private DefaultTransactionVerificationResults createVerificationResultDetails(BackendTransactionVerificationResultsDTO verificationResult) {
        return new DefaultTransactionVerificationResults(MapperExtensionsKt.toTransactionVerificationResult((BackendTransactionVerificationResultDTO)verificationResult.getAvsZipCode()), MapperExtensionsKt.toTransactionVerificationResult((BackendTransactionVerificationResultDTO)verificationResult.getAvsStreet()), MapperExtensionsKt.toTransactionVerificationResult((BackendTransactionVerificationResultDTO)verificationResult.getCvv()));
    }

    private List<RefundTransaction> createRefundTransactionList(List<BackendRefundTransactionDTO> refundTransactionsDTO) {
        if (refundTransactionsDTO == null) {
            return new ArrayList<RefundTransaction>();
        }
        this.sortRefundTransactionsDTOListByCreatedDate(refundTransactionsDTO);
        ArrayList<RefundTransaction> arrayList = new ArrayList<RefundTransaction>();
        for (BackendRefundTransactionDTO backendRefundTransactionDTO : refundTransactionsDTO) {
            DefaultRefundTransaction defaultRefundTransaction = this.createRefundTransactionFromDTO(backendRefundTransactionDTO);
            if (defaultRefundTransaction == null) continue;
            arrayList.add(defaultRefundTransaction);
        }
        return arrayList;
    }

    private List<BackendRefundTransactionDTO> sortRefundTransactionsDTOListByCreatedDate(List<BackendRefundTransactionDTO> refundTransactionsDTO) {
        Collections.sort(refundTransactionsDTO, (o1, o2) -> {
            if (o1.getCreated() == null || o2.getCreated() == null) {
                return 0;
            }
            return o1.getCreated().compareTo(o2.getCreated());
        });
        return refundTransactionsDTO;
    }

    private DefaultRefundTransaction createRefundTransactionFromDTO(BackendRefundTransactionDTO refundTransactionDTO) {
        BackendStatusDetailsDTO backendStatusDetailsDTO;
        if (refundTransactionDTO == null) {
            return null;
        }
        DefaultRefundTransaction defaultRefundTransaction = new DefaultRefundTransaction();
        defaultRefundTransaction.setType((TransactionType)TransactionTypeSerializer.getInstance().deserialize(refundTransactionDTO.getType()));
        defaultRefundTransaction.setIdentifier(refundTransactionDTO.getIdentifier());
        defaultRefundTransaction.setAmount(refundTransactionDTO.getAmount());
        defaultRefundTransaction.setCurrency(MapperExtensionsKt.toCurrency((BackendCurrencyDTO)refundTransactionDTO.getCurrency()));
        defaultRefundTransaction.setStatus((TransactionStatus)TransactionStatusSerializer.getInstance().deserialize(refundTransactionDTO.getStatus()));
        defaultRefundTransaction.setCreatedTimestamp(refundTransactionDTO.getCreated().getTime());
        if (refundTransactionDTO.getTypeDetails() != null && refundTransactionDTO.getTypeDetails().getCode() != null) {
            defaultRefundTransaction.setCode((TransactionTypeDetailsCode)TransactionTypeDetailsCodeSerializer.getInstance().deserialize(refundTransactionDTO.getTypeDetails().getCode()));
        }
        if ((backendStatusDetailsDTO = refundTransactionDTO.getStatusDetails()) != null && backendStatusDetailsDTO.getDescription() != null) {
            defaultRefundTransaction.setStatusDetails(this.createTransactionStatusDetailsFromDTO(backendStatusDetailsDTO));
        }
        return defaultRefundTransaction;
    }

    private List<IncrementalAuthorizationTransaction> createIncrementalAuthorizationTransactionList(List<BackendIncrementalAuthorizationTransactionDTO> incrementalAuthorizationTransactionDTOs) {
        if (incrementalAuthorizationTransactionDTOs == null) {
            return new ArrayList<IncrementalAuthorizationTransaction>();
        }
        this.sortIncrementalAuthorizationTransactionDTOsByCreatedDate(incrementalAuthorizationTransactionDTOs);
        ArrayList<IncrementalAuthorizationTransaction> arrayList = new ArrayList<IncrementalAuthorizationTransaction>();
        for (BackendIncrementalAuthorizationTransactionDTO backendIncrementalAuthorizationTransactionDTO : incrementalAuthorizationTransactionDTOs) {
            DefaultIncrementalAuthorizationTransaction defaultIncrementalAuthorizationTransaction = this.createIncrementalAuthorizationTransactionFromDTO(backendIncrementalAuthorizationTransactionDTO);
            if (defaultIncrementalAuthorizationTransaction == null) continue;
            arrayList.add(defaultIncrementalAuthorizationTransaction);
        }
        return arrayList;
    }

    private void sortIncrementalAuthorizationTransactionDTOsByCreatedDate(List<BackendIncrementalAuthorizationTransactionDTO> authorizationTransactionDTOs) {
        Collections.sort(authorizationTransactionDTOs, (o1, o2) -> {
            if (o1.getCreated() == null || o2.getCreated() == null) {
                return 0;
            }
            return o1.getCreated().compareTo(o2.getCreated());
        });
    }

    private DefaultIncrementalAuthorizationTransaction createIncrementalAuthorizationTransactionFromDTO(BackendIncrementalAuthorizationTransactionDTO incrementalAuthorizationTransactionDTO) {
        if (incrementalAuthorizationTransactionDTO == null) {
            return null;
        }
        DefaultIncrementalAuthorizationTransaction defaultIncrementalAuthorizationTransaction = new DefaultIncrementalAuthorizationTransaction();
        defaultIncrementalAuthorizationTransaction.setIdentifier(incrementalAuthorizationTransactionDTO.getIdentifier());
        defaultIncrementalAuthorizationTransaction.setAmount(incrementalAuthorizationTransactionDTO.getAmount());
        defaultIncrementalAuthorizationTransaction.setCurrency(MapperExtensionsKt.toCurrency((BackendCurrencyDTO)incrementalAuthorizationTransactionDTO.getCurrency()));
        defaultIncrementalAuthorizationTransaction.setType(TransactionType.INCREMENTAL_AUTHORIZATION);
        defaultIncrementalAuthorizationTransaction.setCreatedTimestamp(incrementalAuthorizationTransactionDTO.getCreated().getTime());
        defaultIncrementalAuthorizationTransaction.setRefundDetails(this.createRefundDetailsFromDTO(incrementalAuthorizationTransactionDTO.getRefundDetails()));
        defaultIncrementalAuthorizationTransaction.setStatus((TransactionStatus)TransactionStatusSerializer.getInstance().deserialize(incrementalAuthorizationTransactionDTO.getStatus()));
        BackendStatusDetailsDTO backendStatusDetailsDTO = incrementalAuthorizationTransactionDTO.getStatusDetails();
        if (backendStatusDetailsDTO != null && backendStatusDetailsDTO.getDescription() != null) {
            defaultIncrementalAuthorizationTransaction.setStatusDetails(this.createTransactionStatusDetailsFromDTO(backendStatusDetailsDTO));
        }
        return defaultIncrementalAuthorizationTransaction;
    }

    private ClearingDetails createClearingDetailsFromDTO(BackendClearingDetailsDTO clearingDetailsDTO) {
        ei ei2 = new ei();
        ei2.d(clearingDetailsDTO.getAuthorizationCode());
        ei2.a(clearingDetailsDTO.getCompleted());
        ei2.a(clearingDetailsDTO.getInstitute());
        ei2.e(clearingDetailsDTO.getMerchantId());
        ei2.b(clearingDetailsDTO.getTransactionIdentifier());
        ei2.c(clearingDetailsDTO.getOriginalTransactionIdentifier());
        ei2.g(clearingDetailsDTO.getStatusText());
        ei2.f(clearingDetailsDTO.getTerminalId());
        return ei2;
    }

    private CardDetails createCardDetailsFromDTO(BackendCardDetailsDTO cardDetailsDTO) {
        DefaultCardDetails defaultCardDetails = new DefaultCardDetails();
        defaultCardDetails.setCardHolderName(cardDetailsDTO.getCardholderName());
        defaultCardDetails.setFingerprint(cardDetailsDTO.getFingerprint());
        defaultCardDetails.setMaskedCardNumber(cardDetailsDTO.getMaskedCardNumber());
        if (cardDetailsDTO.getScheme() != null) {
            defaultCardDetails.setScheme((PaymentDetailsScheme)PaymentDetailsSchemeSerializer.getInstance().deserialize(cardDetailsDTO.getScheme()));
        }
        defaultCardDetails.setCountryCodeNumeric(cardDetailsDTO.getCountryCodeNumber());
        defaultCardDetails.setExpiryMonth(cardDetailsDTO.getExpiryMonth());
        defaultCardDetails.setExpiryYear(cardDetailsDTO.getExpiryYear());
        return defaultCardDetails;
    }

    private ShopperDetails createShopperDetailsFromDTO(BackendShopperDetailsDTO shopperDetailsDTO) {
        DefaultShopperDetails defaultShopperDetails = new DefaultShopperDetails();
        defaultShopperDetails.setEmail(shopperDetailsDTO.getEmail());
        defaultShopperDetails.setIdentifier(shopperDetailsDTO.getIdentifier());
        return defaultShopperDetails;
    }

    private void updatePaymentDetailsIccData(DefaultPaymentDetails paymentDetails, BackendPaymentDetailsDTO paymentDetailsDTO) {
        byte[] byArray;
        TlvObject[] tlvObjectArray;
        PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper(paymentDetails);
        if (paymentDetailsDTO.getIccData().getArqc() != null && (tlvObjectArray = TLVHelper.deserializeFlatTlvObjects(byArray = ByteHelper.fromHexString(paymentDetailsDTO.getIccData().getArqc()))) != null) {
            paymentDetailsIccWrapper.setDataArqc(tlvObjectArray);
        }
        if (paymentDetailsDTO.getIccData().getArpc() != null && (tlvObjectArray = TLVHelper.deserializeFlatTlvObjects(byArray = ByteHelper.fromHexString(paymentDetailsDTO.getIccData().getArpc()))) != null) {
            paymentDetailsIccWrapper.setDataArpc(tlvObjectArray);
        }
        if (paymentDetailsDTO.getIccData().getAac() != null && (tlvObjectArray = TLVHelper.deserializeFlatTlvObjects(byArray = ByteHelper.fromHexString(paymentDetailsDTO.getIccData().getAac()))) != null) {
            paymentDetailsIccWrapper.setDataAac(tlvObjectArray);
        }
        if (paymentDetailsDTO.getIccData().getTc() != null && (tlvObjectArray = TLVHelper.deserializeFlatTlvObjects(byArray = ByteHelper.fromHexString(paymentDetailsDTO.getIccData().getTc()))) != null) {
            paymentDetailsIccWrapper.setDataTc(tlvObjectArray);
        }
    }

    public synchronized ProcessingDetails createProcessingDetailsFromDTO(BackendProcessingDetailsDTO processingDetailsDTO) {
        String string = processingDetailsDTO.getSessionIdentifier();
        String string2 = processingDetailsDTO.getIdentifier();
        String string3 = processingDetailsDTO.getTimestamp();
        return new DefaultProcessingDetails(string, string2, string3, null);
    }

    public synchronized ReceiptDetails createReceiptDetailsFromDTO(BackendReceiptDetailsDTO receiptDetailsDTO) {
        if (receiptDetailsDTO == null) {
            return null;
        }
        BackendReceiptDetailsEntityDTO backendReceiptDetailsEntityDTO = receiptDetailsDTO.getEmv();
        String string = backendReceiptDetailsEntityDTO.getApplicationID();
        String string2 = backendReceiptDetailsEntityDTO.getApplicationLabel();
        String string3 = receiptDetailsDTO.getAuthorizationCode();
        String string4 = backendReceiptDetailsEntityDTO.getTerminalVerificationResult();
        String string5 = backendReceiptDetailsEntityDTO.getTransactionStatusInformation();
        return new DefaultReceiptDetails(string, string2, string3, string4, string5);
    }

    public synchronized DefaultTransactionStatusDetails createTransactionStatusDetailsFromDTO(BackendStatusDetailsDTO statusDetailsDTO) {
        TransactionStatusDetailsCodes transactionStatusDetailsCodes = (TransactionStatusDetailsCodes)TransactionStatusDetailsCodesSerializer.getInstance().deserialize(statusDetailsDTO.getCode());
        String string = statusDetailsDTO.getDescription();
        String string2 = statusDetailsDTO.getDeveloperDescription();
        return new DefaultTransactionStatusDetails(transactionStatusDetailsCodes, string, string2);
    }

    public synchronized BackendTransactionRegistrationDTO createTransactionRegistrationDTOFromTransactionParameters(ProviderMode providerMode, TransactionParameters transactionParameters, AccessoryDetails accessoryDetails) {
        BackendTransactionRegistrationDTO backendTransactionRegistrationDTO = new BackendTransactionRegistrationDTO();
        backendTransactionRegistrationDTO.setAmount(transactionParameters.getAmount());
        if (transactionParameters.getCurrency() != null) {
            backendTransactionRegistrationDTO.setCurrency(new CurrencyWrapper(transactionParameters.getCurrency()).getIsoCode());
        }
        backendTransactionRegistrationDTO.setCustomIdentifier(transactionParameters.getCustomIdentifier());
        if (transactionParameters.getType() == TransactionType.CHARGE) {
            backendTransactionRegistrationDTO.setAutoCapture(Boolean.valueOf(transactionParameters.isAutoCapture()));
        }
        backendTransactionRegistrationDTO.setType(TransactionTypeSerializer.getInstance().serialize(transactionParameters.getType()));
        backendTransactionRegistrationDTO.setReferencedTransactionIdentifier(transactionParameters.getReferencedTransactionIdentifier());
        backendTransactionRegistrationDTO.setSubject(transactionParameters.getSubject());
        backendTransactionRegistrationDTO.setDetails(this.createTransactionDetailsDTOFromTransactionParameters(transactionParameters));
        backendTransactionRegistrationDTO.setReader(this.createBackendReaderDataDTO(accessoryDetails));
        if (transactionParameters.getWorkflow() != TransactionWorkflowType.UNKNOWN) {
            backendTransactionRegistrationDTO.setWorkflow(MapperExtensionsKt.toBackendTransactionWorkflowTypeDTO((TransactionWorkflowType)transactionParameters.getWorkflow()));
        }
        backendTransactionRegistrationDTO.setLocalTimeZone(TimeHelper.getCurrentTimeZoneString());
        if (providerMode.isLive()) {
            backendTransactionRegistrationDTO.setMode(ProviderMode.LIVE.name());
        } else {
            backendTransactionRegistrationDTO.setMode(ProviderMode.TEST.name());
        }
        return backendTransactionRegistrationDTO;
    }

    private BackendReaderDataDTO createBackendReaderDataDTO(AccessoryDetails accessoryDetails) {
        if (accessoryDetails != null && accessoryDetails.getSerialNumber() != null && !accessoryDetails.getSerialNumber().equals("") && accessoryDetails.getAccessoryType() != null) {
            return new BackendReaderDataDTO(accessoryDetails.getSerialNumber(), AccessoryTypeSerializer.getInstance().serialize(accessoryDetails.getAccessoryType()));
        }
        return null;
    }

    private BackendTransactionDetailsDTO createTransactionDetailsDTOFromTransactionParameters(TransactionParameters transactionParameters) {
        return new BackendTransactionDetailsDTO(transactionParameters.getIncludedTipAmount(), transactionParameters.getCashbackAmount(), transactionParameters.getMetadata(), null, transactionParameters.isTipAdjustable());
    }

    private synchronized BackendTransactionRegistrationDTO createTransactionRegistrationDTOFromTransaction(DefaultTransaction transaction) {
        BackendTransactionRegistrationDTO backendTransactionRegistrationDTO = new BackendTransactionRegistrationDTO();
        backendTransactionRegistrationDTO.setAmount(transaction.getAmount());
        backendTransactionRegistrationDTO.setCurrency(new CurrencyWrapper(transaction.getCurrency()).getIsoCode());
        backendTransactionRegistrationDTO.setCustomIdentifier(transaction.getCustomIdentifier());
        backendTransactionRegistrationDTO.setType(TransactionTypeSerializer.getInstance().serialize(transaction.getType()));
        backendTransactionRegistrationDTO.setSubject(transaction.getSubject());
        backendTransactionRegistrationDTO.setDetails(this.createTransactionDetailsDTOFromTransaction(transaction));
        return backendTransactionRegistrationDTO;
    }

    private BackendTransactionDetailsDTO createTransactionDetailsDTOFromTransaction(DefaultTransaction transaction) {
        BackendTransactionDetailsDTO backendTransactionDetailsDTO = new BackendTransactionDetailsDTO();
        if (transaction.getDetails() != null) {
            backendTransactionDetailsDTO.setIncludedTipAmount(transaction.getDetails().getIncludedTipAmount());
            backendTransactionDetailsDTO.setCashbackAmount(transaction.getDetails().getCashbackAmount());
            backendTransactionDetailsDTO.setMetadata(transaction.getDetails().getMetadata());
        }
        return backendTransactionDetailsDTO;
    }

    public synchronized BackendNotifyAccessoryWasUpdatedServicePayloadDTO.ComponentInformationDTO createComponentInformationDTOFromComponentInformation(eP componentInformation) {
        BackendNotifyAccessoryWasUpdatedServicePayloadDTO.ComponentInformationDTO componentInformationDTO = new BackendNotifyAccessoryWasUpdatedServicePayloadDTO.ComponentInformationDTO();
        componentInformationDTO.setServerVersion(componentInformation.b());
        componentInformationDTO.setUpdated(componentInformation.a());
        List<BackendNotifyAccessoryWasUpdatedServicePayloadDTO.ConfigurationInformationDTO> list = this.createConfigurationInformationDTOFromConfigurationInformation(componentInformation.c());
        componentInformationDTO.setItems(list);
        return componentInformationDTO;
    }

    private synchronized List<BackendNotifyAccessoryWasUpdatedServicePayloadDTO.ConfigurationInformationDTO> createConfigurationInformationDTOFromConfigurationInformation(ConfigurationItem[] items) {
        ArrayList<BackendNotifyAccessoryWasUpdatedServicePayloadDTO.ConfigurationInformationDTO> arrayList = new ArrayList<BackendNotifyAccessoryWasUpdatedServicePayloadDTO.ConfigurationInformationDTO>(items.length);
        for (ConfigurationItem configurationItem : items) {
            arrayList.add(this.createConfigurationInformationDTOFromConfigurationInformation(configurationItem));
        }
        return arrayList;
    }

    private synchronized BackendNotifyAccessoryWasUpdatedServicePayloadDTO.ConfigurationInformationDTO createConfigurationInformationDTOFromConfigurationInformation(ConfigurationItem information) {
        return new BackendNotifyAccessoryWasUpdatedServicePayloadDTO.ConfigurationInformationDTO(information.getName(), information.getVersion(), information.getHash(), information.getSignature());
    }

    public synchronized BackendNotifyAccessoryWasUpdatedServicePayloadDTO.EncryptionInformationDTO createEncryptionInformationDTOFromEncryptionInformation(eQ encryption) {
        BackendNotifyAccessoryWasUpdatedServicePayloadDTO.EncryptionInformationDTO encryptionInformationDTO = new BackendNotifyAccessoryWasUpdatedServicePayloadDTO.EncryptionInformationDTO();
        encryptionInformationDTO.setUpdated(encryption.a());
        LinkedList<String> linkedList = new LinkedList<String>();
        for (eQ.a a2 : encryption.b()) {
            linkedList.add(this.createKeyString(a2));
        }
        encryptionInformationDTO.setAvailable(linkedList);
        return encryptionInformationDTO;
    }

    private synchronized String createKeyString(eQ.a key) {
        switch (key) {
            case c: {
                return "GENERIC";
            }
            case b: {
                return "PIN";
            }
            case a: {
                return "SRED";
            }
        }
        return null;
    }

    public BackendCreateAndExecuteTransactionPayloadDTO createCreateAndExecuteTransactionPayloadDTO(DefaultTransaction transaction, AccountParameters accountParameters) {
        BackendCreateAndExecuteTransactionPayloadDTO backendCreateAndExecuteTransactionPayloadDTO = new BackendCreateAndExecuteTransactionPayloadDTO();
        backendCreateAndExecuteTransactionPayloadDTO.setTransaction(this.createCreateAndExecuteTransactionDTO(transaction, accountParameters));
        return backendCreateAndExecuteTransactionPayloadDTO;
    }

    private BackendRegisterAndExecuteTransactionDTO createCreateAndExecuteTransactionDTO(DefaultTransaction transaction, AccountParameters accountParameters) {
        BackendRegisterAndExecuteTransactionDTO backendRegisterAndExecuteTransactionDTO = new BackendRegisterAndExecuteTransactionDTO();
        backendRegisterAndExecuteTransactionDTO.setIdentifier(transaction.getIdentifier());
        backendRegisterAndExecuteTransactionDTO.setParameters(this.createTransactionRegistrationDTOFromTransaction(transaction));
        backendRegisterAndExecuteTransactionDTO.setAlternativePaymentMethod(this.createTransactionAlternativePaymentMethodDTO(accountParameters));
        if (transaction.getWorkflow() != TransactionWorkflowType.UNKNOWN) {
            backendRegisterAndExecuteTransactionDTO.setWorkflowType(MapperExtensionsKt.toBackendTransactionWorkflowTypeDTO((TransactionWorkflowType)transaction.getWorkflow()));
        }
        backendRegisterAndExecuteTransactionDTO.setReader(this.createBackendReaderDataDTO(transaction.getAccessoryDetails()));
        backendRegisterAndExecuteTransactionDTO.setLocalTimeZone(TimeHelper.getTimeZoneFromCreatedTimeZone((TimeZone)transaction.getCreatedTimeZone()));
        return backendRegisterAndExecuteTransactionDTO;
    }

    private BackendTransactionAlternativePaymentMethodDTO createTransactionAlternativePaymentMethodDTO(AccountParameters accountParameters) {
        BackendTransactionAlternativePaymentMethodDTO backendTransactionAlternativePaymentMethodDTO = new BackendTransactionAlternativePaymentMethodDTO();
        backendTransactionAlternativePaymentMethodDTO.setShopperAccountIdentifier(accountParameters.getShopperAccountIdentifier());
        backendTransactionAlternativePaymentMethodDTO.setScheme(MapperExtensionsKt.toBackendPaymentDetailsSchemeDTO((PaymentDetailsScheme)accountParameters.getScheme()));
        backendTransactionAlternativePaymentMethodDTO.setSource(MapperExtensionsKt.toBackendPaymentDetailsSourceDTO((PaymentDetailsSource)accountParameters.getSource()));
        return backendTransactionAlternativePaymentMethodDTO;
    }

    public synchronized BackendExecuteTransactionPayloadDTO createExecuteTransactionDTO(DefaultTransaction transaction, AccountParameters accountParameters) {
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)transaction.getPaymentDetails();
        BackendExecuteTransactionPayloadDTO backendExecuteTransactionPayloadDTO = new BackendExecuteTransactionPayloadDTO();
        if (!defaultPaymentDetails.isAlternativePaymentMethod() && !defaultPaymentDetails.isGiftCard()) {
            backendExecuteTransactionPayloadDTO.setCardPresent(this.createExecuteTransactionCardPresentDTO(transaction));
            backendExecuteTransactionPayloadDTO.setDcc(this.createDccStatusDTO(transaction));
        }
        if (defaultPaymentDetails.isMoto()) {
            PaymentDetailsManualInputWrapper paymentDetailsManualInputWrapper = new PaymentDetailsManualInputWrapper((DefaultPaymentDetails)transaction.getPaymentDetails());
            backendExecuteTransactionPayloadDTO.setAvs(this.createAvsDetailsDTO(paymentDetailsManualInputWrapper.getAvsDetails()));
        }
        if (defaultPaymentDetails.isEbt()) {
            backendExecuteTransactionPayloadDTO.setEbtDetails(this.ebtMapper.createEbtData(transaction));
        }
        if (defaultPaymentDetails.isAlternativePaymentMethod()) {
            backendExecuteTransactionPayloadDTO.setAlternativePaymentMethod(this.createTransactionAlternativePaymentMethodDTO(accountParameters));
        }
        if (transaction.getWorkflow() != TransactionWorkflowType.UNKNOWN) {
            backendExecuteTransactionPayloadDTO.setWorkflow(MapperExtensionsKt.toBackendTransactionWorkflowTypeDTO((TransactionWorkflowType)transaction.getWorkflow()));
        }
        if (defaultPaymentDetails.isGiftCard()) {
            backendExecuteTransactionPayloadDTO.setGiftCard(this.giftCardMapper.createGiftCardData(transaction));
            backendExecuteTransactionPayloadDTO.setEncryptedData(this.encryptedDataMapper.createEncryptedData(transaction));
            backendExecuteTransactionPayloadDTO.setReader(this.createBackendReaderDataDTO(transaction.getAccessoryDetails()));
        }
        if (transaction.getInteracAccountType() != null) {
            backendExecuteTransactionPayloadDTO.setInteracAccountType(transaction.getInteracAccountType().name());
        }
        if (transaction.getSelectedLanguage() != null) {
            backendExecuteTransactionPayloadDTO.setSelectedLanguage(transaction.getSelectedLanguage().toLanguageTag());
        }
        backendExecuteTransactionPayloadDTO.setLocalTimeZone(TimeHelper.getTimeZoneFromCreatedTimeZone((TimeZone)transaction.getCreatedTimeZone()));
        backendExecuteTransactionPayloadDTO.setShopperAidSelection(defaultPaymentDetails.getManualApplicationSelection());
        return backendExecuteTransactionPayloadDTO;
    }

    private BackendDccStatusDTO createDccStatusDTO(DefaultTransaction transaction) {
        if (transaction.getDccDetails() != null && transaction.getDccDetails().getStatus() != DccStatus.NOT_AVAILABLE) {
            BackendDccStatusDTO backendDccStatusDTO = new BackendDccStatusDTO();
            backendDccStatusDTO.setStatusDetails(MapperExtensionsKt.toBackendDccStatusDetailsDTO((DccStatusDetails)transaction.getDccDetails().getStatusDetails()));
            return backendDccStatusDTO;
        }
        return null;
    }

    public synchronized BackendExecuteTransactionCardPresentDTO createExecuteTransactionCardPresentDTO(DefaultTransaction transaction) {
        Object object;
        Object object2;
        Object object3;
        BackendExecuteTransactionCardPresentDTO backendExecuteTransactionCardPresentDTO = new BackendExecuteTransactionCardPresentDTO();
        backendExecuteTransactionCardPresentDTO.setMode(this.getSourceString(transaction.getPaymentDetails()));
        backendExecuteTransactionCardPresentDTO.setPaymentScheme(this.getSchemeString(transaction.getPaymentDetails()));
        if (transaction.getPaymentDetails() instanceof DefaultPaymentDetails && ((DefaultPaymentDetails)(object3 = (DefaultPaymentDetails)transaction.getPaymentDetails())).getMotoType() != null) {
            backendExecuteTransactionCardPresentDTO.setCardHolderPresence(this.getCardHolderPresenceType(((DefaultPaymentDetails)object3).getMotoType()));
        }
        if ((object3 = ((DefaultPaymentDetails)transaction.getPaymentDetails()).getCustomerVerificationDetailed()) != null) {
            object2 = PaymentDetailsCustomerVerificationDetailedSerializer.getInstance().serialize(object3);
            backendExecuteTransactionCardPresentDTO.setVerificationMethod((String)object2);
        }
        if ((object2 = ((DefaultPaymentDetails)transaction.getPaymentDetails()).getBypassedVerificationMethods()) != null && object2.size() != 0) {
            object = new HashSet();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                BypassedVerificationMethod bypassedVerificationMethod = (BypassedVerificationMethod)((Object)iterator.next());
                String string = BypassedVerificationMethodSerializer.getInstance().serialize(bypassedVerificationMethod);
                object.add(string);
            }
            backendExecuteTransactionCardPresentDTO.setBypassedVerificationMethods((Set)object);
        }
        object = this.createExecuteTransactionReaderDataDTO(transaction.getAccessoryDetails());
        backendExecuteTransactionCardPresentDTO.setReader((BackendExecuteTransactionReaderDataDTO)object);
        this.populateCardDataIntoExecuteTransactionCardPresentDTO(backendExecuteTransactionCardPresentDTO, transaction);
        return backendExecuteTransactionCardPresentDTO;
    }

    private synchronized void populateCardDataIntoExecuteTransactionCardPresentDTO(BackendExecuteTransactionCardPresentDTO dto, DefaultTransaction transaction) {
        if (transaction.getPaymentDetails().getSource() == null) {
            return;
        }
        switch (transaction.getPaymentDetails().getSource()) {
            case UNKNOWN: 
            case MANUAL: {
                this.populateManualCardDataIntoExecuteTransactionCardPresentDTO(dto, transaction);
                break;
            }
            case MAGNETIC_STRIPE: 
            case MAGNETIC_STRIPE_FALLBACK: {
                this.populateMagstripeCardDataIntoExecuteTransactionCardPresentDTO(dto, transaction);
                break;
            }
            case ICC: 
            case NFC_ICC: 
            case NFC_MAGSTRIPE: {
                this.populateIccCardDataIntoExecuteTransactionCardPresentDTO(dto, transaction);
            }
        }
    }

    private void populateManualCardDataIntoExecuteTransactionCardPresentDTO(BackendExecuteTransactionCardPresentDTO dto, DefaultTransaction transaction) {
        PaymentDetailsManualInputWrapper paymentDetailsManualInputWrapper = new PaymentDetailsManualInputWrapper((DefaultPaymentDetails)transaction.getPaymentDetails());
        DefaultCardData defaultCardData = paymentDetailsManualInputWrapper.getCardData();
        if (defaultCardData == null) {
            return;
        }
        dto.setSred(this.createExecuteTransactionEncryptedDataDTO(defaultCardData.getSred(), defaultCardData.getKsn()));
        dto.setMaskedAccountNumber(defaultCardData.getMaskedPan());
        dto.setExpiryMonth(defaultCardData.getExpiryMonth());
        dto.setExpiryYear(defaultCardData.getExpiryYear());
    }

    private synchronized void populateMagstripeCardDataIntoExecuteTransactionCardPresentDTO(BackendExecuteTransactionCardPresentDTO dto, DefaultTransaction transaction) {
        PaymentDetailsMagstripeWrapper paymentDetailsMagstripeWrapper = new PaymentDetailsMagstripeWrapper((DefaultPaymentDetails)transaction.getPaymentDetails());
        MagstripeInformation magstripeInformation = paymentDetailsMagstripeWrapper.getMagstripeInformation();
        if (magstripeInformation == null) {
            return;
        }
        dto.setSred(this.createExecuteTransactionEncryptedDataDTO(magstripeInformation.getSredData(), magstripeInformation.getSredKSN()));
        if (magstripeInformation.getPinData() != null && magstripeInformation.getPinKSN() != null) {
            dto.setPin(this.createExecuteTransactionEncryptedDataDTO(magstripeInformation.getPinData(), magstripeInformation.getPinKSN()));
        }
        if (magstripeInformation.getMacData() != null && magstripeInformation.getMacKSN() != null) {
            dto.setMac(this.createExecuteTransactionEncryptedDataDTO(magstripeInformation.getMacData(), magstripeInformation.getMacKSN()));
        }
        boolean bl2 = transaction.getPaymentDetails().getSource() == PaymentDetailsSource.MAGNETIC_STRIPE_FALLBACK;
        PaymentDetailsFallbackReason paymentDetailsFallbackReason = ((DefaultPaymentDetails)transaction.getPaymentDetails()).getFallbackReason();
        if (bl2 && paymentDetailsFallbackReason != PaymentDetailsFallbackReason.UNKNOWN) {
            dto.setFallbackReason(PaymentDetailsFallbackReasonSerializer.getInstance().serialize(paymentDetailsFallbackReason));
        }
        dto.setMaskedAccountNumber(magstripeInformation.getMaskedAccountNumber());
        dto.setMaskedTrack2(magstripeInformation.getMaskedTrack2());
    }

    private synchronized void populateIccCardDataIntoExecuteTransactionCardPresentDTO(BackendExecuteTransactionCardPresentDTO dto, DefaultTransaction transaction) {
        PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper((DefaultPaymentDetails)transaction.getPaymentDetails());
        dto.setIccData(this.createExecuteTransactionIccDataDTO(paymentDetailsIccWrapper));
        IccInformation iccInformation = paymentDetailsIccWrapper.getIccInformation();
        if (iccInformation == null) {
            return;
        }
        dto.setSred(this.createExecuteTransactionEncryptedDataDTO(iccInformation.getSredData(), iccInformation.getSredKSN()));
        if (iccInformation.getPinData() != null && iccInformation.getPinKSN() != null) {
            dto.setPin(this.createExecuteTransactionEncryptedDataDTO(iccInformation.getPinData(), iccInformation.getPinKSN()));
        }
        if (iccInformation.getMacData() != null && iccInformation.getMacKSN() != null) {
            dto.setMac(this.createExecuteTransactionEncryptedDataDTO(iccInformation.getMacData(), iccInformation.getMacKSN()));
        }
        dto.setMaskedAccountNumber(iccInformation.getMaskedAccountNumber());
        dto.setMaskedTrack2(iccInformation.getMaskedTrack2());
    }

    private synchronized BackendExecuteTransactionIccDataDTO createExecuteTransactionIccDataDTO(PaymentDetailsIccWrapper iccWrapper) {
        byte[] byArray;
        TlvObject[] tlvObjectArray;
        byte[] byArray2;
        TlvObject[] tlvObjectArray2;
        BackendExecuteTransactionIccDataDTO backendExecuteTransactionIccDataDTO = new BackendExecuteTransactionIccDataDTO();
        TlvObject[] tlvObjectArray3 = iccWrapper.getDataArqc();
        byte[] byArray3 = TLVHelper.serializeFlatTlvObjects(tlvObjectArray3);
        if (byArray3 != null) {
            tlvObjectArray2 = ByteHelper.toHexShortString(byArray3);
            backendExecuteTransactionIccDataDTO.setArqc((String)tlvObjectArray2);
        }
        if ((byArray2 = TLVHelper.serializeFlatTlvObjects(tlvObjectArray2 = iccWrapper.getDataAac())) != null) {
            tlvObjectArray = ByteHelper.toHexShortString(byArray2);
            backendExecuteTransactionIccDataDTO.setAac((String)tlvObjectArray);
        }
        if ((byArray = TLVHelper.serializeFlatTlvObjects(tlvObjectArray = iccWrapper.getDataTc())) != null) {
            String string = ByteHelper.toHexShortString(byArray);
            backendExecuteTransactionIccDataDTO.setTc(string);
        }
        return backendExecuteTransactionIccDataDTO;
    }

    private synchronized BackendExecuteTransactionReaderDataDTO createExecuteTransactionReaderDataDTO(AccessoryDetails details) {
        BackendExecuteTransactionReaderDataDTO backendExecuteTransactionReaderDataDTO = new BackendExecuteTransactionReaderDataDTO();
        DefaultAccessoryDetails defaultAccessoryDetails = (DefaultAccessoryDetails)details;
        backendExecuteTransactionReaderDataDTO.setSerialNumber(defaultAccessoryDetails.getSerialNumber());
        if (defaultAccessoryDetails.getAccessoryType() != AccessoryType.MOCK) {
            backendExecuteTransactionReaderDataDTO.setType(AccessoryTypeSerializer.getInstance().serialize(defaultAccessoryDetails.getAccessoryType()));
        } else {
            backendExecuteTransactionReaderDataDTO.setType(defaultAccessoryDetails.getType());
        }
        return backendExecuteTransactionReaderDataDTO;
    }

    private synchronized BackendExecuteTransactionEncryptedDataDTO createExecuteTransactionEncryptedDataDTO(String data, String ksn) {
        BackendExecuteTransactionEncryptedDataDTO backendExecuteTransactionEncryptedDataDTO = new BackendExecuteTransactionEncryptedDataDTO();
        backendExecuteTransactionEncryptedDataDTO.setData(data);
        backendExecuteTransactionEncryptedDataDTO.setKsn(ksn);
        return backendExecuteTransactionEncryptedDataDTO;
    }

    public synchronized BackendVoidFinalizeTransactionPayloadDTO createVoidFinalizeTransactionPayloadDTOFromTransaction(BaseTransaction transaction, boolean isVoid) {
        BackendVoidFinalizeTransactionPayloadDTO backendVoidFinalizeTransactionPayloadDTO = new BackendVoidFinalizeTransactionPayloadDTO();
        backendVoidFinalizeTransactionPayloadDTO.setTransaction(new BackendTransactionDTO());
        if (isVoid) {
            backendVoidFinalizeTransactionPayloadDTO.setReason(TransactionStatusDetailsCodesSerializer.getInstance().serialize(transaction.getStatusDetails().getCode()));
            backendVoidFinalizeTransactionPayloadDTO.getTransaction().setEncryptedData(this.createSredDataDTO(transaction));
        }
        backendVoidFinalizeTransactionPayloadDTO.getTransaction().setReceiptDetails(this.createBackendReceiptDetailsDTO(((DefaultTransaction)transaction).getReceiptDetails()));
        backendVoidFinalizeTransactionPayloadDTO.getTransaction().setPaymentDetails(this.createBackendPaymentDetailsDTO(transaction.getPaymentDetails(), isVoid));
        backendVoidFinalizeTransactionPayloadDTO.getTransaction().setLocalTimeZone(TimeHelper.getTimeZoneFromCreatedTimeZone((TimeZone)transaction.getCreatedTimeZone()));
        return backendVoidFinalizeTransactionPayloadDTO;
    }

    private synchronized BackendEncryptedDataDTO createSredDataDTO(BaseTransaction transaction) {
        return this.encryptedDataMapper.createEncryptedData((DefaultTransaction)transaction);
    }

    public synchronized BackendVoidFinalizeTransactionPayloadDTO createVoidFinalizeTransactionPayloadDTOForSessionIdentifierTransaction(TransactionStatusDetailsCodes code) {
        BackendVoidFinalizeTransactionPayloadDTO backendVoidFinalizeTransactionPayloadDTO = new BackendVoidFinalizeTransactionPayloadDTO();
        backendVoidFinalizeTransactionPayloadDTO.setReason(TransactionStatusDetailsCodesSerializer.getInstance().serialize(code));
        return backendVoidFinalizeTransactionPayloadDTO;
    }

    public synchronized BackendCaptureTransactionPayloadDTO createCaptureTransactionPayloadDTOFromTransactionParameters(TransactionParameters transactionParameters) {
        BackendCaptureTransactionPayloadDTO backendCaptureTransactionPayloadDTO = new BackendCaptureTransactionPayloadDTO();
        if (transactionParameters.getAmount() != null && transactionParameters.getCurrency() != null) {
            backendCaptureTransactionPayloadDTO.setAmount(transactionParameters.getAmount());
            backendCaptureTransactionPayloadDTO.setCurrency(new CurrencyWrapper(transactionParameters.getCurrency()).getIsoCode());
        }
        return backendCaptureTransactionPayloadDTO;
    }

    public synchronized BackendTipAdjustTransactionPayloadDTO createTipAdjustTransactionPayloadDTOFromTransactionParameters(TransactionParameters transactionParameters) {
        BackendTipAdjustTransactionPayloadDTO backendTipAdjustTransactionPayloadDTO = new BackendTipAdjustTransactionPayloadDTO();
        if (transactionParameters.getAmount() != null && transactionParameters.getCurrency() != null) {
            backendTipAdjustTransactionPayloadDTO.setAmount(transactionParameters.getAmount());
            backendTipAdjustTransactionPayloadDTO.setCurrency(new CurrencyWrapper(transactionParameters.getCurrency()).getIsoCode());
        }
        return backendTipAdjustTransactionPayloadDTO;
    }

    public BackendProvisionAccessoryPayloadDTO createProvisionAccessoryPayloadDTO(Accessory accessory) {
        BackendProvisionAccessoryPayloadDTO backendProvisionAccessoryPayloadDTO = new BackendProvisionAccessoryPayloadDTO();
        backendProvisionAccessoryPayloadDTO.setModel(AccessoryTypeSerializer.getInstance().serialize(accessory.getType()));
        backendProvisionAccessoryPayloadDTO.setSerialNo(accessory.getAccessoryDetails().getSerialNumber());
        return backendProvisionAccessoryPayloadDTO;
    }

    public synchronized BackendMetricsDTO createBackendMetricsDTO(Profiler profiler) {
        TippingParameters tippingParameters;
        BaseTransaction baseTransaction;
        ProviderOptions providerOptions;
        BackendMetricsDTO backendMetricsDTO = new BackendMetricsDTO();
        backendMetricsDTO.setStatus(profiler.getStatus().name());
        backendMetricsDTO.setStatusDetails(profiler.getStatusDetails());
        backendMetricsDTO.setReference(profiler.getReferenceTimestamp());
        backendMetricsDTO.setPhone(profiler.getPhoneInfo());
        List<Profiler.ProfilerItem> list = profiler.getProfileItems();
        for (Profiler.ProfilerItem object2 : list) {
            providerOptions = new BackendMetricsDTO.TracePoint(object2.getCategory().name(), object2.getAction().name(), object2.getTimepoint(), object2.getError(), object2.getInfo());
            backendMetricsDTO.addTracepoint((BackendMetricsDTO.TracePoint)providerOptions);
        }
        Accessory accessory = profiler.getAccessory();
        if (accessory != null) {
            BackendMetricsDTO.Accessory accessory2 = new BackendMetricsDTO.Accessory(accessory.getAccessoryDetails().getSerialNumber(), accessory.getType().toString(), profiler.getAccessoryIdentifier(), DTOConversionHelper.connectionTypeToString(accessory.getAccessoryParameters().getAccessoryConnectionType()));
            backendMetricsDTO.setAccessory(accessory2);
        }
        if ((baseTransaction = profiler.getTransaction()) != null) {
            providerOptions = new BackendMetricsDTO.Transaction(baseTransaction.getIdentifier(), baseTransaction.getSessionIdentifier());
            backendMetricsDTO.setTransaction((BackendMetricsDTO.Transaction)providerOptions);
            tippingParameters = baseTransaction.getTippingParameters();
            if (tippingParameters != null) {
                backendMetricsDTO = this.tippingToMetrics(backendMetricsDTO, tippingParameters);
            }
        }
        if ((providerOptions = profiler.getProvider().getProviderOptions()) != null) {
            tippingParameters = new BackendMetricsDTO.Provider(providerOptions.getProviderMode().toString(), providerOptions.getMerchantIdentifier());
            backendMetricsDTO.setProvider((BackendMetricsDTO.Provider)tippingParameters);
        }
        tippingParameters = new BackendMetricsDTO.MemoryUsage(profiler.getUsedMemory(), profiler.getFreeMemory());
        backendMetricsDTO.setMemoryUsage((BackendMetricsDTO.MemoryUsage)tippingParameters);
        List<String> list2 = profiler.getFeatureToggles();
        String string = DTOConversionHelper.integrationTypeToString(profiler.getIntegrationType());
        BackendMetricsDTO.SdkDetails sdkDetails = new BackendMetricsDTO.SdkDetails(list2, string);
        backendMetricsDTO.setSdkDetails(sdkDetails);
        return backendMetricsDTO;
    }

    private BackendMetricsDTO tippingToMetrics(BackendMetricsDTO retVal, TippingParameters tippingParameters) {
        String string;
        TippingParametersDTO tippingParametersDTO = new TippingParametersDTO();
        tippingParametersDTO.setShowTotalAmountConfirmationScreen(Boolean.valueOf(tippingParameters.isShowTotalAmountConfirmationScreen()));
        if (tippingParameters instanceof TippingParameters.BasicTippingParameters.Normal) {
            string = "NORMAL";
            tippingParametersDTO = this.addTippingParametersTippingNormal((TippingParameters.BasicTippingParameters)tippingParameters, tippingParametersDTO);
        } else if (tippingParameters instanceof TippingParameters.BasicTippingParameters.Total) {
            string = "TOTAL";
            tippingParametersDTO = this.addTippingParametersTippingNormal((TippingParameters.BasicTippingParameters)tippingParameters, tippingParametersDTO);
            TippingParameters.BasicTippingParameters.Total total = (TippingParameters.BasicTippingParameters.Total)tippingParameters;
            tippingParametersDTO.setZeroAmountDefaultsToTransactionAmount(Boolean.valueOf(total.isZeroAmountDefaultsToTransactionAmount()));
        } else if (tippingParameters instanceof TippingParameters.Percentage) {
            string = "PERCENTAGE";
            TippingParameters.Percentage percentage = (TippingParameters.Percentage)tippingParameters;
            tippingParametersDTO.setMinPercentage(percentage.getMinPercentage());
            tippingParametersDTO.setMaxPercentage(percentage.getMaxPercentage());
        } else if (tippingParameters instanceof TippingParameters.Fixed) {
            string = "FIXED";
            TippingParameters.Fixed fixed = (TippingParameters.Fixed)tippingParameters;
            tippingParametersDTO.setFixedPercentage(fixed.getFixedPercentage());
        } else if (tippingParameters instanceof TippingParameters.PercentageChoice) {
            string = "PERCENTAGE_CHOICE";
            TippingParameters.PercentageChoice percentageChoice = (TippingParameters.PercentageChoice)tippingParameters;
            tippingParametersDTO.setPercentage1(percentageChoice.getPercentage1());
            tippingParametersDTO.setPercentage2(percentageChoice.getPercentage2());
            tippingParametersDTO.setPercentage3(percentageChoice.getPercentage3());
            tippingParametersDTO = this.addTippingParametersTippingNormal((TippingParameters.BasicTippingParameters)percentageChoice.getCustomParameters(), tippingParametersDTO);
        } else {
            Log.w(TAG, "Tipping parameters type is not handled: " + tippingParameters);
            string = "UNKNOWN";
        }
        retVal.setTipping(new BackendMetricsDTO.Tipping(string, tippingParametersDTO));
        return retVal;
    }

    private TippingParametersDTO addTippingParametersTippingNormal(TippingParameters.BasicTippingParameters tippingParameters, TippingParametersDTO tippingParametersDTO) {
        AmountOrPercentage amountOrPercentage = tippingParameters.getSuggestedTip();
        if (amountOrPercentage instanceof AmountOrPercentage.Amount) {
            tippingParametersDTO.setSuggestedTipAmount(((AmountOrPercentage.Amount)amountOrPercentage).getAmount());
        } else if (amountOrPercentage instanceof AmountOrPercentage.Percentage) {
            tippingParametersDTO.setSuggestedTipPercentage(((AmountOrPercentage.Percentage)amountOrPercentage).getPercentage());
        }
        AmountOrPercentage amountOrPercentage2 = tippingParameters.getMaxTip();
        if (amountOrPercentage2 instanceof AmountOrPercentage.Amount) {
            tippingParametersDTO.setMaxTipAmount(((AmountOrPercentage.Amount)amountOrPercentage2).getAmount());
        } else if (amountOrPercentage2 instanceof AmountOrPercentage.Percentage) {
            tippingParametersDTO.setMaxTipPercentage(((AmountOrPercentage.Percentage)amountOrPercentage2).getPercentage());
        }
        tippingParametersDTO.setFractionDigits(tippingParameters.getFractionDigits());
        tippingParametersDTO.setDecimalDigits(tippingParameters.getIntegerDigits());
        tippingParametersDTO.setShowAddTipConfirmationScreen(Boolean.valueOf(tippingParameters.isShowAddTipConfirmationScreen()));
        return tippingParametersDTO;
    }

    private static String connectionTypeToString(AccessoryConnectionType type) {
        switch (type) {
            case BONJOUR: {
                return "BONJOUR";
            }
            case EXTERNAL_ACCESSORY: {
                return "BLUETOOTH";
            }
            case TCP: {
                return "TCP";
            }
            case SERIAL_PORT: {
                return "SERIAL";
            }
            case INTEGRATED: {
                return "INTEGRATED";
            }
        }
        return "UNKNOWN";
    }

    private static String integrationTypeToString(Profiler.IntegrationType type) {
        switch (type) {
            case ANDROID_PAYBUTTON: {
                return "ANDROID_PAYBUTTON";
            }
            case ANDROID_PAYBUTTON2: {
                return "ANDROID_PAYBUTTON2";
            }
            case PAYSERVER: {
                return "PAYSERVER";
            }
        }
        return "ANDROID_CUSTOM";
    }

    public synchronized BackendReceiptDetailsDTO createBackendReceiptDetailsDTO(ReceiptDetails details) {
        BackendReceiptDetailsDTO backendReceiptDetailsDTO = new BackendReceiptDetailsDTO();
        backendReceiptDetailsDTO.setAuthorizationCode(details.getAuthorizationCode());
        backendReceiptDetailsDTO.setEmv(new BackendReceiptDetailsEntityDTO());
        backendReceiptDetailsDTO.getEmv().setApplicationID(details.getApplicationId());
        backendReceiptDetailsDTO.getEmv().setApplicationLabel(details.getApplicationLabel());
        backendReceiptDetailsDTO.getEmv().setTransactionStatusInformation(details.getTransactionStatusInformation());
        backendReceiptDetailsDTO.getEmv().setTerminalVerificationResult(details.getTerminalVerificationResult());
        return backendReceiptDetailsDTO;
    }

    public synchronized BackendPaymentDetailsDTO createBackendPaymentDetailsDTO(PaymentDetails paymentDetails, boolean isVoid) {
        Object object;
        Object object2;
        Object object3;
        DefaultPaymentDetails defaultPaymentDetails;
        BackendPaymentDetailsDTO backendPaymentDetailsDTO = new BackendPaymentDetailsDTO();
        if (paymentDetails.getCustomerVerification() != null) {
            defaultPaymentDetails = new BackendCustomerVerificationDTO();
            defaultPaymentDetails.setType(PaymentDetailsCustomerVerificationSerializer.getInstance().serialize(paymentDetails.getCustomerVerification()));
            backendPaymentDetailsDTO.setCustomerVerification((BackendCustomerVerificationDTO)defaultPaymentDetails);
            if (((DefaultPaymentDetails)paymentDetails).requiresSignature()) {
                object3 = new BackendCustomerVerificationSignatureDTO();
                object2 = new PaymentDetailsSignatureWrapper((DefaultPaymentDetails)paymentDetails);
                object = ((PaymentDetailsSignatureWrapper)object2).getSignature() != null ? Base64.encodeToString((byte[])((PaymentDetailsSignatureWrapper)object2).getSignature(), (int)2) : null;
                object3.setImage((String)object);
                if (((PaymentDetailsSignatureWrapper)object2).getType() != PaymentDetailsSignatureWrapper.SignatureType.UNKNOWN) {
                    if (((PaymentDetailsSignatureWrapper)object2).getType() == PaymentDetailsSignatureWrapper.SignatureType.SKIPPED) {
                        object3.setType(PaymentDetailsSignatureWrapper.SignatureType.ON_RECEIPT.name());
                    } else {
                        object3.setType(((PaymentDetailsSignatureWrapper)object2).getType().name());
                    }
                }
                if (object3.getImage() != null || object3.getType() != null) {
                    defaultPaymentDetails.setSignature((BackendCustomerVerificationSignatureDTO)object3);
                }
            }
        }
        if ((defaultPaymentDetails = (DefaultPaymentDetails)paymentDetails).sourceHasIccData()) {
            object3 = new PaymentDetailsIccWrapper(paymentDetails);
            if (((PaymentDetailsIccWrapper)object3).getIccInformation() != null) {
                backendPaymentDetailsDTO.setMaskedTrack2(((PaymentDetailsIccWrapper)object3).getIccInformation().getMaskedTrack2());
                backendPaymentDetailsDTO.setMaskedAccount(((PaymentDetailsIccWrapper)object3).getIccInformation().getMaskedAccountNumber());
            }
        } else {
            object3 = new PaymentDetailsMagstripeWrapper(paymentDetails);
            if (((PaymentDetailsMagstripeWrapper)object3).getMagstripeInformation() != null) {
                backendPaymentDetailsDTO.setMaskedTrack2(((PaymentDetailsMagstripeWrapper)object3).getMagstripeInformation().getMaskedTrack2());
                backendPaymentDetailsDTO.setMaskedAccount(((PaymentDetailsMagstripeWrapper)object3).getMagstripeInformation().getMaskedAccountNumber());
            }
        }
        object3 = new PaymentDetailsIccWrapper((DefaultPaymentDetails)paymentDetails);
        object2 = new BackendPaymentDetailsIccDataDTO();
        if (isVoid) {
            byte[] byArray;
            object = TLVHelper.serializeFlatTlvObjects(((PaymentDetailsIccWrapper)object3).getDataAac());
            if (object != null) {
                object2.setAac(ByteHelper.toHexShortString(object));
            }
            if ((byArray = TLVHelper.serializeFlatTlvObjects(((PaymentDetailsIccWrapper)object3).getDataArqc())) != null) {
                object2.setArqc(ByteHelper.toHexShortString(byArray));
            }
            backendPaymentDetailsDTO.setSource(this.getSourceString(paymentDetails));
            backendPaymentDetailsDTO.setScheme(this.getSchemeString(paymentDetails));
        } else if (((PaymentDetailsIccWrapper)object3).getDataTc() != null && (object = TLVHelper.serializeFlatTlvObjects(((PaymentDetailsIccWrapper)object3).getDataTc())) != null) {
            String string = ByteHelper.toHexShortString(object);
            object2.setTc(string);
        }
        object = ((DefaultPaymentDetails)paymentDetails).getAdditionalCustomerVerification();
        backendPaymentDetailsDTO.setAdditionalCustomerVerification(object != null ? object.toString() : null);
        backendPaymentDetailsDTO.setIccData((BackendPaymentDetailsIccDataDTO)object2);
        return backendPaymentDetailsDTO;
    }

    private String getSourceString(PaymentDetails paymentDetails) {
        PaymentDetailsSource paymentDetailsSource = paymentDetails.getSource();
        if (paymentDetailsSource != null && !paymentDetailsSource.equals((Object)PaymentDetailsSource.UNKNOWN)) {
            return PaymentDetailsSourceSerializer.getInstance().serialize(paymentDetailsSource);
        }
        return null;
    }

    private String getSchemeString(PaymentDetails paymentDetails) {
        PaymentDetailsScheme paymentDetailsScheme = paymentDetails.getScheme();
        if (paymentDetailsScheme != null && !paymentDetailsScheme.equals((Object)PaymentDetailsScheme.UNKNOWN)) {
            return PaymentDetailsSchemeSerializer.getInstance().serialize(paymentDetailsScheme);
        }
        return null;
    }

    public synchronized Set<WhitelistAccessory> createWhitelistAccessoriesFromBackendWhitelistReadersDTO(List<BackendWhitelistReaderDTO> readers) {
        LinkedHashSet<WhitelistAccessory> linkedHashSet = new LinkedHashSet<WhitelistAccessory>();
        if (readers == null) {
            return linkedHashSet;
        }
        for (BackendWhitelistReaderDTO backendWhitelistReaderDTO : readers) {
            List<WhitelistAccessoryRequirement> list;
            String string = backendWhitelistReaderDTO.getIdentifier();
            String string2 = backendWhitelistReaderDTO.getStatus();
            AccessoryType accessoryType = (AccessoryType)AccessoryTypeSerializer.getInstance().deserialize(backendWhitelistReaderDTO.getModel());
            BackendWhitelistReaderDetailsDTO backendWhitelistReaderDetailsDTO = backendWhitelistReaderDTO.getDetails();
            String string3 = backendWhitelistReaderDetailsDTO.getSerialNo();
            String string4 = backendWhitelistReaderDetailsDTO.getTransactionCounter();
            WhitelistAccessory whitelistAccessory = new WhitelistAccessory(string3, string2, string, accessoryType, null, string4);
            if (backendWhitelistReaderDetailsDTO.getRequiredSoftware() != null && backendWhitelistReaderDetailsDTO.getRequiredSoftware().getVersion() != null) {
                whitelistAccessory.setSoftwareVersion(backendWhitelistReaderDetailsDTO.getRequiredSoftware().getVersion());
                if (backendWhitelistReaderDetailsDTO.getRequiredSoftware().getFiles() != null && (list = this.createWhitelistAccessoryRequirementsFromBackendDTO(backendWhitelistReaderDetailsDTO.getRequiredSoftware().getFiles())) != null) {
                    for (WhitelistAccessoryRequirement whitelistAccessoryRequirement : list) {
                        whitelistAccessory.addSoftwareRequirement(whitelistAccessoryRequirement);
                    }
                }
            }
            if (backendWhitelistReaderDetailsDTO.getRequiredConfiguration() != null && backendWhitelistReaderDetailsDTO.getRequiredConfiguration().getFiles() != null) {
                whitelistAccessory.setConfigurationVersion(backendWhitelistReaderDetailsDTO.getRequiredConfiguration().getVersion());
                list = this.createWhitelistAccessoryRequirementsFromBackendDTO(backendWhitelistReaderDetailsDTO.getRequiredConfiguration().getFiles());
                if (list != null) {
                    for (WhitelistAccessoryRequirement whitelistAccessoryRequirement : list) {
                        whitelistAccessory.addConfigRequirement(whitelistAccessoryRequirement);
                    }
                }
            }
            if (backendWhitelistReaderDetailsDTO.getRequiredFirmware() != null && backendWhitelistReaderDetailsDTO.getRequiredFirmware().getFiles() != null) {
                whitelistAccessory.setFirmwareVersion(backendWhitelistReaderDetailsDTO.getRequiredFirmware().getVersion());
                list = this.createWhitelistAccessoryRequirementsFromBackendDTO(backendWhitelistReaderDetailsDTO.getRequiredFirmware().getFiles());
                if (list != null) {
                    for (WhitelistAccessoryRequirement whitelistAccessoryRequirement : list) {
                        whitelistAccessory.addFirmwareRequirement(whitelistAccessoryRequirement);
                    }
                }
            }
            if (backendWhitelistReaderDetailsDTO.getTerminalIds() != null) {
                list = new HashMap();
                for (Map.Entry entry : backendWhitelistReaderDetailsDTO.getTerminalIds().entrySet()) {
                    PaymentDetailsScheme paymentDetailsScheme = (PaymentDetailsScheme)PaymentDetailsSchemeSerializer.getInstance().deserialize((String)entry.getKey());
                    ((HashMap)((Object)list)).put(paymentDetailsScheme, (String)entry.getValue());
                }
                whitelistAccessory.setTerminalIds((HashMap<PaymentDetailsScheme, String>)((Object)list));
            }
            list = backendWhitelistReaderDetailsDTO.getEncryptionStatus();
            whitelistAccessory.setEncryptionStatus((WhitelistAccessory.EncryptionStatus)((Object)WhitelistAccessorySerializers.getEncryptionStatusSerializer().deserialize((String)((Object)list))));
            Iterator<WhitelistAccessoryRequirement> iterator = backendWhitelistReaderDetailsDTO.getUpdateStatus();
            whitelistAccessory.setUpdateStatus((WhitelistAccessory.UpdateStatus)((Object)WhitelistAccessorySerializers.getUpdateStatusSerializer().deserialize((String)((Object)iterator))));
            List object2 = backendWhitelistReaderDetailsDTO.getRequiredEncryption();
            whitelistAccessory.setRequiredEncryption(this.createRequiredEncryptionsFromStrings(object2));
            linkedHashSet.add(whitelistAccessory);
        }
        return linkedHashSet;
    }

    private EnumSet<WhitelistAccessory.RequiredEncryption> createRequiredEncryptionsFromStrings(List<String> requiredEncryption) {
        EnumSet<WhitelistAccessory.RequiredEncryption> enumSet = EnumSet.noneOf(WhitelistAccessory.RequiredEncryption.class);
        if (requiredEncryption == null) {
            return enumSet;
        }
        for (String string : requiredEncryption) {
            enumSet.add((WhitelistAccessory.RequiredEncryption)((Object)WhitelistAccessorySerializers.getRequiredEncryptionSerializer().deserialize(string)));
        }
        return enumSet;
    }

    public synchronized BackendGenerateKeysAccessoryServicePayloadDTO createGenerateKeysAccessoryServicePayloadFromWrapper(AccessoryKeysWrapper wrapper) {
        BackendGenerateKeysAccessoryServicePayloadDTO backendGenerateKeysAccessoryServicePayloadDTO = new BackendGenerateKeysAccessoryServicePayloadDTO();
        Certificate certificate = new Certificate();
        certificate.setProductSigning(wrapper.getProductSigning());
        certificate.setTerminal(wrapper.getTerminal());
        certificate.setTemporaryKeyLoading(wrapper.getTemporaryKeyLoading());
        backendGenerateKeysAccessoryServicePayloadDTO.setCertificates(certificate);
        backendGenerateKeysAccessoryServicePayloadDTO.setIksn(wrapper.getIksn());
        return backendGenerateKeysAccessoryServicePayloadDTO;
    }

    public synchronized AccessoryKeys createAccessoryKeysFromGenerateAccessoryServiceResponse(BackendGenerateKeysAccessoryServiceResponseDTO response) {
        KeyIksn keyIksn;
        AccessoryKeys accessoryKeys = new AccessoryKeys();
        accessoryKeys.setHsmPublicKey(response.getData().getHsmPublicKey());
        KeyIksn keyIksn2 = response.getData().getSred();
        if (keyIksn2 != null) {
            accessoryKeys.setSredKey(Helper.decodeBase64AsBytes(keyIksn2.getKey()));
            accessoryKeys.setSredIksn(response.getData().getSred().getIksn());
            if (keyIksn2.getTerminalManagement() != null) {
                accessoryKeys.setSredTerminalManagementKey(Helper.decodeBase64AsBytes(keyIksn2.getTerminalManagement().getKey()));
                accessoryKeys.setSredTerminalManagementSignature(Helper.decodeBase64AsBytes(keyIksn2.getTerminalManagement().getSignature()));
            }
        }
        if ((keyIksn = response.getData().getPin()) != null) {
            accessoryKeys.setPinKey(Helper.decodeBase64AsBytes(keyIksn.getKey()));
            accessoryKeys.setPinIksn(response.getData().getPin().getIksn());
            if (keyIksn.getTerminalManagement() != null) {
                accessoryKeys.setPinTerminalManagementKey(Helper.decodeBase64AsBytes(keyIksn.getTerminalManagement().getKey()));
                accessoryKeys.setPinTerminalManagementSignature(Helper.decodeBase64AsBytes(keyIksn.getTerminalManagement().getSignature()));
            }
        }
        return accessoryKeys;
    }

    public synchronized AccessoryKeys createAccessoryKeysFromGetKeysAccessoryServiceResponse(BackendGetKeysAccessoryServiceResponseDTO response) {
        AccessoryKeys accessoryKeys = new AccessoryKeys();
        ArrayList<AccessoryFile> arrayList = new ArrayList<AccessoryFile>();
        for (Map.Entry entry : response.getData().getFiles().entrySet()) {
            String string = (String)entry.getKey();
            MultiBuffer multiBuffer = ((BackendAccessoryFileDTO)entry.getValue()).getData();
            arrayList.add(new AccessoryFile(string, multiBuffer));
        }
        accessoryKeys.setKeyFiles(arrayList);
        return accessoryKeys;
    }

    public synchronized String createPaymentDetailsSchemeString(PaymentDetailsScheme scheme) {
        if (PaymentDetailsScheme.UNKNOWN.equals((Object)scheme)) {
            return "UNKNOWN";
        }
        String string = new PaymentDetailsSchemesContainer(scheme).getKey();
        if (string == null) {
            Log.w(TAG, "no string representation for PaymentDetailsScheme " + scheme);
        }
        return string;
    }

    public synchronized MposError createMposError(BackendErrorDTO backendError) {
        String cfr_ignored_0 = "Creating MposError for backendError: " + backendError;
        switch (backendError.getError().getErrorCode()) {
            case "5201": {
                return new DefaultMposError(ErrorType.SERVER_PAYLOAD_EXCEEDED, backendError.getError().getErrorDescription());
            }
            case "5202": {
                return new DefaultMposError(ErrorType.SERVER_STOP_ACTION, backendError.getError().getErrorDescription());
            }
            case "5001": {
                return new DefaultMposError(ErrorType.SERVER_AUTHENTICATION_FAILED, backendError.getError().getErrorDescription());
            }
            case "5122": {
                return new DefaultMposError(ErrorType.SERVER_UNKNOWN_USERNAME, backendError.getError().getErrorDescription());
            }
            case "5522": 
            case "5523": {
                return new DefaultMposError(ErrorType.TRANSACTION_ERROR_ALREADY_REFUNDED, backendError.getError().getErrorDescription());
            }
            case "5525": {
                return new DefaultMposError(ErrorType.TRANSACTION_ERROR_ALREADY_CAPTURED, backendError.getError().getErrorDescription());
            }
            case "5528": {
                return new DefaultMposError(ErrorType.TRANSACTION_ERROR_PARTIAL_REFUND_UNAVAILABLE, backendError.getError().getErrorDescription());
            }
            case "5532": {
                return new DefaultMposError(ErrorType.TRANSACTION_ERROR_TIP_CANNOT_BE_ADJUSTED, backendError.getError().getErrorDescription());
            }
            case "5533": {
                return new DefaultMposError(ErrorType.TRANSACTION_ERROR_TIP_ALREADY_ADJUSTED, backendError.getError().getErrorDescription());
            }
            case "5534": {
                return new DefaultMposError(ErrorType.TRANSACTION_ERROR_TIP_AMOUNT_EXCEEDS, backendError.getError().getErrorDescription());
            }
            case "5527": 
            case "5529": {
                return new DefaultMposError(ErrorType.TRANSACTION_DECLINED, backendError.getError().getErrorDescription());
            }
            case "5591": {
                return new DefaultMposError(ErrorType.INCREMENTAL_AUTH_NOT_POSSIBLE, backendError.getError().getErrorDescription());
            }
            case "5592": {
                return new DefaultMposError(ErrorType.TRANSACTION_DECLINED_CAPTURE_EXCEEDS_AUTHORIZED, backendError.getError().getErrorDescription());
            }
            case "5593": {
                return new DefaultMposError(ErrorType.INCREMENTAL_AUTH_NOT_SUPPORTED_BY_CARD, backendError.getError().getErrorDescription());
            }
            case "5031": {
                return new DefaultMposError(ErrorType.TRANSACTION_SESSION_EXPIRED, backendError.getError().getErrorDescription());
            }
            case "5030": 
            case "5154": 
            case "5563": {
                return new DefaultMposError(ErrorType.SDK_FEATURE_NOT_ENABLED, backendError.getError().getErrorDescription());
            }
            case "5567": {
                return new DefaultMposError(ErrorType.TRANSACTION_ERROR_REFUND_NOT_SUPPORTED, backendError.getError().getErrorDescription());
            }
            case "5211": 
            case "5148": 
            case "5813": {
                return new DefaultMposError(ErrorType.ACCESSORY_NOT_WHITELISTED, backendError.getError().getErrorDescription());
            }
            case "5541": {
                return new DefaultMposError(ErrorType.ACCESSORY_DEACTIVATED, backendError.getError().getErrorDescription());
            }
            case "5176": {
                return new DefaultMposError(ErrorType.SERVER_OFFLINE_BATCH_MALFORMED, backendError.getError().getErrorDescription());
            }
            case "5100": {
                return new DefaultMposError(ErrorType.TRANSACTION_ERROR_INVALID_TRANSACTION_REQUEST, backendError.getError().getErrorDescription());
            }
        }
        return new DefaultMposError(ErrorType.SERVER_ERROR, backendError.getError().getErrorDescription());
    }

    public synchronized List<WhitelistAccessoryRequirement> createWhitelistAccessoryRequirementsFromBackendDTO(Map<String, BackendAccessoryFileDTO> files) {
        ArrayList<WhitelistAccessoryRequirement> arrayList = new ArrayList<WhitelistAccessoryRequirement>();
        for (Map.Entry<String, BackendAccessoryFileDTO> entry : files.entrySet()) {
            WhitelistAccessoryRequirement whitelistAccessoryRequirement = new WhitelistAccessoryRequirement(entry.getKey());
            BackendAccessoryFileDTO backendAccessoryFileDTO = entry.getValue();
            whitelistAccessoryRequirement.setData(backendAccessoryFileDTO.getData());
            whitelistAccessoryRequirement.setMd5(backendAccessoryFileDTO.getMd5());
            whitelistAccessoryRequirement.setSha256(backendAccessoryFileDTO.getSha256());
            whitelistAccessoryRequirement.setSignature(Helper.decodeBase64AsBytes(backendAccessoryFileDTO.getSignature()));
            whitelistAccessoryRequirement.setVersion(backendAccessoryFileDTO.getVersion());
            arrayList.add(whitelistAccessoryRequirement);
        }
        return arrayList;
    }

    public synchronized ProcessingOptionsContainer createProcessingOptionsFromProcessingOptionsDTO(BackendProcessingOptionsDTO optionsDTO) {
        Object object;
        Object object2;
        Object object3;
        ProcessingOptionsContainer processingOptionsContainer = new ProcessingOptionsContainer();
        if (optionsDTO == null) {
            return processingOptionsContainer;
        }
        Map map = optionsDTO.getDefaults();
        if (map != null) {
            object3 = map.entrySet().iterator();
            while (object3.hasNext()) {
                object2 = (Map.Entry)object3.next();
                PaymentDetailsSource object4 = (PaymentDetailsSource)PaymentDetailsSourceSerializer.getInstance().deserialize((String)object2.getKey());
                if (object4 == null) continue;
                processingOptionsContainer.addDefaultProcessingOptions(object4, this.createProcessingOptionsFromBackendProcessingOptionsDTO((BackendProcessingOptionsDTO.BackendProcessingOptionsSchemeDTO)object2.getValue()));
            }
        }
        if ((object3 = optionsDTO.getSchemes()) != null) {
            for (Map.Entry entry : object3.entrySet()) {
                object = (PaymentDetailsScheme)PaymentDetailsSchemeSerializer.getInstance().deserialize((String)entry.getKey());
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    PaymentDetailsSource paymentDetailsSource = (PaymentDetailsSource)PaymentDetailsSourceSerializer.getInstance().deserialize((String)entry2.getKey());
                    processingOptionsContainer.addSchemeProcessingOptions((PaymentDetailsScheme)object, paymentDetailsSource, this.createProcessingOptionsFromBackendProcessingOptionsDTO((BackendProcessingOptionsDTO.BackendProcessingOptionsSchemeDTO)entry2.getValue()));
                }
            }
        }
        if (optionsDTO.getBehavior() != null) {
            for (String string : optionsDTO.getBehavior()) {
                object = (ProcessingOptions.Behavior)((Object)ProcessingOptionsSerializers.getBehaviorSerializer().deserialize(string));
                if (object == null) continue;
                processingOptionsContainer.addAccessoryBehavior((ProcessingOptions.Behavior)((Object)object));
            }
        }
        if (optionsDTO.getFeatures() != null) {
            for (String string : optionsDTO.getFeatures()) {
                object = (ProcessingOptions.Feature)((Object)ProcessingOptionsSerializers.getFeatureSerializer().deserialize(string));
                if (object == null) continue;
                processingOptionsContainer.addFeature((ProcessingOptions.Feature)((Object)object));
            }
        }
        if (optionsDTO.getAidConstraints() != null) {
            object2 = this.aidConstraintsMapper.createPriorities(optionsDTO.getAidConstraints());
            processingOptionsContainer.setAidConstraints((cy)object2);
        }
        processingOptionsContainer.setBlockedTransactionTypesPerScheme(this.convertBlockedTransactionTypes(optionsDTO));
        return processingOptionsContainer;
    }

    private Map<TransactionType, Set<PaymentDetailsScheme>> convertBlockedTransactionTypes(BackendProcessingOptionsDTO optionsDTO) {
        HashMap<TransactionType, Set<PaymentDetailsScheme>> hashMap = new HashMap<TransactionType, Set<PaymentDetailsScheme>>();
        if (optionsDTO.getBlockedTransactionTypes() == null) {
            return hashMap;
        }
        for (Map.Entry entry : optionsDTO.getBlockedTransactionTypes().entrySet()) {
            TransactionType transactionType = (TransactionType)TransactionTypeSerializer.getInstance().deserialize((String)entry.getKey());
            HashSet<PaymentDetailsScheme> hashSet = new HashSet<PaymentDetailsScheme>();
            for (String string : (Set)entry.getValue()) {
                PaymentDetailsScheme paymentDetailsScheme = (PaymentDetailsScheme)PaymentDetailsSchemeSerializer.getInstance().deserialize(string);
                hashSet.add(paymentDetailsScheme);
            }
            hashMap.put(transactionType, hashSet);
        }
        return hashMap;
    }

    protected ProcessingOptions createProcessingOptionsFromBackendProcessingOptionsDTO(BackendProcessingOptionsDTO.BackendProcessingOptionsSchemeDTO schemeDTO) {
        ProcessingOptions processingOptions = new ProcessingOptions();
        processingOptions.setCvm((ProcessingOptions.CVM)((Object)ProcessingOptionsSerializers.getCVMSerializer().deserialize(schemeDTO.getCvm())));
        if (schemeDTO.getNoCvmLimit() != null) {
            processingOptions.setNoCvmLimit(schemeDTO.getNoCvmLimit());
        }
        if (schemeDTO.isCoBrandingSupported() != null) {
            processingOptions.setCoBrandingSupported(schemeDTO.isCoBrandingSupported());
        }
        processingOptions.setStatus((ProcessingOptions.Status)((Object)ProcessingOptionsSerializers.getStatusSerializer().deserialize(schemeDTO.getStatus())));
        if (schemeDTO.getFallback() != null) {
            processingOptions.setFallbackStatus((ProcessingOptions.Status)((Object)ProcessingOptionsSerializers.getStatusSerializer().deserialize(schemeDTO.getFallback().getStatus())));
            processingOptions.setFallbackRequiredRetries(schemeDTO.getFallback().getRequiredRetries());
        }
        return processingOptions;
    }

    private synchronized ej createReceiptFromBackendTransactionReceiptDTO(BackendTransactionReceiptDTO receiptDTO) {
        ReceiptLineItemKey receiptLineItemKey;
        if (receiptDTO == null) {
            return null;
        }
        ej ej2 = new ej();
        ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.RECEIPT_TYPE, receiptDTO.getReceiptType()));
        ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.TRANSACTION_TYPE, receiptDTO.getTransactionType()));
        ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.IDENTIFIER, receiptDTO.getIdentifier()));
        if (receiptDTO.getAmountAndCurrency() != null) {
            if (receiptDTO.getCashbackAmountAndCurrency() == null) {
                ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.AMOUNT_AND_CURRENCY, receiptDTO.getAmountAndCurrency()));
            } else {
                ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.TOTAL_AMOUNT_AND_CURRENCY, receiptDTO.getTotalAmountAndCurrency()));
                ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.PURCHASE_AMOUNT_AND_CURRENCY, receiptDTO.getPurchaseAmountAndCurrency()));
                ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.CASHBACK_AMOUNT_AND_CURRENCY, receiptDTO.getCashbackAmountAndCurrency()));
            }
        }
        ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.DATE, receiptDTO.getDate()));
        ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.TIME, receiptDTO.getTime()));
        ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.STATUS_TEXT, receiptDTO.getStatusText()));
        ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.SUBJECT, receiptDTO.getSubject()));
        this.addTipInformation(ej2, receiptDTO);
        if (receiptDTO.getDccConversionRate() != null) {
            ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.DCC_CONVERSION_RATE, receiptDTO.getDccConversionRate()));
        }
        if (receiptDTO.getDccConvertedAmountAndCurrency() != null) {
            ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.DCC_CONVERTED_AMOUNT_AND_CURRENCY, receiptDTO.getDccConvertedAmountAndCurrency()));
        }
        if (receiptDTO.getDccDisclaimer() != null) {
            ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.DCC_DISCLAIMER, receiptDTO.getDccDisclaimer()));
        }
        if (receiptDTO.getDccMarkup() != null) {
            ej2.a(this.createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey.DCC_MARKUP, receiptDTO.getDccMarkup()));
        }
        for (BackendReceiptLineItemDTO backendReceiptLineItemDTO : receiptDTO.getMerchantDetails()) {
            receiptLineItemKey = ReceiptLineItemKeySerializer.INSTANCE.deserialize(backendReceiptLineItemDTO.getKey());
            ej2.d(this.createReceiptLineItemFromBackendReceiptLineItemDTO(receiptLineItemKey, backendReceiptLineItemDTO));
        }
        for (BackendReceiptLineItemDTO backendReceiptLineItemDTO : receiptDTO.getClearingDetails()) {
            receiptLineItemKey = ReceiptLineItemKeySerializer.INSTANCE.deserialize(backendReceiptLineItemDTO.getKey());
            ej2.b(this.createReceiptLineItemFromBackendReceiptLineItemDTO(receiptLineItemKey, backendReceiptLineItemDTO));
        }
        for (BackendReceiptLineItemDTO backendReceiptLineItemDTO : receiptDTO.getPaymentDetails()) {
            receiptLineItemKey = ReceiptLineItemKeySerializer.INSTANCE.deserialize(backendReceiptLineItemDTO.getKey());
            ej2.c(this.createReceiptLineItemFromBackendReceiptLineItemDTO(receiptLineItemKey, backendReceiptLineItemDTO));
        }
        if (receiptDTO.getReceiptFooters() != null) {
            this.addListItems(receiptDTO.getReceiptFooters(), ej2);
        }
        if (receiptDTO.getMessages() != null) {
            this.addListItems(receiptDTO.getMessages(), ej2);
        }
        ej2.a(receiptDTO.isSignatureLineRequired());
        ej2.b(receiptDTO.isTipLineRequired());
        ej2.a(receiptDTO.getLines());
        return ej2;
    }

    private void addListItems(List<BackendReceiptLineItemDTO> lineItemDTOS, ej receipt) {
        for (BackendReceiptLineItemDTO backendReceiptLineItemDTO : lineItemDTOS) {
            ReceiptLineItemKey receiptLineItemKey = ReceiptLineItemKeySerializer.INSTANCE.deserialize(backendReceiptLineItemDTO.getKey());
            receipt.e(this.createReceiptLineItemFromBackendReceiptLineItemDTO(receiptLineItemKey, backendReceiptLineItemDTO));
        }
    }

    private ReceiptLineItem createReceiptLineItemFromBackendReceiptLineItemDTO(ReceiptLineItemKey key, BackendReceiptLineItemDTO itemDTO) {
        String string = itemDTO.getLabel() == null ? "" : itemDTO.getLabel();
        String string2 = itemDTO.getValue() == null ? "" : itemDTO.getValue();
        return new ReceiptLineItem(key, string, string2);
    }

    public AdditionalAccessoryCapabilities createAdditionalAccessoryCapabilitiesFromResponseEmbeddedDTO(BackendTransactionResponseEmbeddedDTO embeddedDTO) {
        if (embeddedDTO == null || embeddedDTO.getReaderFeatures() == null) {
            return new AdditionalAccessoryCapabilities(false);
        }
        return new AdditionalAccessoryCapabilities(embeddedDTO.getReaderFeatures().getSdkLogExtraction());
    }

    private CardHolderPresenceType getCardHolderPresenceType(MotoType motoType) {
        switch (motoType) {
            case MAIL_ORDER: {
                return CardHolderPresenceType.MAIL_ORDER;
            }
            case TELEPHONE_ORDER: {
                return CardHolderPresenceType.TELEPHONE_ORDER;
            }
        }
        return null;
    }

    public synchronized BackendIncrementalAuthorizationTransactionPayloadDTO createIncrementalAuthorizationTransactionPayloadDTOFromTransactionParameters(TransactionParameters transactionParameters) {
        BackendIncrementalAuthorizationTransactionPayloadDTO backendIncrementalAuthorizationTransactionPayloadDTO = new BackendIncrementalAuthorizationTransactionPayloadDTO();
        if (transactionParameters.getAmount() != null && transactionParameters.getCurrency() != null) {
            backendIncrementalAuthorizationTransactionPayloadDTO.setAmount(transactionParameters.getAmount());
            backendIncrementalAuthorizationTransactionPayloadDTO.setCurrency(new CurrencyWrapper(transactionParameters.getCurrency()).getIsoCode());
        }
        return backendIncrementalAuthorizationTransactionPayloadDTO;
    }
}

