/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.processors.payworks.services.response.dto.mappers;

import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.PaymentDetailsIccWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsMagstripeWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsManualInputWrapper;
import io.mpos.shared.processors.payworks.services.response.dto.BackendEncryptedDataDTO;
import io.mpos.shared.processors.payworks.services.response.dto.BackendSredDataDTO;
import io.mpos.shared.transactions.DefaultTransaction;

public class EncryptedDataMapper {
    public BackendEncryptedDataDTO createEncryptedData(DefaultTransaction transaction) {
        PaymentDetailsManualInputWrapper paymentDetailsManualInputWrapper;
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)transaction.getPaymentDetails();
        BackendEncryptedDataDTO backendEncryptedDataDTO = new BackendEncryptedDataDTO();
        BackendSredDataDTO backendSredDataDTO = new BackendSredDataDTO();
        if (defaultPaymentDetails.sourceHasIccData()) {
            PaymentDetailsIccWrapper paymentDetailsIccWrapper = new PaymentDetailsIccWrapper(defaultPaymentDetails);
            if (paymentDetailsIccWrapper.getIccInformation() != null) {
                backendSredDataDTO.setData(paymentDetailsIccWrapper.getIccInformation().getSredData());
                backendSredDataDTO.setKsn(paymentDetailsIccWrapper.getIccInformation().getSredKSN());
            }
        } else if (defaultPaymentDetails.sourceHasMagstripeData()) {
            PaymentDetailsMagstripeWrapper paymentDetailsMagstripeWrapper = new PaymentDetailsMagstripeWrapper(defaultPaymentDetails);
            if (paymentDetailsMagstripeWrapper.getMagstripeInformation() != null) {
                backendSredDataDTO.setData(paymentDetailsMagstripeWrapper.getMagstripeInformation().getSredData());
                backendSredDataDTO.setKsn(paymentDetailsMagstripeWrapper.getMagstripeInformation().getSredKSN());
            }
        } else if (defaultPaymentDetails.sourceHasManualData() && (paymentDetailsManualInputWrapper = new PaymentDetailsManualInputWrapper(defaultPaymentDetails)).getCardData() != null) {
            backendSredDataDTO.setData(paymentDetailsManualInputWrapper.getCardData().getSred());
            backendSredDataDTO.setKsn(paymentDetailsManualInputWrapper.getCardData().getKsn());
        }
        backendEncryptedDataDTO.setSred(backendSredDataDTO);
        return backendEncryptedDataDTO;
    }
}

