/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.provider.listener;

import io.mpos.accessories.Accessory;
import io.mpos.core.common.obfuscated.r;
import io.mpos.errors.MposError;
import io.mpos.provider.listener.AccessoryConnectionStateListener;

public class AccessoryConnectionStateChangedInternalEvent
extends r<AccessoryConnectionStateListener> {
    boolean mIsConnect;
    boolean mIsCancelConnect;
    Accessory mAccessory;
    MposError mError;
    boolean mIsError;

    public AccessoryConnectionStateChangedInternalEvent(boolean isConnect, Accessory accessory, MposError error) {
        this(isConnect, accessory);
        this.mError = error;
        this.mIsError = true;
    }

    public AccessoryConnectionStateChangedInternalEvent(boolean isConnect, Accessory accessory) {
        this.mIsConnect = isConnect;
        this.mAccessory = accessory;
    }

    public AccessoryConnectionStateChangedInternalEvent(boolean connect, MposError error) {
        this(connect, null, error);
    }

    public void setCancelConnect(boolean isCancelConnect) {
        this.mIsCancelConnect = isCancelConnect;
    }

    @Override
    public void dispatch(AccessoryConnectionStateListener listener) {
        if (this.mIsCancelConnect) {
            if (this.mIsError) {
                listener.onAccessoryCancelConnectFailure(this.mAccessory, this.mError);
            } else {
                listener.onAccessoryCancelConnectSuccess(this.mAccessory);
            }
        } else if (this.mIsConnect) {
            if (this.mIsError) {
                listener.onAccessoryConnectFailure(this.mError);
            } else {
                listener.onAccessoryConnectSuccess(this.mAccessory);
            }
        } else if (this.mIsError) {
            listener.onAccessoryDisconnectFailure(this.mAccessory, this.mError);
        } else {
            listener.onAccessoryDisconnectSuccess(this.mAccessory);
        }
    }

    public String toString() {
        return "AccessoryConnectionStateChangedInternalEvent{mIsConnect=" + this.mIsConnect + ", mIsCancelConnect=" + this.mIsCancelConnect + ", mAccessory=" + this.mAccessory + ", mError=" + this.mError + ", mIsError=" + this.mIsError + "}";
    }
}

