/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.provider.listener;

import io.mpos.core.common.obfuscated.r;
import io.mpos.errors.MposError;
import io.mpos.provider.listener.TransactionListener;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.transactions.TransactionAction;
import io.mpos.transactions.actionsupport.TransactionActionSupport;

public final class TransactionInternalEvent
extends r<TransactionListener> {
    boolean mIsError;
    TransactionState mState;
    BaseTransaction mTransaction;
    MposError mError;
    TransactionAction mAction;
    TransactionActionSupport mSupportData;

    public TransactionInternalEvent(BaseTransaction transaction) {
        this.mTransaction = transaction;
    }

    public TransactionInternalEvent(BaseTransaction transaction, MposError error) {
        this(transaction);
        this.mError = error;
        this.mIsError = true;
    }

    public TransactionInternalEvent(TransactionState state, BaseTransaction transaction) {
        this(transaction);
        this.mState = state;
    }

    public TransactionInternalEvent(TransactionState state, BaseTransaction transaction, TransactionAction action, TransactionActionSupport supportData) {
        this(state, transaction);
        this.mAction = action;
        this.mSupportData = supportData;
    }

    public TransactionInternalEvent(TransactionState state, BaseTransaction transaction, MposError error) {
        this(state, transaction);
        this.mError = error;
        this.mIsError = true;
    }

    @Override
    public void dispatch(TransactionListener listener) {
        if (this.mState == null) {
            if (this.mIsError) {
                listener.onTransactionFailure(this.mTransaction, this.mError);
            }
        } else if (this.mState == TransactionState.ACTION_REQUIRED) {
            listener.onTransactionActionRequired(this.mTransaction, this.mAction, this.mSupportData);
        } else if (this.mState == TransactionState.ABORT) {
            if (this.mIsError) {
                listener.onTransactionAbortFailure(this.mTransaction, this.mError);
            } else {
                listener.onTransactionAbortSuccess(this.mTransaction);
            }
        } else if (this.mState == TransactionState.APPROVED) {
            listener.onTransactionApproved(this.mTransaction);
        } else if (this.mState == TransactionState.DECLINED) {
            listener.onTransactionDeclined(this.mTransaction);
        } else if (this.mState == TransactionState.ABORTED) {
            listener.onTransactionAborted(this.mTransaction);
        }
    }

    public static enum TransactionState {
        ACTION_REQUIRED,
        ABORT,
        ABORTED,
        APPROVED,
        DECLINED;

    }
}

