/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.tlv.items;

import io.mpos.shared.CommonResult;
import io.mpos.shared.hexstring.HexString;
import io.mpos.shared.hexstring.HexStringKt;
import io.mpos.shared.hexstring.HexStringTransformExtensionsKt;
import io.mpos.shared.tlv.items.TlvError;
import io.mpos.shared.tlv.items.TlvItem;
import io.mpos.shared.tlv.items.TlvParser;
import io.mpos.shared.tlv.items.TlvPrimitiveItem;
import io.mpos.shared.tlv.items.TlvTag;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\f\u001a\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"TAG_SIZE_PRIMARY_MASK_ADD_SUBSEQUENT", "", "TAG_SIZE_CONSECUTIVE_MASK_ADD_SUBSEQUENT", "LENGTH_CONSTRUCTED_FLAG_MASK", "LENGTH_BYTES_MASK", "LENGTH_MAX_INTEGER_BYTES", "tlvItems", "", "Lio/mpos/shared/tlv/items/TlvItem;", "tlvString", "Lio/mpos/shared/hexstring/HexString;", "tlvItem", "", "tag", "value", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nTlvParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlvParser.kt\nio/mpos/shared/tlv/items/TlvParserKt\n+ 2 CommonResult.kt\nio/mpos/shared/CommonResultKt\n*L\n1#1,134:1\n18#2,4:135\n*S KotlinDebug\n*F\n+ 1 TlvParser.kt\nio/mpos/shared/tlv/items/TlvParserKt\n*L\n19#1:135,4\n*E\n"})
public final class TlvParserKt {
    public static final int TAG_SIZE_PRIMARY_MASK_ADD_SUBSEQUENT = 31;
    public static final int TAG_SIZE_CONSECUTIVE_MASK_ADD_SUBSEQUENT = 128;
    public static final int LENGTH_CONSTRUCTED_FLAG_MASK = 128;
    public static final int LENGTH_BYTES_MASK = 127;
    public static final int LENGTH_MAX_INTEGER_BYTES = 4;

    @NotNull
    public static final List<TlvItem> tlvItems(@NotNull HexString tlvString) {
        CommonResult<List<TlvItem>, TlvError> commonResult;
        Intrinsics.checkNotNullParameter((Object)tlvString, (String)"");
        CommonResult<List<TlvItem>, TlvError> commonResult2 = commonResult = new TlvParser().parse(HexStringTransformExtensionsKt.toBytes(tlvString));
        if (!(commonResult2 instanceof CommonResult.Success)) {
            if (commonResult2 instanceof CommonResult.Error) {
                CommonResult.Error error = (CommonResult.Error)commonResult;
                throw new IllegalArgumentException(((TlvError)error.getError()).getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }
        return (List)((CommonResult.Success)commonResult).getValue();
    }

    @NotNull
    public static final TlvItem tlvItem(@NotNull HexString tlvString) {
        Intrinsics.checkNotNullParameter((Object)tlvString, (String)"");
        return (TlvItem)CollectionsKt.first(TlvParserKt.tlvItems(tlvString));
    }

    @NotNull
    public static final TlvItem tlvItem(@NotNull String tlvString) {
        Intrinsics.checkNotNullParameter((Object)tlvString, (String)"");
        return TlvParserKt.tlvItem(HexStringKt.hex(tlvString));
    }

    @NotNull
    public static final TlvItem tlvItem(@NotNull HexString tag, @NotNull HexString value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter((Object)value, (String)"");
        return new TlvPrimitiveItem(new TlvTag(tag), value);
    }

    @NotNull
    public static final TlvItem tlvItem(@NotNull String tag, @NotNull HexString value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter((Object)value, (String)"");
        return TlvParserKt.tlvItem(HexStringKt.hex(tag), value);
    }

    @NotNull
    public static final TlvItem tlvItem(@NotNull String tag, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter((Object)value, (String)"");
        return TlvParserKt.tlvItem(HexStringKt.hex(tag), HexStringKt.hex(value));
    }
}

