/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.tlv.references;

import io.mpos.shared.hexstring.HexString;
import io.mpos.shared.hexstring.HexStringKt;
import io.mpos.shared.tlv.items.TlvConstructedItem;
import io.mpos.shared.tlv.items.TlvItem;
import io.mpos.shared.tlv.items.TlvPrimitiveItem;
import io.mpos.shared.tlv.items.TlvTag;
import io.mpos.shared.tlv.references.TlvDataLength;
import io.mpos.shared.tlv.references.TlvMapper;
import io.mpos.shared.tlv.references.TlvReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\t\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0018H\u0016J\u0013\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u001dJ\u001d\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u0004\u0018\u00010\u00142\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0018R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lio/mpos/shared/tlv/references/AbstractTlvReference;", "V", "Lio/mpos/shared/tlv/references/TlvReference;", "tag", "Lio/mpos/shared/tlv/items/TlvTag;", "mapper", "Lio/mpos/shared/tlv/references/TlvMapper;", "length", "Lio/mpos/shared/tlv/references/TlvDataLength;", "<init>", "(Lio/mpos/shared/tlv/items/TlvTag;Lio/mpos/shared/tlv/references/TlvMapper;Lio/mpos/shared/tlv/references/TlvDataLength;)V", "getTag", "()Lio/mpos/shared/tlv/items/TlvTag;", "getMapper", "()Lio/mpos/shared/tlv/references/TlvMapper;", "getLength", "()Lio/mpos/shared/tlv/references/TlvDataLength;", "tlv", "Lio/mpos/shared/tlv/items/TlvPrimitiveItem;", "rawData", "Lio/mpos/shared/hexstring/HexString;", "firstItemIn", "Lio/mpos/shared/tlv/items/TlvItem;", "items", "", "tlvFromValue", "value", "(Ljava/lang/Object;)Lio/mpos/shared/tlv/items/TlvPrimitiveItem;", "valueFromTlv", "(Lio/mpos/shared/tlv/items/TlvPrimitiveItem;)Ljava/lang/Object;", "firstValueIn", "(Ljava/lang/Iterable;)Ljava/lang/Object;", "firstRawDataIn", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nAbstractTlvReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTlvReference.kt\nio/mpos/shared/tlv/references/AbstractTlvReference\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n295#2,2:55\n*S KotlinDebug\n*F\n+ 1 AbstractTlvReference.kt\nio/mpos/shared/tlv/references/AbstractTlvReference\n*L\n30#1:55,2\n*E\n"})
public abstract class AbstractTlvReference<V>
implements TlvReference {
    @NotNull
    private final TlvTag tag;
    @NotNull
    private final TlvMapper<V> mapper;
    @NotNull
    private final TlvDataLength length;

    public AbstractTlvReference(@NotNull TlvTag tag, @NotNull TlvMapper<V> mapper, @NotNull TlvDataLength length) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"");
        Intrinsics.checkNotNullParameter(mapper, (String)"");
        Intrinsics.checkNotNullParameter((Object)length, (String)"");
        this.tag = tag;
        this.mapper = mapper;
        this.length = length;
    }

    public /* synthetic */ AbstractTlvReference(TlvTag tlvTag, TlvMapper tlvMapper, TlvDataLength tlvDataLength, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            tlvDataLength = TlvDataLength.Flexible.INSTANCE;
        }
        this(tlvTag, tlvMapper, tlvDataLength);
    }

    @Override
    @NotNull
    public TlvTag getTag() {
        return this.tag;
    }

    @NotNull
    public final TlvMapper<V> getMapper() {
        return this.mapper;
    }

    @Override
    @NotNull
    public TlvDataLength getLength() {
        return this.length;
    }

    @Override
    @NotNull
    public TlvPrimitiveItem tlv(@NotNull HexString rawData) {
        Intrinsics.checkNotNullParameter((Object)rawData, (String)"");
        return new TlvPrimitiveItem(this.getTag(), rawData);
    }

    @Override
    @Nullable
    public TlvItem firstItemIn(@Nullable Iterable<? extends TlvItem> items) {
        TlvItem tlvItem;
        Iterable<? extends TlvItem> iterable = items;
        if (iterable != null) {
            TlvItem tlvItem2;
            block3: {
                Iterable<? extends TlvItem> iterable2 = iterable;
                for (TlvItem tlvItem3 : iterable2) {
                    TlvItem tlvItem4 = tlvItem3;
                    if (!Intrinsics.areEqual((Object)tlvItem4.getTag(), (Object)this.getTag())) continue;
                    tlvItem2 = tlvItem3;
                    break block3;
                }
                tlvItem2 = null;
            }
            tlvItem = tlvItem2;
        } else {
            tlvItem = null;
        }
        return tlvItem;
    }

    @NotNull
    public final TlvPrimitiveItem tlvFromValue(V value) {
        return new TlvPrimitiveItem(this.getTag(), HexStringKt.fitIn$default(this.mapper.fromValue(value), this.getLength().getRange(), this.mapper.getPadding(), null, 4, null));
    }

    @Nullable
    public final V valueFromTlv(@NotNull TlvPrimitiveItem tlv) {
        Intrinsics.checkNotNullParameter((Object)tlv, (String)"");
        return this.mapper.toValue(tlv.getValue());
    }

    @Nullable
    public final V firstValueIn(@Nullable Iterable<? extends TlvItem> items) {
        Object v0;
        TlvItem tlvItem = this.firstItemIn(items);
        if (tlvItem instanceof TlvPrimitiveItem) {
            v0 = this.mapper.toValue(((TlvPrimitiveItem)tlvItem).getValue());
        } else if (tlvItem instanceof TlvConstructedItem) {
            v0 = null;
        } else if (tlvItem == null) {
            v0 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return v0;
    }

    @Nullable
    public final HexString firstRawDataIn(@Nullable Iterable<? extends TlvItem> items) {
        HexString hexString;
        TlvItem tlvItem = this.firstItemIn(items);
        if (tlvItem instanceof TlvPrimitiveItem) {
            hexString = ((TlvPrimitiveItem)tlvItem).getValue();
        } else if (tlvItem instanceof TlvConstructedItem) {
            hexString = null;
        } else if (tlvItem == null) {
            hexString = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return hexString;
    }

    @Override
    @NotNull
    public String getLongDescription() {
        return TlvReference.DefaultImpls.getLongDescription(this);
    }
}

