/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactionprovider;

import com.squareup.otto.Subscribe;
import io.mpos.accessories.Accessory;
import io.mpos.accessories.AccessoryConnectionState;
import io.mpos.accessories.components.interaction.EbtInteraction;
import io.mpos.accessories.components.interaction.GiftCardInteraction;
import io.mpos.accessories.components.interaction.IntegratedAccessory;
import io.mpos.accessories.components.interaction.MotoInteraction;
import io.mpos.accessories.components.interaction.tipping.TippingInteraction;
import io.mpos.accessories.parameters.AccessoryParameters;
import io.mpos.core.common.obfuscated.da;
import io.mpos.core.common.obfuscated.dh;
import io.mpos.core.common.obfuscated.dn;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.logger.Log;
import io.mpos.platform.EventDispatcher;
import io.mpos.provider.Provider;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.events.AccessoryConnectionStateChangedEvent;
import io.mpos.shared.events.BusProvider;
import io.mpos.shared.helper.ParameterValidator;
import io.mpos.shared.provider.DefaultProvider;
import io.mpos.shared.transactionprovider.ProcessTracker;
import io.mpos.transactionprovider.AccessoryConnectListener;
import io.mpos.transactionprovider.AccessoryDisconnectListener;
import io.mpos.transactionprovider.AccessoryDisconnectListener2;
import io.mpos.transactionprovider.AccessoryModule;
import io.mpos.transactionprovider.AccessoryModuleConnectionStateChangeListener;
import io.mpos.transactionprovider.AccessoryProcess;
import io.mpos.transactionprovider.AccessoryProcessDetails;
import io.mpos.transactionprovider.AccessoryProcessDetailsState;
import io.mpos.transactionprovider.AccessoryUpdateListener;
import io.mpos.transactions.TransactionMode;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.Nullable;

public class DefaultAccessoryModule
implements AccessoryModule {
    private static final String TAG = "DefaultAccessoryModule";
    private final Provider provider;
    private final ProcessTracker processTracker;
    private List<Accessory> connectedAccessories = new CopyOnWriteArrayList<Accessory>();
    private final List<da> connectedAccessoryProcesses = Collections.synchronizedList(new ArrayList());
    private AccessoryModuleConnectionStateChangeListener connectionStateChangeListener;
    private MotoInteraction motoInteraction = null;
    private EbtInteraction ebtInteraction = null;
    private TippingInteraction tippingInteraction = null;
    private GiftCardInteraction giftCardInteraction = null;
    private WeakReference<MotoInteraction> motoInteractionReference = new WeakReference<Object>(null);
    private WeakReference<EbtInteraction> ebtInteractionReference = new WeakReference<Object>(null);
    private WeakReference<TippingInteraction> tippingInteractionReference = new WeakReference<Object>(null);
    private WeakReference<GiftCardInteraction> giftCardInteractionReference = new WeakReference<Object>(null);

    public DefaultAccessoryModule(Provider provider, ProcessTracker processTracker) {
        this.provider = provider;
        this.processTracker = processTracker;
    }

    public AccessoryProcess connectToAccessoryWithoutReconnection(AccessoryParameters accessoryParameters, AccessoryConnectListener listener) {
        da da2 = new da(this.provider, ((DefaultProvider)this.provider).getPlatformToolkit().getEventDispatcher(), this, accessoryParameters, new AccessoryConnectListenerWrapper(listener), true);
        return this.connectToAccessory(accessoryParameters, listener, da2);
    }

    public AccessoryProcess connectToAccessory(AccessoryParameters accessoryParameters, AccessoryConnectListener listener) {
        da da2 = new da(this.provider, ((DefaultProvider)this.provider).getPlatformToolkit().getEventDispatcher(), this, accessoryParameters, new AccessoryConnectListenerWrapper(listener));
        return this.connectToAccessory(accessoryParameters, listener, da2);
    }

    private AccessoryProcess connectToAccessory(AccessoryParameters accessoryParameters, AccessoryConnectListener listener, da connectProcess) {
        if (this.processTracker.isAccessoryProcessOngoing()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.ACCESSORY_BUSY, "An accessory process is ongoing"));
        }
        ParameterValidator.checkNull(Arrays.asList(accessoryParameters, listener), Arrays.asList("accessoryParameters", "connectionStateChangeListener"));
        Log.i(TAG, "Requesting connect to accessory: " + accessoryParameters);
        this.processTracker.setAccessoryProcessOngoing(true);
        this.connectedAccessoryProcesses.add(connectProcess);
        connectProcess.start();
        return connectProcess;
    }

    public AccessoryProcess updateAccessory(Accessory accessory, AccessoryUpdateListener listener) {
        return this.internalUpdateAccessory(TransactionMode.ONLINE, accessory, listener);
    }

    public AccessoryProcess updateAccessoryOffline(Accessory accessory, AccessoryUpdateListener listener) {
        return this.internalUpdateAccessory(TransactionMode.OFFLINE, accessory, listener);
    }

    private dn internalUpdateAccessory(TransactionMode transactionMode, Accessory accessory, final AccessoryUpdateListener listener) {
        if (this.processTracker.isAccessoryProcessOngoing()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.ACCESSORY_BUSY, "An accessory process is ongoing"));
        }
        ParameterValidator.checkNull(Arrays.asList(accessory, listener), Arrays.asList("accessory", "connectionStateChangeListener"));
        Log.i(TAG, "Requesting accessory update");
        this.processTracker.setAccessoryProcessOngoing(true);
        EventDispatcher eventDispatcher = ((DefaultProvider)this.provider).getPlatformToolkit().getEventDispatcher();
        dn dn2 = new dn(this.provider, transactionMode, eventDispatcher, this, accessory, new AccessoryUpdateListener(){

            public void onStatusChanged(AccessoryProcess accessoryProcess, Accessory accessory1, AccessoryProcessDetails details) {
                listener.onStatusChanged((Object)accessoryProcess, (Object)accessory1, (Object)details);
            }

            public void onCompleted(AccessoryProcess accessoryProcess, Accessory accessory1, AccessoryProcessDetails details) {
                DefaultAccessoryModule.this.processTracker.setAccessoryProcessOngoing(false);
                listener.onCompleted((Object)accessoryProcess, (Object)accessory1, (Object)details);
            }
        });
        dn2.start();
        return dn2;
    }

    public AccessoryProcess disconnectFromAccessory(Accessory accessory, AccessoryDisconnectListener2 listener) {
        if (this.processTracker.isAccessoryProcessOngoing()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.ACCESSORY_BUSY, "An accessory process is ongoing"));
        }
        ParameterValidator.checkNull(Arrays.asList(accessory, listener), Arrays.asList("accessory", "connectionStateChangeListener"));
        Log.i(TAG, "Requesting disconnect for accessory");
        return this.internalDisconnectFromAccessory(accessory, listener);
    }

    public AccessoryProcess internalDisconnectFromAccessory(final Accessory accessory, final AccessoryDisconnectListener2 listener) {
        this.processTracker.setAccessoryProcessOngoing(true);
        EventDispatcher eventDispatcher = ((DefaultProvider)this.provider).getPlatformToolkit().getEventDispatcher();
        dh dh2 = new dh(this.provider, eventDispatcher, this, accessory, new AccessoryDisconnectListener2(){

            public void onStatusChanged(AccessoryProcess process, Accessory accessory1, AccessoryProcessDetails processDetails) {
                listener.onStatusChanged((Object)process, (Object)accessory1, (Object)processDetails);
            }

            public void onCompleted(AccessoryProcess process, Accessory accessory1, AccessoryProcessDetails processDetails) {
                if (processDetails.getState() == AccessoryProcessDetailsState.COMPLETED) {
                    DefaultAccessoryModule.this.connectedAccessories.remove(accessory1);
                    DefaultAccessoryModule.this.notifyAccessoryConnectionStateChanged(accessory);
                    if (DefaultAccessoryModule.this.connectedAccessories.isEmpty()) {
                        DefaultAccessoryModule.this.stopListeningForAccessoryConnectionStateChanges();
                    }
                }
                DefaultAccessoryModule.this.processTracker.setAccessoryProcessOngoing(false);
                listener.onCompleted((Object)process, (Object)accessory1, (Object)processDetails);
            }
        });
        dh2.start();
        return dh2;
    }

    @Deprecated
    public void disconnectFromAccessory(final AccessoryDisconnectListener listener) {
        ParameterValidator.checkNull(Arrays.asList(listener), Arrays.asList("connectionStateChangeListener"));
        if (this.connectedAccessories.isEmpty()) {
            listener.onCompleted((MposError)new DefaultMposError(ErrorType.ACCESSORY_ALREADY_DISCONNECTED, "accessory not connected"));
            return;
        }
        this.disconnectFromAccessory(this.connectedAccessories.get(0), new AccessoryDisconnectListener2(){

            public void onStatusChanged(AccessoryProcess process, Accessory model, AccessoryProcessDetails processDetails) {
            }

            public void onCompleted(AccessoryProcess process, Accessory model, AccessoryProcessDetails processDetails) {
                listener.onCompleted(processDetails.getError());
            }
        });
    }

    public List<Accessory> getConnectedAccessories() {
        return Collections.unmodifiableList(this.connectedAccessories);
    }

    public void setConnectionStateChangeListener(AccessoryModuleConnectionStateChangeListener listener) {
        this.connectionStateChangeListener = listener;
    }

    public void setMotoInteraction(MotoInteraction motoInteraction) {
        this.motoInteraction = motoInteraction;
        this.motoInteractionReference.clear();
        this.motoInteractionReference = new WeakReference<MotoInteraction>(motoInteraction);
    }

    public void setEbtInteraction(EbtInteraction ebtInteraction) {
        this.ebtInteraction = ebtInteraction;
        this.ebtInteractionReference.clear();
        this.ebtInteractionReference = new WeakReference<EbtInteraction>(ebtInteraction);
    }

    public void setGiftCardInteraction(GiftCardInteraction giftCardInteraction) {
        this.giftCardInteraction = giftCardInteraction;
        this.giftCardInteractionReference.clear();
        this.giftCardInteractionReference = new WeakReference<GiftCardInteraction>(giftCardInteraction);
    }

    public void setTippingInteraction(TippingInteraction tippingInteraction) {
        this.tippingInteraction = tippingInteraction;
        this.tippingInteractionReference.clear();
        this.tippingInteractionReference = new WeakReference<TippingInteraction>(tippingInteraction);
    }

    public boolean isConnected() {
        return !this.connectedAccessories.isEmpty();
    }

    public boolean isConnected(AccessoryParameters parameters) {
        for (Accessory accessory : this.connectedAccessories) {
            if (!accessory.getAccessoryParameters().equals((Object)parameters)) continue;
            return true;
        }
        return false;
    }

    public Accessory getConnectedAccessory(AccessoryParameters parameters) {
        for (Accessory accessory : this.connectedAccessories) {
            if (!accessory.getAccessoryParameters().equals((Object)parameters)) continue;
            return accessory;
        }
        return null;
    }

    @Nullable
    public Accessory getConnectedAccessory() {
        if (!this.isConnected()) {
            return null;
        }
        return this.connectedAccessories.get(0);
    }

    public boolean isConnected(Accessory accessory) {
        return this.connectedAccessories.contains(accessory);
    }

    private void startListeningForAccessoryConnectionStateChanges() {
        BusProvider.getInstance().register((Object)this);
    }

    private void stopListeningForAccessoryConnectionStateChanges() {
        BusProvider.getInstance().unregister((Object)this);
    }

    @Subscribe
    public void onAccessoryConnectionStateChanged(AccessoryConnectionStateChangedEvent event) {
        String cfr_ignored_0 = "connection state change received :" + event.getConnectionState();
        this.handleConnectionStateChange(event.getAbstractAccessory(), event.getConnectionState());
    }

    private void handleConnectionStateChange(Accessory accessory, AccessoryConnectionState state) {
        if (state == AccessoryConnectionState.CONNECTED_BUT_UNAVAILABLE && !this.processTracker.isAccessoryProcessOngoing() && !this.processTracker.isCardProcessOngoing() && this.isConnected(accessory)) {
            this.disconnectFromAccessory(accessory, new AccessoryDisconnectListener2(){

                public void onStatusChanged(AccessoryProcess process, Accessory model, AccessoryProcessDetails processDetails) {
                }

                public void onCompleted(AccessoryProcess process, Accessory model, AccessoryProcessDetails processDetails) {
                    if (processDetails.getError() != null) {
                        String cfr_ignored_0 = "failed disconnect because of state change: " + processDetails.getError();
                    }
                }
            });
        }
    }

    private void notifyAccessoryConnectionStateChanged(Accessory accessory) {
        if (this.connectionStateChangeListener != null) {
            this.connectionStateChangeListener.onAccessoryConnectionStateChanged(accessory);
        }
    }

    public void hardReset() {
        if (!this.connectedAccessories.isEmpty()) {
            this.stopListeningForAccessoryConnectionStateChanges();
            this.connectedAccessories.clear();
            this.connectionStateChangeListener = null;
        }
        this.hardResetAccessoryProcesses();
    }

    private void hardResetAccessoryProcesses() {
        ArrayList<da> arrayList;
        List<da> list = this.connectedAccessoryProcesses;
        synchronized (list) {
            arrayList = new ArrayList<da>(this.connectedAccessoryProcesses);
            this.connectedAccessoryProcesses.clear();
        }
        for (da da2 : arrayList) {
            da2.a();
        }
    }

    private class AccessoryConnectListenerWrapper
    implements AccessoryConnectListener {
        private final AccessoryConnectListener listener;

        private AccessoryConnectListenerWrapper(AccessoryConnectListener listener) {
            this.listener = listener;
        }

        public void onStatusChanged(AccessoryProcess accessoryProcess, Accessory accessory, AccessoryProcessDetails details) {
            this.listener.onStatusChanged((Object)accessoryProcess, (Object)accessory, (Object)details);
        }

        public void onCompleted(AccessoryProcess accessoryProcess, Accessory accessory, AccessoryProcessDetails details) {
            if (details.getState() == AccessoryProcessDetailsState.COMPLETED) {
                if (DefaultAccessoryModule.this.connectedAccessories.size() == 0) {
                    DefaultAccessoryModule.this.startListeningForAccessoryConnectionStateChanges();
                }
                if (!DefaultAccessoryModule.this.connectedAccessories.contains(accessory)) {
                    this.updateAccessoryInteractions(accessory);
                    DefaultAccessoryModule.this.connectedAccessories.add(accessory);
                    DefaultAccessoryModule.this.notifyAccessoryConnectionStateChanged(accessory);
                }
            }
            DefaultAccessoryModule.this.processTracker.setAccessoryProcessOngoing(false);
            this.listener.onCompleted((Object)accessoryProcess, (Object)accessory, (Object)details);
            DefaultAccessoryModule.this.connectedAccessoryProcesses.remove(accessoryProcess);
        }

        private void updateAccessoryInteractions(Accessory accessory) {
            if (accessory instanceof IntegratedAccessory) {
                ((IntegratedAccessory)accessory).setMotoInteraction(DefaultAccessoryModule.this.motoInteractionReference);
                ((IntegratedAccessory)accessory).setTippingInteraction(DefaultAccessoryModule.this.tippingInteractionReference);
                ((IntegratedAccessory)accessory).setGiftCardInteraction(DefaultAccessoryModule.this.giftCardInteractionReference);
                ((IntegratedAccessory)accessory).setEbtInteraction(DefaultAccessoryModule.this.ebtInteractionReference);
            }
        }
    }
}

