/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactionprovider;

import io.mpos.accessories.components.barcode.StartScanParameters;
import io.mpos.accessories.parameters.AccessoryParameters;
import io.mpos.core.common.obfuscated.ae;
import io.mpos.core.common.obfuscated.af;
import io.mpos.core.common.obfuscated.ag;
import io.mpos.core.common.obfuscated.cE;
import io.mpos.core.common.obfuscated.dA;
import io.mpos.core.common.obfuscated.dD;
import io.mpos.core.common.obfuscated.dc;
import io.mpos.core.common.obfuscated.dl;
import io.mpos.core.common.obfuscated.dr;
import io.mpos.core.common.obfuscated.ek;
import io.mpos.core.common.obfuscated.gw;
import io.mpos.core.common.obfuscated.o;
import io.mpos.core.common.obfuscated.p;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.platform.LocalizationToolbox;
import io.mpos.platform.MainScopeProvider;
import io.mpos.provider.Provider;
import io.mpos.provider.ProviderMode;
import io.mpos.provider.ProviderOptions;
import io.mpos.shared.MposHelper;
import io.mpos.shared.TransactionPlugin;
import io.mpos.shared.config.DelayConfig;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.helper.AssetsHandler;
import io.mpos.shared.helper.ParameterValidator;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.provider.DefaultProvider;
import io.mpos.shared.provider.TransactionLocalRegistrationService;
import io.mpos.shared.provider.di.ProviderScope;
import io.mpos.shared.transactionprovider.DefaultAccessoryModule;
import io.mpos.shared.transactionprovider.ProcessTracker;
import io.mpos.transactionprovider.AccessibilityModule;
import io.mpos.transactionprovider.AccessoryModule;
import io.mpos.transactionprovider.BarcodeScanProcess;
import io.mpos.transactionprovider.BarcodeScanProcessListener;
import io.mpos.transactionprovider.BasicTransactionProcessListener;
import io.mpos.transactionprovider.BasicTransactionProcessWithRegistrationListener;
import io.mpos.transactionprovider.CardProcess;
import io.mpos.transactionprovider.DefaultAccessibilityModule;
import io.mpos.transactionprovider.DefaultTransactionModule;
import io.mpos.transactionprovider.PrintingProcess;
import io.mpos.transactionprovider.PrintingProcessListener;
import io.mpos.transactionprovider.ReadCardProcessListener;
import io.mpos.transactionprovider.StartableTransactionProcess;
import io.mpos.transactionprovider.TransactionModule;
import io.mpos.transactionprovider.TransactionProcess;
import io.mpos.transactionprovider.TransactionProcessListener;
import io.mpos.transactionprovider.TransactionProcessWithRegistrationListener;
import io.mpos.transactionprovider.TransactionProvider;
import io.mpos.transactionprovider.accessibility.AccessibilityManagerProvider;
import io.mpos.transactionprovider.accessibility.RnibPinPadUpdatesHandler;
import io.mpos.transactionprovider.accessibility.RnibSpeaker;
import io.mpos.transactionprovider.accessibility.RnibTextToSpeechDisabler;
import io.mpos.transactionprovider.accessibility.RnibTextToSpeechStateHolder;
import io.mpos.transactionprovider.accessibility.RnibTransactionStateUpdatesHandler;
import io.mpos.transactionprovider.configuration.SynchronizeConfigurationProcessListener;
import io.mpos.transactionprovider.offline.OfflineModule;
import io.mpos.transactionprovider.processparameters.TransactionProcessParameters;
import io.mpos.transactions.TransactionAction;
import io.mpos.transactions.account.AccountParameters;
import io.mpos.transactions.parameters.TransactionParameters;
import io.mpos.transactions.receipts.PrintLayout;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import javax.inject.Inject;

@ProviderScope
public class DefaultTransactionProvider
implements TransactionProvider {
    private static final String TAG = "TransactionProvider";
    private DefaultProvider mProvider;
    private DefaultTransactionModule mTransactionModule;
    private DefaultAccessoryModule mAccessoryModule;
    private DefaultAccessibilityModule mAccessibilityModule;
    private dD mOfflineModule;
    private ProcessTracker mProcessTracker;
    private dA mTransactionProcessFactory;
    private Profiler mProfiler;
    private o mAccessibilityLocalization;
    private af mPrintingBoundaryProvider;
    private final DelayConfig delayConfig;
    private final TransactionPlugin transactionPlugin;
    private final ek accessoryUpdateTrackerPlugin;

    @Inject
    public DefaultTransactionProvider(DefaultProvider provider, DelayConfig delayConfig, Profiler profiler, TransactionPlugin transactionPlugin, ek accessoryUpdateTrackerPlugin, MainScopeProvider mainScopeProvider) {
        this.delayConfig = delayConfig;
        this.transactionPlugin = transactionPlugin;
        this.accessoryUpdateTrackerPlugin = accessoryUpdateTrackerPlugin;
        MposHelper.clearSharedProvider();
        this.mProvider = provider;
        MposHelper.setSharedProvider(this.mProvider);
        this.mProfiler = profiler;
        this.mProfiler.setTriggerSource(Profiler.TriggerSource.TRANSACTION_PROVIDER);
        this.mProcessTracker = new ProcessTracker();
        transactionPlugin.transactionTrackers.add(new WeakReference<ProcessTracker>(this.mProcessTracker));
        this.mTransactionModule = new DefaultTransactionModule(this.mProvider, this.mProcessTracker);
        this.mAccessoryModule = new DefaultAccessoryModule(this.mProvider, this.mProcessTracker);
        transactionPlugin.transactionAccessoryModules.add(new WeakReference<DefaultAccessoryModule>(this.mAccessoryModule));
        this.mAccessibilityLocalization = new o(provider.getLocale(), new p(AssetsHandler.getInstance()));
        RnibTextToSpeechStateHolder rnibTextToSpeechStateHolder = new RnibTextToSpeechStateHolder();
        RnibSpeaker rnibSpeaker = new RnibSpeaker(this.mProvider.getPlatformToolkit(), this.mAccessibilityLocalization);
        RnibTextToSpeechDisabler rnibTextToSpeechDisabler = new RnibTextToSpeechDisabler();
        this.mAccessibilityModule = new DefaultAccessibilityModule(AccessibilityManagerProvider.INSTANCE.provide(this.mProvider.getProviderMode(), this.mAccessoryModule, rnibTextToSpeechStateHolder, rnibSpeaker, new RnibTransactionStateUpdatesHandler(rnibSpeaker, rnibTextToSpeechDisabler, rnibTextToSpeechStateHolder), new RnibPinPadUpdatesHandler(rnibSpeaker, rnibTextToSpeechStateHolder), rnibTextToSpeechDisabler));
        this.mTransactionProcessFactory = new dA(this.mProvider, new TransactionLocalRegistrationService(), this.mAccessoryModule, this.mAccessibilityModule, this.mProcessTracker, this, delayConfig, profiler);
        this.mOfflineModule = new dD(this.mProvider, this.mProcessTracker, this.mTransactionProcessFactory, profiler);
        this.mPrintingBoundaryProvider = new ag(this.mProvider, this.mProcessTracker, this.mProfiler, mainScopeProvider.getMainScope());
    }

    public DefaultTransactionProvider(Provider provider, Profiler profiler, ProcessTracker tracker, DefaultTransactionModule transactionModule, DefaultAccessoryModule accessoryModule, dA processFactory, dD offlineModule, DelayConfig delayConfig, TransactionPlugin transactionPlugin, ek accessoryUpdateTrackerPlugin) {
        this.delayConfig = delayConfig;
        this.transactionPlugin = transactionPlugin;
        this.accessoryUpdateTrackerPlugin = accessoryUpdateTrackerPlugin;
        MposHelper.clearSharedProvider();
        this.mProvider = (DefaultProvider)provider;
        MposHelper.setSharedProvider(this.mProvider);
        this.mProfiler = profiler;
        this.mProfiler.setTriggerSource(Profiler.TriggerSource.TRANSACTION_PROVIDER);
        this.mProcessTracker = tracker;
        this.mTransactionModule = transactionModule;
        this.mAccessoryModule = accessoryModule;
        this.mTransactionProcessFactory = processFactory;
        this.mOfflineModule = offlineModule;
        this.transactionPlugin.transactionTrackers.add(new WeakReference<ProcessTracker>(this.mProcessTracker));
        transactionPlugin.transactionAccessoryModules.add(new WeakReference<DefaultAccessoryModule>(this.mAccessoryModule));
    }

    public void setMerchantCredentials(ProviderMode providerMode, String merchantIdentifier, String merchantSecret) {
        if (this.mProcessTracker.isOngoing()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.TRANSACTION_BUSY, "A process is ongoing. Cannot change credentials when a process is ongoing"));
        }
        ProviderOptions providerOptions = MposHelper.getProviderOptionsFactory().createProviderOptions(providerMode, merchantIdentifier, merchantSecret, EnumSet.allOf(TransactionAction.class));
        this.mProvider.setProviderOptions(providerOptions);
    }

    public void synchronizeConfiguration(SynchronizeConfigurationProcessListener listener) {
        dl dl2 = new dl(this.mProvider, listener, this.mProfiler);
        dl2.a();
    }

    public String getMerchantIdentifier() {
        ProviderOptions providerOptions = this.mProvider.getProviderOptions();
        return providerOptions.getMerchantIdentifier();
    }

    public void setLocale(Locale locale) {
        this.mProvider.setLocale(locale);
        this.mAccessibilityLocalization.a(locale);
    }

    public TransactionProcess startTransaction(String sessionIdentifier, AccessoryParameters accessoryParameters, TransactionProcessListener listener) {
        return this.startTransaction(sessionIdentifier, accessoryParameters, null, listener);
    }

    public TransactionProcess startTransaction(String sessionIdentifier, AccessoryParameters accessoryParameters, TransactionProcessParameters transactionProcessParameters, TransactionProcessListener listener) {
        ParameterValidator.checkNull(Arrays.asList(sessionIdentifier, accessoryParameters, listener), Arrays.asList("sessionIdentifier", "accessoryParameters", "listener"));
        this.assertPeriodicalUpdateProcessNotOngoing(accessoryParameters);
        this.assertCardProcessNotOngoing();
        this.assertNonCardProcessNotOngoing();
        StartableTransactionProcess startableTransactionProcess = this.mTransactionProcessFactory.a(sessionIdentifier, accessoryParameters, transactionProcessParameters, listener);
        startableTransactionProcess.start();
        return startableTransactionProcess;
    }

    public TransactionProcess startTransaction(TransactionParameters transactionParameters, AccessoryParameters accessoryParameters, TransactionProcessWithRegistrationListener listener) {
        return this.startTransaction(transactionParameters, accessoryParameters, null, listener);
    }

    public TransactionProcess startTransaction(TransactionParameters transactionParameters, AccessoryParameters accessoryParameters, TransactionProcessParameters transactionProcessParameters, TransactionProcessWithRegistrationListener listener) {
        ParameterValidator.checkNull(Arrays.asList(transactionParameters, accessoryParameters, listener), Arrays.asList("transactionParameters", "accessoryParameters", "listener"));
        this.assertPeriodicalUpdateProcessNotOngoing(accessoryParameters);
        StartableTransactionProcess startableTransactionProcess = this.mTransactionProcessFactory.a(transactionParameters, accessoryParameters, transactionProcessParameters, (TransactionProcessListener)listener);
        startableTransactionProcess.start();
        return startableTransactionProcess;
    }

    public TransactionProcess startTransaction(TransactionParameters transactionParameters, AccountParameters accountParameters, BasicTransactionProcessWithRegistrationListener listener) {
        ParameterValidator.checkNull(Arrays.asList(transactionParameters, accountParameters, listener), Arrays.asList("transactionParameters", "accountParameters", "listener"));
        StartableTransactionProcess startableTransactionProcess = this.mTransactionProcessFactory.a(transactionParameters, accountParameters, listener);
        startableTransactionProcess.start();
        return startableTransactionProcess;
    }

    public TransactionProcess startTransaction(String sessionIdentifier, AccountParameters accountParameters, BasicTransactionProcessWithRegistrationListener listener) {
        ParameterValidator.checkNull(Arrays.asList(sessionIdentifier, accountParameters, listener), Arrays.asList("sessionIdentifier", "accountParameters", "listener"));
        StartableTransactionProcess startableTransactionProcess = this.mTransactionProcessFactory.a(accountParameters, sessionIdentifier, listener);
        startableTransactionProcess.start();
        return startableTransactionProcess;
    }

    public TransactionProcess amendTransaction(TransactionParameters transactionParameters, BasicTransactionProcessListener listener) {
        ParameterValidator.checkNull(Arrays.asList(transactionParameters, listener), Arrays.asList("transactionParameters", "listener"));
        StartableTransactionProcess startableTransactionProcess = this.mTransactionProcessFactory.a(transactionParameters, listener);
        startableTransactionProcess.start();
        return startableTransactionProcess;
    }

    public TransactionModule getTransactionModule() {
        return this.mTransactionModule;
    }

    public AccessoryModule getAccessoryModule() {
        return this.mAccessoryModule;
    }

    public OfflineModule getOfflineModule() {
        return this.mOfflineModule;
    }

    public PrintingProcess printCustomerReceiptForTransaction(String transactionIdentifier, AccessoryParameters accessoryParameters, PrintingProcessListener listener) {
        return this.printReceiptForTransaction(cE.a, transactionIdentifier, accessoryParameters, listener, false);
    }

    public PrintingProcess printCustomerReceiptForTransaction(String transactionIdentifier, AccessoryParameters accessoryParameters, PrintingProcessListener listener, boolean isDuplicate) {
        return this.printReceiptForTransaction(cE.a, transactionIdentifier, accessoryParameters, listener, isDuplicate);
    }

    public PrintingProcess printMerchantReceiptForTransaction(String transactionIdentifier, AccessoryParameters accessoryParameters, PrintingProcessListener listener) {
        return this.printReceiptForTransaction(cE.b, transactionIdentifier, accessoryParameters, listener, false);
    }

    public PrintingProcess printMerchantReceiptForTransaction(String transactionIdentifier, AccessoryParameters accessoryParameters, PrintingProcessListener listener, boolean isDuplicate) {
        return this.printReceiptForTransaction(cE.b, transactionIdentifier, accessoryParameters, listener, isDuplicate);
    }

    public PrintingProcess customPrint(PrintLayout printLayout, AccessoryParameters accessoryParameters, PrintingProcessListener listener) {
        ParameterValidator.checkNull(Collections.singletonList(accessoryParameters), Collections.singletonList("accessoryParameters"));
        ParameterValidator.checkNull(Collections.singletonList(accessoryParameters.getAccessoryFamily()), Collections.singletonList("accessoryFamily"));
        ae ae2 = this.mPrintingBoundaryProvider.a(listener);
        ae2.a(accessoryParameters, printLayout);
        return ae2;
    }

    private PrintingProcess printReceiptForTransaction(cE receiptType, String transactionIdentifier, AccessoryParameters accessoryParameters, PrintingProcessListener listener, boolean isDuplicate) {
        ParameterValidator.checkNullOrEmpty(Arrays.asList(transactionIdentifier), Arrays.asList("transactionIdentifier"));
        ParameterValidator.checkNull(Arrays.asList(accessoryParameters), Arrays.asList("accessoryParameters"));
        ParameterValidator.checkNull(Arrays.asList(accessoryParameters.getAccessoryFamily()), Arrays.asList("accessoryFamily"));
        ae ae2 = this.mPrintingBoundaryProvider.a(listener);
        ae2.a(accessoryParameters, transactionIdentifier, receiptType, isDuplicate);
        return ae2;
    }

    public CardProcess readCard(AccessoryParameters accessoryParameters, ReadCardProcessListener listener) {
        ParameterValidator.checkNull(Arrays.asList(accessoryParameters), Arrays.asList("accessoryParameters"));
        ParameterValidator.checkNull(Arrays.asList(accessoryParameters.getAccessoryFamily()), Arrays.asList("accessoryFamily"));
        this.assertCardProcessNotOngoing();
        this.assertPeriodicalUpdateProcessNotOngoing(accessoryParameters);
        dc dc2 = new dc(this.mProvider, this.mAccessoryModule, this.mProcessTracker, accessoryParameters, listener, this.mProfiler);
        dc2.a();
        return dc2;
    }

    public BarcodeScanProcess startBarcodeScan(AccessoryParameters accessoryParameters, StartScanParameters startScanParameters, BarcodeScanProcessListener startScanListener) {
        DefaultProvider defaultProvider = this.mProvider;
        dr dr2 = new dr(defaultProvider.getPlatformToolkit().getEventDispatcher(), accessoryParameters, startScanParameters, this.mAccessoryModule, startScanListener, new gw(), this.delayConfig);
        dr2.a();
        return dr2;
    }

    public void setMaxReceiptLineLength(int maxReceiptLineLength) {
        if (maxReceiptLineLength <= 0) {
            throw new IllegalArgumentException("maxReceiptLineLength has to be a positive number");
        }
        this.mProvider.changeMaxReceiptLineLength(maxReceiptLineLength);
    }

    public AccessibilityModule getAccessibilityModule() {
        return this.mAccessibilityModule;
    }

    public LocalizationToolbox getLocalizationToolbox() {
        return this.mProvider.getLocalizationToolbox();
    }

    public ProcessTracker getProcessTracker() {
        return this.mProcessTracker;
    }

    public Provider getProvider() {
        return this.mProvider;
    }

    public void hardReset() {
        this.mProvider.hardReset();
        this.mAccessoryModule.hardReset();
        this.mProcessTracker.reset();
    }

    public void assertPeriodicalUpdateProcessNotOngoing(AccessoryParameters accessoryParameters) {
        if (this.accessoryUpdateTrackerPlugin.c(accessoryParameters)) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.TRANSACTION_BUSY, "A periodical update process already ongoing!"));
        }
    }

    public void assertCardProcessNotOngoing() {
        if (this.mProcessTracker.isCardProcessOngoing()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.TRANSACTION_BUSY, "A process is already ongoing!"));
        }
    }

    public void assertNonCardProcessNotOngoing() {
        if (this.mProcessTracker.isNonCardProcessOngoing()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.TRANSACTION_BUSY, "A non card process is already ongoing!"));
        }
    }
}

