/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactionprovider;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ProcessTracker {
    private static final String TAG = "ProcessTracker";
    private AtomicBoolean cardProcessOngoing = new AtomicBoolean(false);
    private AtomicBoolean accessoryProcessOngoing = new AtomicBoolean(false);
    private AtomicInteger nonCardProcessOngoingCount = new AtomicInteger(0);
    private AtomicBoolean batchSubmissionProcessOngoing = new AtomicBoolean(false);

    public void setCardProcessOngoing(boolean ongoing) {
        this.cardProcessOngoing.set(ongoing);
    }

    public void setAccessoryProcessOngoing(boolean ongoing) {
        this.accessoryProcessOngoing.set(ongoing);
    }

    public void incrementNonCardProcessOngoing() {
        this.nonCardProcessOngoingCount.incrementAndGet();
    }

    public void decrementNonCardProcessOngoing() {
        this.nonCardProcessOngoingCount.decrementAndGet();
    }

    public boolean isCardProcessOngoing() {
        return this.cardProcessOngoing.get();
    }

    public boolean isNonCardProcessOngoing() {
        return this.nonCardProcessOngoingCount.get() > 0;
    }

    public boolean isAccessoryProcessOngoing() {
        return this.accessoryProcessOngoing.get();
    }

    public boolean isBatchSubmissionProcessOngoing() {
        return this.batchSubmissionProcessOngoing.get();
    }

    public void setBatchSubmissionProcessOngoing(boolean ongoing) {
        this.batchSubmissionProcessOngoing.set(ongoing);
    }

    public boolean isOngoing() {
        return this.cardProcessOngoing.get() || this.accessoryProcessOngoing.get() || this.nonCardProcessOngoingCount.get() > 0 || this.batchSubmissionProcessOngoing.get();
    }

    public void reset() {
        this.cardProcessOngoing.set(false);
        this.accessoryProcessOngoing.set(false);
        this.nonCardProcessOngoingCount.set(0);
        this.batchSubmissionProcessOngoing.set(false);
    }
}

