/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactionprovider.processparameters.steps.tipping;

import io.mpos.shared.transactions.CurrencyWrapper;
import io.mpos.transactions.Currency;
import io.mpos.utils.LocaleExtensionsKt;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/mpos/shared/transactionprovider/processparameters/steps/tipping/TippingUtils;", "", "<init>", "()V", "BIG_DECIMAL_100", "Ljava/math/BigDecimal;", "tipAmountForPercentage", "transactionAmount", "percentage", "currency", "Lio/mpos/transactions/Currency;", "locale", "Ljava/util/Locale;", "fractionDigits", "", "mpos.core"})
public final class TippingUtils {
    @NotNull
    public static final TippingUtils INSTANCE = new TippingUtils();
    @NotNull
    private static final BigDecimal BIG_DECIMAL_100 = new BigDecimal(100);

    private TippingUtils() {
    }

    @NotNull
    public final BigDecimal tipAmountForPercentage(@NotNull BigDecimal transactionAmount, @NotNull BigDecimal percentage, @NotNull Currency currency, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)transactionAmount, (String)"");
        Intrinsics.checkNotNullParameter((Object)percentage, (String)"");
        Intrinsics.checkNotNullParameter((Object)currency, (String)"");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"");
        return this.tipAmountForPercentage(transactionAmount, percentage, new CurrencyWrapper(currency, locale).getExponent());
    }

    public static /* synthetic */ BigDecimal tipAmountForPercentage$default(TippingUtils tippingUtils, BigDecimal bigDecimal, BigDecimal bigDecimal2, Currency currency, Locale locale, int n2, Object object) {
        if ((n2 & 8) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"");
            locale = LocaleExtensionsKt.localeForDigitFormatting(locale2);
        }
        return tippingUtils.tipAmountForPercentage(bigDecimal, bigDecimal2, currency, locale);
    }

    @NotNull
    public final BigDecimal tipAmountForPercentage(@NotNull BigDecimal transactionAmount, @NotNull BigDecimal percentage, int fractionDigits) {
        Intrinsics.checkNotNullParameter((Object)transactionAmount, (String)"");
        Intrinsics.checkNotNullParameter((Object)percentage, (String)"");
        BigDecimal bigDecimal = transactionAmount;
        BigDecimal bigDecimal2 = percentage.divide(BIG_DECIMAL_100);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"");
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"");
        BigDecimal bigDecimal4 = bigDecimal3.setScale(fractionDigits, RoundingMode.DOWN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"");
        return bigDecimal4;
    }
}

