/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactionprovider.processparameters.steps.tipping;

import io.mpos.shared.transactionprovider.processparameters.steps.tipping.AmountOrPercentage;
import io.mpos.shared.transactions.TransactionAmount;
import io.mpos.transactionprovider.processparameters.steps.tipping.TippingParameters;
import java.math.BigDecimal;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0019\u0010\u0007\u001a\u00020\u0001*\u00020\u00012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\u0001\u00a8\u0006\f"}, d2={"getMaxTipAmount", "Ljava/math/BigDecimal;", "Lio/mpos/transactionprovider/processparameters/steps/tipping/TippingParameters$BasicTippingParameters;", "transactionAmount", "Lio/mpos/shared/transactions/TransactionAmount;", "getMaxTipAmountForDisplay", "getDefaultInputAmount", "limitScale", "scale", "", "(Ljava/math/BigDecimal;Ljava/lang/Integer;)Ljava/math/BigDecimal;", "getFractionDigits", "mpos.core"})
public final class TippingUtilsKt {
    @Nullable
    public static final BigDecimal getMaxTipAmount(@NotNull TippingParameters.BasicTippingParameters $this$getMaxTipAmount, @NotNull TransactionAmount transactionAmount) {
        Intrinsics.checkNotNullParameter((Object)$this$getMaxTipAmount, (String)"");
        Intrinsics.checkNotNullParameter((Object)transactionAmount, (String)"");
        AmountOrPercentage amountOrPercentage = $this$getMaxTipAmount.getMaxTip();
        return amountOrPercentage != null ? amountOrPercentage.getAmount(transactionAmount) : null;
    }

    @Nullable
    public static final BigDecimal getMaxTipAmountForDisplay(@NotNull TippingParameters.BasicTippingParameters $this$getMaxTipAmountForDisplay, @NotNull TransactionAmount transactionAmount) {
        Intrinsics.checkNotNullParameter((Object)$this$getMaxTipAmountForDisplay, (String)"");
        Intrinsics.checkNotNullParameter((Object)transactionAmount, (String)"");
        BigDecimal bigDecimal = TippingUtilsKt.getMaxTipAmount($this$getMaxTipAmountForDisplay, transactionAmount);
        return bigDecimal != null ? TippingUtilsKt.limitScale(bigDecimal, $this$getMaxTipAmountForDisplay.getFractionDigits()) : null;
    }

    @Nullable
    public static final BigDecimal getDefaultInputAmount(@NotNull TippingParameters.BasicTippingParameters $this$getDefaultInputAmount, @NotNull TransactionAmount transactionAmount) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)$this$getDefaultInputAmount, (String)"");
        Intrinsics.checkNotNullParameter((Object)transactionAmount, (String)"");
        TippingParameters.BasicTippingParameters basicTippingParameters = $this$getDefaultInputAmount;
        if (basicTippingParameters instanceof TippingParameters.BasicTippingParameters.Normal) {
            AmountOrPercentage amountOrPercentage = ((TippingParameters.BasicTippingParameters.Normal)$this$getDefaultInputAmount).getSuggestedTip();
            bigDecimal = amountOrPercentage != null ? amountOrPercentage.getAmount(transactionAmount) : null;
        } else if (basicTippingParameters instanceof TippingParameters.BasicTippingParameters.Total) {
            Object object = ((TippingParameters.BasicTippingParameters.Total)$this$getDefaultInputAmount).getSuggestedTip();
            if (object != null && (object = object.getAmount(transactionAmount)) != null) {
                BigDecimal bigDecimal2 = ((BigDecimal)object).add(transactionAmount.getAmount());
                bigDecimal = bigDecimal2;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"");
            } else {
                bigDecimal = null;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        BigDecimal bigDecimal3 = bigDecimal;
        return bigDecimal3 != null ? TippingUtilsKt.limitScale(bigDecimal3, $this$getDefaultInputAmount.getFractionDigits()) : null;
    }

    @NotNull
    public static final BigDecimal limitScale(@NotNull BigDecimal $this$limitScale, @Nullable Integer scale) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)$this$limitScale, (String)"");
        if (scale != null && $this$limitScale.scale() > scale) {
            BigDecimal bigDecimal2 = $this$limitScale.setScale((int)scale, RoundingMode.DOWN);
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"");
        } else {
            bigDecimal = $this$limitScale;
        }
        return bigDecimal;
    }

    public static final int getFractionDigits(@NotNull BigDecimal $this$getFractionDigits) {
        Intrinsics.checkNotNullParameter((Object)$this$getFractionDigits, (String)"");
        return $this$getFractionDigits.stripTrailingZeros().scale();
    }
}

