/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactionprovider.processparameters.steps.tipping;

import io.mpos.shared.CommonResult;
import io.mpos.shared.transactionprovider.processparameters.steps.tipping.TippingUtilsKt;
import io.mpos.shared.transactionprovider.processparameters.steps.tipping.TippingValidationError;
import io.mpos.shared.transactionprovider.processparameters.steps.tipping.TippingValidator;
import io.mpos.shared.transactions.CurrencyWrapper;
import io.mpos.shared.transactions.TransactionAmountKt;
import io.mpos.transactionprovider.processparameters.steps.tipping.TippingParameters;
import io.mpos.transactions.parameters.TransactionParameters;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b*\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b*\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J,\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b*\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lio/mpos/shared/transactionprovider/processparameters/steps/tipping/TippingValidatorImpl;", "Lio/mpos/shared/transactionprovider/processparameters/steps/tipping/TippingValidator;", "<init>", "()V", "validate", "Lio/mpos/shared/CommonResult;", "", "Lio/mpos/shared/transactionprovider/processparameters/steps/tipping/TippingValidationError;", "Lio/mpos/shared/transactionprovider/processparameters/steps/tipping/TippingValidationResult;", "tip", "Ljava/math/BigDecimal;", "parameters", "Lio/mpos/transactionprovider/processparameters/steps/tipping/TippingParameters;", "transactionParameters", "Lio/mpos/transactions/parameters/TransactionParameters;", "Lio/mpos/transactionprovider/processparameters/steps/tipping/TippingParameters$Percentage;", "Lio/mpos/transactionprovider/processparameters/steps/tipping/TippingParameters$BasicTippingParameters$Total;", "Lio/mpos/transactionprovider/processparameters/steps/tipping/TippingParameters$BasicTippingParameters$Normal;", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nTippingValidatorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TippingValidatorImpl.kt\nio/mpos/shared/transactionprovider/processparameters/steps/tipping/TippingValidatorImpl\n+ 2 CommonResult.kt\nio/mpos/shared/CommonResultKt\n*L\n1#1,66:1\n35#2,4:67\n35#2,4:71\n35#2,4:75\n35#2,4:79\n*S KotlinDebug\n*F\n+ 1 TippingValidatorImpl.kt\nio/mpos/shared/transactionprovider/processparameters/steps/tipping/TippingValidatorImpl\n*L\n19#1:67,4\n20#1:71,4\n21#1:75,4\n22#1:79,4\n*E\n"})
public final class TippingValidatorImpl
implements TippingValidator {
    @NotNull
    public static final TippingValidatorImpl INSTANCE = new TippingValidatorImpl();

    private TippingValidatorImpl() {
    }

    @Override
    @NotNull
    public CommonResult<Unit, TippingValidationError> validate(@NotNull BigDecimal tip, @NotNull TippingParameters parameters, @NotNull TransactionParameters transactionParameters) {
        Intrinsics.checkNotNullParameter((Object)tip, (String)"");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"");
        Intrinsics.checkNotNullParameter((Object)transactionParameters, (String)"");
        int n2 = new CurrencyWrapper(transactionParameters.getCurrency(), null, 2, null).getExponent();
        TippingParameters tippingParameters = parameters;
        if (tippingParameters instanceof TippingParameters.BasicTippingParameters.Normal) {
            CommonResult<Unit, TippingValidationError> commonResult = this.validate((TippingParameters.BasicTippingParameters.Normal)parameters, transactionParameters, tip);
            CommonResult<Unit, TippingValidationError> commonResult2 = commonResult;
            if (!(commonResult2 instanceof CommonResult.Success)) {
                if (commonResult2 instanceof CommonResult.Error) {
                    CommonResult.Error error = (CommonResult.Error)commonResult;
                    return error;
                }
                throw new NoWhenBranchMatchedException();
            }
        } else if (tippingParameters instanceof TippingParameters.BasicTippingParameters.Total) {
            CommonResult<Unit, TippingValidationError> commonResult = this.validate((TippingParameters.BasicTippingParameters.Total)parameters, transactionParameters, tip);
            CommonResult<Unit, TippingValidationError> commonResult3 = commonResult;
            if (!(commonResult3 instanceof CommonResult.Success)) {
                if (commonResult3 instanceof CommonResult.Error) {
                    CommonResult.Error error = (CommonResult.Error)commonResult;
                    return error;
                }
                throw new NoWhenBranchMatchedException();
            }
        } else if (tippingParameters instanceof TippingParameters.Percentage) {
            CommonResult<Unit, TippingValidationError> commonResult = this.validate((TippingParameters.Percentage)parameters, transactionParameters, tip);
            CommonResult<Unit, TippingValidationError> commonResult4 = commonResult;
            if (!(commonResult4 instanceof CommonResult.Success)) {
                if (commonResult4 instanceof CommonResult.Error) {
                    CommonResult.Error error = (CommonResult.Error)commonResult;
                    return error;
                }
                throw new NoWhenBranchMatchedException();
            }
        } else if (tippingParameters instanceof TippingParameters.PercentageChoice) {
            CommonResult<Unit, TippingValidationError> commonResult = this.validate(((TippingParameters.PercentageChoice)parameters).getCustomParameters(), transactionParameters, tip);
            CommonResult<Unit, TippingValidationError> commonResult5 = commonResult;
            if (!(commonResult5 instanceof CommonResult.Success)) {
                if (commonResult5 instanceof CommonResult.Error) {
                    CommonResult.Error error = (CommonResult.Error)commonResult;
                    return error;
                }
                throw new NoWhenBranchMatchedException();
            }
        } else if (!(tippingParameters instanceof TippingParameters.Fixed)) {
            throw new NoWhenBranchMatchedException();
        }
        if (tip.compareTo(BigDecimal.ZERO) < 0) {
            return new CommonResult.Error<TippingValidationError>(TippingValidationError.TIP_IS_NEGATIVE);
        }
        if (tip.scale() > n2) {
            return new CommonResult.Error<TippingValidationError>(TippingValidationError.TIP_SCALE_EXCEEDS_CURRENCY_SCALE);
        }
        return new CommonResult.Success<Unit>(Unit.INSTANCE);
    }

    private final CommonResult<Unit, TippingValidationError> validate(TippingParameters.Percentage $this$validate, TransactionParameters transactionParameters, BigDecimal tip) {
        BigDecimal bigDecimal = transactionParameters.getAmount();
        Intrinsics.checkNotNull((Object)bigDecimal);
        BigDecimal bigDecimal2 = bigDecimal;
        BigDecimal bigDecimal3 = $this$validate.getMinPercentage().divide(new BigDecimal(100));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"");
        BigDecimal bigDecimal4 = bigDecimal2.multiply(bigDecimal3);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"");
        BigDecimal bigDecimal5 = bigDecimal4;
        BigDecimal bigDecimal6 = bigDecimal;
        BigDecimal bigDecimal7 = $this$validate.getMaxPercentage().divide(new BigDecimal(100));
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal7, (String)"");
        BigDecimal bigDecimal8 = bigDecimal6.multiply(bigDecimal7);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal8, (String)"");
        bigDecimal2 = bigDecimal8;
        return tip.compareTo(bigDecimal5) < 0 ? (CommonResult)new CommonResult.Error<TippingValidationError>(TippingValidationError.BELOW_MIN_TIP) : (tip.compareTo(bigDecimal2) > 0 ? (CommonResult)new CommonResult.Error<TippingValidationError>(TippingValidationError.MAX_TIP_EXCEEDED) : (CommonResult)new CommonResult.Success<Unit>(Unit.INSTANCE));
    }

    private final CommonResult<Unit, TippingValidationError> validate(TippingParameters.BasicTippingParameters.Total $this$validate, TransactionParameters transactionParameters, BigDecimal tip) {
        BigDecimal bigDecimal = TippingUtilsKt.getMaxTipAmount((TippingParameters.BasicTippingParameters)$this$validate, TransactionAmountKt.getTransactionAmount((TransactionParameters)transactionParameters));
        if (tip.compareTo(BigDecimal.ZERO) < 0) {
            return new CommonResult.Error<TippingValidationError>(TippingValidationError.BELOW_MIN_TIP);
        }
        if (bigDecimal != null && tip.compareTo(bigDecimal) > 0) {
            return new CommonResult.Error<TippingValidationError>(TippingValidationError.MAX_TIP_EXCEEDED);
        }
        return new CommonResult.Success<Unit>(Unit.INSTANCE);
    }

    private final CommonResult<Unit, TippingValidationError> validate(TippingParameters.BasicTippingParameters.Normal $this$validate, TransactionParameters transactionParameters, BigDecimal tip) {
        BigDecimal bigDecimal = TippingUtilsKt.getMaxTipAmount((TippingParameters.BasicTippingParameters)$this$validate, TransactionAmountKt.getTransactionAmount((TransactionParameters)transactionParameters));
        return bigDecimal == null || tip.compareTo(bigDecimal) <= 0 ? (CommonResult)new CommonResult.Success<Unit>(Unit.INSTANCE) : (CommonResult)new CommonResult.Error<TippingValidationError>(TippingValidationError.MAX_TIP_EXCEEDED);
    }
}

