/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactions;

import com.visa.utils.CurrencyUtilsKt;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.transactions.Currency;
import io.mpos.utils.LocaleExtensionsKt;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010\u001c\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0010\u0010\u001d\u001a\u00020\u000b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0016\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lio/mpos/shared/transactions/CurrencyWrapper;", "", "publicCurrency", "Lio/mpos/transactions/Currency;", "locale", "Ljava/util/Locale;", "<init>", "(Lio/mpos/transactions/Currency;Ljava/util/Locale;)V", "getLocale", "()Ljava/util/Locale;", "currencyIsoCode", "", "isoCode", "getIsoCode", "()Ljava/lang/String;", "isoNumber", "", "getIsoNumber", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "formattedIsoNumber", "getFormattedIsoNumber", "exponent", "getExponent", "()I", "formatAmount", "amount", "Ljava/math/BigDecimal;", "formatAmountOnlyDigits", "formatAmountAndCurrency", "Companion", "mpos.core"})
public final class CurrencyWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Locale locale;
    @NotNull
    private final String currencyIsoCode;
    @Nullable
    private final String isoCode;
    @Nullable
    private final Integer isoNumber;
    @NotNull
    private final String formattedIsoNumber;
    private final int exponent;

    @JvmOverloads
    public CurrencyWrapper(@Nullable Currency publicCurrency, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"");
        this.locale = locale;
        Object object = publicCurrency;
        if (object == null || (object = object.name()) == null) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.INTERNAL_INCONSISTENCY, "Trying to create currency metadata without valid reference"));
        }
        this.currencyIsoCode = object;
        this.isoCode = publicCurrency.name();
        this.isoNumber = CurrencyUtilsKt.isoNumberByIsoCode((String)this.currencyIsoCode);
        Locale locale2 = Locale.US;
        String string = "%03d";
        Object[] objectArray = new Object[]{this.isoNumber};
        String string2 = String.format(locale2, string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"");
        this.formattedIsoNumber = string2;
        Integer n2 = CurrencyUtilsKt.exponentByIsoCode((String)this.currencyIsoCode);
        if (n2 == null) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.INTERNAL_INCONSISTENCY, "Unknown currency iso code " + this.currencyIsoCode));
        }
        this.exponent = n2;
    }

    public /* synthetic */ CurrencyWrapper(Currency currency, Locale locale, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"");
            locale = LocaleExtensionsKt.localeForDigitFormatting(locale2);
        }
        this(currency, locale);
    }

    @NotNull
    public final Locale getLocale() {
        return this.locale;
    }

    @Nullable
    public final String getIsoCode() {
        return this.isoCode;
    }

    @Nullable
    public final Integer getIsoNumber() {
        return this.isoNumber;
    }

    @NotNull
    public final String getFormattedIsoNumber() {
        return this.formattedIsoNumber;
    }

    public final int getExponent() {
        return this.exponent;
    }

    @NotNull
    public final String formatAmount(@Nullable BigDecimal amount) {
        if (amount == null) {
            return "";
        }
        int n2 = this.exponent;
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(this.locale));
        decimalFormat.setMinimumFractionDigits(n2);
        decimalFormat.setMaximumFractionDigits(n2);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        decimalFormat.setGroupingUsed(true);
        String string = decimalFormat.format(amount);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @NotNull
    public final String formatAmountOnlyDigits(@Nullable BigDecimal amount) {
        String string = this.formatAmount(amount);
        CharSequence charSequence = string;
        Regex regex = new Regex("[^0-9]");
        String string2 = "";
        return regex.replace(charSequence, string2);
    }

    @NotNull
    public final String formatAmountAndCurrency(@Nullable BigDecimal amount) {
        String string = this.formatAmount(amount);
        return string + " " + this.isoCode;
    }

    @JvmOverloads
    public CurrencyWrapper(@Nullable Currency publicCurrency) {
        this(publicCurrency, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final Currency currencyForIsoNumber(int isoNumber) {
        return Companion.currencyForIsoNumber(isoNumber);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lio/mpos/shared/transactions/CurrencyWrapper$Companion;", "", "<init>", "()V", "currencyForIsoNumber", "Lio/mpos/transactions/Currency;", "isoNumber", "", "mpos.core"})
    @SourceDebugExtension(value={"SMAP\nCurrencyWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurrencyWrapper.kt\nio/mpos/shared/transactions/CurrencyWrapper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Currency currencyForIsoNumber(int isoNumber) {
            Currency currency;
            Object v1;
            block2: {
                Iterable iterable = (Iterable)Currency.getEntries();
                for (Object t2 : iterable) {
                    Currency currency2 = (Currency)t2;
                    Integer n2 = CurrencyUtilsKt.isoNumberByIsoCode((String)currency2.name());
                    int n3 = isoNumber;
                    if (!(n2 != null && n2 == n3)) continue;
                    v1 = t2;
                    break block2;
                }
                v1 = null;
            }
            if ((currency = (Currency)v1) == null) {
                currency = Currency.UNKNOWN;
            }
            return currency;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

