/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactions;

import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.transactions.Currency;
import io.mpos.transactions.DccDetails;
import io.mpos.transactions.DccLookupStatus;
import io.mpos.transactions.DccOptions;
import io.mpos.transactions.DccStatus;
import io.mpos.transactions.DccStatusDetails;
import java.math.BigDecimal;
import java.util.EnumSet;

public class DefaultDccDetails
implements DccDetails {
    private DccStatus status;
    private EnumSet<PaymentDetailsScheme> supportedSchemes;
    private DccLookupStatus lookupStatus;
    private DccStatusDetails statusDetails;
    private BigDecimal convertedAmount;
    private Currency convertedCurrency;
    private BigDecimal rate;
    private BigDecimal markup;
    private String conversionHint;
    private EnumSet<DccOptions> options;

    public DefaultDccDetails() {
        this.status = DccStatus.NOT_AVAILABLE;
        this.supportedSchemes = EnumSet.noneOf(PaymentDetailsScheme.class);
        this.lookupStatus = DccLookupStatus.UNKNOWN;
        this.statusDetails = DccStatusDetails.NOT_AVAILABLE;
        this.convertedCurrency = Currency.UNKNOWN;
        this.options = EnumSet.noneOf(DccOptions.class);
    }

    public DefaultDccDetails(DccStatus status, EnumSet<PaymentDetailsScheme> supportedSchemes, DccLookupStatus lookupStatus, DccStatusDetails statusDetails, BigDecimal convertedAmount, Currency convertedCurrency, BigDecimal rate, BigDecimal markup, EnumSet<DccOptions> options) {
        this.status = status;
        this.supportedSchemes = supportedSchemes;
        this.lookupStatus = lookupStatus;
        this.statusDetails = statusDetails;
        this.convertedAmount = convertedAmount;
        this.convertedCurrency = convertedCurrency;
        this.rate = rate;
        this.markup = markup;
        this.options = options;
    }

    public DccStatus getStatus() {
        return this.status;
    }

    public DccLookupStatus getLookupStatus() {
        return this.lookupStatus;
    }

    public DccStatusDetails getStatusDetails() {
        return this.statusDetails;
    }

    public BigDecimal getConvertedAmount() {
        return this.convertedAmount;
    }

    public Currency getConvertedCurrency() {
        return this.convertedCurrency;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public BigDecimal getMarkup() {
        return this.markup;
    }

    public EnumSet<PaymentDetailsScheme> getSupportedSchemes() {
        return this.supportedSchemes;
    }

    public String getConversionHint() {
        return this.conversionHint;
    }

    public EnumSet<DccOptions> getOptions() {
        return this.options;
    }

    public void setSupportedSchemes(EnumSet<PaymentDetailsScheme> supportedSchemes) {
        this.supportedSchemes = supportedSchemes;
    }

    public void setDccLookupStatus(DccLookupStatus dccLookupStatus) {
        this.lookupStatus = dccLookupStatus;
    }

    public void setStatusDetails(DccStatusDetails dccStatusDetails) {
        this.statusDetails = dccStatusDetails;
        this.status = DccStatus.fromStatusDetails((DccStatusDetails)this.statusDetails);
    }

    public void setConvertedAmount(BigDecimal convertedAmount) {
        this.convertedAmount = convertedAmount;
    }

    public void setConvertedCurrency(Currency convertedCurrency) {
        this.convertedCurrency = convertedCurrency;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public void setMarkup(BigDecimal markup) {
        this.markup = markup;
    }

    public void setConversionHint(String conversionHint) {
        this.conversionHint = conversionHint;
    }

    public void setOptions(EnumSet<DccOptions> options) {
        this.options = options;
    }

    public String toString() {
        return "DefaultDccDetails{status=" + this.status + ", supportedSchemes=" + this.supportedSchemes + ", lookupStatus=" + this.lookupStatus + ", statusDetails=" + this.statusDetails + ", convertedAmount=" + this.convertedAmount + ", convertedCurrency=" + this.convertedCurrency + ", rate=" + this.rate + ", markup=" + this.markup + ", conversionHint=" + this.conversionHint + ", options=" + this.options.toString() + "}";
    }

    public void mergeWithDccDetails(DccDetails dccDetails) {
        DefaultDccDetails defaultDccDetails = (DefaultDccDetails)dccDetails;
        if (defaultDccDetails.getStatusDetails() != null) {
            this.statusDetails = defaultDccDetails.getStatusDetails();
        }
        if (defaultDccDetails.getConvertedAmount() != null) {
            this.convertedAmount = defaultDccDetails.getConvertedAmount();
        }
        if (defaultDccDetails.getConvertedCurrency() != null) {
            this.convertedCurrency = defaultDccDetails.getConvertedCurrency();
        }
        if (defaultDccDetails.getStatus() != null) {
            this.status = defaultDccDetails.getStatus();
        }
        if (defaultDccDetails.getLookupStatus() != null) {
            this.lookupStatus = defaultDccDetails.getLookupStatus();
        }
        if (defaultDccDetails.getMarkup() != null) {
            this.markup = defaultDccDetails.getMarkup();
        }
        if (defaultDccDetails.getRate() != null) {
            this.rate = defaultDccDetails.getRate();
        }
        if (defaultDccDetails.getSupportedSchemes() != null) {
            this.supportedSchemes = defaultDccDetails.getSupportedSchemes();
        }
        if (defaultDccDetails.getOptions() != null) {
            this.options = defaultDccDetails.getOptions();
        }
    }

    public static DefaultDccDetails fromSupportedSchemes(EnumSet<PaymentDetailsScheme> schemes) {
        DefaultDccDetails defaultDccDetails = new DefaultDccDetails();
        defaultDccDetails.resetWithCandidates(schemes);
        return defaultDccDetails;
    }

    public void resetWithCandidates(EnumSet<PaymentDetailsScheme> schemes) {
        if (schemes == null || schemes.isEmpty()) {
            this.setStatusDetails(DccStatusDetails.NOT_AVAILABLE);
            this.setSupportedSchemes(EnumSet.noneOf(PaymentDetailsScheme.class));
        } else {
            this.setStatusDetails(DccStatusDetails.NOT_APPLIED);
            this.setSupportedSchemes(schemes);
        }
    }
}

