/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactions;

import io.mpos.transactions.MerchantDetails;
import java.util.Objects;
import java.util.stream.Stream;

public class DefaultMerchantDetails
implements MerchantDetails {
    private String salesOrganizationId;
    private String subMerchantId;
    private String descriptorName;

    public String getSalesOrganizationId() {
        return this.salesOrganizationId;
    }

    public String getSubMerchantId() {
        return this.subMerchantId;
    }

    public String getDescriptorName() {
        return this.descriptorName;
    }

    public void setSalesOrganizationId(String salesOrganizationId) {
        this.salesOrganizationId = salesOrganizationId;
    }

    public void setDescriptorName(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    public void setSubMerchantId(String subMerchantId) {
        this.subMerchantId = subMerchantId;
    }

    public String toString() {
        return "DefaultMerchantDetails{salesOrganizationId=" + this.salesOrganizationId + ", subMerchantId=" + this.subMerchantId + ", descriptorName=" + this.descriptorName + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DefaultMerchantDetails defaultMerchantDetails = (DefaultMerchantDetails)o2;
        if (!Objects.equals(this.salesOrganizationId, defaultMerchantDetails.salesOrganizationId)) {
            return false;
        }
        if (!Objects.equals(this.subMerchantId, defaultMerchantDetails.subMerchantId)) {
            return false;
        }
        return Objects.equals(this.descriptorName, defaultMerchantDetails.descriptorName);
    }

    public int hashCode() {
        int n2 = this.salesOrganizationId != null ? this.salesOrganizationId.hashCode() : 0;
        n2 = 31 * n2 + (this.subMerchantId != null ? this.subMerchantId.hashCode() : 0);
        n2 = 31 * n2 + (this.descriptorName != null ? this.descriptorName.hashCode() : 0);
        return n2;
    }

    public boolean isMerchantDetailsEmpty() {
        return Stream.of(this.salesOrganizationId, this.subMerchantId, this.descriptorName).allMatch(Objects::isNull);
    }

    public void mergeWithMerchantDetails(MerchantDetails merchantDetails) {
        DefaultMerchantDetails defaultMerchantDetails = (DefaultMerchantDetails)merchantDetails;
        if (defaultMerchantDetails.getSalesOrganizationId() != null) {
            this.salesOrganizationId = defaultMerchantDetails.getSalesOrganizationId();
        }
        if (defaultMerchantDetails.getSubMerchantId() != null) {
            this.subMerchantId = defaultMerchantDetails.getSubMerchantId();
        }
        if (defaultMerchantDetails.getDescriptorName() != null) {
            this.descriptorName = defaultMerchantDetails.getDescriptorName();
        }
    }
}

